/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils.streaming;

import java.nio.ByteBuffer;

public interface StreamBuffer {
    public void getBytes(int var1, ByteBuffer var2, int var3);

    public void getBytes(int var1, byte[] var2, int var3, int var4);

    public byte getByte(int var1);

    public int readableBytes();

    public void release();

    public static ByteArrayWrapper wrap(byte[] bytes) {
        return new ByteArrayWrapper(bytes);
    }

    public static class ByteArrayWrapper
    implements StreamBuffer {
        private final byte[] bytes;

        private ByteArrayWrapper(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public void getBytes(int index, ByteBuffer destination, int length) {
            destination.put(this.bytes, index, length);
        }

        @Override
        public void getBytes(int index, byte[] destination, int destinationIndex, int length) {
            System.arraycopy(this.bytes, index, destination, destinationIndex, length);
        }

        @Override
        public byte getByte(int index) {
            return this.bytes[index];
        }

        @Override
        public int readableBytes() {
            return this.bytes.length;
        }

        @Override
        public void release() {
        }
    }
}

