/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class LoggerHelper {
    private final Logger logger;
    private final String keys;
    private final Object[] fixedArgumentss;

    public LoggerHelper(Logger logger, Object ... fixedArguments) {
        this.logger = logger;
        this.keys = LoggerHelper.buildKey(fixedArguments);
        this.fixedArgumentss = LoggerHelper.extractArguments(fixedArguments);
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    private static String buildKey(Object ... args) {
        Preconditions.checkArgument((args.length % 2 == 0 ? 1 : 0) != 0, (Object)"Expect even number of key/value pairs in fixedArgs");
        return " " + IntStream.range(0, args.length / 2).map(index -> index * 2).mapToObj(index -> args[index]).map(key -> String.valueOf(key) + "={}").collect(Collectors.joining(" "));
    }

    private static Object[] extractArguments(Object ... arguments) {
        Preconditions.checkArgument((arguments.length % 2 == 0 ? 1 : 0) != 0, (Object)"Expect even number of key/value pairs in fixedArgs");
        return IntStream.range(0, arguments.length / 2).map(index -> index * 2 + 1).mapToObj(index -> arguments[index]).toArray(Object[]::new);
    }

    public void trace(String message, Object ... arguments) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.logMsg(message, arguments), this.buildArguments(arguments));
        }
    }

    @SafeVarargs
    public final void trace(String message, Supplier<Object> ... arguments) {
        if (this.logger.isTraceEnabled()) {
            Object[] evaluatedArguments = Arrays.stream(arguments).map(Supplier::get).toArray();
            this.logger.trace(this.logMsg(message, evaluatedArguments), this.buildArguments(evaluatedArguments));
        }
    }

    public void debug(String message, Object ... arguments) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.logMsg(message, arguments), this.buildArguments(arguments));
        }
    }

    @SafeVarargs
    public final void debug(String message, Supplier<Object> ... arguments) {
        if (this.logger.isDebugEnabled()) {
            Object[] evaluatedArguments = Arrays.stream(arguments).map(Supplier::get).toArray();
            this.logger.debug(this.logMsg(message, evaluatedArguments), this.buildArguments(evaluatedArguments));
        }
    }

    public void info(String message, Object ... arguments) {
        this.logger.info(this.logMsg(message, arguments), this.buildArguments(arguments));
    }

    public void warn(String message, Throwable throwable, Object ... arguments) {
        this.logger.warn(this.logMsg(message, arguments), this.buildArguments(throwable, arguments));
    }

    public void error(String message, Throwable throwable, Object ... arguments) {
        this.logger.error(this.logMsg(message, arguments), this.buildArguments(throwable, arguments));
    }

    @VisibleForTesting
    String logMsg(String message, Object ... arguments) {
        message = (String)message + this.keys;
        if (0 < arguments.length) {
            message = (String)message + LoggerHelper.buildKey(arguments);
        }
        return message;
    }

    private Object[] buildArguments(Object ... arguments) {
        return this.buildArguments(null, arguments);
    }

    @VisibleForTesting
    Object[] buildArguments(@Nullable Throwable throwable, Object ... arguments) {
        Object[] variableArguments = LoggerHelper.extractArguments(arguments);
        Object[] allArguments = new Object[variableArguments.length + this.fixedArgumentss.length + (throwable != null ? 1 : 0)];
        System.arraycopy(this.fixedArgumentss, 0, allArguments, 0, this.fixedArgumentss.length);
        System.arraycopy(variableArguments, 0, allArguments, this.fixedArgumentss.length, variableArguments.length);
        if (throwable != null) {
            allArguments[variableArguments.length + this.fixedArgumentss.length] = throwable;
        }
        return allArguments;
    }
}

