/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.msg;

import java.nio.ByteBuffer;
import java.util.function.Function;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.jetbrains.annotations.Nullable;

public class Value {
    public final String keyspace;
    public final String columnName;
    public final String columnType;
    @Nullable
    private final ByteBuffer value;

    public Value(String keyspace, String columnName, String columnType, @Nullable ByteBuffer value) {
        this.keyspace = keyspace;
        this.columnName = columnName;
        this.columnType = columnType;
        this.value = value;
    }

    public static Value of(String keyspace, String columnName, String columnType, @Nullable ByteBuffer value) {
        return new Value(keyspace, columnName, columnType, value);
    }

    @Nullable
    public byte[] getBytes() {
        return this.value == null ? null : ByteBufferUtils.getArray(this.value);
    }

    public CqlField.CqlType getCqlType(Function<String, CqlField.CqlType> typeMapping) {
        return typeMapping.apply(this.columnType);
    }

    @Nullable
    public ByteBuffer getValue() {
        return this.value == null ? null : this.value.duplicate();
    }
}

