/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.api;

import java.util.List;
import org.apache.cassandra.cdc.api.CommitLog;
import org.apache.cassandra.cdc.api.Marker;
import org.apache.cassandra.db.commitlog.PartitionUpdateWrapper;

public interface CommitLogReader {
    public List<PartitionUpdateWrapper> updates();

    public CommitLog log();

    public long segmentId();

    public int position();

    public boolean skipped();

    public static class Result {
        private final List<PartitionUpdateWrapper> updates;
        private final Marker marker;
        private final boolean isFullyRead;
        private final boolean skipped;

        public Result(CommitLogReader reader) {
            CommitLog log = reader.log();
            this.updates = reader.updates();
            this.marker = log.markerAt(reader.segmentId(), reader.position());
            this.isFullyRead = log.completed() && (long)this.marker.position >= log.maxOffset();
            this.skipped = reader.skipped();
        }

        public List<PartitionUpdateWrapper> updates() {
            return this.updates;
        }

        public Marker marker() {
            return this.marker;
        }

        public boolean isFullyRead() {
            return this.isFullyRead;
        }

        public boolean wasSkipped() {
            return this.skipped;
        }
    }
}

