/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.api;

import java.io.Closeable;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.cdc.api.Marker;
import org.apache.cassandra.cdc.stats.ICdcStats;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.utils.Pair;
import org.apache.cassandra.spark.utils.streaming.CassandraFile;
import org.apache.cassandra.spark.utils.streaming.CassandraFileSource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CommitLog
extends Closeable,
CassandraFile,
Comparable<CommitLog> {
    public static final Logger LOGGER = LoggerFactory.getLogger(CommitLog.class);
    public static final Pattern COMMIT_LOG_FILE_PATTERN = Pattern.compile("CommitLog(-(\\d+))?-(\\d+).log");

    public static Optional<Pair<Integer, Long>> extractVersionAndSegmentId(@NotNull CommitLog log) {
        return CommitLog.extractVersionAndSegmentId(log.name());
    }

    public static Optional<Pair<Integer, Long>> extractVersionAndSegmentId(@NotNull String filename) {
        Matcher matcher = COMMIT_LOG_FILE_PATTERN.matcher(filename);
        if (matcher.matches()) {
            try {
                int version;
                int n = version = matcher.group(2) == null ? 6 : Integer.parseInt(matcher.group(2));
                if (version != 6 && version != 7) {
                    throw new IllegalStateException("Unknown commitlog version " + version);
                }
                return Optional.of(Pair.of(version == 6 ? 10 : 12, Long.parseLong(matcher.group(3))));
            }
            catch (NumberFormatException e) {
                LOGGER.error("Could not parse commit log segmentId name={}", (Object)filename, (Object)e);
                return Optional.empty();
            }
        }
        LOGGER.error("Could not parse commit log filename name={}", (Object)filename);
        return Optional.empty();
    }

    public String name();

    public String path();

    public long maxOffset();

    public long length();

    public boolean completed();

    public CassandraFileSource<CommitLog> source();

    public CassandraInstance instance();

    default public long segmentId() {
        return CommitLog.extractVersionAndSegmentId(this).map(Pair::getRight).orElseThrow(() -> new RuntimeException("Could not extract segmentId from CommitLog"));
    }

    default public Marker zeroMarker() {
        return this.markerAt(this.segmentId(), 0);
    }

    default public Marker maxMarker() {
        return this.markerAt(this.segmentId(), Math.toIntExact(this.maxOffset()));
    }

    default public Marker markerAt(long section, int offset) {
        return new Marker(this.instance(), section, offset);
    }

    default public ICdcStats stats() {
        return ICdcStats.STUB;
    }

    @Override
    default public int compareTo(@NotNull CommitLog other) {
        return Long.compare(this.segmentId(), other.segmentId());
    }
}

