/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.transports.storage;

import org.apache.cassandra.spark.transports.storage.StorageAccessConfiguration;
import org.apache.cassandra.spark.transports.storage.StorageCredentials;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StorageAccessConfigurationTest {
    StorageAccessConfigurationTest() {
    }

    @Test
    void testCopyWithNewCredentials() {
        StorageAccessConfiguration config1 = new StorageAccessConfiguration("writeRegion", "writeBucket", new StorageCredentials("access", "secret"));
        StorageAccessConfiguration config2 = config1.copyWithNewCredentials(new StorageCredentials("newAccess", "newSecret"));
        Assertions.assertThat((Object)config1).isNotSameAs((Object)config2);
        Assertions.assertThat((String)config1.bucket()).isEqualTo(config2.bucket());
        Assertions.assertThat((String)config1.region()).isEqualTo(config2.region());
        Assertions.assertThat((Object)config1.storageCredentials()).isNotEqualTo((Object)config2.storageCredentials());
    }

    @Test
    void testHashcodeAndEquals() {
        StorageAccessConfiguration config1 = new StorageAccessConfiguration("writeRegion", "writeBucket", new StorageCredentials("access", "secret"));
        StorageAccessConfiguration config2 = new StorageAccessConfiguration("writeRegion", "writeBucket", new StorageCredentials("access", "secret"));
        Assertions.assertThat((int)config1.hashCode()).isEqualTo(config2.hashCode());
        Assertions.assertThat((Object)config1).isEqualTo((Object)config2);
        config2 = config1.copyWithNewCredentials(new StorageCredentials("newAccess", "newSecret"));
        Assertions.assertThat((int)config1.hashCode()).isNotEqualTo(config2.hashCode());
        Assertions.assertThat((Object)config1).isNotEqualTo((Object)config2);
    }
}

