/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.endtoend;

import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.Tester;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.quicktheories.QuickTheory;

@Tag(value="Sequential")
public class FiltersUdtTests {
    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testUdtNativeTypes(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.udt("keyspace", "testudt").withField("b", (CqlField.CqlType)bridge.text()).withField("c", (CqlField.CqlType)type).withField("d", (CqlField.CqlType)bridge.aInt()).build())).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testUdtInnerSet(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).assuming(CqlField.CqlType::supportedAsSetElement).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.udt("keyspace", "testudt").withField("b", (CqlField.CqlType)bridge.text()).withField("c", (CqlField.CqlType)bridge.set((CqlField.CqlType)type).frozen()).withField("d", (CqlField.CqlType)bridge.aInt()).build())).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testUdtInnerList(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.udt("keyspace", "testudt").withField("b", (CqlField.CqlType)bridge.bigint()).withField("c", (CqlField.CqlType)bridge.list((CqlField.CqlType)type).frozen()).withField("d", (CqlField.CqlType)bridge.bool()).build())).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testUdtInnerMap(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(50).forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).assuming((type1, type2) -> type1.supportedAsMapKey()).checkAssert((type1, type2) -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.udt("keyspace", "testudt").withField("b", (CqlField.CqlType)bridge.aFloat()).withField("c", (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.uuid()).frozen()).withField("d", (CqlField.CqlType)bridge.map((CqlField.CqlType)type1, (CqlField.CqlType)type2).frozen()).withField("e", (CqlField.CqlType)bridge.bool()).build())).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testMultipleUdts(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).assuming(CqlField.CqlType::supportedAsSetElement).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("col1", (CqlField.CqlType)bridge.udt("keyspace", "udt1").withField("a", (CqlField.CqlType)bridge.aFloat()).withField("b", (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.uuid()).frozen()).withField("c", (CqlField.CqlType)bridge.set((CqlField.CqlType)type).frozen()).withField("d", (CqlField.CqlType)bridge.bool()).build()).withColumn("col2", (CqlField.CqlType)bridge.udt("keyspace", "udt2").withField("a", (CqlField.CqlType)bridge.text()).withField("b", (CqlField.CqlType)bridge.bigint()).withField("g", (CqlField.CqlType)bridge.varchar()).build()).withColumn("col3", (CqlField.CqlType)bridge.udt("keyspace", "udt3").withField("a", (CqlField.CqlType)bridge.aInt()).withField("b", (CqlField.CqlType)bridge.list((CqlField.CqlType)type).frozen()).withField("c", (CqlField.CqlType)bridge.ascii()).build())).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testNestedUdt(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.udt("keyspace", "test_udt").withField("b", (CqlField.CqlType)bridge.aFloat()).withField("c", (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.uuid()).frozen()).withField("d", (CqlField.CqlType)bridge.udt("keyspace", "nested_udt").withField("x", (CqlField.CqlType)bridge.aInt()).withField("y", (CqlField.CqlType)type).withField("z", (CqlField.CqlType)bridge.aInt()).build().frozen()).withField("e", (CqlField.CqlType)bridge.bool()).build())).run(bridge.getVersion()));
    }
}

