/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.token;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.RingInstanceTest;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.bulkwriter.token.FailureHandlerTextContext;
import org.apache.cassandra.spark.bulkwriter.token.SingleClusterReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMappingTest;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class SingleClusterReplicaAwareFailureHandlerTest {
    private static final String DATACENTER_1 = "dc1";
    private final Partitioner partitioner = Partitioner.Murmur3Partitioner;
    private final SingleClusterReplicaAwareFailureHandler<RingInstance> handler = new SingleClusterReplicaAwareFailureHandler(this.partitioner, null);

    SingleClusterReplicaAwareFailureHandlerTest() {
    }

    @Test
    void testGetFailedInstances() {
        RingInstance instance1 = RingInstanceTest.instance(BigInteger.valueOf(10L), "instance1", DATACENTER_1);
        RingInstance instance2 = RingInstanceTest.instance(BigInteger.valueOf(20L), "instance2", DATACENTER_1);
        Assertions.assertThat((boolean)this.handler.isEmpty()).isTrue();
        this.handler.addFailure(TestUtils.range(0L, 10L), (CassandraInstance)instance1, "instance 1 fails");
        Assertions.assertThat((boolean)this.handler.isEmpty()).isFalse();
        this.handler.addFailure(TestUtils.range(0L, 10L), (CassandraInstance)instance2, "instance 2 fails");
        this.handler.addFailure(TestUtils.range(10L, 20L), (CassandraInstance)instance2, "instance 2 fails");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.handler.getFailedInstances()).hasSize(2)).containsExactlyInAnyOrder((Object[])new RingInstance[]{instance1, instance2});
    }

    @Test
    public void testMinorityFailuresProduceNoFailedRanges() {
        this.testFailedRangeCheck(ctx -> {
            Range<BigInteger> range = TestUtils.range(0L, 10L);
            Map writeReplicasOfRange = ctx.topology.getWriteReplicasOfRange(range, DATACENTER_1);
            Assertions.assertThat((Map)writeReplicasOfRange).hasSize(1);
            ArrayList writeReplicas = new ArrayList((Collection)writeReplicasOfRange.values().iterator().next());
            Assertions.assertThat(writeReplicas).hasSize(3);
            RingInstance instance = (RingInstance)writeReplicas.get(1);
            Range<BigInteger> range1 = TestUtils.range(0L, 3L);
            Range<BigInteger> range2 = TestUtils.range(3L, 4L);
            Range<BigInteger> range3 = TestUtils.range(5L, 6L);
            this.handler.addFailure(range1, (CassandraInstance)instance, "Failure 1");
            this.handler.addFailure(range2, (CassandraInstance)instance, "Failure 2");
            this.handler.addFailure(range3, (CassandraInstance)instance, "Failure 3");
            Assertions.assertThat((List)this.handler.getFailedRanges(ctx.topology, ctx.jobInfo, ctx.clusterInfo)).isEmpty();
        });
    }

    @Test
    public void testMajorityFailuresProduceFailedRanges() {
        this.testFailedRangeCheck(ctx -> {
            Range<BigInteger> range = TestUtils.range(0L, 10L);
            Map writeReplicasOfRange = ctx.topology.getWriteReplicasOfRange(range, DATACENTER_1);
            Assertions.assertThat((Map)writeReplicasOfRange).hasSize(1);
            ArrayList writeReplicas = new ArrayList((Collection)writeReplicasOfRange.values().iterator().next());
            Assertions.assertThat(writeReplicas).hasSize(3);
            RingInstance instance1 = (RingInstance)writeReplicas.get(1);
            RingInstance instance2 = (RingInstance)writeReplicas.get(2);
            this.handler.addFailure(range, (CassandraInstance)instance1, "fails on instance 1");
            this.handler.addFailure(range, (CassandraInstance)instance2, "fails on instance 2");
            List failedRanges = this.handler.getFailedRanges(ctx.topology, ctx.jobInfo, ctx.clusterInfo);
            Assertions.assertThat((List)failedRanges).isNotEmpty();
        });
    }

    private void testFailedRangeCheck(Consumer<FailureHandlerTextContext> test) {
        TokenRangeMapping<RingInstance> topology = TokenRangeMappingTest.createTestMapping(0L, 5, this.partitioner, null);
        JobInfo jobInfo = (JobInfo)Mockito.mock(JobInfo.class);
        Mockito.when((Object)jobInfo.getConsistencyLevel()).thenReturn((Object)ConsistencyLevel.CL.LOCAL_QUORUM);
        Mockito.when((Object)jobInfo.getLocalDC()).thenReturn((Object)DATACENTER_1);
        ClusterInfo clusterInfo = (ClusterInfo)Mockito.mock(ClusterInfo.class);
        ReplicationFactor rf = new ReplicationFactor(ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy, (Map)ImmutableMap.of((Object)DATACENTER_1, (Object)3));
        Mockito.when((Object)clusterInfo.replicationFactor()).thenReturn((Object)rf);
        test.accept(new FailureHandlerTextContext(topology, jobInfo, clusterInfo));
    }
}

