/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import o.a.c.sidecar.client.shaded.client.SidecarInstanceImpl;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedWriteConf;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CoordinatedWriteConfTest {
    CoordinatedWriteConfTest() {
    }

    @Test
    void testSerDeser() {
        HashMap<String, CoordinatedWriteConf.SimpleClusterConf> clusters = new HashMap<String, CoordinatedWriteConf.SimpleClusterConf>();
        clusters.put("cluster1", new CoordinatedWriteConf.SimpleClusterConf(Arrays.asList("instance-1:9999", "instance-2:9999", "instance-3:9999"), "dc1"));
        clusters.put("cluster2", new CoordinatedWriteConf.SimpleClusterConf(Arrays.asList("instance-4:8888", "instance-5:8888", "instance-6:8888"), "dc1"));
        CoordinatedWriteConf conf = new CoordinatedWriteConf(clusters);
        String json = conf.toJson();
        Assertions.assertThat((String)json).isEqualTo("{\"cluster1\":{\"sidecarContactPoints\":[\"instance-1:9999\",\"instance-2:9999\",\"instance-3:9999\"],\"localDc\":\"dc1\",\"writeToLocalDcOnly\":false},\"cluster2\":{\"sidecarContactPoints\":[\"instance-4:8888\",\"instance-5:8888\",\"instance-6:8888\"],\"localDc\":\"dc1\",\"writeToLocalDcOnly\":false}}");
        CoordinatedWriteConf deser = CoordinatedWriteConf.create((String)json, (ConsistencyLevel.CL)ConsistencyLevel.CL.LOCAL_QUORUM, CoordinatedWriteConf.SimpleClusterConf.class);
        Assertions.assertThat((Map)deser.clusters()).containsKeys((Object[])new String[]{"cluster1", "cluster2"});
        Assertions.assertThat((Object)deser.cluster("cluster1")).isNotNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> deser.cluster("non-exist-cluster")).isExactlyInstanceOf(NoSuchElementException.class)).hasMessage("No ClusterConf is found for clusterId: non-exist-cluster");
        Assertions.assertThat((List)((CoordinatedWriteConf.SimpleClusterConf)deser.clustersOf(CoordinatedWriteConf.SimpleClusterConf.class).get("cluster1")).sidecarContactPointsValue()).isEqualTo(Arrays.asList("instance-1:9999", "instance-2:9999", "instance-3:9999"));
        Assertions.assertThat((List)((CoordinatedWriteConf.SimpleClusterConf)deser.clustersOf(CoordinatedWriteConf.SimpleClusterConf.class).get("cluster2")).sidecarContactPointsValue()).isEqualTo(Arrays.asList("instance-4:8888", "instance-5:8888", "instance-6:8888"));
        Assertions.assertThat((String)((CoordinatedWriteConf.ClusterConf)deser.clusters().get("cluster1")).localDc()).isEqualTo("dc1");
        Assertions.assertThat((String)((CoordinatedWriteConf.ClusterConf)deser.clusters().get("cluster2")).localDc()).isEqualTo("dc1");
        Set contactPoints = ((CoordinatedWriteConf.ClusterConf)deser.clusters().get("cluster1")).sidecarContactPoints();
        Assertions.assertThat((Collection)contactPoints).hasSize(3);
        Assertions.assertThat((boolean)contactPoints.contains(new SidecarInstanceImpl("instance-1", 9999))).isTrue();
        Assertions.assertThat((boolean)contactPoints.contains(new SidecarInstanceImpl("instance-2", 9999))).isTrue();
        Assertions.assertThat((boolean)contactPoints.contains(new SidecarInstanceImpl("instance-3", 9999))).isTrue();
        contactPoints = ((CoordinatedWriteConf.ClusterConf)deser.clusters().get("cluster2")).sidecarContactPoints();
        Assertions.assertThat((Collection)contactPoints).hasSize(3);
        Assertions.assertThat((boolean)contactPoints.contains(new SidecarInstanceImpl("instance-4", 8888))).isTrue();
        Assertions.assertThat((boolean)contactPoints.contains(new SidecarInstanceImpl("instance-5", 8888))).isTrue();
        Assertions.assertThat((boolean)contactPoints.contains(new SidecarInstanceImpl("instance-6", 8888))).isTrue();
    }

    @Test
    void testDeserFailsWhenInstanceHasNoPort() {
        String json = "{\"cluster1\":{\"sidecarContactPoints\":[\"instance-1\",\"instance-2\",\"instance-3\"],\"localDc\":\"dc1\"}}";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CoordinatedWriteConf.create((String)json, (ConsistencyLevel.CL)ConsistencyLevel.CL.LOCAL_QUORUM, CoordinatedWriteConf.SimpleClusterConf.class)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Unable to parse json string into CoordinatedWriteConf of SimpleClusterConf").hasRootCauseExactlyInstanceOf(IllegalStateException.class).hasRootCauseMessage("Unable to resolve port from instance-1");
    }

    @Test
    void testDeserFailsDueToMissingLocalDcWithNonLocalCL() {
        String json = "{\"cluster1\":{\"sidecarContactPoints\":[\"instance-1:8888\"]}}";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CoordinatedWriteConf.create((String)json, (ConsistencyLevel.CL)ConsistencyLevel.CL.LOCAL_QUORUM, CoordinatedWriteConf.SimpleClusterConf.class)).isExactlyInstanceOf(IllegalStateException.class)).hasMessage("localDc is not configured for cluster: cluster1 for consistency level: LOCAL_QUORUM");
    }

    @Test
    void testResolveLocalDc() {
        CoordinatedWriteConf.SimpleClusterConf clusterWithLocalDc = new CoordinatedWriteConf.SimpleClusterConf(Collections.singletonList("instance-1:9999"), "dc1");
        ((AbstractStringAssert)Assertions.assertThat((String)clusterWithLocalDc.resolveLocalDc((ConsistencyLevel)ConsistencyLevel.CL.EACH_QUORUM)).describedAs("Resolving localDc with Non-local CL should return null", new Object[0])).isNull();
        ((AbstractStringAssert)Assertions.assertThat((String)clusterWithLocalDc.resolveLocalDc((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_QUORUM)).describedAs("Resolving localDc with local CL should return the actual localDc", new Object[0])).isEqualTo("dc1");
        CoordinatedWriteConf.SimpleClusterConf clusterWithoutLocalDc = new CoordinatedWriteConf.SimpleClusterConf(Collections.singletonList("instance-1:9999"), null);
        Assertions.assertThat((String)clusterWithoutLocalDc.resolveLocalDc((ConsistencyLevel)ConsistencyLevel.CL.EACH_QUORUM)).isNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CoordinatedWriteConfTest.lambda$testResolveLocalDc$3((CoordinatedWriteConf.ClusterConf)clusterWithoutLocalDc)).isExactlyInstanceOf(IllegalStateException.class)).hasMessage("No localDc is specified for local consistency level: " + String.valueOf(ConsistencyLevel.CL.LOCAL_QUORUM));
    }

    private static /* synthetic */ void lambda$testResolveLocalDc$3(CoordinatedWriteConf.ClusterConf clusterWithoutLocalDc) throws Throwable {
        clusterWithoutLocalDc.resolveLocalDc((ConsistencyLevel)ConsistencyLevel.CL.LOCAL_QUORUM);
    }
}

