/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.spark.bulkwriter.BroadcastableTableSchema;
import org.apache.cassandra.spark.bulkwriter.CqlTableInfoProvider;
import org.apache.cassandra.spark.bulkwriter.TTLOption;
import org.apache.cassandra.spark.bulkwriter.TableInfoProvider;
import org.apache.cassandra.spark.bulkwriter.TableSchema;
import org.apache.cassandra.spark.bulkwriter.TableSchemaTestCommon;
import org.apache.cassandra.spark.bulkwriter.TimestampOption;
import org.apache.cassandra.spark.bulkwriter.WriteMode;
import org.apache.cassandra.spark.common.schema.ColumnType;
import org.apache.cassandra.spark.common.schema.ColumnTypes;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.exception.UnsupportedAnalyticsOperationException;
import org.apache.cassandra.spark.utils.CqlUtils;
import org.apache.cassandra.spark.utils.CqlUtilsTest;
import org.apache.cassandra.spark.utils.ResourceUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class TableSchemaTest {
    @TempDir
    private static Path tempPath;
    private StructType validDataFrameSchema;
    private ImmutableMap<String, CqlField.CqlType> validCqlColumns;
    private final String[] partitionKeyColumns = new String[]{"id"};
    private final String[] primaryKeyColumnNames = new String[]{"id", "date"};
    private final ColumnType<?>[] partitionKeyColumnTypes = new ColumnType[]{ColumnTypes.INT};

    public TableSchemaTest() {
        Pair<StructType, ImmutableMap<String, CqlField.CqlType>> validPair = TableSchemaTestCommon.buildMatchedDataframeAndCqlColumns(new String[]{"id", "date", "course", "marks"}, new DataType[]{DataTypes.IntegerType, DataTypes.TimestampType, DataTypes.StringType, DataTypes.IntegerType}, new CqlField.CqlType[]{TableSchemaTestCommon.mockCqlType("int"), TableSchemaTestCommon.mockCqlType("date"), TableSchemaTestCommon.mockCqlType("varchar"), TableSchemaTestCommon.mockCqlType("int")});
        this.validDataFrameSchema = (StructType)validPair.getKey();
        this.validCqlColumns = (ImmutableMap)validPair.getValue();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testInsertStatement(String cassandraVersion) {
        TableSchema schema = this.getValidSchemaBuilder(cassandraVersion).build();
        Assertions.assertThat((String)TableSchemaTest.trimUniqueTableName(schema.modificationStatement)).isEqualTo("INSERT INTO test.test (id,date,course,marks) VALUES (:id,:date,:course,:marks);");
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testInsertStatementWithConstantTTL(String cassandraVersion) {
        TableSchema schema = this.getValidSchemaBuilder(cassandraVersion).withTTLSetting(TTLOption.from((String)"1000")).build();
        Assertions.assertThat((String)TableSchemaTest.trimUniqueTableName(schema.modificationStatement)).isEqualTo("INSERT INTO test.test (id,date,course,marks) VALUES (:id,:date,:course,:marks) USING TTL 1000;");
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testInsertStatementWithTTLColumn(String cassandraVersion) {
        TableSchema schema = this.getValidSchemaBuilder(cassandraVersion).withTTLSetting(TTLOption.from((String)"ttl")).build();
        Assertions.assertThat((String)TableSchemaTest.trimUniqueTableName(schema.modificationStatement)).isEqualTo("INSERT INTO test.test (id,date,course,marks) VALUES (:id,:date,:course,:marks) USING TTL :ttl;");
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testInsertStatementWithConstantTimestamp(String cassandraVersion) {
        TableSchema schema = this.getValidSchemaBuilder(cassandraVersion).withTimeStampSetting(TimestampOption.from((String)"1000")).build();
        String expectedQuery = "INSERT INTO test.test (id,date,course,marks) VALUES (:id,:date,:course,:marks) USING TIMESTAMP 1000;";
        Assertions.assertThat((String)TableSchemaTest.trimUniqueTableName(schema.modificationStatement)).isEqualTo(expectedQuery);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testInsertStatementWithTimestampColumn(String cassandraVersion) {
        TableSchema schema = this.getValidSchemaBuilder(cassandraVersion).withTimeStampSetting(TimestampOption.from((String)"timestamp")).build();
        String expectedQuery = "INSERT INTO test.test (id,date,course,marks) VALUES (:id,:date,:course,:marks) USING TIMESTAMP :timestamp;";
        Assertions.assertThat((String)TableSchemaTest.trimUniqueTableName(schema.modificationStatement)).isEqualTo(expectedQuery);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testInsertStatementWithTTLAndTimestampColumn(String cassandraVersion) {
        TableSchema schema = this.getValidSchemaBuilder(cassandraVersion).withTTLSetting(TTLOption.from((String)"ttl")).withTimeStampSetting(TimestampOption.from((String)"timestamp")).build();
        String expectedQuery = "INSERT INTO test.test (id,date,course,marks) VALUES (:id,:date,:course,:marks) USING TIMESTAMP :timestamp AND TTL :ttl;";
        Assertions.assertThat((String)TableSchemaTest.trimUniqueTableName(schema.modificationStatement)).isEqualTo(expectedQuery);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testDeleteStatement(String cassandraVersion) {
        Pair<StructType, ImmutableMap<String, CqlField.CqlType>> validPair = TableSchemaTestCommon.buildMatchedDataframeAndCqlColumns(new String[]{"id"}, new DataType[]{DataTypes.IntegerType}, new CqlField.CqlType[]{TableSchemaTestCommon.mockCqlType("int")});
        this.validDataFrameSchema = (StructType)validPair.getKey();
        this.validCqlColumns = (ImmutableMap)validPair.getValue();
        TableSchema schema = this.getValidSchemaBuilder(cassandraVersion).withWriteMode(WriteMode.DELETE_PARTITION).build();
        Assertions.assertThat((String)TableSchemaTest.trimUniqueTableName(schema.modificationStatement)).isEqualTo("DELETE FROM test.test where id=?;");
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testDeleteWithNonPartitionKeyFieldsInDfFails(String cassandraVersion) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getValidSchemaBuilder(cassandraVersion).withWriteMode(WriteMode.DELETE_PARTITION).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Only partition key columns (id) are supported in the input Dataframe when WRITE_MODE=DELETE_PARTITION but (id,date,course,marks) columns were provided");
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testPartitionKeyColumnNames(String cassandraVersion) {
        TableSchema schema = this.getValidSchemaBuilder(cassandraVersion).build();
        Assertions.assertThat((List)schema.partitionKeyColumns).isEqualTo(Arrays.asList("id"));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testPartitionKeyColumnTypes(String cassandraVersion) {
        TableSchema schema = this.getValidSchemaBuilder(cassandraVersion).build();
        Assertions.assertThat((List)schema.partitionKeyColumnTypes).isEqualTo(Arrays.asList(ColumnTypes.INT));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void normalizeConvertsValidTable(String cassandraVersion) {
        TableSchema schema = this.getValidSchemaBuilder(cassandraVersion).build();
        BroadcastableTableSchema broadcastable = BroadcastableTableSchema.from((TableSchema)schema);
        Assertions.assertThat((Object[])broadcastable.normalize(new Object[]{1, 1L, "foo", 2})).isEqualTo((Object)new Object[]{1, Integer.MIN_VALUE, "foo", 2});
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testExtraFieldsInDataFrameFails(String cassandraVersion) {
        StructType extraFieldsDataFrameSchema = new StructType().add("id", DataTypes.IntegerType).add("date", DataTypes.TimestampType).add("extra_field", DataTypes.StringType).add("course", DataTypes.StringType).add("marks", DataTypes.IntegerType);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getValidSchemaBuilder(cassandraVersion).withDataFrameSchema(extraFieldsDataFrameSchema).build()).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Unknown fields");
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testGetKeyColumnsFindsCorrectValues(String cassandraVersion) {
        StructType outOfOrderDataFrameSchema = new StructType().add("date", DataTypes.TimestampType).add("id", DataTypes.IntegerType).add("course", DataTypes.StringType).add("marks", DataTypes.IntegerType);
        TableSchema schema = this.getValidSchemaBuilder(cassandraVersion).withDataFrameSchema(outOfOrderDataFrameSchema).build();
        BroadcastableTableSchema broadcastable = BroadcastableTableSchema.from((TableSchema)schema);
        Assertions.assertThat((Object[])broadcastable.getKeyColumns(new Object[]{"date_val", "id_val", "course_val", "marks_val"})).isEqualTo((Object)new Object[]{"id_val", "date_val"});
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testGetKeyColumnsFailsWhenNullKeyValues(String cassandraVersion) {
        TableSchema schema = this.getValidSchemaBuilder(cassandraVersion).build();
        BroadcastableTableSchema broadcastable = BroadcastableTableSchema.from((TableSchema)schema);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> broadcastable.getKeyColumns(new Object[]{"foo", null, "baz", "boo"})).isInstanceOf(NullPointerException.class)).hasMessage("Found a null primary or composite key column in source data. All key columns must be non-null.");
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testMissingPrimaryKeyFieldFails(String cassandraVersion) {
        StructType missingFieldsDataFrame = new StructType().add("id", DataTypes.IntegerType).add("course", DataTypes.StringType).add("marks", DataTypes.IntegerType);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getValidSchemaBuilder(cassandraVersion).withWriteMode(WriteMode.INSERT).withDataFrameSchema(missingFieldsDataFrame).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Missing some required key components in DataFrame => date");
    }

    @Test
    public void testSecondaryIndexIsUnsupported() throws Exception {
        Path fullSchemaSampleFile = ResourceUtils.writeResourceToPath(CqlUtilsTest.class.getClassLoader(), tempPath, "cql/fullSchema.cql");
        String fullSchemaSample = FileUtils.readFileToString((File)fullSchemaSampleFile.toFile(), (Charset)StandardCharsets.UTF_8);
        int indexCount = CqlUtils.extractIndexCount((String)fullSchemaSample, (String)"cycling", (String)"rank_by_year_and_name");
        Assertions.assertThat((int)indexCount).isEqualTo(3);
        CqlTable table = (CqlTable)Mockito.mock(CqlTable.class);
        Mockito.when((Object)table.indexCount()).thenReturn((Object)indexCount);
        CqlTableInfoProvider tableInfoProvider = new CqlTableInfoProvider("", table);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableSchemaTest.lambda$testSecondaryIndexIsUnsupported$4((TableInfoProvider)tableInfoProvider)).isInstanceOf(UnsupportedAnalyticsOperationException.class)).hasMessage("Bulkwriter doesn't support secondary indexes");
    }

    private TableSchemaTestCommon.MockTableSchemaBuilder getValidSchemaBuilder(String cassandraVersion) {
        return new TableSchemaTestCommon.MockTableSchemaBuilder(CassandraBridgeFactory.get((String)cassandraVersion)).withCqlColumns((Map<String, CqlField.CqlType>)this.validCqlColumns).withPartitionKeyColumns(this.partitionKeyColumns).withPrimaryKeyColumnNames(this.primaryKeyColumnNames).withCassandraVersion(cassandraVersion).withPartitionKeyColumnTypes(this.partitionKeyColumnTypes).withWriteMode(WriteMode.INSERT).withDataFrameSchema(this.validDataFrameSchema);
    }

    private static String trimUniqueTableName(String statement) {
        return statement.replaceAll("test.test_table_\\d+", "test.test");
    }

    private static /* synthetic */ void lambda$testSecondaryIndexIsUnsupported$4(TableInfoProvider tableInfoProvider) throws Throwable {
        TableSchema.validateNoSecondaryIndexes((TableInfoProvider)tableInfoProvider);
    }
}

