/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import org.apache.cassandra.analytics.SparkTestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SparkTestUtilsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkTestUtilsProvider.class);

    private SparkTestUtilsProvider() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static SparkTestUtils utils() {
        String className = System.getProperty("cassandra.analytics.spark.test_utils");
        if (className != null) {
            try {
                LOGGER.info("Instantiating SparkTestUtils with class name {}", (Object)className);
                return (SparkTestUtils)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to initialize class {}", (Object)className, (Object)e);
            }
        }
        return new SparkTestUtils();
    }
}

