/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.avro;

import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.cassandra.bridge.BridgeInitializationParameters;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraSchema;
import org.apache.cassandra.bridge.CassandraTypesImplementation;
import org.apache.cassandra.cdc.avro.AvroSchemas;
import org.apache.cassandra.cdc.avro.CqlToAvroSchemaConverter;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.db.marshal.EmptyType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.FrozenType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;

public class CqlToAvroSchemaConverterImplementation
implements CqlToAvroSchemaConverter {
    private static final Pattern KEYSPACE_TABLE_MATCH = Pattern.compile("CREATE TABLE (\\S+)\\.(\\S+)");
    public CassandraBridge bridge;

    public CqlToAvroSchemaConverterImplementation() {
    }

    public CqlToAvroSchemaConverterImplementation(CassandraBridge bridge) {
        this.bridge = bridge;
    }

    public Schema convert(CassandraBridge bridge, String tableCreateStatement) {
        return this.convert(bridge, tableCreateStatement, Collections.emptySet());
    }

    public Schema convert(CassandraBridge bridge, String tableCreateStatement, Set<String> udts) {
        Matcher m = KEYSPACE_TABLE_MATCH.matcher(tableCreateStatement);
        if (!m.find() || m.groupCount() != 2) {
            throw new IllegalArgumentException("Invalid create table statement");
        }
        String keyspace = m.group(1);
        String table = m.group(2);
        return this.convert(keyspace, tableCreateStatement, udts);
    }

    public CassandraBridge cassandraBridge() {
        return this.bridge;
    }

    public Schema convert(CqlTable cqlTable) {
        String keyspace = cqlTable.keyspace();
        String table = cqlTable.table();
        TableMetadata tableMetadata = (TableMetadata)CassandraSchema.getTable((String)keyspace, (String)table).orElseThrow(() -> new NoSuchElementException(String.format("Table %s/%s is not defined!", keyspace, table)));
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>(cqlTable.numFields());
        ArrayList<String> primaryKeys = new ArrayList<String>();
        ArrayList<String> partitionKeys = new ArrayList<String>();
        ArrayList<String> clusteringKeys = new ArrayList<String>();
        ArrayList<String> staticColumns = new ArrayList<String>();
        String topLevelNamespace = String.format("%s.%s", keyspace, table);
        for (CqlField cqlField : cqlTable.fields()) {
            ColumnMetadata column = tableMetadata.getColumn(new ColumnIdentifier(cqlField.name(), false));
            Schema avroField = CqlToAvroSchemaConverterImplementation.schemaFrom(column, topLevelNamespace);
            fields.add(new Schema.Field(column.name.toString(), avroField, "doc", null, Schema.Field.Order.ASCENDING));
            if (column.isPrimaryKeyColumn()) {
                primaryKeys.add(column.name.toString());
                if (column.isPartitionKey()) {
                    partitionKeys.add(column.name.toString());
                    continue;
                }
                clusteringKeys.add(column.name.toString());
                continue;
            }
            if (!column.isStatic()) continue;
            staticColumns.add(column.name.toString());
        }
        Schema avroSchema = Schema.createRecord((String)table, (String)"doc", (String)topLevelNamespace, (boolean)false, fields);
        AvroSchemas.setPrimaryKeys((Schema)avroSchema, primaryKeys);
        AvroSchemas.setPartitionKeys((Schema)avroSchema, partitionKeys);
        AvroSchemas.setClusteringKeys((Schema)avroSchema, clusteringKeys);
        AvroSchemas.setStaticColumns((Schema)avroSchema, staticColumns);
        return avroSchema;
    }

    private static Schema schemaFrom(ColumnMetadata column, String namespace) {
        Schema schema = CqlToAvroSchemaConverterImplementation.schemaFrom(column.type, namespace + "." + column.name.toString());
        return (Schema)SchemaBuilder.nullable().type(schema);
    }

    private static boolean isFrozen(AbstractType<?> type) {
        return type.isFreezable() && !type.isMultiCell() || type instanceof FrozenType;
    }

    private static Schema schemaFrom(AbstractType<?> columnCqlType, String namespace) {
        Schema result;
        AbstractType cqlType;
        AbstractType abstractType = cqlType = columnCqlType.isReversed() ? ((ReversedType)columnCqlType).baseType : columnCqlType;
        if (cqlType instanceof ListType) {
            String collectionNamespace = namespace + "." + cqlType.asCQL3Type().toString();
            result = (Schema)SchemaBuilder.array().items(CqlToAvroSchemaConverterImplementation.schemaFrom(((ListType)cqlType).getElementsType(), collectionNamespace));
        } else if (cqlType instanceof SetType) {
            String collectionNamespace = namespace + "." + cqlType.asCQL3Type().toString();
            result = (Schema)SchemaBuilder.array().items(CqlToAvroSchemaConverterImplementation.schemaFrom(((SetType)cqlType).getElementsType(), collectionNamespace));
            AvroSchemas.flagArrayAsSet((Schema)result);
        } else if (cqlType instanceof MapType) {
            String arrayBasedMapName = "array_map";
            String childNamespace = namespace + "." + arrayBasedMapName;
            SchemaBuilder.FieldAssembler keyValue = ((SchemaBuilder.RecordBuilder)SchemaBuilder.builder().record(arrayBasedMapName).namespace(childNamespace)).fields();
            MapType cqlMap = (MapType)cqlType;
            keyValue.name("key").type(CqlToAvroSchemaConverterImplementation.schemaFrom(cqlMap.getKeysType(), childNamespace)).noDefault();
            keyValue.name("value").type(CqlToAvroSchemaConverterImplementation.schemaFrom(cqlMap.getValuesType(), childNamespace)).noDefault();
            result = (Schema)SchemaBuilder.builder().array().items((Schema)keyValue.endRecord());
            AvroSchemas.flagArrayAsMap((Schema)result);
        } else if (cqlType instanceof UserType) {
            UserType userType = (UserType)cqlType;
            String recordBasedUdt = "record_udt";
            String childNamespace = namespace + "." + recordBasedUdt;
            Schema[] ar = (Schema[])userType.fieldTypes().stream().map(udtType -> CqlToAvroSchemaConverterImplementation.schemaFrom(udtType, childNamespace)).toArray(Schema[]::new);
            SchemaBuilder.FieldAssembler udtValue = ((SchemaBuilder.RecordBuilder)SchemaBuilder.builder().record(recordBasedUdt).namespace(childNamespace)).fields();
            for (int i = 0; i < ar.length; ++i) {
                udtValue.name(userType.fieldNameAsString(i)).type(ar[i]).noDefault();
            }
            result = (Schema)udtValue.endRecord();
            AvroSchemas.flagAsUdt((Schema)result);
        } else {
            result = CqlToAvroSchemaConverterImplementation.convertLiteralType(cqlType, namespace);
        }
        AvroSchemas.flagCqlType((Schema)result, (String)cqlType.asCQL3Type().toString());
        if (CqlToAvroSchemaConverterImplementation.isFrozen(cqlType)) {
            AvroSchemas.flagFrozen((Schema)result);
        }
        if (columnCqlType.isReversed()) {
            AvroSchemas.flagReversed((Schema)result);
        }
        return result;
    }

    private static Schema convertLiteralType(AbstractType<?> cqlType, String namespace) {
        Schema result;
        if (cqlType instanceof AsciiType) {
            result = (Schema)SchemaBuilder.builder((String)namespace).stringType();
        } else if (cqlType instanceof LongType) {
            result = (Schema)SchemaBuilder.builder((String)namespace).longType();
        } else if (cqlType instanceof BytesType) {
            result = (Schema)SchemaBuilder.builder((String)namespace).bytesType();
        } else if (cqlType instanceof BooleanType) {
            result = (Schema)SchemaBuilder.builder((String)namespace).booleanType();
        } else if (cqlType instanceof SimpleDateType) {
            result = (Schema)SchemaBuilder.builder((String)namespace).intType();
            LogicalTypes.date().addToSchema(result);
        } else if (cqlType instanceof DecimalType) {
            result = (Schema)SchemaBuilder.builder((String)namespace).fixed(".fixed").size(16);
            LogicalTypes.decimal((int)38, (int)19).addToSchema(result);
        } else if (cqlType instanceof DoubleType) {
            result = (Schema)SchemaBuilder.builder((String)namespace).doubleType();
        } else if (cqlType instanceof FloatType) {
            result = (Schema)SchemaBuilder.builder((String)namespace).floatType();
        } else if (cqlType instanceof InetAddressType) {
            result = (Schema)SchemaBuilder.builder((String)namespace).bytesType();
            new LogicalType("inet").addToSchema(result);
        } else if (cqlType instanceof Int32Type || cqlType instanceof ShortType) {
            result = (Schema)SchemaBuilder.builder((String)namespace).intType();
        } else if (cqlType instanceof UTF8Type) {
            result = (Schema)SchemaBuilder.builder((String)namespace).stringType();
        } else if (cqlType instanceof TimeType) {
            result = (Schema)SchemaBuilder.builder((String)namespace).longType();
        } else if (cqlType instanceof TimestampType) {
            result = (Schema)SchemaBuilder.builder((String)namespace).longType();
            LogicalTypes.timestampMicros().addToSchema(result);
        } else if (cqlType instanceof TimeUUIDType || cqlType instanceof UUIDType) {
            result = (Schema)SchemaBuilder.builder((String)namespace).stringType();
            LogicalTypes.uuid().addToSchema(result);
        } else if (cqlType instanceof ByteType) {
            result = (Schema)SchemaBuilder.builder((String)namespace).intType();
        } else if (cqlType instanceof IntegerType) {
            result = (Schema)SchemaBuilder.builder((String)namespace).fixed(".fixed").size(16);
            LogicalTypes.decimal((int)38, (int)0).addToSchema(result);
        } else {
            if (cqlType instanceof DurationType || cqlType instanceof EmptyType || cqlType instanceof CounterColumnType) {
                throw new UnsupportedOperationException("Unsupported Cql data type " + String.valueOf(cqlType.asCQL3Type()));
            }
            throw new RuntimeException("Unknown Cql datatype " + String.valueOf(cqlType.asCQL3Type()));
        }
        return result;
    }

    static {
        CassandraTypesImplementation.setup((BridgeInitializationParameters)BridgeInitializationParameters.fromEnvironment());
    }
}

