/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import com.codahale.metrics.Meter;
import java.util.Map;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.metrics.ReadRepairMetrics;
import org.apache.cassandra.service.reads.repair.AbstractReadRepair;
import org.apache.cassandra.transport.Dispatcher;

public class ReadOnlyReadRepair<E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E, P>>
extends AbstractReadRepair<E, P> {
    ReadOnlyReadRepair(ReadCommand command, ReplicaPlan.Shared<E, P> replicaPlan, Dispatcher.RequestTime requestTime) {
        super(command, replicaPlan, requestTime);
    }

    @Override
    public UnfilteredPartitionIterators.MergeListener getMergeListener(P replicaPlan) {
        return UnfilteredPartitionIterators.MergeListener.NOOP;
    }

    @Override
    Meter getRepairMeter() {
        return ReadRepairMetrics.reconcileRead;
    }

    @Override
    public void maybeSendAdditionalWrites() {
    }

    @Override
    public void repairPartition(DecoratedKey partitionKey, Map<Replica, Mutation> mutations, ReplicaPlan.ForWrite writePlan) {
        throw new UnsupportedOperationException("ReadOnlyReadRepair shouldn't be trying to repair partitions");
    }

    @Override
    public void awaitWrites() {
    }
}

