/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.state;

import com.google.common.base.Throwables;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.repair.state.Completable;
import org.apache.cassandra.utils.Clock;

public abstract class AbstractCompletable<I>
implements Completable<I> {
    private final long creationTimeMillis;
    private final long creationTimeNanos;
    protected final Clock clock;
    private final AtomicReference<Completable.Result> result = new AtomicReference<Object>(null);
    public final I id;
    protected volatile long lastUpdatedAtNs;

    public AbstractCompletable(Clock clock, I id) {
        this.creationTimeMillis = clock.currentTimeMillis();
        this.creationTimeNanos = clock.nanoTime();
        this.clock = clock;
        this.id = id;
    }

    public abstract boolean isAccepted();

    public Status getCompletionStatus() {
        Completable.Result result = this.getResult();
        if (result != null) {
            return Status.COMPLETED;
        }
        return this.isAccepted() ? Status.ACCEPTED : Status.INIT;
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public long getInitializedAtMillis() {
        return this.nanosToMillis(this.creationTimeNanos);
    }

    @Override
    public long getInitializedAtNanos() {
        return this.creationTimeNanos;
    }

    @Override
    public long getLastUpdatedAtMillis() {
        return this.nanosToMillis(this.lastUpdatedAtNs);
    }

    @Override
    public long getLastUpdatedAtNanos() {
        return this.lastUpdatedAtNs;
    }

    @Override
    public Completable.Result getResult() {
        return this.result.get();
    }

    public void updated() {
        this.lastUpdatedAtNs = this.clock.nanoTime();
    }

    protected boolean tryResult(Completable.Result result) {
        if (!this.result.compareAndSet(null, result)) {
            return false;
        }
        this.onComplete();
        this.lastUpdatedAtNs = this.clock.nanoTime();
        return true;
    }

    protected void onComplete() {
    }

    protected long nanosToMillis(long nanos) {
        return this.creationTimeMillis + TimeUnit.NANOSECONDS.toMillis(nanos - this.creationTimeNanos);
    }

    protected class BasePhase {
        protected BasePhase() {
        }

        public void success() {
            AbstractCompletable.this.tryResult(Completable.Result.success());
        }

        public void success(String msg) {
            AbstractCompletable.this.tryResult(Completable.Result.success(msg));
        }

        public void fail(Throwable e) {
            this.fail(e == null ? null : Throwables.getStackTraceAsString((Throwable)e));
        }

        public void fail(String failureCause) {
            AbstractCompletable.this.tryResult(Completable.Result.fail(failureCause));
        }
    }

    protected class BaseSkipPhase
    extends BasePhase {
        protected BaseSkipPhase() {
        }

        public void skip(String msg) {
            AbstractCompletable.this.tryResult(Completable.Result.skip(msg));
        }
    }

    public static enum Status {
        INIT,
        ACCEPTED,
        COMPLETED;

    }
}

