/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import org.apache.cassandra.concurrent.ResizableThreadPool;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;

public class ThreadPoolMetrics {
    public static final String ACTIVE_TASKS = "ActiveTasks";
    public static final String PENDING_TASKS = "PendingTasks";
    public static final String COMPLETED_TASKS = "CompletedTasks";
    public static final String CURRENTLY_BLOCKED_TASKS = "CurrentlyBlockedTasks";
    public static final String TOTAL_BLOCKED_TASKS = "TotalBlockedTasks";
    public static final String MAX_POOL_SIZE = "MaxPoolSize";
    public static final String MAX_TASKS_QUEUED = "MaxTasksQueued";
    public static final String OLDEST_TASK_QUEUE_TIME = "OldestTaskQueueTime";
    public final Gauge<Integer> activeTasks;
    public final Gauge<Integer> pendingTasks;
    public final Gauge<Long> completedTasks;
    public final Counter currentBlocked;
    public final Counter totalBlocked;
    public final Gauge<Integer> maxPoolSize;
    public final Gauge<Long> oldestTaskQueueTime;
    public final Gauge<Integer> maxTasksQueued;
    public final String path;
    public final String poolName;

    public ThreadPoolMetrics(ResizableThreadPool executor, String path, String poolName) {
        this.path = path;
        this.poolName = poolName;
        this.totalBlocked = new Counter();
        this.currentBlocked = new Counter();
        this.activeTasks = executor::getActiveTaskCount;
        this.pendingTasks = executor::getPendingTaskCount;
        this.completedTasks = executor::getCompletedTaskCount;
        this.maxPoolSize = executor::getMaximumPoolSize;
        this.maxTasksQueued = executor::getMaxTasksQueued;
        this.oldestTaskQueueTime = executor::oldestTaskQueueTime;
    }

    public ThreadPoolMetrics register() {
        CassandraMetricsRegistry.Metrics.register(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, ACTIVE_TASKS), this.activeTasks);
        CassandraMetricsRegistry.Metrics.register(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, PENDING_TASKS), this.pendingTasks);
        CassandraMetricsRegistry.Metrics.register(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, COMPLETED_TASKS), this.completedTasks);
        CassandraMetricsRegistry.Metrics.register(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, CURRENTLY_BLOCKED_TASKS), this.currentBlocked);
        CassandraMetricsRegistry.Metrics.register(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, TOTAL_BLOCKED_TASKS), this.totalBlocked);
        CassandraMetricsRegistry.Metrics.register(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, MAX_POOL_SIZE), this.maxPoolSize);
        CassandraMetricsRegistry.Metrics.register(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, MAX_TASKS_QUEUED), this.maxTasksQueued);
        CassandraMetricsRegistry.Metrics.register(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, OLDEST_TASK_QUEUE_TIME), this.oldestTaskQueueTime);
        return CassandraMetricsRegistry.Metrics.register(this);
    }

    public void release() {
        CassandraMetricsRegistry.Metrics.remove(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, ACTIVE_TASKS));
        CassandraMetricsRegistry.Metrics.remove(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, PENDING_TASKS));
        CassandraMetricsRegistry.Metrics.remove(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, COMPLETED_TASKS));
        CassandraMetricsRegistry.Metrics.remove(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, CURRENTLY_BLOCKED_TASKS));
        CassandraMetricsRegistry.Metrics.remove(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, TOTAL_BLOCKED_TASKS));
        CassandraMetricsRegistry.Metrics.remove(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, MAX_POOL_SIZE));
        CassandraMetricsRegistry.Metrics.remove(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, MAX_TASKS_QUEUED));
        CassandraMetricsRegistry.Metrics.remove(ThreadPoolMetrics.makeMetricName(this.path, this.poolName, OLDEST_TASK_QUEUE_TIME));
        CassandraMetricsRegistry.Metrics.remove(this);
    }

    private static CassandraMetricsRegistry.MetricName makeMetricName(String path, String poolName, String metricName) {
        return new CassandraMetricsRegistry.MetricName("org.apache.cassandra.metrics", "ThreadPools", metricName, path + "." + poolName, String.format("org.apache.cassandra.metrics:type=ThreadPools,path=%s,scope=%s,name=%s", path, poolName, metricName));
    }
}

