/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.utils;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;

public class PartitionInfo {
    public final DecoratedKey key;
    public final Row staticRow;
    @Nullable
    public final DeletionTime partitionDeletion;
    @Nullable
    public final EncodingStats encodingStats;

    public PartitionInfo(DecoratedKey key, Row staticRow) {
        this.key = key;
        this.staticRow = staticRow;
        this.partitionDeletion = null;
        this.encodingStats = null;
    }

    public PartitionInfo(DecoratedKey key, Row staticRow, DeletionTime partitionDeletion, EncodingStats encodingStats) {
        this.key = key;
        this.staticRow = staticRow;
        this.partitionDeletion = partitionDeletion;
        this.encodingStats = encodingStats;
    }

    public static <U extends Unfiltered, R extends BaseRowIterator<U>> PartitionInfo create(R baseRowIterator) {
        return baseRowIterator instanceof UnfilteredRowIterator ? new PartitionInfo(baseRowIterator.partitionKey(), baseRowIterator.staticRow(), ((UnfilteredRowIterator)baseRowIterator).partitionLevelDeletion(), ((UnfilteredRowIterator)baseRowIterator).stats()) : new PartitionInfo(baseRowIterator.partitionKey(), baseRowIterator.staticRow());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionInfo that = (PartitionInfo)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.staticRow, that.staticRow) && Objects.equals(this.partitionDeletion, that.partitionDeletion) && Objects.equals(this.encodingStats, that.encodingStats);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.staticRow, this.partitionDeletion, this.encodingStats);
    }
}

