/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.plan;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sai.utils.IndexTermType;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Expression {
    Logger logger = LoggerFactory.getLogger(Expression.class);
    private final IndexTermType indexTermType;
    protected IndexOperator operator;
    public Bound lower;
    public Bound upper;
    public boolean upperInclusive;
    public boolean lowerInclusive;

    Expression(IndexTermType indexTermType) {
        this.indexTermType = indexTermType;
    }

    public static Expression create(StorageAttachedIndex index) {
        return new IndexedExpression(index);
    }

    public static Expression create(IndexTermType indexTermType) {
        return new UnindexedExpression(indexTermType);
    }

    public static boolean supportsOperator(Operator operator) {
        return IndexOperator.valueOf(operator) != null;
    }

    public abstract boolean isNotIndexed();

    public abstract StorageAttachedIndex getIndex();

    abstract boolean hasAnalyzer();

    abstract AbstractAnalyzer getAnalyzer();

    public IndexOperator getIndexOperator() {
        return this.operator;
    }

    public IndexTermType getIndexTermType() {
        return this.indexTermType;
    }

    public Bound lower() {
        return this.lower;
    }

    public Bound upper() {
        return this.upper;
    }

    public Expression add(Operator op, ByteBuffer value) {
        boolean upperInclusive;
        boolean lowerInclusive = upperInclusive = this.indexTermType.supportsRounding();
        switch (op) {
            case EQ: 
            case CONTAINS: 
            case CONTAINS_KEY: {
                this.upper = this.lower = new Bound(value, this.indexTermType, true);
                this.operator = IndexOperator.valueOf(op);
                break;
            }
            case LTE: {
                if (this.indexTermType.isReversed()) {
                    this.lowerInclusive = true;
                    lowerInclusive = true;
                } else {
                    this.upperInclusive = true;
                    upperInclusive = true;
                }
            }
            case LT: {
                this.operator = IndexOperator.RANGE;
                if (this.indexTermType.isReversed()) {
                    this.lower = new Bound(value, this.indexTermType, lowerInclusive);
                    break;
                }
                this.upper = new Bound(value, this.indexTermType, upperInclusive);
                break;
            }
            case GTE: {
                if (this.indexTermType.isReversed()) {
                    this.upperInclusive = true;
                    upperInclusive = true;
                } else {
                    this.lowerInclusive = true;
                    lowerInclusive = true;
                }
            }
            case GT: {
                this.operator = IndexOperator.RANGE;
                if (this.indexTermType.isReversed()) {
                    this.upper = new Bound(value, this.indexTermType, upperInclusive);
                    break;
                }
                this.lower = new Bound(value, this.indexTermType, lowerInclusive);
                break;
            }
            case ANN: {
                this.operator = IndexOperator.ANN;
                this.upper = this.lower = new Bound(value, this.indexTermType, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Index does not support the " + op + " operator");
            }
        }
        return this;
    }

    public boolean isSatisfiedBy(ByteBuffer columnValue) {
        int cmp;
        if (this.indexTermType.isVector()) {
            return true;
        }
        if (!this.indexTermType.isValid(columnValue)) {
            this.logger.error("Value is not valid for indexed column {} with {}", (Object)this.indexTermType.columnName(), this.indexTermType.indexType());
            return false;
        }
        Value value = new Value(columnValue, this.indexTermType);
        if (this.lower != null) {
            if (this.indexTermType.isLiteral()) {
                return this.validateStringValue(value.raw, this.lower.value.raw);
            }
            cmp = this.indexTermType.comparePostFilter(this.lower.value, value);
            if (this.operator == IndexOperator.EQ || this.operator == IndexOperator.CONTAINS_KEY || this.operator == IndexOperator.CONTAINS_VALUE) {
                return cmp == 0;
            }
            if (cmp > 0 || cmp == 0 && !this.lowerInclusive) {
                return false;
            }
        }
        if (this.upper != null && this.lower != this.upper) {
            if (this.indexTermType.isLiteral()) {
                return this.validateStringValue(value.raw, this.upper.value.raw);
            }
            cmp = this.indexTermType.comparePostFilter(this.upper.value, value);
            return cmp > 0 || cmp == 0 && this.upperInclusive;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateStringValue(ByteBuffer columnValue, ByteBuffer requestedValue) {
        if (this.hasAnalyzer()) {
            AbstractAnalyzer analyzer = this.getAnalyzer();
            analyzer.reset(columnValue.duplicate());
            try {
                while (analyzer.hasNext()) {
                    if (!this.termMatches(analyzer.next(), requestedValue)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                analyzer.end();
            }
        }
        return this.termMatches(columnValue, requestedValue);
    }

    private boolean termMatches(ByteBuffer term, ByteBuffer requestedValue) {
        boolean isMatch = false;
        switch (this.operator) {
            case EQ: 
            case CONTAINS_KEY: 
            case CONTAINS_VALUE: {
                isMatch = this.indexTermType.compare(term, requestedValue) == 0;
                break;
            }
            case RANGE: {
                isMatch = this.isLowerSatisfiedBy(term) && this.isUpperSatisfiedBy(term);
            }
        }
        return isMatch;
    }

    private boolean hasLower() {
        return this.lower != null;
    }

    private boolean hasUpper() {
        return this.upper != null;
    }

    private boolean isLowerSatisfiedBy(ByteBuffer value) {
        if (!this.hasLower()) {
            return true;
        }
        int cmp = this.indexTermType.indexType().compare(value, this.lower.value.raw);
        return cmp > 0 || cmp == 0 && this.lower.inclusive;
    }

    private boolean isUpperSatisfiedBy(ByteBuffer value) {
        if (!this.hasUpper()) {
            return true;
        }
        int cmp = this.indexTermType.indexType().compare(value, this.upper.value.raw);
        return cmp < 0 || cmp == 0 && this.upper.inclusive;
    }

    public String toString() {
        return String.format("Expression{name: %s, op: %s, lower: (%s, %s), upper: (%s, %s)}", new Object[]{this.indexTermType.columnName(), this.operator, this.lower == null ? "null" : this.indexTermType.asString(this.lower.value.raw), this.lower != null && this.lower.inclusive, this.upper == null ? "null" : this.indexTermType.asString(this.upper.value.raw), this.upper != null && this.upper.inclusive});
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.indexTermType).append((Object)this.operator).append((Object)this.lower).append((Object)this.upper).build();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Expression)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Expression o = (Expression)other;
        return Objects.equals(this.indexTermType, o.indexTermType) && this.operator == o.operator && Objects.equals(this.lower, o.lower) && Objects.equals(this.upper, o.upper);
    }

    public static class Bound {
        public final Value value;
        public final boolean inclusive;

        public Bound(ByteBuffer value, IndexTermType indexTermType, boolean inclusive) {
            this.value = new Value(value, indexTermType);
            this.inclusive = inclusive;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Bound)) {
                return false;
            }
            Bound o = (Bound)other;
            return this.value.equals(o.value) && this.inclusive == o.inclusive;
        }

        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append((Object)this.value);
            builder.append(this.inclusive);
            return builder.toHashCode();
        }
    }

    public static class Value {
        public final ByteBuffer raw;
        public final ByteBuffer encoded;

        public Value(ByteBuffer value, IndexTermType indexTermType) {
            this.raw = value;
            this.encoded = indexTermType.asIndexBytes(value);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Value)) {
                return false;
            }
            Value o = (Value)other;
            return this.raw.equals(o.raw) && this.encoded.equals(o.encoded);
        }

        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append((Object)this.raw);
            builder.append((Object)this.encoded);
            return builder.toHashCode();
        }
    }

    public static class UnindexedExpression
    extends Expression {
        private UnindexedExpression(IndexTermType indexTermType) {
            super(indexTermType);
        }

        @Override
        public boolean isNotIndexed() {
            return true;
        }

        @Override
        public StorageAttachedIndex getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean hasAnalyzer() {
            return false;
        }

        @Override
        AbstractAnalyzer getAnalyzer() {
            throw new UnsupportedOperationException();
        }
    }

    public static class IndexedExpression
    extends Expression {
        private final StorageAttachedIndex index;

        public IndexedExpression(StorageAttachedIndex index) {
            super(index.termType());
            this.index = index;
        }

        @Override
        public boolean isNotIndexed() {
            return false;
        }

        @Override
        public StorageAttachedIndex getIndex() {
            return this.index;
        }

        @Override
        boolean hasAnalyzer() {
            return this.index.hasAnalyzer();
        }

        @Override
        AbstractAnalyzer getAnalyzer() {
            return this.index.analyzer();
        }
    }

    public static enum IndexOperator {
        EQ,
        RANGE,
        CONTAINS_KEY,
        CONTAINS_VALUE,
        ANN;


        public static IndexOperator valueOf(Operator operator) {
            switch (operator) {
                case EQ: {
                    return EQ;
                }
                case CONTAINS: {
                    return CONTAINS_VALUE;
                }
                case CONTAINS_KEY: {
                    return CONTAINS_KEY;
                }
                case LT: 
                case GT: 
                case LTE: 
                case GTE: {
                    return RANGE;
                }
                case ANN: {
                    return ANN;
                }
            }
            return null;
        }

        public boolean isEquality() {
            return this == EQ || this == CONTAINS_KEY || this == CONTAINS_VALUE;
        }

        public boolean isEqualityOrRange() {
            return this.isEquality() || this == RANGE;
        }
    }
}

