/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.trie;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.io.tries.SerializationNode;
import org.apache.cassandra.io.tries.TrieNode;
import org.apache.cassandra.io.tries.TrieSerializer;
import org.apache.cassandra.io.tries.Walker;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.io.util.SizedInts;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;

@NotThreadSafe
public class TrieTermsDictionaryReader
extends Walker<TrieTermsDictionaryReader> {
    public static final long NOT_FOUND = -1L;
    public static final TrieSerializer<Long, DataOutputPlus> trieSerializer = new TrieSerializer<Long, DataOutputPlus>(){

        @Override
        public int sizeofNode(SerializationNode<Long> node, long nodePosition) {
            return TrieNode.typeFor(node, nodePosition).sizeofNode(node) + this.sizeof(node.payload());
        }

        @Override
        public void write(DataOutputPlus dest, SerializationNode<Long> node, long nodePosition) throws IOException {
            TrieNode type = TrieNode.typeFor(node, nodePosition);
            Long payload = node.payload();
            int payloadBits = this.sizeof(payload);
            type.serialize(dest, node, payloadBits, nodePosition);
            if (payload != null) {
                SizedInts.write(dest, payload, payloadBits);
            }
        }

        private int sizeof(Long payload) {
            return payload == null ? 0 : SizedInts.nonZeroSize(payload);
        }
    };

    public TrieTermsDictionaryReader(Rebufferer rebufferer, long root) {
        super(rebufferer, root);
    }

    public long exactMatch(ByteComparable key) {
        return this.follow(key) == -1 ? this.getCurrentPayload() : -1L;
    }

    private long getCurrentPayload() {
        return this.getPayloadAt(this.buf, this.payloadPosition(), this.payloadFlags());
    }

    private long getPayloadAt(ByteBuffer contents, int payloadPos, int bytes) {
        if (bytes == 0) {
            return -1L;
        }
        return SizedInts.read(contents, payloadPos, bytes);
    }
}

