/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm.strategies;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Optional;
import org.github.jamm.CannotMeasureObjectException;
import org.github.jamm.VM;
import org.github.jamm.strategies.ContendedUtils;
import org.github.jamm.strategies.MemoryLayoutBasedStrategy;
import org.github.jamm.utils.MathUtils;
import sun.misc.Unsafe;

final class PreJava15UnsafeStrategy
extends MemoryLayoutBasedStrategy {
    private static final Unsafe UNSAFE = VM.getUnsafe();
    private static final int ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(Object[].class);
    private final Optional<MethodHandle> mayBeIsRecordMH;
    private final MemoryLayoutBasedStrategy recordsStrategy;

    public PreJava15UnsafeStrategy(Optional<MethodHandle> mayBeIsRecordMH, MemoryLayoutBasedStrategy strategy) {
        this.mayBeIsRecordMH = mayBeIsRecordMH;
        this.recordsStrategy = strategy;
    }

    @Override
    public long measureInstance(Object instance, Class<?> type) {
        try {
            if (this.mayBeIsRecordMH.isPresent() && this.mayBeIsRecordMH.get().invoke(type).booleanValue()) {
                return this.recordsStrategy.measureInstance(instance, type);
            }
            int annotatedClassesWithoutFields = 0;
            while (type != null) {
                long size = 0L;
                boolean isLastFieldWithinContentionGroup = false;
                for (Field f : type.getDeclaredFields()) {
                    long previousSize;
                    if (Modifier.isStatic(f.getModifiers()) || (previousSize = size) >= (size = Math.max(size, UNSAFE.objectFieldOffset(f) + (long)this.measureField(f.getType())))) continue;
                    isLastFieldWithinContentionGroup = ContendedUtils.isFieldAnnotatedWithContended(f) && ContendedUtils.isContendedEnabled(type);
                }
                if (isLastFieldWithinContentionGroup) {
                    size += (long)MEMORY_LAYOUT.getContendedPaddingWidth();
                }
                if (size > 0L) {
                    if (ContendedUtils.isClassAnnotatedWithContended(type) && ContendedUtils.isContendedEnabled(type)) {
                        size += (long)MEMORY_LAYOUT.getContendedPaddingWidth();
                    }
                    return MathUtils.roundTo(size += (long)(annotatedClassesWithoutFields * (MEMORY_LAYOUT.getContendedPaddingWidth() << 1)), MEMORY_LAYOUT.getObjectAlignment());
                }
                if (ContendedUtils.isClassAnnotatedWithContended(type) && ContendedUtils.isContendedEnabled(type)) {
                    ++annotatedClassesWithoutFields;
                }
                type = type.getSuperclass();
            }
            return MathUtils.roundTo(MEMORY_LAYOUT.getObjectHeaderSize(), MEMORY_LAYOUT.getObjectAlignment());
        }
        catch (Throwable e) {
            throw new CannotMeasureObjectException("The object of type " + type + " cannot be measured by the unsafe strategy", e);
        }
    }

    @Override
    protected int arrayBaseOffset() {
        return ARRAY_BASE_OFFSET;
    }
}

