/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm;

import java.util.ArrayDeque;
import java.util.Deque;
import org.github.jamm.FieldAndClassFilter;
import org.github.jamm.IdentityHashSet;
import org.github.jamm.MemoryMeterListener;

public final class MeasurementStack {
    private final IdentityHashSet tracker = new IdentityHashSet();
    private final MemoryMeterListener listener;
    private final FieldAndClassFilter classFilter;
    private final Deque<Object> stack = new ArrayDeque<Object>();

    MeasurementStack(FieldAndClassFilter classFilter, MemoryMeterListener listener) {
        this.classFilter = classFilter;
        this.listener = listener;
    }

    public void pushObject(Object parent, String name, Object child) {
        if (child != null && this.tracker.add(child)) {
            this.stack.push(child);
            this.listener.fieldAdded(parent, name, child);
        }
    }

    void pushRoot(Object object) {
        this.stack.push(object);
        this.tracker.add(object);
        this.listener.started(object);
    }

    void pushArrayElement(Object[] array, int index) {
        Object child = array[index];
        if (child != null && !this.classFilter.ignore(child.getClass()) && this.tracker.add(child)) {
            this.stack.push(child);
            this.listener.arrayElementAdded(array, index, child);
        }
    }

    boolean isEmpty() {
        return this.stack.isEmpty();
    }

    MemoryMeterListener listener() {
        return this.listener;
    }

    Object pop() {
        return this.stack.pop();
    }
}

