/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.lifecycle.SSTableIntervalTree;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.streaming.CassandraIncomingFile;
import org.apache.cassandra.db.streaming.CassandraOutgoingFile;
import org.apache.cassandra.db.streaming.CassandraStreamReceiver;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.locator.RangesAtEndpoint;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.streaming.IncomingStream;
import org.apache.cassandra.streaming.OutgoingStream;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.streaming.StreamReceiver;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.TableStreamManager;
import org.apache.cassandra.streaming.messages.StreamMessageHeader;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStreamManager
implements TableStreamManager {
    private static final Logger logger = LoggerFactory.getLogger(CassandraStreamManager.class);
    private final ColumnFamilyStore cfs;

    public CassandraStreamManager(ColumnFamilyStore cfs) {
        this.cfs = cfs;
    }

    @Override
    public IncomingStream prepareIncomingStream(StreamSession session, StreamMessageHeader header) {
        return new CassandraIncomingFile(this.cfs, session, header);
    }

    @Override
    public StreamReceiver createStreamReceiver(StreamSession session, int totalStreams) {
        return new CassandraStreamReceiver(this.cfs, session, totalStreams);
    }

    @Override
    public Collection<OutgoingStream> createOutgoingStreams(StreamSession session, RangesAtEndpoint replicas, TimeUUID pendingRepair, PreviewKind previewKind) {
        Refs<SSTableReader> refs = new Refs<SSTableReader>();
        try {
            ArrayList<Range<PartitionPosition>> keyRanges = new ArrayList<Range<PartitionPosition>>(replicas.size());
            for (Replica replica : replicas) {
                keyRanges.add(Range.makeRowRange(replica.range()));
            }
            refs.addAll(this.cfs.selectAndReference((Function<View, Iterable<SSTableReader>>)(Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$createOutgoingStreams$1(org.apache.cassandra.streaming.PreviewKind org.apache.cassandra.utils.TimeUUID java.util.List org.apache.cassandra.db.lifecycle.View ), (Lorg/apache/cassandra/db/lifecycle/View;)Ljava/lang/Iterable;)((PreviewKind)previewKind, (TimeUUID)pendingRepair, keyRanges)).refs);
            this.cfs.writeAndAddMemtableRanges(session.getPendingRepair(), () -> Range.normalize(keyRanges), refs);
            List<Range<Token>> normalizedFullRanges = Range.normalize(replicas.onlyFull().ranges());
            List normalizedAllRanges = Range.normalize(replicas.ranges());
            ArrayList<OutgoingStream> streams = new ArrayList<OutgoingStream>(refs.size());
            for (SSTableReader sstable : refs) {
                List<Range<Token>> ranges = sstable.isRepaired() ? normalizedFullRanges : normalizedAllRanges;
                List<SSTableReader.PartitionPositionBounds> sections = sstable.getPositionsForRanges(ranges);
                Ref<SSTableReader> ref = refs.get(sstable);
                if (sections.isEmpty()) {
                    ref.release();
                    continue;
                }
                streams.add(new CassandraOutgoingFile(session.getStreamOperation(), ref, sections, ranges, sstable.estimatedKeysForRanges(ranges)));
            }
            return streams;
        }
        catch (Throwable t) {
            refs.release();
            throw t;
        }
    }

    private static /* synthetic */ Iterable lambda$createOutgoingStreams$1(PreviewKind previewKind, TimeUUID pendingRepair, List keyRanges, View view) {
        HashSet sstables = Sets.newHashSet();
        SSTableIntervalTree intervalTree = SSTableIntervalTree.build(view.select(SSTableSet.CANONICAL));
        Predicate predicate = previewKind.isPreview() ? previewKind.predicate() : (pendingRepair == ActiveRepairService.NO_PENDING_REPAIR ? Predicates.alwaysTrue() : s -> s.isPendingRepair() && s.getSSTableMetadata().pendingRepair.equals(pendingRepair));
        for (Range keyRange : keyRanges) {
            for (SSTableReader sstable : Iterables.filter(View.sstablesInBounds((PartitionPosition)keyRange.left, (PartitionPosition)keyRange.right, intervalTree), (Predicate)predicate)) {
                sstables.add(sstable);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ViewFilter for {}/{} sstables", (Object)sstables.size(), (Object)Iterables.size(view.select(SSTableSet.CANONICAL)));
        }
        return sstables;
    }
}

