/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.cql3.statements.PropertyDefinitions;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;

public class IndexAttributes
extends PropertyDefinitions {
    private static final String KW_OPTIONS = "options";
    private static final Set<String> keywords = new HashSet<String>();
    private static final Set<String> obsoleteKeywords = new HashSet<String>();
    public boolean isCustom;
    public String customClass;

    public void validate() throws RequestValidationException {
        this.validate(keywords, obsoleteKeywords);
        if (this.isCustom && this.customClass == null) {
            throw new InvalidRequestException("CUSTOM index requires specifiying the index class");
        }
        if (!this.isCustom && this.customClass != null) {
            throw new InvalidRequestException("Cannot specify index class for a non-CUSTOM index");
        }
        if (!this.isCustom && !this.properties.isEmpty()) {
            throw new InvalidRequestException("Cannot specify options for a non-CUSTOM index");
        }
        if (this.getRawOptions().containsKey("class_name")) {
            throw new InvalidRequestException(String.format("Cannot specify %s as a CUSTOM option", "class_name"));
        }
        if (this.getRawOptions().containsKey("target")) {
            throw new InvalidRequestException(String.format("Cannot specify %s as a CUSTOM option", "target"));
        }
    }

    private Map<String, String> getRawOptions() throws SyntaxException {
        Map<String, String> options = this.getMap(KW_OPTIONS);
        return options == null ? Collections.emptyMap() : options;
    }

    public Map<String, String> getOptions() throws SyntaxException {
        HashMap<String, String> options = new HashMap<String, String>(this.getRawOptions());
        options.put("class_name", this.customClass);
        return options;
    }

    static {
        keywords.add(KW_OPTIONS);
    }
}

