/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.ImmutableCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Json;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Operations;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.SingleColumnRelation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.cql3.conditions.ColumnCondition;
import org.apache.cassandra.cql3.conditions.Conditions;
import org.apache.cassandra.cql3.restrictions.StatementRestrictions;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.StatementType;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class UpdateStatement
extends ModificationStatement {
    private static final Constants.Value EMPTY = new Constants.Value(ByteBufferUtil.EMPTY_BYTE_BUFFER);

    private UpdateStatement(StatementType type, VariableSpecifications bindVariables, TableMetadata metadata, Operations operations, StatementRestrictions restrictions, Conditions conditions, Attributes attrs) {
        super(type, bindVariables, metadata, operations, restrictions, conditions, attrs);
    }

    @Override
    public void addUpdateForKey(PartitionUpdate.Builder updateBuilder, Clustering<?> clustering, UpdateParameters params) {
        int i;
        int isize;
        if (this.updatesRegularRows()) {
            params.newRow(clustering);
            if (this.type.isInsert() && !this.metadata.isCompactTable()) {
                params.addPrimaryKeyLivenessInfo();
            }
            List<Operation> updates = this.getRegularOperations();
            if (this.metadata().isCompactTable() && updates.isEmpty()) {
                TableMetadata.CompactTableMetadata metadata = (TableMetadata.CompactTableMetadata)this.metadata();
                RequestValidations.checkTrue(metadata.hasEmptyCompactValue(), "Column %s is mandatory for this COMPACT STORAGE table", metadata.compactValueColumn);
                updates = Collections.singletonList(new Constants.Setter(metadata.compactValueColumn, EMPTY));
            }
            isize = updates.size();
            for (i = 0; i < isize; ++i) {
                updates.get(i).execute(updateBuilder.partitionKey(), params);
            }
            updateBuilder.add(params.buildRow());
        }
        if (this.updatesStaticRow()) {
            params.newRow(Clustering.STATIC_CLUSTERING);
            List<Operation> staticOps = this.getStaticOperations();
            isize = staticOps.size();
            for (i = 0; i < isize; ++i) {
                staticOps.get(i).execute(updateBuilder.partitionKey(), params);
            }
            updateBuilder.add(params.buildRow());
        }
    }

    @Override
    public void addUpdateForKey(PartitionUpdate.Builder update, Slice slice, UpdateParameters params) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.UPDATE, this.keyspace(), this.table());
    }

    public static class ParsedUpdate
    extends ModificationStatement.Parsed {
        private final List<Pair<ColumnIdentifier, Operation.RawUpdate>> updates;
        private final WhereClause whereClause;

        public ParsedUpdate(QualifiedName name, Attributes.Raw attrs, List<Pair<ColumnIdentifier, Operation.RawUpdate>> updates, WhereClause whereClause, List<Pair<ColumnIdentifier, ColumnCondition.Raw>> conditions, boolean ifExists) {
            super(name, StatementType.UPDATE, attrs, conditions, false, ifExists);
            this.updates = updates;
            this.whereClause = whereClause;
        }

        @Override
        protected ModificationStatement prepareInternal(TableMetadata metadata, VariableSpecifications bindVariables, Conditions conditions, Attributes attrs) {
            Operations operations = new Operations(this.type);
            for (Pair<ColumnIdentifier, Operation.RawUpdate> entry : this.updates) {
                ColumnMetadata def = metadata.getExistingColumn((ColumnIdentifier)entry.left);
                RequestValidations.checkFalse(def.isPrimaryKeyColumn(), "PRIMARY KEY part %s found in SET part", def.name);
                Operation operation = ((Operation.RawUpdate)entry.right).prepare(metadata, def, !conditions.isEmpty());
                operation.collectMarkerSpecification(bindVariables);
                operations.add(operation);
            }
            StatementRestrictions restrictions = this.newRestrictions(metadata, bindVariables, operations, this.whereClause, conditions);
            return new UpdateStatement(this.type, bindVariables, metadata, operations, restrictions, conditions, attrs);
        }
    }

    public static class ParsedInsertJson
    extends ModificationStatement.Parsed {
        private final Json.Raw jsonValue;
        private final boolean defaultUnset;

        public ParsedInsertJson(QualifiedName name, Attributes.Raw attrs, Json.Raw jsonValue, boolean defaultUnset, boolean ifNotExists) {
            super(name, StatementType.INSERT, attrs, null, ifNotExists, false);
            this.jsonValue = jsonValue;
            this.defaultUnset = defaultUnset;
        }

        @Override
        protected ModificationStatement prepareInternal(TableMetadata metadata, VariableSpecifications bindVariables, Conditions conditions, Attributes attrs) {
            RequestValidations.checkFalse(metadata.isCounter(), "INSERT statements are not allowed on counter tables, use UPDATE instead");
            ImmutableCollection<ColumnMetadata> defs = metadata.columns();
            Json.Prepared prepared = this.jsonValue.prepareAndCollectMarkers(metadata, (Collection<ColumnMetadata>)defs, bindVariables);
            WhereClause.Builder whereClause = new WhereClause.Builder();
            Operations operations = new Operations(this.type);
            boolean hasClusteringColumnsSet = false;
            for (ColumnMetadata def : defs) {
                if (def.isClusteringColumn()) {
                    hasClusteringColumnsSet = true;
                }
                Term.Raw raw = prepared.getRawTermForColumn(def, this.defaultUnset);
                if (def.isPrimaryKeyColumn()) {
                    whereClause.add(new SingleColumnRelation(def.name, Operator.EQ, raw));
                    continue;
                }
                Operation operation = new Operation.SetValue(raw).prepare(metadata, def, !conditions.isEmpty());
                operation.collectMarkerSpecification(bindVariables);
                operations.add(operation);
            }
            boolean applyOnlyToStaticColumns = !hasClusteringColumnsSet && ModificationStatement.appliesOnlyToStaticColumns(operations, conditions);
            StatementRestrictions restrictions = new StatementRestrictions(this.type, metadata, whereClause.build(), bindVariables, applyOnlyToStaticColumns, false, false);
            return new UpdateStatement(this.type, bindVariables, metadata, operations, restrictions, conditions, attrs);
        }
    }

    public static class ParsedInsert
    extends ModificationStatement.Parsed {
        private final List<ColumnIdentifier> columnNames;
        private final List<Term.Raw> columnValues;

        public ParsedInsert(QualifiedName name, Attributes.Raw attrs, List<ColumnIdentifier> columnNames, List<Term.Raw> columnValues, boolean ifNotExists) {
            super(name, StatementType.INSERT, attrs, null, ifNotExists, false);
            this.columnNames = columnNames;
            this.columnValues = columnValues;
        }

        @Override
        protected ModificationStatement prepareInternal(TableMetadata metadata, VariableSpecifications bindVariables, Conditions conditions, Attributes attrs) {
            RequestValidations.checkFalse(metadata.isCounter(), "INSERT statements are not allowed on counter tables, use UPDATE instead");
            RequestValidations.checkFalse(this.columnNames == null, "Column names for INSERT must be provided when using VALUES");
            RequestValidations.checkFalse(this.columnNames.isEmpty(), "No columns provided to INSERT");
            RequestValidations.checkFalse(this.columnNames.size() != this.columnValues.size(), "Unmatched column names/values");
            RequestValidations.checkContainsNoDuplicates(this.columnNames, "The column names contains duplicates");
            WhereClause.Builder whereClause = new WhereClause.Builder();
            Operations operations = new Operations(this.type);
            boolean hasClusteringColumnsSet = false;
            for (int i = 0; i < this.columnNames.size(); ++i) {
                ColumnMetadata def = metadata.getExistingColumn(this.columnNames.get(i));
                if (def.isClusteringColumn()) {
                    hasClusteringColumnsSet = true;
                }
                Term.Raw value = this.columnValues.get(i);
                if (def.isPrimaryKeyColumn()) {
                    whereClause.add(new SingleColumnRelation(this.columnNames.get(i), Operator.EQ, value));
                    continue;
                }
                Operation operation = new Operation.SetValue(value).prepare(metadata, def, !conditions.isEmpty());
                operation.collectMarkerSpecification(bindVariables);
                operations.add(operation);
            }
            boolean applyOnlyToStaticColumns = !hasClusteringColumnsSet && ModificationStatement.appliesOnlyToStaticColumns(operations, conditions);
            StatementRestrictions restrictions = new StatementRestrictions(this.type, metadata, whereClause.build(), bindVariables, applyOnlyToStaticColumns, false, false);
            return new UpdateStatement(this.type, bindVariables, metadata, operations, restrictions, conditions, attrs);
        }
    }
}

