/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.deque;

import java.util.Iterator;
import org.psjava.ds.Collection;
import org.psjava.ds.deque.Deque;
import org.psjava.util.IterableToString;
import org.psjava.util.ReadOnlyIterator;

public class DoubleLinkedList<T>
implements Deque<T>,
Collection<T> {
    private final Node head = new Node(null, null, null);
    private final Node tail;

    public static <T> DoubleLinkedList<T> create() {
        return new DoubleLinkedList<T>();
    }

    public DoubleLinkedList() {
        this.head.n = this.tail = new Node(null, null, null);
        this.tail.p = this.head;
    }

    @Override
    public void addToLast(T e) {
        this.add(this.tail, e);
    }

    @Override
    public void clear() {
        this.head.n = this.tail;
        this.tail.p = this.head;
    }

    @Override
    public boolean isEmpty() {
        return this.head.n == this.tail;
    }

    @Override
    public Iterator<T> iterator() {
        return new ReadOnlyIterator<T>(){
            Node next;
            {
                this.next = ((DoubleLinkedList)DoubleLinkedList.this).head.n;
            }

            @Override
            public boolean hasNext() {
                return this.next != DoubleLinkedList.this.tail;
            }

            @Override
            public T next() {
                Object r = this.next.v;
                this.next = this.next.n;
                return r;
            }
        };
    }

    @Override
    public int size() {
        int r = 0;
        Node node = this.head;
        while (node.n != this.tail) {
            ++r;
            node = node.n;
        }
        return r;
    }

    @Override
    public void addToFirst(T v) {
        this.add(this.head.n, v);
    }

    @Override
    public T getFirst() {
        return this.head.n.v;
    }

    @Override
    public T getLast() {
        return this.tail.p.v;
    }

    @Override
    public T removeFirst() {
        return this.remove(this.head.n);
    }

    @Override
    public T removeLast() {
        return this.remove(this.tail.p);
    }

    private T remove(Node node) {
        node.p.n = node.n;
        node.n.p = node.p;
        return node.v;
    }

    private void add(Node node, T v) {
        Node newNode;
        newNode.p.n = newNode = new Node(v, node.p, node);
        newNode.n.p = newNode;
    }

    public String toString() {
        return IterableToString.toString(this);
    }

    private class Node {
        public T v;
        public Node n;
        public Node p;

        public Node(T v, Node p, Node n) {
            this.v = v;
            this.p = p;
            this.n = n;
        }
    }
}

