/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.SingleConsumerQueue;
import com.github.benmanes.caffeine.base.UnsafeAccess;
import com.github.benmanes.caffeine.cache.AccessOrderDeque;
import com.github.benmanes.caffeine.cache.BoundedLocalCache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.FrequencySketch;
import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.WriteOrderDeque;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import java.lang.ref.ReferenceQueue;

final class LocalCacheFactory {
    LocalCacheFactory() {
    }

    static <K, V> BoundedLocalCache<K, V> newBoundedLocalCache(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
        StringBuilder sb = new StringBuilder();
        if (builder.isStrongKeys()) {
            sb.append('S');
        } else {
            sb.append('W');
        }
        if (builder.isStrongValues()) {
            sb.append('S');
        } else {
            sb.append('I');
        }
        if (builder.removalListener != null) {
            sb.append("Li");
        }
        if (builder.isRecordingStats()) {
            sb.append('S');
        }
        if (builder.evicts()) {
            sb.append('M');
            if (builder.isWeighted()) {
                sb.append('W');
            } else {
                sb.append('S');
            }
        }
        if (builder.expiresAfterAccess()) {
            sb.append('A');
        }
        if (builder.expiresAfterWrite()) {
            sb.append('W');
        }
        if (builder.refreshes()) {
            sb.append('R');
        }
        switch (sb.toString()) {
            case "SI": {
                return new SI<K, V>(builder, cacheLoader, async);
            }
            case "SIA": {
                return new SIA<K, V>(builder, cacheLoader, async);
            }
            case "SIAR": {
                return new SIAR<K, V>(builder, cacheLoader, async);
            }
            case "SIAW": {
                return new SIAW<K, V>(builder, cacheLoader, async);
            }
            case "SIAWR": {
                return new SIAWR<K, V>(builder, cacheLoader, async);
            }
            case "SILi": {
                return new SILi<K, V>(builder, cacheLoader, async);
            }
            case "SILiA": {
                return new SILiA<K, V>(builder, cacheLoader, async);
            }
            case "SILiAR": {
                return new SILiAR<K, V>(builder, cacheLoader, async);
            }
            case "SILiAW": {
                return new SILiAW<K, V>(builder, cacheLoader, async);
            }
            case "SILiAWR": {
                return new SILiAWR<K, V>(builder, cacheLoader, async);
            }
            case "SILiMS": {
                return new SILiMS<K, V>(builder, cacheLoader, async);
            }
            case "SILiMSA": {
                return new SILiMSA<K, V>(builder, cacheLoader, async);
            }
            case "SILiMSAR": {
                return new SILiMSAR<K, V>(builder, cacheLoader, async);
            }
            case "SILiMSAW": {
                return new SILiMSAW<K, V>(builder, cacheLoader, async);
            }
            case "SILiMSAWR": {
                return new SILiMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "SILiMSR": {
                return new SILiMSR<K, V>(builder, cacheLoader, async);
            }
            case "SILiMSW": {
                return new SILiMSW<K, V>(builder, cacheLoader, async);
            }
            case "SILiMSWR": {
                return new SILiMSWR<K, V>(builder, cacheLoader, async);
            }
            case "SILiMW": {
                return new SILiMW<K, V>(builder, cacheLoader, async);
            }
            case "SILiMWA": {
                return new SILiMWA<K, V>(builder, cacheLoader, async);
            }
            case "SILiMWAR": {
                return new SILiMWAR<K, V>(builder, cacheLoader, async);
            }
            case "SILiMWAW": {
                return new SILiMWAW<K, V>(builder, cacheLoader, async);
            }
            case "SILiMWAWR": {
                return new SILiMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "SILiMWR": {
                return new SILiMWR<K, V>(builder, cacheLoader, async);
            }
            case "SILiMWW": {
                return new SILiMWW<K, V>(builder, cacheLoader, async);
            }
            case "SILiMWWR": {
                return new SILiMWWR<K, V>(builder, cacheLoader, async);
            }
            case "SILiR": {
                return new SILiR<K, V>(builder, cacheLoader, async);
            }
            case "SILiS": {
                return new SILiS<K, V>(builder, cacheLoader, async);
            }
            case "SILiSA": {
                return new SILiSA<K, V>(builder, cacheLoader, async);
            }
            case "SILiSAR": {
                return new SILiSAR<K, V>(builder, cacheLoader, async);
            }
            case "SILiSAW": {
                return new SILiSAW<K, V>(builder, cacheLoader, async);
            }
            case "SILiSAWR": {
                return new SILiSAWR<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMS": {
                return new SILiSMS<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMSA": {
                return new SILiSMSA<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMSAR": {
                return new SILiSMSAR<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMSAW": {
                return new SILiSMSAW<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMSAWR": {
                return new SILiSMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMSR": {
                return new SILiSMSR<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMSW": {
                return new SILiSMSW<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMSWR": {
                return new SILiSMSWR<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMW": {
                return new SILiSMW<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMWA": {
                return new SILiSMWA<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMWAR": {
                return new SILiSMWAR<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMWAW": {
                return new SILiSMWAW<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMWAWR": {
                return new SILiSMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMWR": {
                return new SILiSMWR<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMWW": {
                return new SILiSMWW<K, V>(builder, cacheLoader, async);
            }
            case "SILiSMWWR": {
                return new SILiSMWWR<K, V>(builder, cacheLoader, async);
            }
            case "SILiSR": {
                return new SILiSR<K, V>(builder, cacheLoader, async);
            }
            case "SILiSW": {
                return new SILiSW<K, V>(builder, cacheLoader, async);
            }
            case "SILiSWR": {
                return new SILiSWR<K, V>(builder, cacheLoader, async);
            }
            case "SILiW": {
                return new SILiW<K, V>(builder, cacheLoader, async);
            }
            case "SILiWR": {
                return new SILiWR<K, V>(builder, cacheLoader, async);
            }
            case "SIMS": {
                return new SIMS<K, V>(builder, cacheLoader, async);
            }
            case "SIMSA": {
                return new SIMSA<K, V>(builder, cacheLoader, async);
            }
            case "SIMSAR": {
                return new SIMSAR<K, V>(builder, cacheLoader, async);
            }
            case "SIMSAW": {
                return new SIMSAW<K, V>(builder, cacheLoader, async);
            }
            case "SIMSAWR": {
                return new SIMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "SIMSR": {
                return new SIMSR<K, V>(builder, cacheLoader, async);
            }
            case "SIMSW": {
                return new SIMSW<K, V>(builder, cacheLoader, async);
            }
            case "SIMSWR": {
                return new SIMSWR<K, V>(builder, cacheLoader, async);
            }
            case "SIMW": {
                return new SIMW<K, V>(builder, cacheLoader, async);
            }
            case "SIMWA": {
                return new SIMWA<K, V>(builder, cacheLoader, async);
            }
            case "SIMWAR": {
                return new SIMWAR<K, V>(builder, cacheLoader, async);
            }
            case "SIMWAW": {
                return new SIMWAW<K, V>(builder, cacheLoader, async);
            }
            case "SIMWAWR": {
                return new SIMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "SIMWR": {
                return new SIMWR<K, V>(builder, cacheLoader, async);
            }
            case "SIMWW": {
                return new SIMWW<K, V>(builder, cacheLoader, async);
            }
            case "SIMWWR": {
                return new SIMWWR<K, V>(builder, cacheLoader, async);
            }
            case "SIR": {
                return new SIR<K, V>(builder, cacheLoader, async);
            }
            case "SIS": {
                return new SIS<K, V>(builder, cacheLoader, async);
            }
            case "SISA": {
                return new SISA<K, V>(builder, cacheLoader, async);
            }
            case "SISAR": {
                return new SISAR<K, V>(builder, cacheLoader, async);
            }
            case "SISAW": {
                return new SISAW<K, V>(builder, cacheLoader, async);
            }
            case "SISAWR": {
                return new SISAWR<K, V>(builder, cacheLoader, async);
            }
            case "SISMS": {
                return new SISMS<K, V>(builder, cacheLoader, async);
            }
            case "SISMSA": {
                return new SISMSA<K, V>(builder, cacheLoader, async);
            }
            case "SISMSAR": {
                return new SISMSAR<K, V>(builder, cacheLoader, async);
            }
            case "SISMSAW": {
                return new SISMSAW<K, V>(builder, cacheLoader, async);
            }
            case "SISMSAWR": {
                return new SISMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "SISMSR": {
                return new SISMSR<K, V>(builder, cacheLoader, async);
            }
            case "SISMSW": {
                return new SISMSW<K, V>(builder, cacheLoader, async);
            }
            case "SISMSWR": {
                return new SISMSWR<K, V>(builder, cacheLoader, async);
            }
            case "SISMW": {
                return new SISMW<K, V>(builder, cacheLoader, async);
            }
            case "SISMWA": {
                return new SISMWA<K, V>(builder, cacheLoader, async);
            }
            case "SISMWAR": {
                return new SISMWAR<K, V>(builder, cacheLoader, async);
            }
            case "SISMWAW": {
                return new SISMWAW<K, V>(builder, cacheLoader, async);
            }
            case "SISMWAWR": {
                return new SISMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "SISMWR": {
                return new SISMWR<K, V>(builder, cacheLoader, async);
            }
            case "SISMWW": {
                return new SISMWW<K, V>(builder, cacheLoader, async);
            }
            case "SISMWWR": {
                return new SISMWWR<K, V>(builder, cacheLoader, async);
            }
            case "SISR": {
                return new SISR<K, V>(builder, cacheLoader, async);
            }
            case "SISW": {
                return new SISW<K, V>(builder, cacheLoader, async);
            }
            case "SISWR": {
                return new SISWR<K, V>(builder, cacheLoader, async);
            }
            case "SIW": {
                return new SIW<K, V>(builder, cacheLoader, async);
            }
            case "SIWR": {
                return new SIWR<K, V>(builder, cacheLoader, async);
            }
            case "SS": {
                return new SS<K, V>(builder, cacheLoader, async);
            }
            case "SSA": {
                return new SSA<K, V>(builder, cacheLoader, async);
            }
            case "SSAR": {
                return new SSAR<K, V>(builder, cacheLoader, async);
            }
            case "SSAW": {
                return new SSAW<K, V>(builder, cacheLoader, async);
            }
            case "SSAWR": {
                return new SSAWR<K, V>(builder, cacheLoader, async);
            }
            case "SSLi": {
                return new SSLi<K, V>(builder, cacheLoader, async);
            }
            case "SSLiA": {
                return new SSLiA<K, V>(builder, cacheLoader, async);
            }
            case "SSLiAR": {
                return new SSLiAR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiAW": {
                return new SSLiAW<K, V>(builder, cacheLoader, async);
            }
            case "SSLiAWR": {
                return new SSLiAWR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMS": {
                return new SSLiMS<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMSA": {
                return new SSLiMSA<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMSAR": {
                return new SSLiMSAR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMSAW": {
                return new SSLiMSAW<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMSAWR": {
                return new SSLiMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMSR": {
                return new SSLiMSR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMSW": {
                return new SSLiMSW<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMSWR": {
                return new SSLiMSWR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMW": {
                return new SSLiMW<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMWA": {
                return new SSLiMWA<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMWAR": {
                return new SSLiMWAR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMWAW": {
                return new SSLiMWAW<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMWAWR": {
                return new SSLiMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMWR": {
                return new SSLiMWR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMWW": {
                return new SSLiMWW<K, V>(builder, cacheLoader, async);
            }
            case "SSLiMWWR": {
                return new SSLiMWWR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiR": {
                return new SSLiR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiS": {
                return new SSLiS<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSA": {
                return new SSLiSA<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSAR": {
                return new SSLiSAR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSAW": {
                return new SSLiSAW<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSAWR": {
                return new SSLiSAWR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMS": {
                return new SSLiSMS<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMSA": {
                return new SSLiSMSA<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMSAR": {
                return new SSLiSMSAR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMSAW": {
                return new SSLiSMSAW<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMSAWR": {
                return new SSLiSMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMSR": {
                return new SSLiSMSR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMSW": {
                return new SSLiSMSW<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMSWR": {
                return new SSLiSMSWR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMW": {
                return new SSLiSMW<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMWA": {
                return new SSLiSMWA<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMWAR": {
                return new SSLiSMWAR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMWAW": {
                return new SSLiSMWAW<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMWAWR": {
                return new SSLiSMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMWR": {
                return new SSLiSMWR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMWW": {
                return new SSLiSMWW<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSMWWR": {
                return new SSLiSMWWR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSR": {
                return new SSLiSR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSW": {
                return new SSLiSW<K, V>(builder, cacheLoader, async);
            }
            case "SSLiSWR": {
                return new SSLiSWR<K, V>(builder, cacheLoader, async);
            }
            case "SSLiW": {
                return new SSLiW<K, V>(builder, cacheLoader, async);
            }
            case "SSLiWR": {
                return new SSLiWR<K, V>(builder, cacheLoader, async);
            }
            case "SSMS": {
                return new SSMS<K, V>(builder, cacheLoader, async);
            }
            case "SSMSA": {
                return new SSMSA<K, V>(builder, cacheLoader, async);
            }
            case "SSMSAR": {
                return new SSMSAR<K, V>(builder, cacheLoader, async);
            }
            case "SSMSAW": {
                return new SSMSAW<K, V>(builder, cacheLoader, async);
            }
            case "SSMSAWR": {
                return new SSMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "SSMSR": {
                return new SSMSR<K, V>(builder, cacheLoader, async);
            }
            case "SSMSW": {
                return new SSMSW<K, V>(builder, cacheLoader, async);
            }
            case "SSMSWR": {
                return new SSMSWR<K, V>(builder, cacheLoader, async);
            }
            case "SSMW": {
                return new SSMW<K, V>(builder, cacheLoader, async);
            }
            case "SSMWA": {
                return new SSMWA<K, V>(builder, cacheLoader, async);
            }
            case "SSMWAR": {
                return new SSMWAR<K, V>(builder, cacheLoader, async);
            }
            case "SSMWAW": {
                return new SSMWAW<K, V>(builder, cacheLoader, async);
            }
            case "SSMWAWR": {
                return new SSMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "SSMWR": {
                return new SSMWR<K, V>(builder, cacheLoader, async);
            }
            case "SSMWW": {
                return new SSMWW<K, V>(builder, cacheLoader, async);
            }
            case "SSMWWR": {
                return new SSMWWR<K, V>(builder, cacheLoader, async);
            }
            case "SSR": {
                return new SSR<K, V>(builder, cacheLoader, async);
            }
            case "SSS": {
                return new SSS<K, V>(builder, cacheLoader, async);
            }
            case "SSSA": {
                return new SSSA<K, V>(builder, cacheLoader, async);
            }
            case "SSSAR": {
                return new SSSAR<K, V>(builder, cacheLoader, async);
            }
            case "SSSAW": {
                return new SSSAW<K, V>(builder, cacheLoader, async);
            }
            case "SSSAWR": {
                return new SSSAWR<K, V>(builder, cacheLoader, async);
            }
            case "SSSMS": {
                return new SSSMS<K, V>(builder, cacheLoader, async);
            }
            case "SSSMSA": {
                return new SSSMSA<K, V>(builder, cacheLoader, async);
            }
            case "SSSMSAR": {
                return new SSSMSAR<K, V>(builder, cacheLoader, async);
            }
            case "SSSMSAW": {
                return new SSSMSAW<K, V>(builder, cacheLoader, async);
            }
            case "SSSMSAWR": {
                return new SSSMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "SSSMSR": {
                return new SSSMSR<K, V>(builder, cacheLoader, async);
            }
            case "SSSMSW": {
                return new SSSMSW<K, V>(builder, cacheLoader, async);
            }
            case "SSSMSWR": {
                return new SSSMSWR<K, V>(builder, cacheLoader, async);
            }
            case "SSSMW": {
                return new SSSMW<K, V>(builder, cacheLoader, async);
            }
            case "SSSMWA": {
                return new SSSMWA<K, V>(builder, cacheLoader, async);
            }
            case "SSSMWAR": {
                return new SSSMWAR<K, V>(builder, cacheLoader, async);
            }
            case "SSSMWAW": {
                return new SSSMWAW<K, V>(builder, cacheLoader, async);
            }
            case "SSSMWAWR": {
                return new SSSMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "SSSMWR": {
                return new SSSMWR<K, V>(builder, cacheLoader, async);
            }
            case "SSSMWW": {
                return new SSSMWW<K, V>(builder, cacheLoader, async);
            }
            case "SSSMWWR": {
                return new SSSMWWR<K, V>(builder, cacheLoader, async);
            }
            case "SSSR": {
                return new SSSR<K, V>(builder, cacheLoader, async);
            }
            case "SSSW": {
                return new SSSW<K, V>(builder, cacheLoader, async);
            }
            case "SSSWR": {
                return new SSSWR<K, V>(builder, cacheLoader, async);
            }
            case "SSW": {
                return new SSW<K, V>(builder, cacheLoader, async);
            }
            case "SSWR": {
                return new SSWR<K, V>(builder, cacheLoader, async);
            }
            case "WI": {
                return new WI<K, V>(builder, cacheLoader, async);
            }
            case "WIA": {
                return new WIA<K, V>(builder, cacheLoader, async);
            }
            case "WIAR": {
                return new WIAR<K, V>(builder, cacheLoader, async);
            }
            case "WIAW": {
                return new WIAW<K, V>(builder, cacheLoader, async);
            }
            case "WIAWR": {
                return new WIAWR<K, V>(builder, cacheLoader, async);
            }
            case "WILi": {
                return new WILi<K, V>(builder, cacheLoader, async);
            }
            case "WILiA": {
                return new WILiA<K, V>(builder, cacheLoader, async);
            }
            case "WILiAR": {
                return new WILiAR<K, V>(builder, cacheLoader, async);
            }
            case "WILiAW": {
                return new WILiAW<K, V>(builder, cacheLoader, async);
            }
            case "WILiAWR": {
                return new WILiAWR<K, V>(builder, cacheLoader, async);
            }
            case "WILiMS": {
                return new WILiMS<K, V>(builder, cacheLoader, async);
            }
            case "WILiMSA": {
                return new WILiMSA<K, V>(builder, cacheLoader, async);
            }
            case "WILiMSAR": {
                return new WILiMSAR<K, V>(builder, cacheLoader, async);
            }
            case "WILiMSAW": {
                return new WILiMSAW<K, V>(builder, cacheLoader, async);
            }
            case "WILiMSAWR": {
                return new WILiMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "WILiMSR": {
                return new WILiMSR<K, V>(builder, cacheLoader, async);
            }
            case "WILiMSW": {
                return new WILiMSW<K, V>(builder, cacheLoader, async);
            }
            case "WILiMSWR": {
                return new WILiMSWR<K, V>(builder, cacheLoader, async);
            }
            case "WILiMW": {
                return new WILiMW<K, V>(builder, cacheLoader, async);
            }
            case "WILiMWA": {
                return new WILiMWA<K, V>(builder, cacheLoader, async);
            }
            case "WILiMWAR": {
                return new WILiMWAR<K, V>(builder, cacheLoader, async);
            }
            case "WILiMWAW": {
                return new WILiMWAW<K, V>(builder, cacheLoader, async);
            }
            case "WILiMWAWR": {
                return new WILiMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "WILiMWR": {
                return new WILiMWR<K, V>(builder, cacheLoader, async);
            }
            case "WILiMWW": {
                return new WILiMWW<K, V>(builder, cacheLoader, async);
            }
            case "WILiMWWR": {
                return new WILiMWWR<K, V>(builder, cacheLoader, async);
            }
            case "WILiR": {
                return new WILiR<K, V>(builder, cacheLoader, async);
            }
            case "WILiS": {
                return new WILiS<K, V>(builder, cacheLoader, async);
            }
            case "WILiSA": {
                return new WILiSA<K, V>(builder, cacheLoader, async);
            }
            case "WILiSAR": {
                return new WILiSAR<K, V>(builder, cacheLoader, async);
            }
            case "WILiSAW": {
                return new WILiSAW<K, V>(builder, cacheLoader, async);
            }
            case "WILiSAWR": {
                return new WILiSAWR<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMS": {
                return new WILiSMS<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMSA": {
                return new WILiSMSA<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMSAR": {
                return new WILiSMSAR<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMSAW": {
                return new WILiSMSAW<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMSAWR": {
                return new WILiSMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMSR": {
                return new WILiSMSR<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMSW": {
                return new WILiSMSW<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMSWR": {
                return new WILiSMSWR<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMW": {
                return new WILiSMW<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMWA": {
                return new WILiSMWA<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMWAR": {
                return new WILiSMWAR<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMWAW": {
                return new WILiSMWAW<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMWAWR": {
                return new WILiSMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMWR": {
                return new WILiSMWR<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMWW": {
                return new WILiSMWW<K, V>(builder, cacheLoader, async);
            }
            case "WILiSMWWR": {
                return new WILiSMWWR<K, V>(builder, cacheLoader, async);
            }
            case "WILiSR": {
                return new WILiSR<K, V>(builder, cacheLoader, async);
            }
            case "WILiSW": {
                return new WILiSW<K, V>(builder, cacheLoader, async);
            }
            case "WILiSWR": {
                return new WILiSWR<K, V>(builder, cacheLoader, async);
            }
            case "WILiW": {
                return new WILiW<K, V>(builder, cacheLoader, async);
            }
            case "WILiWR": {
                return new WILiWR<K, V>(builder, cacheLoader, async);
            }
            case "WIMS": {
                return new WIMS<K, V>(builder, cacheLoader, async);
            }
            case "WIMSA": {
                return new WIMSA<K, V>(builder, cacheLoader, async);
            }
            case "WIMSAR": {
                return new WIMSAR<K, V>(builder, cacheLoader, async);
            }
            case "WIMSAW": {
                return new WIMSAW<K, V>(builder, cacheLoader, async);
            }
            case "WIMSAWR": {
                return new WIMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "WIMSR": {
                return new WIMSR<K, V>(builder, cacheLoader, async);
            }
            case "WIMSW": {
                return new WIMSW<K, V>(builder, cacheLoader, async);
            }
            case "WIMSWR": {
                return new WIMSWR<K, V>(builder, cacheLoader, async);
            }
            case "WIMW": {
                return new WIMW<K, V>(builder, cacheLoader, async);
            }
            case "WIMWA": {
                return new WIMWA<K, V>(builder, cacheLoader, async);
            }
            case "WIMWAR": {
                return new WIMWAR<K, V>(builder, cacheLoader, async);
            }
            case "WIMWAW": {
                return new WIMWAW<K, V>(builder, cacheLoader, async);
            }
            case "WIMWAWR": {
                return new WIMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "WIMWR": {
                return new WIMWR<K, V>(builder, cacheLoader, async);
            }
            case "WIMWW": {
                return new WIMWW<K, V>(builder, cacheLoader, async);
            }
            case "WIMWWR": {
                return new WIMWWR<K, V>(builder, cacheLoader, async);
            }
            case "WIR": {
                return new WIR<K, V>(builder, cacheLoader, async);
            }
            case "WIS": {
                return new WIS<K, V>(builder, cacheLoader, async);
            }
            case "WISA": {
                return new WISA<K, V>(builder, cacheLoader, async);
            }
            case "WISAR": {
                return new WISAR<K, V>(builder, cacheLoader, async);
            }
            case "WISAW": {
                return new WISAW<K, V>(builder, cacheLoader, async);
            }
            case "WISAWR": {
                return new WISAWR<K, V>(builder, cacheLoader, async);
            }
            case "WISMS": {
                return new WISMS<K, V>(builder, cacheLoader, async);
            }
            case "WISMSA": {
                return new WISMSA<K, V>(builder, cacheLoader, async);
            }
            case "WISMSAR": {
                return new WISMSAR<K, V>(builder, cacheLoader, async);
            }
            case "WISMSAW": {
                return new WISMSAW<K, V>(builder, cacheLoader, async);
            }
            case "WISMSAWR": {
                return new WISMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "WISMSR": {
                return new WISMSR<K, V>(builder, cacheLoader, async);
            }
            case "WISMSW": {
                return new WISMSW<K, V>(builder, cacheLoader, async);
            }
            case "WISMSWR": {
                return new WISMSWR<K, V>(builder, cacheLoader, async);
            }
            case "WISMW": {
                return new WISMW<K, V>(builder, cacheLoader, async);
            }
            case "WISMWA": {
                return new WISMWA<K, V>(builder, cacheLoader, async);
            }
            case "WISMWAR": {
                return new WISMWAR<K, V>(builder, cacheLoader, async);
            }
            case "WISMWAW": {
                return new WISMWAW<K, V>(builder, cacheLoader, async);
            }
            case "WISMWAWR": {
                return new WISMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "WISMWR": {
                return new WISMWR<K, V>(builder, cacheLoader, async);
            }
            case "WISMWW": {
                return new WISMWW<K, V>(builder, cacheLoader, async);
            }
            case "WISMWWR": {
                return new WISMWWR<K, V>(builder, cacheLoader, async);
            }
            case "WISR": {
                return new WISR<K, V>(builder, cacheLoader, async);
            }
            case "WISW": {
                return new WISW<K, V>(builder, cacheLoader, async);
            }
            case "WISWR": {
                return new WISWR<K, V>(builder, cacheLoader, async);
            }
            case "WIW": {
                return new WIW<K, V>(builder, cacheLoader, async);
            }
            case "WIWR": {
                return new WIWR<K, V>(builder, cacheLoader, async);
            }
            case "WS": {
                return new WS<K, V>(builder, cacheLoader, async);
            }
            case "WSA": {
                return new WSA<K, V>(builder, cacheLoader, async);
            }
            case "WSAR": {
                return new WSAR<K, V>(builder, cacheLoader, async);
            }
            case "WSAW": {
                return new WSAW<K, V>(builder, cacheLoader, async);
            }
            case "WSAWR": {
                return new WSAWR<K, V>(builder, cacheLoader, async);
            }
            case "WSLi": {
                return new WSLi<K, V>(builder, cacheLoader, async);
            }
            case "WSLiA": {
                return new WSLiA<K, V>(builder, cacheLoader, async);
            }
            case "WSLiAR": {
                return new WSLiAR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiAW": {
                return new WSLiAW<K, V>(builder, cacheLoader, async);
            }
            case "WSLiAWR": {
                return new WSLiAWR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMS": {
                return new WSLiMS<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMSA": {
                return new WSLiMSA<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMSAR": {
                return new WSLiMSAR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMSAW": {
                return new WSLiMSAW<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMSAWR": {
                return new WSLiMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMSR": {
                return new WSLiMSR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMSW": {
                return new WSLiMSW<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMSWR": {
                return new WSLiMSWR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMW": {
                return new WSLiMW<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMWA": {
                return new WSLiMWA<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMWAR": {
                return new WSLiMWAR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMWAW": {
                return new WSLiMWAW<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMWAWR": {
                return new WSLiMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMWR": {
                return new WSLiMWR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMWW": {
                return new WSLiMWW<K, V>(builder, cacheLoader, async);
            }
            case "WSLiMWWR": {
                return new WSLiMWWR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiR": {
                return new WSLiR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiS": {
                return new WSLiS<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSA": {
                return new WSLiSA<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSAR": {
                return new WSLiSAR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSAW": {
                return new WSLiSAW<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSAWR": {
                return new WSLiSAWR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMS": {
                return new WSLiSMS<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMSA": {
                return new WSLiSMSA<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMSAR": {
                return new WSLiSMSAR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMSAW": {
                return new WSLiSMSAW<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMSAWR": {
                return new WSLiSMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMSR": {
                return new WSLiSMSR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMSW": {
                return new WSLiSMSW<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMSWR": {
                return new WSLiSMSWR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMW": {
                return new WSLiSMW<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMWA": {
                return new WSLiSMWA<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMWAR": {
                return new WSLiSMWAR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMWAW": {
                return new WSLiSMWAW<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMWAWR": {
                return new WSLiSMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMWR": {
                return new WSLiSMWR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMWW": {
                return new WSLiSMWW<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSMWWR": {
                return new WSLiSMWWR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSR": {
                return new WSLiSR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSW": {
                return new WSLiSW<K, V>(builder, cacheLoader, async);
            }
            case "WSLiSWR": {
                return new WSLiSWR<K, V>(builder, cacheLoader, async);
            }
            case "WSLiW": {
                return new WSLiW<K, V>(builder, cacheLoader, async);
            }
            case "WSLiWR": {
                return new WSLiWR<K, V>(builder, cacheLoader, async);
            }
            case "WSMS": {
                return new WSMS<K, V>(builder, cacheLoader, async);
            }
            case "WSMSA": {
                return new WSMSA<K, V>(builder, cacheLoader, async);
            }
            case "WSMSAR": {
                return new WSMSAR<K, V>(builder, cacheLoader, async);
            }
            case "WSMSAW": {
                return new WSMSAW<K, V>(builder, cacheLoader, async);
            }
            case "WSMSAWR": {
                return new WSMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "WSMSR": {
                return new WSMSR<K, V>(builder, cacheLoader, async);
            }
            case "WSMSW": {
                return new WSMSW<K, V>(builder, cacheLoader, async);
            }
            case "WSMSWR": {
                return new WSMSWR<K, V>(builder, cacheLoader, async);
            }
            case "WSMW": {
                return new WSMW<K, V>(builder, cacheLoader, async);
            }
            case "WSMWA": {
                return new WSMWA<K, V>(builder, cacheLoader, async);
            }
            case "WSMWAR": {
                return new WSMWAR<K, V>(builder, cacheLoader, async);
            }
            case "WSMWAW": {
                return new WSMWAW<K, V>(builder, cacheLoader, async);
            }
            case "WSMWAWR": {
                return new WSMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "WSMWR": {
                return new WSMWR<K, V>(builder, cacheLoader, async);
            }
            case "WSMWW": {
                return new WSMWW<K, V>(builder, cacheLoader, async);
            }
            case "WSMWWR": {
                return new WSMWWR<K, V>(builder, cacheLoader, async);
            }
            case "WSR": {
                return new WSR<K, V>(builder, cacheLoader, async);
            }
            case "WSS": {
                return new WSS<K, V>(builder, cacheLoader, async);
            }
            case "WSSA": {
                return new WSSA<K, V>(builder, cacheLoader, async);
            }
            case "WSSAR": {
                return new WSSAR<K, V>(builder, cacheLoader, async);
            }
            case "WSSAW": {
                return new WSSAW<K, V>(builder, cacheLoader, async);
            }
            case "WSSAWR": {
                return new WSSAWR<K, V>(builder, cacheLoader, async);
            }
            case "WSSMS": {
                return new WSSMS<K, V>(builder, cacheLoader, async);
            }
            case "WSSMSA": {
                return new WSSMSA<K, V>(builder, cacheLoader, async);
            }
            case "WSSMSAR": {
                return new WSSMSAR<K, V>(builder, cacheLoader, async);
            }
            case "WSSMSAW": {
                return new WSSMSAW<K, V>(builder, cacheLoader, async);
            }
            case "WSSMSAWR": {
                return new WSSMSAWR<K, V>(builder, cacheLoader, async);
            }
            case "WSSMSR": {
                return new WSSMSR<K, V>(builder, cacheLoader, async);
            }
            case "WSSMSW": {
                return new WSSMSW<K, V>(builder, cacheLoader, async);
            }
            case "WSSMSWR": {
                return new WSSMSWR<K, V>(builder, cacheLoader, async);
            }
            case "WSSMW": {
                return new WSSMW<K, V>(builder, cacheLoader, async);
            }
            case "WSSMWA": {
                return new WSSMWA<K, V>(builder, cacheLoader, async);
            }
            case "WSSMWAR": {
                return new WSSMWAR<K, V>(builder, cacheLoader, async);
            }
            case "WSSMWAW": {
                return new WSSMWAW<K, V>(builder, cacheLoader, async);
            }
            case "WSSMWAWR": {
                return new WSSMWAWR<K, V>(builder, cacheLoader, async);
            }
            case "WSSMWR": {
                return new WSSMWR<K, V>(builder, cacheLoader, async);
            }
            case "WSSMWW": {
                return new WSSMWW<K, V>(builder, cacheLoader, async);
            }
            case "WSSMWWR": {
                return new WSSMWWR<K, V>(builder, cacheLoader, async);
            }
            case "WSSR": {
                return new WSSR<K, V>(builder, cacheLoader, async);
            }
            case "WSSW": {
                return new WSSW<K, V>(builder, cacheLoader, async);
            }
            case "WSSWR": {
                return new WSSWR<K, V>(builder, cacheLoader, async);
            }
            case "WSW": {
                return new WSW<K, V>(builder, cacheLoader, async);
            }
            case "WSWR": {
                return new WSWR<K, V>(builder, cacheLoader, async);
            }
        }
        throw new IllegalStateException(sb.toString());
    }

    static final class WSWR<K, V>
    extends WSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSW<K, V>
    extends WS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSSWR<K, V>
    extends WSSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSSW<K, V>
    extends WSS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WSSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSSR<K, V>
    extends WSS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WSSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSSMWWR<K, V>
    extends WSSMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSSMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSSMWW<K, V>
    extends WSSMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WSSMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSSMWR<K, V>
    extends WSSMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WSSMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WSSMWAWR<K, V>
    extends WSSMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSSMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSSMWAW<K, V>
    extends WSSMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WSSMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSSMWAR<K, V>
    extends WSSMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSSMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSSMWA<K, V>
    extends WSSMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WSSMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WSSMW<K, V>
    extends WSS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSSMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSSMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSSMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSSMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSSMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSSMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WSSMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSSMSWR<K, V>
    extends WSSMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSSMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSSMSW<K, V>
    extends WSSMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WSSMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSSMSR<K, V>
    extends WSSMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WSSMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WSSMSAWR<K, V>
    extends WSSMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSSMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSSMSAW<K, V>
    extends WSSMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WSSMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSSMSAR<K, V>
    extends WSSMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSSMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSSMSA<K, V>
    extends WSSMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WSSMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WSSMS<K, V>
    extends WSS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSSMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSSMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSSMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSSMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSSMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSSMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WSSMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSSAWR<K, V>
    extends WSSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSSAW<K, V>
    extends WSSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WSSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSSAR<K, V>
    extends WSSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSSA<K, V>
    extends WSS<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WSSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class WSS<K, V>
    extends WS<K, V> {
        private final StatsCounter statsCounter;

        WSS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.statsCounter = builder.getStatsCounterSupplier().get();
        }

        @Override
        public final boolean isRecordingStats() {
            return true;
        }

        @Override
        public final Ticker statsTicker() {
            return Ticker.systemTicker();
        }

        @Override
        public final StatsCounter statsCounter() {
            return this.statsCounter;
        }
    }

    static final class WSR<K, V>
    extends WS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSMWWR<K, V>
    extends WSMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSMWW<K, V>
    extends WSMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WSMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSMWR<K, V>
    extends WSMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WSMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WSMWAWR<K, V>
    extends WSMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSMWAW<K, V>
    extends WSMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WSMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSMWAR<K, V>
    extends WSMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSMWA<K, V>
    extends WSMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WSMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WSMW<K, V>
    extends WS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WSMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSMSWR<K, V>
    extends WSMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSMSW<K, V>
    extends WSMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WSMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSMSR<K, V>
    extends WSMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WSMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WSMSAWR<K, V>
    extends WSMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSMSAW<K, V>
    extends WSMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WSMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSMSAR<K, V>
    extends WSMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSMSA<K, V>
    extends WSMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WSMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WSMS<K, V>
    extends WS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WSMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSLiWR<K, V>
    extends WSLiW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiW<K, V>
    extends WSLi<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WSLiW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSLiSWR<K, V>
    extends WSLiSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiSW<K, V>
    extends WSLiS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WSLiSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSLiSR<K, V>
    extends WSLiS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WSLiSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSLiSMWWR<K, V>
    extends WSLiSMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiSMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiSMWW<K, V>
    extends WSLiSMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WSLiSMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSLiSMWR<K, V>
    extends WSLiSMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WSLiSMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WSLiSMWAWR<K, V>
    extends WSLiSMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiSMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiSMWAW<K, V>
    extends WSLiSMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WSLiSMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSLiSMWAR<K, V>
    extends WSLiSMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiSMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiSMWA<K, V>
    extends WSLiSMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WSLiSMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WSLiSMW<K, V>
    extends WSLiS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSLiSMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSLiSMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSLiSMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSLiSMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSLiSMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSLiSMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WSLiSMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSLiSMSWR<K, V>
    extends WSLiSMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiSMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiSMSW<K, V>
    extends WSLiSMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WSLiSMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSLiSMSR<K, V>
    extends WSLiSMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WSLiSMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WSLiSMSAWR<K, V>
    extends WSLiSMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiSMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiSMSAW<K, V>
    extends WSLiSMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WSLiSMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSLiSMSAR<K, V>
    extends WSLiSMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiSMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiSMSA<K, V>
    extends WSLiSMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WSLiSMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WSLiSMS<K, V>
    extends WSLiS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSLiSMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSLiSMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSLiSMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSLiSMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSLiSMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSLiSMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WSLiSMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSLiSAWR<K, V>
    extends WSLiSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiSAW<K, V>
    extends WSLiSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WSLiSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSLiSAR<K, V>
    extends WSLiSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiSA<K, V>
    extends WSLiS<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WSLiSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class WSLiS<K, V>
    extends WSLi<K, V> {
        private final StatsCounter statsCounter;

        WSLiS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.statsCounter = builder.getStatsCounterSupplier().get();
        }

        @Override
        public final boolean isRecordingStats() {
            return true;
        }

        @Override
        public final Ticker statsTicker() {
            return Ticker.systemTicker();
        }

        @Override
        public final StatsCounter statsCounter() {
            return this.statsCounter;
        }
    }

    static final class WSLiR<K, V>
    extends WSLi<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WSLiR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSLiMWWR<K, V>
    extends WSLiMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiMWW<K, V>
    extends WSLiMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WSLiMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSLiMWR<K, V>
    extends WSLiMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WSLiMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WSLiMWAWR<K, V>
    extends WSLiMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiMWAW<K, V>
    extends WSLiMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WSLiMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSLiMWAR<K, V>
    extends WSLiMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiMWA<K, V>
    extends WSLiMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WSLiMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WSLiMW<K, V>
    extends WSLi<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSLiMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSLiMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSLiMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSLiMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSLiMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSLiMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WSLiMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSLiMSWR<K, V>
    extends WSLiMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiMSW<K, V>
    extends WSLiMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WSLiMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSLiMSR<K, V>
    extends WSLiMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WSLiMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WSLiMSAWR<K, V>
    extends WSLiMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiMSAW<K, V>
    extends WSLiMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WSLiMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSLiMSAR<K, V>
    extends WSLiMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiMSA<K, V>
    extends WSLiMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WSLiMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WSLiMS<K, V>
    extends WSLi<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSLiMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSLiMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WSLiMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSLiMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSLiMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WSLiMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WSLiMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WSLiAWR<K, V>
    extends WSLiAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiAW<K, V>
    extends WSLiA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WSLiAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSLiAR<K, V>
    extends WSLiA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSLiAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSLiA<K, V>
    extends WSLi<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WSLiA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class WSLi<K, V>
    extends WS<K, V> {
        private final RemovalListener<K, V> removalListener;

        WSLi(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.removalListener = builder.getRemovalListener(async);
        }

        @Override
        public final RemovalListener<K, V> removalListener() {
            return this.removalListener;
        }

        @Override
        protected final boolean hasRemovalListener() {
            return true;
        }
    }

    static final class WSAWR<K, V>
    extends WSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSAW<K, V>
    extends WSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WSAR<K, V>
    extends WSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WSA<K, V>
    extends WS<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class WS<K, V>
    extends BoundedLocalCache<K, V> {
        private final ReferenceQueue<K> keyReferenceQueue = new ReferenceQueue();

        WS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final ReferenceQueue<K> keyReferenceQueue() {
            return this.keyReferenceQueue;
        }

        @Override
        protected final boolean collectKeys() {
            return true;
        }
    }

    static final class WIWR<K, V>
    extends WIW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WIWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WIW<K, V>
    extends WI<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WIW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WISWR<K, V>
    extends WISW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WISWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WISW<K, V>
    extends WIS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WISW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WISR<K, V>
    extends WIS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WISR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WISMWWR<K, V>
    extends WISMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WISMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WISMWW<K, V>
    extends WISMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WISMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WISMWR<K, V>
    extends WISMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WISMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WISMWAWR<K, V>
    extends WISMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WISMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WISMWAW<K, V>
    extends WISMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WISMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WISMWAR<K, V>
    extends WISMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WISMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WISMWA<K, V>
    extends WISMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WISMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WISMW<K, V>
    extends WIS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WISMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WISMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WISMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WISMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WISMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WISMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WISMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WISMSWR<K, V>
    extends WISMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WISMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WISMSW<K, V>
    extends WISMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WISMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WISMSR<K, V>
    extends WISMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WISMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WISMSAWR<K, V>
    extends WISMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WISMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WISMSAW<K, V>
    extends WISMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WISMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WISMSAR<K, V>
    extends WISMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WISMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WISMSA<K, V>
    extends WISMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WISMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WISMS<K, V>
    extends WIS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WISMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WISMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WISMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WISMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WISMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WISMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WISMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WISAWR<K, V>
    extends WISAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WISAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WISAW<K, V>
    extends WISA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WISAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WISAR<K, V>
    extends WISA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WISAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WISA<K, V>
    extends WIS<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WISA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class WIS<K, V>
    extends WI<K, V> {
        private final StatsCounter statsCounter;

        WIS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.statsCounter = builder.getStatsCounterSupplier().get();
        }

        @Override
        public final boolean isRecordingStats() {
            return true;
        }

        @Override
        public final Ticker statsTicker() {
            return Ticker.systemTicker();
        }

        @Override
        public final StatsCounter statsCounter() {
            return this.statsCounter;
        }
    }

    static final class WIR<K, V>
    extends WI<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WIR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WIMWWR<K, V>
    extends WIMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WIMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WIMWW<K, V>
    extends WIMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WIMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WIMWR<K, V>
    extends WIMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WIMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WIMWAWR<K, V>
    extends WIMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WIMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WIMWAW<K, V>
    extends WIMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WIMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WIMWAR<K, V>
    extends WIMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WIMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WIMWA<K, V>
    extends WIMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WIMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WIMW<K, V>
    extends WI<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WIMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WIMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WIMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WIMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WIMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WIMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WIMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WIMSWR<K, V>
    extends WIMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WIMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WIMSW<K, V>
    extends WIMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WIMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WIMSR<K, V>
    extends WIMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WIMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WIMSAWR<K, V>
    extends WIMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WIMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WIMSAW<K, V>
    extends WIMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WIMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WIMSAR<K, V>
    extends WIMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WIMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WIMSA<K, V>
    extends WIMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WIMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WIMS<K, V>
    extends WI<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WIMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WIMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WIMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WIMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WIMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WIMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WIMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WILiWR<K, V>
    extends WILiW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiW<K, V>
    extends WILi<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WILiW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WILiSWR<K, V>
    extends WILiSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiSW<K, V>
    extends WILiS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WILiSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WILiSR<K, V>
    extends WILiS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WILiSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WILiSMWWR<K, V>
    extends WILiSMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiSMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiSMWW<K, V>
    extends WILiSMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WILiSMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WILiSMWR<K, V>
    extends WILiSMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WILiSMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WILiSMWAWR<K, V>
    extends WILiSMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiSMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiSMWAW<K, V>
    extends WILiSMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WILiSMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WILiSMWAR<K, V>
    extends WILiSMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiSMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiSMWA<K, V>
    extends WILiSMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WILiSMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WILiSMW<K, V>
    extends WILiS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WILiSMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WILiSMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WILiSMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WILiSMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WILiSMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WILiSMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WILiSMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WILiSMSWR<K, V>
    extends WILiSMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiSMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiSMSW<K, V>
    extends WILiSMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WILiSMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WILiSMSR<K, V>
    extends WILiSMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WILiSMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WILiSMSAWR<K, V>
    extends WILiSMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiSMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiSMSAW<K, V>
    extends WILiSMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WILiSMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WILiSMSAR<K, V>
    extends WILiSMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiSMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiSMSA<K, V>
    extends WILiSMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WILiSMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WILiSMS<K, V>
    extends WILiS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WILiSMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WILiSMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WILiSMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WILiSMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WILiSMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WILiSMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WILiSMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WILiSAWR<K, V>
    extends WILiSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiSAW<K, V>
    extends WILiSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WILiSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WILiSAR<K, V>
    extends WILiSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiSA<K, V>
    extends WILiS<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WILiSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class WILiS<K, V>
    extends WILi<K, V> {
        private final StatsCounter statsCounter;

        WILiS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.statsCounter = builder.getStatsCounterSupplier().get();
        }

        @Override
        public final boolean isRecordingStats() {
            return true;
        }

        @Override
        public final Ticker statsTicker() {
            return Ticker.systemTicker();
        }

        @Override
        public final StatsCounter statsCounter() {
            return this.statsCounter;
        }
    }

    static final class WILiR<K, V>
    extends WILi<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WILiR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WILiMWWR<K, V>
    extends WILiMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiMWW<K, V>
    extends WILiMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WILiMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WILiMWR<K, V>
    extends WILiMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WILiMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WILiMWAWR<K, V>
    extends WILiMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiMWAW<K, V>
    extends WILiMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WILiMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WILiMWAR<K, V>
    extends WILiMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiMWA<K, V>
    extends WILiMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WILiMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WILiMW<K, V>
    extends WILi<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WILiMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WILiMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WILiMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WILiMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WILiMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WILiMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WILiMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WILiMSWR<K, V>
    extends WILiMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiMSW<K, V>
    extends WILiMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        WILiMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WILiMSR<K, V>
    extends WILiMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        WILiMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class WILiMSAWR<K, V>
    extends WILiMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiMSAW<K, V>
    extends WILiMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WILiMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WILiMSAR<K, V>
    extends WILiMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiMSA<K, V>
    extends WILiMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        WILiMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class WILiMS<K, V>
    extends WILi<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WILiMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WILiMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(WILiMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WILiMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WILiMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(WILiMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        WILiMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class WILiAWR<K, V>
    extends WILiAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiAW<K, V>
    extends WILiA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WILiAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WILiAR<K, V>
    extends WILiA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WILiAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WILiA<K, V>
    extends WILi<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WILiA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class WILi<K, V>
    extends WI<K, V> {
        private final RemovalListener<K, V> removalListener;

        WILi(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.removalListener = builder.getRemovalListener(async);
        }

        @Override
        public final RemovalListener<K, V> removalListener() {
            return this.removalListener;
        }

        @Override
        protected final boolean hasRemovalListener() {
            return true;
        }
    }

    static final class WIAWR<K, V>
    extends WIAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        WIAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WIAW<K, V>
    extends WIA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        WIAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class WIAR<K, V>
    extends WIA<K, V> {
        private volatile long refreshAfterWriteNanos;

        WIAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class WIA<K, V>
    extends WI<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        WIA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class WI<K, V>
    extends BoundedLocalCache<K, V> {
        private final ReferenceQueue<K> keyReferenceQueue = new ReferenceQueue();
        private final ReferenceQueue<V> valueReferenceQueue = new ReferenceQueue();

        WI(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final ReferenceQueue<K> keyReferenceQueue() {
            return this.keyReferenceQueue;
        }

        @Override
        protected final boolean collectKeys() {
            return true;
        }

        @Override
        protected final ReferenceQueue<V> valueReferenceQueue() {
            return this.valueReferenceQueue;
        }

        @Override
        protected final boolean collectValues() {
            return true;
        }
    }

    static final class SSWR<K, V>
    extends SSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSW<K, V>
    extends SS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSSWR<K, V>
    extends SSSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSSW<K, V>
    extends SSS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SSSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSSR<K, V>
    extends SSS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SSSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSSMWWR<K, V>
    extends SSSMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSSMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSSMWW<K, V>
    extends SSSMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SSSMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSSMWR<K, V>
    extends SSSMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SSSMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SSSMWAWR<K, V>
    extends SSSMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSSMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSSMWAW<K, V>
    extends SSSMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SSSMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSSMWAR<K, V>
    extends SSSMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSSMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSSMWA<K, V>
    extends SSSMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SSSMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected boolean fastpath() {
            return false;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SSSMW<K, V>
    extends SSS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSSMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSSMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSSMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSSMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSSMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSSMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SSSMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected boolean fastpath() {
            return true;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSSMSWR<K, V>
    extends SSSMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSSMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSSMSW<K, V>
    extends SSSMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SSSMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSSMSR<K, V>
    extends SSSMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SSSMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SSSMSAWR<K, V>
    extends SSSMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSSMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSSMSAW<K, V>
    extends SSSMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SSSMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSSMSAR<K, V>
    extends SSSMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSSMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSSMSA<K, V>
    extends SSSMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SSSMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected boolean fastpath() {
            return false;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SSSMS<K, V>
    extends SSS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSSMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSSMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSSMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSSMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSSMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSSMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SSSMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected boolean fastpath() {
            return true;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSSAWR<K, V>
    extends SSSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSSAW<K, V>
    extends SSSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SSSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSSAR<K, V>
    extends SSSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSSA<K, V>
    extends SSS<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SSSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class SSS<K, V>
    extends SS<K, V> {
        private final StatsCounter statsCounter;

        SSS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.statsCounter = builder.getStatsCounterSupplier().get();
        }

        @Override
        public final boolean isRecordingStats() {
            return true;
        }

        @Override
        public final Ticker statsTicker() {
            return Ticker.systemTicker();
        }

        @Override
        public final StatsCounter statsCounter() {
            return this.statsCounter;
        }
    }

    static final class SSR<K, V>
    extends SS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSMWWR<K, V>
    extends SSMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSMWW<K, V>
    extends SSMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SSMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSMWR<K, V>
    extends SSMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SSMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SSMWAWR<K, V>
    extends SSMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSMWAW<K, V>
    extends SSMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SSMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSMWAR<K, V>
    extends SSMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSMWA<K, V>
    extends SSMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SSMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected boolean fastpath() {
            return false;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SSMW<K, V>
    extends SS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SSMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected boolean fastpath() {
            return true;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSMSWR<K, V>
    extends SSMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSMSW<K, V>
    extends SSMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SSMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSMSR<K, V>
    extends SSMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SSMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SSMSAWR<K, V>
    extends SSMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSMSAW<K, V>
    extends SSMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SSMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSMSAR<K, V>
    extends SSMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSMSA<K, V>
    extends SSMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SSMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected boolean fastpath() {
            return false;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SSMS<K, V>
    extends SS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SSMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected boolean fastpath() {
            return true;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSLiWR<K, V>
    extends SSLiW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiW<K, V>
    extends SSLi<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SSLiW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSLiSWR<K, V>
    extends SSLiSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiSW<K, V>
    extends SSLiS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SSLiSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSLiSR<K, V>
    extends SSLiS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SSLiSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSLiSMWWR<K, V>
    extends SSLiSMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiSMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiSMWW<K, V>
    extends SSLiSMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SSLiSMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSLiSMWR<K, V>
    extends SSLiSMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SSLiSMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SSLiSMWAWR<K, V>
    extends SSLiSMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiSMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiSMWAW<K, V>
    extends SSLiSMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SSLiSMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSLiSMWAR<K, V>
    extends SSLiSMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiSMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiSMWA<K, V>
    extends SSLiSMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SSLiSMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected boolean fastpath() {
            return false;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SSLiSMW<K, V>
    extends SSLiS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSLiSMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSLiSMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSLiSMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSLiSMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSLiSMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSLiSMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SSLiSMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected boolean fastpath() {
            return true;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSLiSMSWR<K, V>
    extends SSLiSMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiSMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiSMSW<K, V>
    extends SSLiSMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SSLiSMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSLiSMSR<K, V>
    extends SSLiSMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SSLiSMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SSLiSMSAWR<K, V>
    extends SSLiSMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiSMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiSMSAW<K, V>
    extends SSLiSMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SSLiSMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSLiSMSAR<K, V>
    extends SSLiSMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiSMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiSMSA<K, V>
    extends SSLiSMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SSLiSMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected boolean fastpath() {
            return false;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SSLiSMS<K, V>
    extends SSLiS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSLiSMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSLiSMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSLiSMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSLiSMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSLiSMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSLiSMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SSLiSMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected boolean fastpath() {
            return true;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSLiSAWR<K, V>
    extends SSLiSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiSAW<K, V>
    extends SSLiSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SSLiSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSLiSAR<K, V>
    extends SSLiSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiSA<K, V>
    extends SSLiS<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SSLiSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class SSLiS<K, V>
    extends SSLi<K, V> {
        private final StatsCounter statsCounter;

        SSLiS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.statsCounter = builder.getStatsCounterSupplier().get();
        }

        @Override
        public final boolean isRecordingStats() {
            return true;
        }

        @Override
        public final Ticker statsTicker() {
            return Ticker.systemTicker();
        }

        @Override
        public final StatsCounter statsCounter() {
            return this.statsCounter;
        }
    }

    static final class SSLiR<K, V>
    extends SSLi<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SSLiR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSLiMWWR<K, V>
    extends SSLiMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiMWW<K, V>
    extends SSLiMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SSLiMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSLiMWR<K, V>
    extends SSLiMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SSLiMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SSLiMWAWR<K, V>
    extends SSLiMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiMWAW<K, V>
    extends SSLiMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SSLiMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSLiMWAR<K, V>
    extends SSLiMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiMWA<K, V>
    extends SSLiMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SSLiMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected boolean fastpath() {
            return false;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SSLiMW<K, V>
    extends SSLi<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSLiMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSLiMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSLiMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSLiMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSLiMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSLiMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SSLiMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected boolean fastpath() {
            return true;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSLiMSWR<K, V>
    extends SSLiMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiMSW<K, V>
    extends SSLiMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SSLiMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSLiMSR<K, V>
    extends SSLiMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SSLiMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SSLiMSAWR<K, V>
    extends SSLiMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiMSAW<K, V>
    extends SSLiMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SSLiMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSLiMSAR<K, V>
    extends SSLiMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiMSA<K, V>
    extends SSLiMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SSLiMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected boolean fastpath() {
            return false;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SSLiMS<K, V>
    extends SSLi<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSLiMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSLiMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SSLiMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSLiMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSLiMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SSLiMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SSLiMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected boolean fastpath() {
            return true;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SSLiAWR<K, V>
    extends SSLiAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiAW<K, V>
    extends SSLiA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SSLiAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSLiAR<K, V>
    extends SSLiA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSLiAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSLiA<K, V>
    extends SSLi<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SSLiA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class SSLi<K, V>
    extends SS<K, V> {
        private final RemovalListener<K, V> removalListener;

        SSLi(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.removalListener = builder.getRemovalListener(async);
        }

        @Override
        public final RemovalListener<K, V> removalListener() {
            return this.removalListener;
        }

        @Override
        protected final boolean hasRemovalListener() {
            return true;
        }
    }

    static final class SSAWR<K, V>
    extends SSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSAW<K, V>
    extends SSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SSAR<K, V>
    extends SSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SSA<K, V>
    extends SS<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class SS<K, V>
    extends BoundedLocalCache<K, V> {
        SS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }
    }

    static final class SIWR<K, V>
    extends SIW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SIWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SIW<K, V>
    extends SI<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SIW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SISWR<K, V>
    extends SISW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SISWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SISW<K, V>
    extends SIS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SISW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SISR<K, V>
    extends SIS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SISR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SISMWWR<K, V>
    extends SISMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SISMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SISMWW<K, V>
    extends SISMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SISMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SISMWR<K, V>
    extends SISMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SISMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SISMWAWR<K, V>
    extends SISMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SISMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SISMWAW<K, V>
    extends SISMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SISMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SISMWAR<K, V>
    extends SISMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SISMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SISMWA<K, V>
    extends SISMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SISMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SISMW<K, V>
    extends SIS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SISMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SISMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SISMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SISMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SISMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SISMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SISMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SISMSWR<K, V>
    extends SISMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SISMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SISMSW<K, V>
    extends SISMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SISMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SISMSR<K, V>
    extends SISMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SISMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SISMSAWR<K, V>
    extends SISMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SISMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SISMSAW<K, V>
    extends SISMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SISMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SISMSAR<K, V>
    extends SISMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SISMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SISMSA<K, V>
    extends SISMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SISMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SISMS<K, V>
    extends SIS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SISMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SISMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SISMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SISMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SISMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SISMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SISMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SISAWR<K, V>
    extends SISAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SISAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SISAW<K, V>
    extends SISA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SISAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SISAR<K, V>
    extends SISA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SISAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SISA<K, V>
    extends SIS<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SISA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class SIS<K, V>
    extends SI<K, V> {
        private final StatsCounter statsCounter;

        SIS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.statsCounter = builder.getStatsCounterSupplier().get();
        }

        @Override
        public final boolean isRecordingStats() {
            return true;
        }

        @Override
        public final Ticker statsTicker() {
            return Ticker.systemTicker();
        }

        @Override
        public final StatsCounter statsCounter() {
            return this.statsCounter;
        }
    }

    static final class SIR<K, V>
    extends SI<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SIR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SIMWWR<K, V>
    extends SIMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SIMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SIMWW<K, V>
    extends SIMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SIMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SIMWR<K, V>
    extends SIMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SIMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SIMWAWR<K, V>
    extends SIMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SIMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SIMWAW<K, V>
    extends SIMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SIMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SIMWAR<K, V>
    extends SIMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SIMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SIMWA<K, V>
    extends SIMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SIMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SIMW<K, V>
    extends SI<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SIMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SIMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SIMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SIMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SIMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SIMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SIMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SIMSWR<K, V>
    extends SIMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SIMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SIMSW<K, V>
    extends SIMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SIMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SIMSR<K, V>
    extends SIMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SIMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SIMSAWR<K, V>
    extends SIMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SIMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SIMSAW<K, V>
    extends SIMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SIMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SIMSAR<K, V>
    extends SIMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SIMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SIMSA<K, V>
    extends SIMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SIMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SIMS<K, V>
    extends SI<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SIMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SIMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SIMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SIMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SIMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SIMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SIMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SILiWR<K, V>
    extends SILiW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiW<K, V>
    extends SILi<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SILiW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SILiSWR<K, V>
    extends SILiSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiSW<K, V>
    extends SILiS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SILiSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SILiSR<K, V>
    extends SILiS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SILiSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SILiSMWWR<K, V>
    extends SILiSMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiSMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiSMWW<K, V>
    extends SILiSMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SILiSMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SILiSMWR<K, V>
    extends SILiSMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SILiSMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SILiSMWAWR<K, V>
    extends SILiSMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiSMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiSMWAW<K, V>
    extends SILiSMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SILiSMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SILiSMWAR<K, V>
    extends SILiSMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiSMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiSMWA<K, V>
    extends SILiSMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SILiSMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SILiSMW<K, V>
    extends SILiS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SILiSMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SILiSMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SILiSMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SILiSMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SILiSMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SILiSMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SILiSMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SILiSMSWR<K, V>
    extends SILiSMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiSMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiSMSW<K, V>
    extends SILiSMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SILiSMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SILiSMSR<K, V>
    extends SILiSMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SILiSMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SILiSMSAWR<K, V>
    extends SILiSMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiSMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiSMSAW<K, V>
    extends SILiSMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SILiSMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SILiSMSAR<K, V>
    extends SILiSMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiSMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiSMSA<K, V>
    extends SILiSMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SILiSMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SILiSMS<K, V>
    extends SILiS<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SILiSMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SILiSMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SILiSMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SILiSMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SILiSMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SILiSMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SILiSMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SILiSAWR<K, V>
    extends SILiSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiSAW<K, V>
    extends SILiSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SILiSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SILiSAR<K, V>
    extends SILiSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiSA<K, V>
    extends SILiS<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SILiSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class SILiS<K, V>
    extends SILi<K, V> {
        private final StatsCounter statsCounter;

        SILiS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.statsCounter = builder.getStatsCounterSupplier().get();
        }

        @Override
        public final boolean isRecordingStats() {
            return true;
        }

        @Override
        public final Ticker statsTicker() {
            return Ticker.systemTicker();
        }

        @Override
        public final StatsCounter statsCounter() {
            return this.statsCounter;
        }
    }

    static final class SILiR<K, V>
    extends SILi<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SILiR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SILiMWWR<K, V>
    extends SILiMWW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiMWWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiMWW<K, V>
    extends SILiMW<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SILiMWW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SILiMWR<K, V>
    extends SILiMW<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SILiMWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SILiMWAWR<K, V>
    extends SILiMWAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiMWAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiMWAW<K, V>
    extends SILiMWA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SILiMWAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SILiMWAR<K, V>
    extends SILiMWA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiMWAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiMWA<K, V>
    extends SILiMW<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SILiMWA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SILiMW<K, V>
    extends SILi<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SILiMW.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SILiMW.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SILiMW.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SILiMW.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SILiMW.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SILiMW.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SILiMW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SILiMSWR<K, V>
    extends SILiMSW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiMSWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiMSW<K, V>
    extends SILiMS<K, V> {
        private final Ticker ticker;
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque;
        private volatile long expiresAfterWriteNanos;

        SILiMSW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.writeOrderDeque = new WriteOrderDeque();
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SILiMSR<K, V>
    extends SILiMS<K, V> {
        private final Ticker ticker;
        private volatile long refreshAfterWriteNanos;

        SILiMSR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static final class SILiMSAWR<K, V>
    extends SILiMSAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiMSAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiMSAW<K, V>
    extends SILiMSA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SILiMSAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SILiMSAR<K, V>
    extends SILiMSA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiMSAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiMSA<K, V>
    extends SILiMS<K, V> {
        private final Ticker ticker;
        private volatile long expiresAfterAccessNanos;

        SILiMSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }
    }

    static class SILiMS<K, V>
    extends SILi<K, V> {
        protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SILiMS.class, "maximum");
        protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SILiMS.class, "edenMaximum");
        protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SILiMS.class, "mainProtectedMaximum");
        protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SILiMS.class, "weightedSize");
        protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SILiMS.class, "edenWeightedSize");
        protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SILiMS.class, "mainProtectedWeightedSize");
        private volatile long maximum;
        private volatile long edenMaximum;
        private volatile long mainProtectedMaximum;
        private volatile long weightedSize;
        private volatile long edenWeightedSize;
        private volatile long mainProtectedWeightedSize;
        private final FrequencySketch<K> sketch = new FrequencySketch();
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque = new AccessOrderDeque();
        private final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque = new AccessOrderDeque();
        private final SingleConsumerQueue<Runnable> writeQueue = SingleConsumerQueue.optimistic();

        SILiMS(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final boolean evicts() {
            return true;
        }

        @Override
        protected final long maximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMaximum(long maximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, maximum);
        }

        @Override
        protected final long edenMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetEdenMaximum(long edenMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, edenMaximum);
        }

        @Override
        protected final long mainProtectedMaximum() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedMaximum(long mainProtectedMaximum) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, mainProtectedMaximum);
        }

        @Override
        protected final long weightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetWeightedSize(long weightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, weightedSize);
        }

        @Override
        protected final long edenWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetEdenWeightedSize(long edenWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, edenWeightedSize);
        }

        @Override
        protected final long mainProtectedWeightedSize() {
            return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
        }

        @Override
        protected final void lazySetMainProtectedWeightedSize(long mainProtectedWeightedSize) {
            UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, mainProtectedWeightedSize);
        }

        @Override
        protected final FrequencySketch<K> frequencySketch() {
            return this.sketch;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
            return this.accessOrderProbationDeque;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
            return this.accessOrderProtectedDeque;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static final class SILiAWR<K, V>
    extends SILiAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiAW<K, V>
    extends SILiA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SILiAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SILiAR<K, V>
    extends SILiA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SILiAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SILiA<K, V>
    extends SILi<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SILiA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class SILi<K, V>
    extends SI<K, V> {
        private final RemovalListener<K, V> removalListener;

        SILi(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.removalListener = builder.getRemovalListener(async);
        }

        @Override
        public final RemovalListener<K, V> removalListener() {
            return this.removalListener;
        }

        @Override
        protected final boolean hasRemovalListener() {
            return true;
        }
    }

    static final class SIAWR<K, V>
    extends SIAW<K, V> {
        private volatile long refreshAfterWriteNanos;

        SIAWR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SIAW<K, V>
    extends SIA<K, V> {
        private final WriteOrderDeque<Node<K, V>> writeOrderDeque = new WriteOrderDeque();
        private volatile long expiresAfterWriteNanos;

        SIAW(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.expiresAfterWriteNanos = builder.getExpiresAfterWriteNanos();
        }

        @Override
        protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
            return this.writeOrderDeque;
        }

        @Override
        protected final boolean expiresAfterWrite() {
            return true;
        }

        @Override
        protected final long expiresAfterWriteNanos() {
            return this.expiresAfterWriteNanos;
        }

        @Override
        protected final void setExpiresAfterWriteNanos(long expiresAfterWriteNanos) {
            this.expiresAfterWriteNanos = expiresAfterWriteNanos;
        }
    }

    static final class SIAR<K, V>
    extends SIA<K, V> {
        private volatile long refreshAfterWriteNanos;

        SIAR(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.refreshAfterWriteNanos = builder.getRefreshAfterWriteNanos();
        }

        @Override
        protected final boolean refreshAfterWrite() {
            return true;
        }

        @Override
        protected final long refreshAfterWriteNanos() {
            return this.refreshAfterWriteNanos;
        }

        @Override
        protected final void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
            this.refreshAfterWriteNanos = refreshAfterWriteNanos;
        }
    }

    static class SIA<K, V>
    extends SI<K, V> {
        private final Ticker ticker;
        private final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
        private volatile long expiresAfterAccessNanos;
        private final SingleConsumerQueue<Runnable> writeQueue;

        SIA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
            this.ticker = builder.getTicker();
            this.accessOrderEdenDeque = new AccessOrderDeque();
            this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
            this.writeQueue = SingleConsumerQueue.optimistic();
        }

        @Override
        public final Ticker expirationTicker() {
            return this.ticker;
        }

        @Override
        protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
            return this.accessOrderEdenDeque;
        }

        @Override
        protected final boolean expiresAfterAccess() {
            return true;
        }

        @Override
        protected final long expiresAfterAccessNanos() {
            return this.expiresAfterAccessNanos;
        }

        @Override
        protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
            this.expiresAfterAccessNanos = expiresAfterAccessNanos;
        }

        protected final SingleConsumerQueue<Runnable> writeQueue() {
            return this.writeQueue;
        }

        @Override
        protected final boolean buffersWrites() {
            return true;
        }
    }

    static class SI<K, V>
    extends BoundedLocalCache<K, V> {
        private final ReferenceQueue<V> valueReferenceQueue = new ReferenceQueue();

        SI(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
            super(builder, cacheLoader, async);
        }

        @Override
        protected final ReferenceQueue<V> valueReferenceQueue() {
            return this.valueReferenceQueue;
        }

        @Override
        protected final boolean collectValues() {
            return true;
        }
    }
}

