/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.ibm.watson.tts.WatsonTextToSpeechComponent;

/**
 * Convert text to natural-sounding speech using IBM Watson Text to Speech
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface IbmWatsonTextToSpeechComponentBuilderFactory {

    /**
     * IBM Watson Text to Speech (camel-ibm-watson-text-to-speech)
     * Convert text to natural-sounding speech using IBM Watson Text to Speech
     * 
     * Category: ai,cloud
     * Since: 4.17
     * Maven coordinates: org.apache.camel:camel-ibm-watson-text-to-speech
     * 
     * @return the dsl builder
     */
    static IbmWatsonTextToSpeechComponentBuilder ibmWatsonTextToSpeech() {
        return new IbmWatsonTextToSpeechComponentBuilderImpl();
    }

    /**
     * Builder for the IBM Watson Text to Speech component.
     */
    interface IbmWatsonTextToSpeechComponentBuilder extends ComponentBuilder<WatsonTextToSpeechComponent> {
    
        /**
         * The service endpoint URL. If not specified, the default URL will be
         * used.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceUrl the value to set
         * @return the dsl builder
         */
        default IbmWatsonTextToSpeechComponentBuilder serviceUrl(java.lang.String serviceUrl) {
            doSetProperty("serviceUrl", serviceUrl);
            return this;
        }
    
        
        /**
         * The audio format for synthesized speech. Default is audio/wav.
         * Supported formats: audio/wav, audio/mp3, audio/ogg, audio/flac,
         * audio/webm.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: audio/wav
         * Group: producer
         * 
         * @param accept the value to set
         * @return the dsl builder
         */
        default IbmWatsonTextToSpeechComponentBuilder accept(java.lang.String accept) {
            doSetProperty("accept", accept);
            return this;
        }
    
        /**
         * Component configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.ibm.watson.tts.WatsonTextToSpeechConfiguration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default IbmWatsonTextToSpeechComponentBuilder configuration(org.apache.camel.component.ibm.watson.tts.WatsonTextToSpeechConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        /**
         * The customization ID (GUID) of a custom voice model to use for
         * synthesis.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param customizationId the value to set
         * @return the dsl builder
         */
        default IbmWatsonTextToSpeechComponentBuilder customizationId(java.lang.String customizationId) {
            doSetProperty("customizationId", customizationId);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default IbmWatsonTextToSpeechComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        /**
         * The operation to perform.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.ibm.watson.tts.WatsonTextToSpeechOperations&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default IbmWatsonTextToSpeechComponentBuilder operation(org.apache.camel.component.ibm.watson.tts.WatsonTextToSpeechOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
    
        
        /**
         * The voice to use for synthesis. Default is en-US_MichaelV3Voice.
         * Examples: en-US_AllisonV3Voice, en-GB_KateV3Voice,
         * es-ES_EnriqueV3Voice, fr-FR_NicolasV3Voice.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: en-US_MichaelV3Voice
         * Group: producer
         * 
         * @param voice the value to set
         * @return the dsl builder
         */
        default IbmWatsonTextToSpeechComponentBuilder voice(java.lang.String voice) {
            doSetProperty("voice", voice);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default IbmWatsonTextToSpeechComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all consumer based health checks from
         * this component.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckConsumerEnabled the value to set
         * @return the dsl builder
         */
        default IbmWatsonTextToSpeechComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all producer based health checks from
         * this component. Notice: Camel has by default disabled all producer
         * based health-checks. You can turn on producer checks globally by
         * setting camel.health.producersEnabled=true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckProducerEnabled the value to set
         * @return the dsl builder
         */
        default IbmWatsonTextToSpeechComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }
    
        /**
         * The IBM Cloud API key for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default IbmWatsonTextToSpeechComponentBuilder apiKey(java.lang.String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
    }

    class IbmWatsonTextToSpeechComponentBuilderImpl
            extends AbstractComponentBuilder<WatsonTextToSpeechComponent>
            implements IbmWatsonTextToSpeechComponentBuilder {
        @Override
        protected WatsonTextToSpeechComponent buildConcreteComponent() {
            return new WatsonTextToSpeechComponent();
        }
        private org.apache.camel.component.ibm.watson.tts.WatsonTextToSpeechConfiguration getOrCreateConfiguration(WatsonTextToSpeechComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.ibm.watson.tts.WatsonTextToSpeechConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "serviceUrl": getOrCreateConfiguration((WatsonTextToSpeechComponent) component).setServiceUrl((java.lang.String) value); return true;
            case "accept": getOrCreateConfiguration((WatsonTextToSpeechComponent) component).setAccept((java.lang.String) value); return true;
            case "configuration": ((WatsonTextToSpeechComponent) component).setConfiguration((org.apache.camel.component.ibm.watson.tts.WatsonTextToSpeechConfiguration) value); return true;
            case "customizationId": getOrCreateConfiguration((WatsonTextToSpeechComponent) component).setCustomizationId((java.lang.String) value); return true;
            case "lazyStartProducer": ((WatsonTextToSpeechComponent) component).setLazyStartProducer((boolean) value); return true;
            case "operation": getOrCreateConfiguration((WatsonTextToSpeechComponent) component).setOperation((org.apache.camel.component.ibm.watson.tts.WatsonTextToSpeechOperations) value); return true;
            case "voice": getOrCreateConfiguration((WatsonTextToSpeechComponent) component).setVoice((java.lang.String) value); return true;
            case "autowiredEnabled": ((WatsonTextToSpeechComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "healthCheckConsumerEnabled": ((WatsonTextToSpeechComponent) component).setHealthCheckConsumerEnabled((boolean) value); return true;
            case "healthCheckProducerEnabled": ((WatsonTextToSpeechComponent) component).setHealthCheckProducerEnabled((boolean) value); return true;
            case "apiKey": getOrCreateConfiguration((WatsonTextToSpeechComponent) component).setApiKey((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}