/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Test routes and mediation rules using mocks.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface MockEndpointBuilderFactory {

    /**
     * Builder for endpoint for the Mock component.
     */
    public interface MockEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedMockEndpointBuilder advanced() {
            return (AdvancedMockEndpointBuilder) this;
        }

        /**
         * Sets a grace period after which the mock will re-assert to ensure the
         * preliminary assertion is still valid. This is used, for example, to
         * assert that exactly a number of messages arrive. For example, if the
         * expected count was set to 5, then the assertion is satisfied when
         * five or more messages arrive. To ensure that exactly 5 messages
         * arrive, then you would need to wait a little period to ensure no
         * further message arrives. This is what you can use this method for. By
         * default, this period is disabled.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: producer
         * 
         * @param assertPeriod the value to set
         * @return the dsl builder
         */
        default MockEndpointBuilder assertPeriod(long assertPeriod) {
            doSetProperty("assertPeriod", assertPeriod);
            return this;
        }
        /**
         * Sets a grace period after which the mock will re-assert to ensure the
         * preliminary assertion is still valid. This is used, for example, to
         * assert that exactly a number of messages arrive. For example, if the
         * expected count was set to 5, then the assertion is satisfied when
         * five or more messages arrive. To ensure that exactly 5 messages
         * arrive, then you would need to wait a little period to ensure no
         * further message arrives. This is what you can use this method for. By
         * default, this period is disabled.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: producer
         * 
         * @param assertPeriod the value to set
         * @return the dsl builder
         */
        default MockEndpointBuilder assertPeriod(String assertPeriod) {
            doSetProperty("assertPeriod", assertPeriod);
            return this;
        }
        /**
         * Specifies the expected number of message exchanges that should be
         * received by this mock. Beware: If you want to expect that 0 messages,
         * then take extra care, as 0 matches when the tests starts, so you need
         * to set a assert period time to let the test run for a while to make
         * sure there are still no messages arrived; for that use the
         * assertPeriod option. If you want to assert that exactly nth message
         * arrives to this mock, then see also the assertPeriod option for
         * further details.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param expectedCount the value to set
         * @return the dsl builder
         */
        default MockEndpointBuilder expectedCount(int expectedCount) {
            doSetProperty("expectedCount", expectedCount);
            return this;
        }
        /**
         * Specifies the expected number of message exchanges that should be
         * received by this mock. Beware: If you want to expect that 0 messages,
         * then take extra care, as 0 matches when the tests starts, so you need
         * to set a assert period time to let the test run for a while to make
         * sure there are still no messages arrived; for that use the
         * assertPeriod option. If you want to assert that exactly nth message
         * arrives to this mock, then see also the assertPeriod option for
         * further details.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param expectedCount the value to set
         * @return the dsl builder
         */
        default MockEndpointBuilder expectedCount(String expectedCount) {
            doSetProperty("expectedCount", expectedCount);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Mock component.
     */
    public interface AdvancedMockEndpointBuilder
            extends
                EndpointProducerBuilder {
        default MockEndpointBuilder basic() {
            return (MockEndpointBuilder) this;
        }

        /**
         * Sets whether to make a deep copy of the incoming Exchange when
         * received at this mock endpoint.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param copyOnExchange the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder copyOnExchange(boolean copyOnExchange) {
            doSetProperty("copyOnExchange", copyOnExchange);
            return this;
        }
        /**
         * Sets whether to make a deep copy of the incoming Exchange when
         * received at this mock endpoint.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param copyOnExchange the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder copyOnExchange(String copyOnExchange) {
            doSetProperty("copyOnExchange", copyOnExchange);
            return this;
        }
        /**
         * Sets whether assertIsSatisfied() should fail fast at the first
         * detected failed expectation while it may otherwise wait for all
         * expected messages to arrive before performing expectations
         * verifications. Is by default true. Set to false to use behavior as in
         * Camel 2.x.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param failFast the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder failFast(boolean failFast) {
            doSetProperty("failFast", failFast);
            return this;
        }
        /**
         * Sets whether assertIsSatisfied() should fail fast at the first
         * detected failed expectation while it may otherwise wait for all
         * expected messages to arrive before performing expectations
         * verifications. Is by default true. Set to false to use behavior as in
         * Camel 2.x.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param failFast the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder failFast(String failFast) {
            doSetProperty("failFast", failFast);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * To turn on logging when the mock receives an incoming message. This
         * will log only one time at INFO level for the incoming message. For
         * more detailed logging, then set the logger to DEBUG level for the
         * org.apache.camel.component.mock.MockEndpoint class.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param log the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder log(boolean log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * To turn on logging when the mock receives an incoming message. This
         * will log only one time at INFO level for the incoming message. For
         * more detailed logging, then set the logger to DEBUG level for the
         * org.apache.camel.component.mock.MockEndpoint class.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param log the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder log(String log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * A number that is used to turn on throughput logging based on groups
         * of the size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: producer (advanced)
         * 
         * @param reportGroup the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder reportGroup(int reportGroup) {
            doSetProperty("reportGroup", reportGroup);
            return this;
        }
        /**
         * A number that is used to turn on throughput logging based on groups
         * of the size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: producer (advanced)
         * 
         * @param reportGroup the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder reportGroup(String reportGroup) {
            doSetProperty("reportGroup", reportGroup);
            return this;
        }
        /**
         * Sets the minimum expected amount of time the assertIsSatisfied() will
         * wait on a latch until it is satisfied.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: producer (advanced)
         * 
         * @param resultMinimumWaitTime the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder resultMinimumWaitTime(long resultMinimumWaitTime) {
            doSetProperty("resultMinimumWaitTime", resultMinimumWaitTime);
            return this;
        }
        /**
         * Sets the minimum expected amount of time the assertIsSatisfied() will
         * wait on a latch until it is satisfied.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: producer (advanced)
         * 
         * @param resultMinimumWaitTime the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder resultMinimumWaitTime(String resultMinimumWaitTime) {
            doSetProperty("resultMinimumWaitTime", resultMinimumWaitTime);
            return this;
        }
        /**
         * Sets the maximum amount of time the assertIsSatisfied() will wait on
         * a latch until it is satisfied.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: producer (advanced)
         * 
         * @param resultWaitTime the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder resultWaitTime(long resultWaitTime) {
            doSetProperty("resultWaitTime", resultWaitTime);
            return this;
        }
        /**
         * Sets the maximum amount of time the assertIsSatisfied() will wait on
         * a latch until it is satisfied.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: producer (advanced)
         * 
         * @param resultWaitTime the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder resultWaitTime(String resultWaitTime) {
            doSetProperty("resultWaitTime", resultWaitTime);
            return this;
        }
        /**
         * Specifies to only retain the first nth number of received Exchanges.
         * This is used when testing with big data, to reduce memory consumption
         * by not storing copies of every Exchange this mock endpoint receives.
         * Important: When using this limitation, then the getReceivedCounter()
         * will still return the actual number of received message. For example
         * if we have received 5000 messages and have configured to only retain
         * the first 10 Exchanges, then the getReceivedCounter() will still
         * return 5000 but there is only the first 10 Exchanges in the
         * getExchanges() and getReceivedExchanges() methods. When using this
         * method, then some of the other expectation methods is not supported,
         * for example the expectedBodiesReceived(Object...) sets a expectation
         * on the first number of bodies received. You can configure both
         * retainFirst and retainLast options, to limit both the first and last
         * received.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: -1
         * Group: producer (advanced)
         * 
         * @param retainFirst the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder retainFirst(int retainFirst) {
            doSetProperty("retainFirst", retainFirst);
            return this;
        }
        /**
         * Specifies to only retain the first nth number of received Exchanges.
         * This is used when testing with big data, to reduce memory consumption
         * by not storing copies of every Exchange this mock endpoint receives.
         * Important: When using this limitation, then the getReceivedCounter()
         * will still return the actual number of received message. For example
         * if we have received 5000 messages and have configured to only retain
         * the first 10 Exchanges, then the getReceivedCounter() will still
         * return 5000 but there is only the first 10 Exchanges in the
         * getExchanges() and getReceivedExchanges() methods. When using this
         * method, then some of the other expectation methods is not supported,
         * for example the expectedBodiesReceived(Object...) sets a expectation
         * on the first number of bodies received. You can configure both
         * retainFirst and retainLast options, to limit both the first and last
         * received.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: -1
         * Group: producer (advanced)
         * 
         * @param retainFirst the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder retainFirst(String retainFirst) {
            doSetProperty("retainFirst", retainFirst);
            return this;
        }
        /**
         * Specifies to only retain the last nth number of received Exchanges.
         * This is used when testing with big data, to reduce memory consumption
         * by not storing copies of every Exchange this mock endpoint receives.
         * Important: When using this limitation, then the getReceivedCounter()
         * will still return the actual number of received message. For example
         * if we have received 5000 messages and have configured to only retain
         * the last 20 Exchanges, then the getReceivedCounter() will still
         * return 5000 but there is only the last 20 Exchanges in the
         * getExchanges() and getReceivedExchanges() methods. When using this
         * method, then some of the other expectation methods is not supported,
         * for example the expectedBodiesReceived(Object...) sets a expectation
         * on the first number of bodies received. You can configure both
         * retainFirst and retainLast options, to limit both the first and last
         * received.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: -1
         * Group: producer (advanced)
         * 
         * @param retainLast the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder retainLast(int retainLast) {
            doSetProperty("retainLast", retainLast);
            return this;
        }
        /**
         * Specifies to only retain the last nth number of received Exchanges.
         * This is used when testing with big data, to reduce memory consumption
         * by not storing copies of every Exchange this mock endpoint receives.
         * Important: When using this limitation, then the getReceivedCounter()
         * will still return the actual number of received message. For example
         * if we have received 5000 messages and have configured to only retain
         * the last 20 Exchanges, then the getReceivedCounter() will still
         * return 5000 but there is only the last 20 Exchanges in the
         * getExchanges() and getReceivedExchanges() methods. When using this
         * method, then some of the other expectation methods is not supported,
         * for example the expectedBodiesReceived(Object...) sets a expectation
         * on the first number of bodies received. You can configure both
         * retainFirst and retainLast options, to limit both the first and last
         * received.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: -1
         * Group: producer (advanced)
         * 
         * @param retainLast the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder retainLast(String retainLast) {
            doSetProperty("retainLast", retainLast);
            return this;
        }
        /**
         * Allows a sleep to be specified to wait to check that this mock really
         * is empty when expectedMessageCount(int) is called with zero value.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: producer (advanced)
         * 
         * @param sleepForEmptyTest the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder sleepForEmptyTest(long sleepForEmptyTest) {
            doSetProperty("sleepForEmptyTest", sleepForEmptyTest);
            return this;
        }
        /**
         * Allows a sleep to be specified to wait to check that this mock really
         * is empty when expectedMessageCount(int) is called with zero value.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: producer (advanced)
         * 
         * @param sleepForEmptyTest the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder sleepForEmptyTest(String sleepForEmptyTest) {
            doSetProperty("sleepForEmptyTest", sleepForEmptyTest);
            return this;
        }
        /**
         * Maximum number of messages to keep in memory available for browsing.
         * Use 0 for unlimited.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param browseLimit the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder browseLimit(int browseLimit) {
            doSetProperty("browseLimit", browseLimit);
            return this;
        }
        /**
         * Maximum number of messages to keep in memory available for browsing.
         * Use 0 for unlimited.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param browseLimit the value to set
         * @return the dsl builder
         */
        default AdvancedMockEndpointBuilder browseLimit(String browseLimit) {
            doSetProperty("browseLimit", browseLimit);
            return this;
        }
    }

    public interface MockBuilders {
        /**
         * Mock (camel-mock)
         * Test routes and mediation rules using mocks.
         * 
         * Category: core,testing
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-mock
         * 
         * Syntax: <code>mock:name</code>
         * 
         * Path parameter: name (required)
         * Name of mock endpoint
         * 
         * @param path name
         * @return the dsl builder
         */
        default MockEndpointBuilder mock(String path) {
            return MockEndpointBuilderFactory.endpointBuilder("mock", path);
        }
        /**
         * Mock (camel-mock)
         * Test routes and mediation rules using mocks.
         * 
         * Category: core,testing
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-mock
         * 
         * Syntax: <code>mock:name</code>
         * 
         * Path parameter: name (required)
         * Name of mock endpoint
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path name
         * @return the dsl builder
         */
        default MockEndpointBuilder mock(String componentName, String path) {
            return MockEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    static MockEndpointBuilder endpointBuilder(String componentName, String path) {
        class MockEndpointBuilderImpl extends AbstractEndpointBuilder implements MockEndpointBuilder, AdvancedMockEndpointBuilder {
            public MockEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new MockEndpointBuilderImpl(path);
    }
}