/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.conf;

import bk-shade.com.google.common.annotations.Beta;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.SortedLedgerStorage;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;

public class ServerConfiguration
extends AbstractConfiguration {
    protected static final String ENTRY_LOG_SIZE_LIMIT = "logSizeLimit";
    protected static final String ENTRY_LOG_FILE_PREALLOCATION_ENABLED = "entryLogFilePreallocationEnabled";
    protected static final String MINOR_COMPACTION_INTERVAL = "minorCompactionInterval";
    protected static final String MINOR_COMPACTION_THRESHOLD = "minorCompactionThreshold";
    protected static final String MAJOR_COMPACTION_INTERVAL = "majorCompactionInterval";
    protected static final String MAJOR_COMPACTION_THRESHOLD = "majorCompactionThreshold";
    protected static final String IS_THROTTLE_BY_BYTES = "isThrottleByBytes";
    protected static final String COMPACTION_MAX_OUTSTANDING_REQUESTS = "compactionMaxOutstandingRequests";
    protected static final String COMPACTION_RATE = "compactionRate";
    protected static final String COMPACTION_RATE_BY_ENTRIES = "compactionRateByEntries";
    protected static final String COMPACTION_RATE_BY_BYTES = "compactionRateByBytes";
    protected static final String GC_WAIT_TIME = "gcWaitTime";
    protected static final String IS_FORCE_GC_ALLOW_WHEN_NO_SPACE = "isForceGCAllowWhenNoSpace";
    protected static final String GC_OVERREPLICATED_LEDGER_WAIT_TIME = "gcOverreplicatedLedgerWaitTime";
    protected static final String FLUSH_INTERVAL = "flushInterval";
    protected static final String FLUSH_ENTRYLOG_INTERVAL_BYTES = "flushEntrylogBytes";
    protected static final String DEATH_WATCH_INTERVAL = "bookieDeathWatchInterval";
    protected static final String OPEN_FILE_LIMIT = "openFileLimit";
    protected static final String PAGE_LIMIT = "pageLimit";
    protected static final String PAGE_SIZE = "pageSize";
    protected static final String MAX_JOURNAL_SIZE = "journalMaxSizeMB";
    protected static final String MAX_BACKUP_JOURNALS = "journalMaxBackups";
    protected static final String JOURNAL_ADAPTIVE_GROUP_WRITES = "journalAdaptiveGroupWrites";
    protected static final String JOURNAL_MAX_GROUP_WAIT_MSEC = "journalMaxGroupWaitMSec";
    protected static final String JOURNAL_BUFFERED_WRITES_THRESHOLD = "journalBufferedWritesThreshold";
    protected static final String JOURNAL_BUFFERED_ENTRIES_THRESHOLD = "journalBufferedEntriesThreshold";
    protected static final String JOURNAL_FLUSH_WHEN_QUEUE_EMPTY = "journalFlushWhenQueueEmpty";
    protected static final String JOURNAL_REMOVE_FROM_PAGE_CACHE = "journalRemoveFromPageCache";
    protected static final String JOURNAL_PRE_ALLOC_SIZE = "journalPreAllocSizeMB";
    protected static final String JOURNAL_WRITE_BUFFER_SIZE = "journalWriteBufferSizeKB";
    protected static final String JOURNAL_ALIGNMENT_SIZE = "journalAlignmentSize";
    protected static final String NUM_JOURNAL_CALLBACK_THREADS = "numJournalCallbackThreads";
    protected static final String JOURNAL_FORMAT_VERSION_TO_WRITE = "journalFormatVersionToWrite";
    protected static final String BOOKIE_PORT = "bookiePort";
    protected static final String LISTENING_INTERFACE = "listeningInterface";
    protected static final String ALLOW_LOOPBACK = "allowLoopback";
    protected static final String ADVERTISED_ADDRESS = "advertisedAddress";
    protected static final String ALLOW_EPHEMERAL_PORTS = "allowEphemeralPorts";
    protected static final String JOURNAL_DIR = "journalDirectory";
    protected static final String JOURNAL_DIRS = "journalDirectories";
    protected static final String LEDGER_DIRS = "ledgerDirectories";
    protected static final String INDEX_DIRS = "indexDirectories";
    protected static final String ALLOW_STORAGE_EXPANSION = "allowStorageExpansion";
    protected static final String SERVER_TCP_NODELAY = "serverTcpNoDelay";
    protected static final String SERVER_SOCK_KEEPALIVE = "serverSockKeepalive";
    protected static final String SERVER_SOCK_LINGER = "serverTcpLinger";
    protected static final String ZK_TIMEOUT = "zkTimeout";
    protected static final String ZK_SERVERS = "zkServers";
    protected static final String ZK_RETRY_BACKOFF_START_MS = "zkRetryBackoffStartMs";
    protected static final String ZK_RETRY_BACKOFF_MAX_MS = "zkRetryBackoffMaxMs";
    protected static final String OPEN_LEDGER_REREPLICATION_GRACE_PERIOD = "openLedgerRereplicationGracePeriod";
    protected static final String READ_ONLY_MODE_ENABLED = "readOnlyModeEnabled";
    protected static final String FORCE_READ_ONLY_BOOKIE = "forceReadOnlyBookie";
    protected static final String DISK_USAGE_THRESHOLD = "diskUsageThreshold";
    protected static final String DISK_USAGE_WARN_THRESHOLD = "diskUsageWarnThreshold";
    protected static final String DISK_USAGE_LWM_THRESHOLD = "diskUsageLwmThreshold";
    protected static final String DISK_CHECK_INTERVAL = "diskCheckInterval";
    protected static final String AUDITOR_PERIODIC_CHECK_INTERVAL = "auditorPeriodicCheckInterval";
    protected static final String AUDITOR_PERIODIC_BOOKIE_CHECK_INTERVAL = "auditorPeriodicBookieCheckInterval";
    protected static final String AUTO_RECOVERY_DAEMON_ENABLED = "autoRecoveryDaemonEnabled";
    protected static final String LOST_BOOKIE_RECOVERY_DELAY = "lostBookieRecoveryDelay";
    protected static final String NUM_ADD_WORKER_THREADS = "numAddWorkerThreads";
    protected static final String NUM_READ_WORKER_THREADS = "numReadWorkerThreads";
    protected static final String NUM_LONG_POLL_WORKER_THREADS = "numLongPollWorkerThreads";
    protected static final String REQUEST_TIMER_TICK_DURATION_MILLISEC = "requestTimerTickDurationMs";
    protected static final String REQUEST_TIMER_NO_OF_TICKS = "requestTimerNumTicks";
    protected static final String READ_BUFFER_SIZE = "readBufferSizeBytes";
    protected static final String WRITE_BUFFER_SIZE = "writeBufferSizeBytes";
    protected static final String USE_HOST_NAME_AS_BOOKIE_ID = "useHostNameAsBookieID";
    protected static final String ENABLE_LOCAL_TRANSPORT = "enableLocalTransport";
    protected static final String DISABLE_SERVER_SOCKET_BIND = "disableServerSocketBind";
    protected static final String SORTED_LEDGER_STORAGE_ENABLED = "sortedLedgerStorageEnabled";
    protected static final String SKIP_LIST_SIZE_LIMIT = "skipListSizeLimit";
    protected static final String SKIP_LIST_CHUNK_SIZE_ENTRY = "skipListArenaChunkSize";
    protected static final String SKIP_LIST_MAX_ALLOC_ENTRY = "skipListArenaMaxAllocSize";
    protected static final String ENABLE_STATISTICS = "enableStatistics";
    protected static final String STATS_PROVIDER_CLASS = "statsProviderClass";
    protected static final String LEDGER_STORAGE_CLASS = "ledgerStorageClass";
    protected static final String BYTEBUF_ALLOCATOR_SIZE_INITIAL = "byteBufAllocatorSizeInitial";
    protected static final String BYTEBUF_ALLOCATOR_SIZE_MIN = "byteBufAllocatorSizeMin";
    protected static final String BYTEBUF_ALLOCATOR_SIZE_MAX = "byteBufAllocatorSizeMax";
    protected static final String BOOKIE_AUTH_PROVIDER_FACTORY_CLASS = "bookieAuthProviderFactoryClass";
    protected static final String MIN_USABLESIZE_FOR_INDEXFILE_CREATION = "minUsableSizeForIndexFileCreation";
    protected static final String ALLOW_MULTIPLEDIRS_UNDER_SAME_DISKPARTITION = "allowMultipleDirsUnderSameDiskPartition";
    protected static final String TLS_CLIENT_AUTHENTICATION = "tlsClientAuthentication";
    protected static final String TLS_KEYSTORE_TYPE = "tlsKeyStoreType";
    protected static final String TLS_KEYSTORE = "tlsKeyStore";
    protected static final String TLS_KEYSTORE_PASSWORD_PATH = "tlsKeyStorePasswordPath";
    protected static final String TLS_TRUSTSTORE_TYPE = "tlsTrustStoreType";
    protected static final String TLS_TRUSTSTORE = "tlsTrustStore";
    protected static final String TLS_TRUSTSTORE_PASSWORD_PATH = "tlsTrustStorePasswordPath";

    public ServerConfiguration() {
    }

    public ServerConfiguration(AbstractConfiguration conf) {
        this.loadConf(conf);
    }

    public long getEntryLogSizeLimit() {
        return this.getLong(ENTRY_LOG_SIZE_LIMIT, 0x40000000L);
    }

    public ServerConfiguration setEntryLogSizeLimit(long logSizeLimit) {
        this.setProperty(ENTRY_LOG_SIZE_LIMIT, Long.toString(logSizeLimit));
        return this;
    }

    public boolean isEntryLogFilePreAllocationEnabled() {
        return this.getBoolean(ENTRY_LOG_FILE_PREALLOCATION_ENABLED, true);
    }

    public ServerConfiguration setEntryLogFilePreAllocationEnabled(boolean enabled) {
        this.setProperty(ENTRY_LOG_FILE_PREALLOCATION_ENABLED, enabled);
        return this;
    }

    public long getGcWaitTime() {
        return this.getLong(GC_WAIT_TIME, 600000L);
    }

    public ServerConfiguration setGcWaitTime(long gcWaitTime) {
        this.setProperty(GC_WAIT_TIME, Long.toString(gcWaitTime));
        return this;
    }

    public long getGcOverreplicatedLedgerWaitTimeMillis() {
        return this.getLong(GC_OVERREPLICATED_LEDGER_WAIT_TIME, TimeUnit.DAYS.toMillis(1L));
    }

    public ServerConfiguration setGcOverreplicatedLedgerWaitTime(long gcWaitTime, TimeUnit unit) {
        this.setProperty(GC_OVERREPLICATED_LEDGER_WAIT_TIME, Long.toString(unit.toMillis(gcWaitTime)));
        return this;
    }

    public int getFlushInterval() {
        return this.getInt(FLUSH_INTERVAL, 10000);
    }

    public ServerConfiguration setFlushInterval(int flushInterval) {
        this.setProperty(FLUSH_INTERVAL, Integer.toString(flushInterval));
        return this;
    }

    public long getFlushIntervalInBytes() {
        return this.getLong(FLUSH_ENTRYLOG_INTERVAL_BYTES, 0L);
    }

    public ServerConfiguration setFlushIntervalInBytes(long flushInterval) {
        this.setProperty(FLUSH_ENTRYLOG_INTERVAL_BYTES, Long.toString(flushInterval));
        return this;
    }

    public int getDeathWatchInterval() {
        return this.getInt(DEATH_WATCH_INTERVAL, 1000);
    }

    public int getOpenFileLimit() {
        return this.getInt(OPEN_FILE_LIMIT, 20000);
    }

    public ServerConfiguration setOpenFileLimit(int fileLimit) {
        this.setProperty(OPEN_FILE_LIMIT, fileLimit);
        return this;
    }

    public int getPageLimit() {
        return this.getInt(PAGE_LIMIT, -1);
    }

    public ServerConfiguration setPageLimit(int pageLimit) {
        this.setProperty(PAGE_LIMIT, pageLimit);
        return this;
    }

    public int getPageSize() {
        return this.getInt(PAGE_SIZE, 8192);
    }

    public ServerConfiguration setPageSize(int pageSize) {
        this.setProperty(PAGE_SIZE, pageSize);
        return this;
    }

    public long getMaxJournalSizeMB() {
        return this.getLong(MAX_JOURNAL_SIZE, 2048L);
    }

    public ServerConfiguration setMaxJournalSizeMB(long maxJournalSize) {
        this.setProperty(MAX_JOURNAL_SIZE, Long.toString(maxJournalSize));
        return this;
    }

    public int getJournalPreAllocSizeMB() {
        return this.getInt(JOURNAL_PRE_ALLOC_SIZE, 16);
    }

    public int getJournalWriteBufferSizeKB() {
        return this.getInt(JOURNAL_WRITE_BUFFER_SIZE, 64);
    }

    public int getMaxBackupJournals() {
        return this.getInt(MAX_BACKUP_JOURNALS, 5);
    }

    public ServerConfiguration setMaxBackupJournals(int maxBackupJournals) {
        this.setProperty(MAX_BACKUP_JOURNALS, Integer.toString(maxBackupJournals));
        return this;
    }

    public int getJournalAlignmentSize() {
        return this.getInt(JOURNAL_ALIGNMENT_SIZE, 512);
    }

    public ServerConfiguration setJournalAlignmentSize(int size) {
        this.setProperty(JOURNAL_ALIGNMENT_SIZE, size);
        return this;
    }

    public int getJournalFormatVersionToWrite() {
        return this.getInt(JOURNAL_FORMAT_VERSION_TO_WRITE, 4);
    }

    public ServerConfiguration setJournalFormatVersionToWrite(int version) {
        this.setProperty(JOURNAL_FORMAT_VERSION_TO_WRITE, version);
        return this;
    }

    public int getBookiePort() {
        return this.getInt(BOOKIE_PORT, 3181);
    }

    public ServerConfiguration setBookiePort(int port) {
        this.setProperty(BOOKIE_PORT, Integer.toString(port));
        return this;
    }

    public String getListeningInterface() {
        return this.getString(LISTENING_INTERFACE);
    }

    public ServerConfiguration setListeningInterface(String iface) {
        this.setProperty(LISTENING_INTERFACE, iface);
        return this;
    }

    public boolean getAllowLoopback() {
        return this.getBoolean(ALLOW_LOOPBACK, false);
    }

    public ServerConfiguration setAllowLoopback(boolean allow) {
        this.setProperty(ALLOW_LOOPBACK, allow);
        return this;
    }

    public String getAdvertisedAddress() {
        return this.getString(ADVERTISED_ADDRESS, null);
    }

    public ServerConfiguration setAdvertisedAddress(String advertisedAddress) {
        this.setProperty(ADVERTISED_ADDRESS, advertisedAddress);
        return this;
    }

    public boolean getAllowEphemeralPorts() {
        return this.getBoolean(ALLOW_EPHEMERAL_PORTS, false);
    }

    public ServerConfiguration setAllowEphemeralPorts(boolean allow) {
        this.setProperty(ALLOW_EPHEMERAL_PORTS, allow);
        return this;
    }

    public boolean getAllowStorageExpansion() {
        return this.getBoolean(ALLOW_STORAGE_EXPANSION, false);
    }

    public ServerConfiguration setAllowStorageExpansion(boolean val) {
        this.setProperty(ALLOW_STORAGE_EXPANSION, val);
        return this;
    }

    public String[] getJournalDirNames() {
        String[] journalDirs = this.getStringArray(JOURNAL_DIRS);
        if (journalDirs == null || journalDirs.length == 0) {
            return new String[]{this.getJournalDirName()};
        }
        return journalDirs;
    }

    @Deprecated
    public String getJournalDirName() {
        return this.getString(JOURNAL_DIR, "/tmp/bk-txn");
    }

    public String getJournalDirNameWithoutDefault() {
        return this.getString(JOURNAL_DIR);
    }

    public ServerConfiguration setJournalDirName(String journalDir) {
        this.setProperty(JOURNAL_DIRS, new String[]{journalDir});
        return this;
    }

    public ServerConfiguration setJournalDirsName(String[] journalDirs) {
        this.setProperty(JOURNAL_DIRS, journalDirs);
        return this;
    }

    public File[] getJournalDirs() {
        String[] journalDirNames = this.getJournalDirNames();
        File[] journalDirs = new File[journalDirNames.length];
        for (int i = 0; i < journalDirNames.length; ++i) {
            journalDirs[i] = new File(journalDirNames[i]);
        }
        return journalDirs;
    }

    public String[] getLedgerDirWithoutDefault() {
        return this.getStringArray(LEDGER_DIRS);
    }

    public String[] getLedgerDirNames() {
        String[] ledgerDirs = this.getStringArray(LEDGER_DIRS);
        if (null == ledgerDirs || 0 == ledgerDirs.length) {
            return new String[]{"/tmp/bk-data"};
        }
        return ledgerDirs;
    }

    public ServerConfiguration setLedgerDirNames(String[] ledgerDirs) {
        if (null == ledgerDirs) {
            return this;
        }
        this.setProperty(LEDGER_DIRS, ledgerDirs);
        return this;
    }

    public File[] getLedgerDirs() {
        String[] ledgerDirNames = this.getLedgerDirNames();
        File[] ledgerDirs = new File[ledgerDirNames.length];
        for (int i = 0; i < ledgerDirNames.length; ++i) {
            ledgerDirs[i] = new File(ledgerDirNames[i]);
        }
        return ledgerDirs;
    }

    public String[] getIndexDirNames() {
        if (!this.containsKey(INDEX_DIRS)) {
            return null;
        }
        return this.getStringArray(INDEX_DIRS);
    }

    public ServerConfiguration setIndexDirName(String[] indexDirs) {
        this.setProperty(INDEX_DIRS, indexDirs);
        return this;
    }

    public File[] getIndexDirs() {
        String[] idxDirNames = this.getIndexDirNames();
        if (null == idxDirNames) {
            return null;
        }
        File[] idxDirs = new File[idxDirNames.length];
        for (int i = 0; i < idxDirNames.length; ++i) {
            idxDirs[i] = new File(idxDirNames[i]);
        }
        return idxDirs;
    }

    public boolean getServerTcpNoDelay() {
        return this.getBoolean(SERVER_TCP_NODELAY, true);
    }

    public ServerConfiguration setServerTcpNoDelay(boolean noDelay) {
        this.setProperty(SERVER_TCP_NODELAY, Boolean.toString(noDelay));
        return this;
    }

    public int getServerSockLinger() {
        return this.getInt(SERVER_SOCK_LINGER, 0);
    }

    public ServerConfiguration setServerSockLinger(int linger) {
        this.setProperty(SERVER_SOCK_LINGER, Integer.toString(linger));
        return this;
    }

    public boolean getServerSockKeepalive() {
        return this.getBoolean(SERVER_SOCK_KEEPALIVE, true);
    }

    public ServerConfiguration setServerSockKeepalive(boolean keepalive) {
        this.setProperty(SERVER_SOCK_KEEPALIVE, Boolean.toString(keepalive));
        return this;
    }

    public String getZkServers() {
        List servers = this.getList(ZK_SERVERS, null);
        if (null == servers || 0 == servers.size()) {
            return null;
        }
        return StringUtils.join((Collection)servers, (String)",");
    }

    public ServerConfiguration setZkServers(String zkServers) {
        this.setProperty(ZK_SERVERS, zkServers);
        return this;
    }

    public int getZkTimeout() {
        return this.getInt(ZK_TIMEOUT, 10000);
    }

    public ServerConfiguration setZkTimeout(int zkTimeout) {
        this.setProperty(ZK_TIMEOUT, Integer.toString(zkTimeout));
        return this;
    }

    public int getZkRetryBackoffStartMs() {
        return this.getInt(ZK_RETRY_BACKOFF_START_MS, this.getZkTimeout());
    }

    public ServerConfiguration setZkRetryBackoffStartMs(int retryMs) {
        this.setProperty(ZK_RETRY_BACKOFF_START_MS, retryMs);
        return this;
    }

    public int getZkRetryBackoffMaxMs() {
        return this.getInt(ZK_RETRY_BACKOFF_MAX_MS, this.getZkTimeout());
    }

    public ServerConfiguration setZkRetryBackoffMaxMs(int retryMs) {
        this.setProperty(ZK_RETRY_BACKOFF_MAX_MS, retryMs);
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.getBoolean(ENABLE_STATISTICS, true);
    }

    public ServerConfiguration setStatisticsEnabled(boolean enabled) {
        this.setProperty(ENABLE_STATISTICS, Boolean.toString(enabled));
        return this;
    }

    public double getMinorCompactionThreshold() {
        return this.getDouble(MINOR_COMPACTION_THRESHOLD, 0.2f);
    }

    public ServerConfiguration setMinorCompactionThreshold(double threshold) {
        this.setProperty(MINOR_COMPACTION_THRESHOLD, threshold);
        return this;
    }

    public double getMajorCompactionThreshold() {
        return this.getDouble(MAJOR_COMPACTION_THRESHOLD, 0.8f);
    }

    public ServerConfiguration setMajorCompactionThreshold(double threshold) {
        this.setProperty(MAJOR_COMPACTION_THRESHOLD, threshold);
        return this;
    }

    public long getMinorCompactionInterval() {
        return this.getLong(MINOR_COMPACTION_INTERVAL, 3600L);
    }

    public ServerConfiguration setMinorCompactionInterval(long interval) {
        this.setProperty(MINOR_COMPACTION_INTERVAL, interval);
        return this;
    }

    public long getMajorCompactionInterval() {
        return this.getLong(MAJOR_COMPACTION_INTERVAL, 86400L);
    }

    public ServerConfiguration setMajorCompactionInterval(long interval) {
        this.setProperty(MAJOR_COMPACTION_INTERVAL, interval);
        return this;
    }

    public boolean getIsForceGCAllowWhenNoSpace() {
        return this.getBoolean(IS_FORCE_GC_ALLOW_WHEN_NO_SPACE, false);
    }

    public ServerConfiguration setIsForceGCAllowWhenNoSpace(boolean force) {
        this.setProperty(IS_FORCE_GC_ALLOW_WHEN_NO_SPACE, force);
        return this;
    }

    public void setOpenLedgerRereplicationGracePeriod(String waitTime) {
        this.setProperty(OPEN_LEDGER_REREPLICATION_GRACE_PERIOD, waitTime);
    }

    public long getOpenLedgerRereplicationGracePeriod() {
        return this.getLong(OPEN_LEDGER_REREPLICATION_GRACE_PERIOD, 30000L);
    }

    public int getReadBufferBytes() {
        return this.getInt(READ_BUFFER_SIZE, 512);
    }

    public ServerConfiguration setReadBufferBytes(int readBufferSize) {
        this.setProperty(READ_BUFFER_SIZE, readBufferSize);
        return this;
    }

    public ServerConfiguration setNumAddWorkerThreads(int numThreads) {
        this.setProperty(NUM_ADD_WORKER_THREADS, numThreads);
        return this;
    }

    public int getNumAddWorkerThreads() {
        return this.getInt(NUM_ADD_WORKER_THREADS, 1);
    }

    public ServerConfiguration setNumLongPollWorkerThreads(int numThreads) {
        this.setProperty(NUM_LONG_POLL_WORKER_THREADS, numThreads);
        return this;
    }

    public int getNumLongPollWorkerThreads() {
        return this.getInt(NUM_LONG_POLL_WORKER_THREADS, 10);
    }

    public ServerConfiguration setNumReadWorkerThreads(int numThreads) {
        this.setProperty(NUM_READ_WORKER_THREADS, numThreads);
        return this;
    }

    public int getNumReadWorkerThreads() {
        return this.getInt(NUM_READ_WORKER_THREADS, 8);
    }

    public ServerConfiguration setRequestTimerTickDurationMs(int tickDuration) {
        this.setProperty(REQUEST_TIMER_TICK_DURATION_MILLISEC, tickDuration);
        return this;
    }

    public int getRequestTimerTickDurationMs() {
        return this.getInt(REQUEST_TIMER_TICK_DURATION_MILLISEC, 10);
    }

    public ServerConfiguration setRequestTimerNumTicks(int tickCount) {
        this.setProperty(REQUEST_TIMER_NO_OF_TICKS, tickCount);
        return this;
    }

    public int getRequestTimerNumTicks() {
        return this.getInt(REQUEST_TIMER_NO_OF_TICKS, 1024);
    }

    public int getWriteBufferBytes() {
        return this.getInt(WRITE_BUFFER_SIZE, 65536);
    }

    public ServerConfiguration setWriteBufferBytes(int writeBufferBytes) {
        this.setProperty(WRITE_BUFFER_SIZE, writeBufferBytes);
        return this;
    }

    public ServerConfiguration setNumJournalCallbackThreads(int numThreads) {
        this.setProperty(NUM_JOURNAL_CALLBACK_THREADS, numThreads);
        return this;
    }

    public int getNumJournalCallbackThreads() {
        return this.getInt(NUM_JOURNAL_CALLBACK_THREADS, 1);
    }

    public ServerConfiguration setSortedLedgerStorageEnabled(boolean enabled) {
        this.setProperty(SORTED_LEDGER_STORAGE_ENABLED, enabled);
        return this;
    }

    public boolean getSortedLedgerStorageEnabled() {
        return this.getBoolean(SORTED_LEDGER_STORAGE_ENABLED, true);
    }

    public long getSkipListSizeLimit() {
        return this.getLong(SKIP_LIST_SIZE_LIMIT, 0x4000000L);
    }

    public ServerConfiguration setSkipListSizeLimit(int size) {
        this.setProperty(SKIP_LIST_SIZE_LIMIT, size);
        return this;
    }

    public int getSkipListArenaChunkSize() {
        return this.getInt(SKIP_LIST_CHUNK_SIZE_ENTRY, 0x400000);
    }

    public ServerConfiguration setSkipListArenaChunkSize(int size) {
        this.setProperty(SKIP_LIST_CHUNK_SIZE_ENTRY, size);
        return this;
    }

    public int getSkipListArenaMaxAllocSize() {
        return this.getInt(SKIP_LIST_MAX_ALLOC_ENTRY, 131072);
    }

    public boolean getJournalAdaptiveGroupWrites() {
        return this.getBoolean(JOURNAL_ADAPTIVE_GROUP_WRITES, true);
    }

    public ServerConfiguration setJournalAdaptiveGroupWrites(boolean enabled) {
        this.setProperty(JOURNAL_ADAPTIVE_GROUP_WRITES, enabled);
        return this;
    }

    public long getJournalMaxGroupWaitMSec() {
        return this.getLong(JOURNAL_MAX_GROUP_WAIT_MSEC, 2L);
    }

    public ServerConfiguration setJournalMaxGroupWaitMSec(long journalMaxGroupWaitMSec) {
        this.setProperty(JOURNAL_MAX_GROUP_WAIT_MSEC, journalMaxGroupWaitMSec);
        return this;
    }

    public long getJournalBufferedWritesThreshold() {
        return this.getLong(JOURNAL_BUFFERED_WRITES_THRESHOLD, 524288L);
    }

    public long getJournalBufferedEntriesThreshold() {
        return this.getLong(JOURNAL_BUFFERED_ENTRIES_THRESHOLD, 0L);
    }

    public ServerConfiguration setJournalBufferedEntriesThreshold(int maxEntries) {
        this.setProperty(JOURNAL_BUFFERED_ENTRIES_THRESHOLD, maxEntries);
        return this;
    }

    public ServerConfiguration setJournalFlushWhenQueueEmpty(boolean enabled) {
        this.setProperty(JOURNAL_FLUSH_WHEN_QUEUE_EMPTY, enabled);
        return this;
    }

    public boolean getJournalFlushWhenQueueEmpty() {
        return this.getBoolean(JOURNAL_FLUSH_WHEN_QUEUE_EMPTY, false);
    }

    public ServerConfiguration setReadOnlyModeEnabled(boolean enabled) {
        this.setProperty(READ_ONLY_MODE_ENABLED, enabled);
        return this;
    }

    public boolean isReadOnlyModeEnabled() {
        return this.getBoolean(READ_ONLY_MODE_ENABLED, true);
    }

    public ServerConfiguration setDiskUsageWarnThreshold(float threshold) {
        this.setProperty(DISK_USAGE_WARN_THRESHOLD, Float.valueOf(threshold));
        return this;
    }

    public float getDiskUsageWarnThreshold() {
        return this.getFloat(DISK_USAGE_WARN_THRESHOLD, 0.9f);
    }

    public ServerConfiguration setDiskUsageThreshold(float threshold) {
        this.setProperty(DISK_USAGE_THRESHOLD, Float.valueOf(threshold));
        return this;
    }

    public float getDiskUsageThreshold() {
        return this.getFloat(DISK_USAGE_THRESHOLD, 0.95f);
    }

    public ServerConfiguration setDiskLowWaterMarkUsageThreshold(float threshold) {
        this.setProperty(DISK_USAGE_LWM_THRESHOLD, Float.valueOf(threshold));
        return this;
    }

    public float getDiskLowWaterMarkUsageThreshold() {
        return this.getFloat(DISK_USAGE_LWM_THRESHOLD, this.getDiskUsageThreshold());
    }

    public ServerConfiguration setDiskCheckInterval(int interval) {
        this.setProperty(DISK_CHECK_INTERVAL, interval);
        return this;
    }

    public int getDiskCheckInterval() {
        return this.getInt(DISK_CHECK_INTERVAL, 10000);
    }

    public void setAuditorPeriodicCheckInterval(long interval) {
        this.setProperty(AUDITOR_PERIODIC_CHECK_INTERVAL, interval);
    }

    public long getAuditorPeriodicCheckInterval() {
        return this.getLong(AUDITOR_PERIODIC_CHECK_INTERVAL, 604800L);
    }

    public void setAuditorPeriodicBookieCheckInterval(long interval) {
        this.setProperty(AUDITOR_PERIODIC_BOOKIE_CHECK_INTERVAL, interval);
    }

    public long getAuditorPeriodicBookieCheckInterval() {
        return this.getLong(AUDITOR_PERIODIC_BOOKIE_CHECK_INTERVAL, 86400L);
    }

    public ServerConfiguration setAutoRecoveryDaemonEnabled(boolean enabled) {
        this.setProperty(AUTO_RECOVERY_DAEMON_ENABLED, enabled);
        return this;
    }

    public boolean isAutoRecoveryDaemonEnabled() {
        return this.getBoolean(AUTO_RECOVERY_DAEMON_ENABLED, false);
    }

    public int getLostBookieRecoveryDelay() {
        return this.getInt(LOST_BOOKIE_RECOVERY_DELAY, 0);
    }

    public void setLostBookieRecoveryDelay(int interval) {
        this.setProperty(LOST_BOOKIE_RECOVERY_DELAY, interval);
    }

    public ServerConfiguration setForceReadOnlyBookie(boolean enabled) {
        this.setProperty(FORCE_READ_ONLY_BOOKIE, enabled);
        return this;
    }

    public boolean isForceReadOnlyBookie() {
        return this.getBoolean(FORCE_READ_ONLY_BOOKIE, false);
    }

    public boolean getIsThrottleByBytes() {
        return this.getBoolean(IS_THROTTLE_BY_BYTES, false);
    }

    public ServerConfiguration setIsThrottleByBytes(boolean byBytes) {
        this.setProperty(IS_THROTTLE_BY_BYTES, byBytes);
        return this;
    }

    public int getCompactionMaxOutstandingRequests() {
        return this.getInt(COMPACTION_MAX_OUTSTANDING_REQUESTS, 100000);
    }

    public ServerConfiguration setCompactionMaxOutstandingRequests(int maxOutstandingRequests) {
        this.setProperty(COMPACTION_MAX_OUTSTANDING_REQUESTS, maxOutstandingRequests);
        return this;
    }

    @Deprecated
    public int getCompactionRate() {
        return this.getInt(COMPACTION_RATE, 1000);
    }

    public ServerConfiguration setCompactionRate(int rate) {
        this.setProperty(COMPACTION_RATE, rate);
        return this;
    }

    public int getCompactionRateByEntries() {
        return this.getInt(COMPACTION_RATE_BY_ENTRIES, this.getCompactionRate());
    }

    public ServerConfiguration setCompactionRateByEntries(int rate) {
        this.setProperty(COMPACTION_RATE_BY_ENTRIES, rate);
        return this;
    }

    public int getCompactionRateByBytes() {
        return this.getInt(COMPACTION_RATE_BY_BYTES, 1000000);
    }

    public ServerConfiguration setCompactionRateByBytes(int rate) {
        this.setProperty(COMPACTION_RATE_BY_BYTES, rate);
        return this;
    }

    @Beta
    public boolean getJournalRemovePagesFromCache() {
        return this.getBoolean(JOURNAL_REMOVE_FROM_PAGE_CACHE, false);
    }

    public ServerConfiguration setJournalRemovePagesFromCache(boolean enabled) {
        this.setProperty(JOURNAL_REMOVE_FROM_PAGE_CACHE, enabled);
        return this;
    }

    public String getLedgerStorageClass() {
        String ledgerStorageClass = this.getString(LEDGER_STORAGE_CLASS, SortedLedgerStorage.class.getName());
        if (ledgerStorageClass.equals(SortedLedgerStorage.class.getName()) && !this.getSortedLedgerStorageEnabled()) {
            ledgerStorageClass = InterleavedLedgerStorage.class.getName();
        }
        return ledgerStorageClass;
    }

    public ServerConfiguration setLedgerStorageClass(String ledgerStorageClass) {
        this.setProperty(LEDGER_STORAGE_CLASS, ledgerStorageClass);
        return this;
    }

    public boolean getUseHostNameAsBookieID() {
        return this.getBoolean(USE_HOST_NAME_AS_BOOKIE_ID, false);
    }

    public ServerConfiguration setUseHostNameAsBookieID(boolean useHostName) {
        this.setProperty(USE_HOST_NAME_AS_BOOKIE_ID, useHostName);
        return this;
    }

    public boolean isEnableLocalTransport() {
        return this.getBoolean(ENABLE_LOCAL_TRANSPORT, false);
    }

    public ServerConfiguration setEnableLocalTransport(boolean enableLocalTransport) {
        this.setProperty(ENABLE_LOCAL_TRANSPORT, enableLocalTransport);
        return this;
    }

    public boolean isDisableServerSocketBind() {
        return this.getBoolean(DISABLE_SERVER_SOCKET_BIND, false);
    }

    public ServerConfiguration setDisableServerSocketBind(boolean disableServerSocketBind) {
        this.setProperty(DISABLE_SERVER_SOCKET_BIND, disableServerSocketBind);
        return this;
    }

    public Class<? extends StatsProvider> getStatsProviderClass() throws ConfigurationException {
        return ReflectionUtils.getClass((Configuration)this, STATS_PROVIDER_CLASS, NullStatsProvider.class, StatsProvider.class, defaultLoader);
    }

    public ServerConfiguration setStatsProviderClass(Class<? extends StatsProvider> providerClass) {
        this.setProperty(STATS_PROVIDER_CLASS, providerClass.getName());
        return this;
    }

    public void validate() throws ConfigurationException {
        if (this.getSkipListArenaChunkSize() < this.getSkipListArenaMaxAllocSize()) {
            throw new ConfigurationException("Arena max allocation size should be smaller than the chunk size.");
        }
        if (this.getJournalAlignmentSize() < 512 || this.getJournalAlignmentSize() % 512 != 0) {
            throw new ConfigurationException("Invalid journal alignment size : " + this.getJournalAlignmentSize());
        }
        if (this.getJournalAlignmentSize() > this.getJournalPreAllocSizeMB() * 1024 * 1024) {
            throw new ConfigurationException("Invalid preallocation size : " + this.getJournalPreAllocSizeMB() + " MB");
        }
        if (this.getEntryLogSizeLimit() > 0x40000000L) {
            throw new ConfigurationException("Entry log file size should not be larger than 1073741824");
        }
        if (0 == this.getBookiePort() && !this.getAllowEphemeralPorts()) {
            throw new ConfigurationException("Invalid port specified, using ephemeral ports accidentally?");
        }
    }

    public int getRecvByteBufAllocatorSizeInitial() {
        return this.getInt(BYTEBUF_ALLOCATOR_SIZE_INITIAL, 65536);
    }

    public void setRecvByteBufAllocatorSizeInitial(int size) {
        this.setProperty(BYTEBUF_ALLOCATOR_SIZE_INITIAL, size);
    }

    public int getRecvByteBufAllocatorSizeMin() {
        return this.getInt(BYTEBUF_ALLOCATOR_SIZE_MIN, 65536);
    }

    public void setRecvByteBufAllocatorSizeMin(int size) {
        this.setProperty(BYTEBUF_ALLOCATOR_SIZE_MIN, size);
    }

    public int getRecvByteBufAllocatorSizeMax() {
        return this.getInt(BYTEBUF_ALLOCATOR_SIZE_MAX, 0x100000);
    }

    public void setRecvByteBufAllocatorSizeMax(int size) {
        this.setProperty(BYTEBUF_ALLOCATOR_SIZE_MAX, size);
    }

    public void setBookieAuthProviderFactoryClass(String factoryClass) {
        this.setProperty(BOOKIE_AUTH_PROVIDER_FACTORY_CLASS, factoryClass);
    }

    public String getBookieAuthProviderFactoryClass() {
        return this.getString(BOOKIE_AUTH_PROVIDER_FACTORY_CLASS, null);
    }

    @Override
    public ServerConfiguration setNettyMaxFrameSizeBytes(int maxSize) {
        super.setNettyMaxFrameSizeBytes(maxSize);
        return this;
    }

    public String getTLSTrustStoreType() {
        return this.getString(TLS_TRUSTSTORE_TYPE, "JKS");
    }

    public ServerConfiguration setTLSKeyStoreType(String arg) {
        this.setProperty(TLS_KEYSTORE_TYPE, arg);
        return this;
    }

    public String getTLSKeyStore() {
        return this.getString(TLS_KEYSTORE, null);
    }

    public ServerConfiguration setTLSKeyStore(String arg) {
        this.setProperty(TLS_KEYSTORE, arg);
        return this;
    }

    public String getTLSKeyStorePasswordPath() {
        return this.getString(TLS_KEYSTORE_PASSWORD_PATH, null);
    }

    public ServerConfiguration setTLSKeyStorePasswordPath(String arg) {
        this.setProperty(TLS_KEYSTORE_PASSWORD_PATH, arg);
        return this;
    }

    public String getTLSKeyStoreType() {
        return this.getString(TLS_KEYSTORE_TYPE, "JKS");
    }

    public ServerConfiguration setTLSTrustStoreType(String arg) {
        this.setProperty(TLS_TRUSTSTORE_TYPE, arg);
        return this;
    }

    public String getTLSTrustStore() {
        return this.getString(TLS_TRUSTSTORE, null);
    }

    public ServerConfiguration setTLSTrustStore(String arg) {
        this.setProperty(TLS_TRUSTSTORE, arg);
        return this;
    }

    public String getTLSTrustStorePasswordPath() {
        return this.getString(TLS_TRUSTSTORE_PASSWORD_PATH, null);
    }

    public ServerConfiguration setTLSTrustStorePasswordPath(String arg) {
        this.setProperty(TLS_TRUSTSTORE_PASSWORD_PATH, arg);
        return this;
    }

    public long getMinUsableSizeForIndexFileCreation() {
        return this.getLong(MIN_USABLESIZE_FOR_INDEXFILE_CREATION, 0x6400000L);
    }

    public ServerConfiguration setMinUsableSizeForIndexFileCreation(long minUsableSizeForIndexFileCreation) {
        this.setProperty(MIN_USABLESIZE_FOR_INDEXFILE_CREATION, Long.toString(minUsableSizeForIndexFileCreation));
        return this;
    }

    public boolean isAllowMultipleDirsUnderSameDiskPartition() {
        return this.getBoolean(ALLOW_MULTIPLEDIRS_UNDER_SAME_DISKPARTITION, true);
    }

    public ServerConfiguration setAllowMultipleDirsUnderSameDiskPartition(boolean allow) {
        this.setProperty(ALLOW_MULTIPLEDIRS_UNDER_SAME_DISKPARTITION, allow);
        return this;
    }
}

