/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.OrderedSafeExecutor;
import org.apache.bookkeeper.versioning.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerDeleteOp
extends OrderedSafeExecutor.OrderedSafeGenericCallback<Void> {
    static final Logger LOG = LoggerFactory.getLogger(LedgerDeleteOp.class);
    BookKeeper bk;
    long ledgerId;
    AsyncCallback.DeleteCallback cb;
    Object ctx;
    long startTime;
    OpStatsLogger deleteOpLogger;

    LedgerDeleteOp(BookKeeper bk, long ledgerId, AsyncCallback.DeleteCallback cb, Object ctx) {
        super(bk.mainWorkerPool, ledgerId);
        this.bk = bk;
        this.ledgerId = ledgerId;
        this.cb = cb;
        this.ctx = ctx;
        this.startTime = MathUtils.nowInNano();
        this.deleteOpLogger = bk.getDeleteOpLogger();
    }

    public void initiate() {
        this.bk.getLedgerManager().removeLedgerMetadata(this.ledgerId, Version.ANY, this);
    }

    @Override
    public void safeOperationComplete(int rc, Void result) {
        if (0 != rc) {
            this.deleteOpLogger.registerFailedEvent(MathUtils.elapsedNanos(this.startTime), TimeUnit.NANOSECONDS);
        } else {
            this.deleteOpLogger.registerSuccessfulEvent(MathUtils.elapsedNanos(this.startTime), TimeUnit.NANOSECONDS);
        }
        this.cb.deleteComplete(rc, this.ctx);
    }

    public String toString() {
        return String.format("LedgerDeleteOp(%d)", this.ledgerId);
    }
}

