/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import bk-shade.com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NavigableMap;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import org.apache.bookkeeper.bookie.EntryLocation;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.GarbageCollectorThread;
import org.apache.bookkeeper.bookie.LedgerCache;
import org.apache.bookkeeper.bookie.LedgerCacheImpl;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.SnapshotMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterleavedLedgerStorage
implements CompactableLedgerStorage,
EntryLogger.EntryLogListener {
    private static final Logger LOG = LoggerFactory.getLogger(InterleavedLedgerStorage.class);
    EntryLogger entryLogger;
    LedgerCache ledgerCache;
    private CheckpointSource checkpointSource;
    protected final CheckpointHolder checkpointHolder = new CheckpointHolder();
    private final CopyOnWriteArrayList<LedgerStorage.LedgerDeletionListener> ledgerDeletionListeners = Lists.newCopyOnWriteArrayList();
    protected final SnapshotMap<Long, Boolean> activeLedgers = new SnapshotMap();
    GarbageCollectorThread gcThread;
    private volatile boolean somethingWritten = false;
    private OpStatsLogger getOffsetStats;
    private OpStatsLogger getEntryStats;

    InterleavedLedgerStorage() {
    }

    @Override
    public void initialize(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, CheckpointSource checkpointSource, StatsLogger statsLogger) throws IOException {
        this.checkpointSource = checkpointSource;
        this.entryLogger = new EntryLogger(conf, ledgerDirsManager, this);
        this.ledgerCache = new LedgerCacheImpl(conf, this.activeLedgers, null == indexDirsManager ? ledgerDirsManager : indexDirsManager, statsLogger);
        this.gcThread = new GarbageCollectorThread(conf, ledgerManager, this);
        ledgerDirsManager.addLedgerDirsListener(this.getLedgerDirsListener());
        this.getOffsetStats = statsLogger.getOpStatsLogger("STORAGE_GET_OFFSET");
        this.getEntryStats = statsLogger.getOpStatsLogger("STORAGE_GET_ENTRY");
    }

    private LedgerDirsManager.LedgerDirsListener getLedgerDirsListener() {
        return new LedgerDirsManager.LedgerDirsListener(){

            @Override
            public void diskFailed(File disk) {
            }

            @Override
            public void diskAlmostFull(File disk) {
                if (InterleavedLedgerStorage.this.gcThread.isForceGCAllowWhenNoSpace) {
                    InterleavedLedgerStorage.this.gcThread.enableForceGC();
                } else {
                    InterleavedLedgerStorage.this.gcThread.suspendMajorGC();
                }
            }

            @Override
            public void diskFull(File disk) {
                if (InterleavedLedgerStorage.this.gcThread.isForceGCAllowWhenNoSpace) {
                    InterleavedLedgerStorage.this.gcThread.enableForceGC();
                } else {
                    InterleavedLedgerStorage.this.gcThread.suspendMajorGC();
                    InterleavedLedgerStorage.this.gcThread.suspendMinorGC();
                }
            }

            @Override
            public void allDisksFull() {
                if (InterleavedLedgerStorage.this.gcThread.isForceGCAllowWhenNoSpace) {
                    InterleavedLedgerStorage.this.gcThread.enableForceGC();
                } else {
                    InterleavedLedgerStorage.this.gcThread.suspendMajorGC();
                    InterleavedLedgerStorage.this.gcThread.suspendMinorGC();
                }
            }

            @Override
            public void fatalError() {
            }

            @Override
            public void diskWritable(File disk) {
                if (InterleavedLedgerStorage.this.gcThread.isForceGCAllowWhenNoSpace) {
                    InterleavedLedgerStorage.this.gcThread.disableForceGC();
                } else {
                    InterleavedLedgerStorage.this.gcThread.resumeMajorGC();
                    InterleavedLedgerStorage.this.gcThread.resumeMinorGC();
                }
            }

            @Override
            public void diskJustWritable(File disk) {
                if (InterleavedLedgerStorage.this.gcThread.isForceGCAllowWhenNoSpace) {
                    InterleavedLedgerStorage.this.gcThread.enableForceGC();
                } else {
                    InterleavedLedgerStorage.this.gcThread.resumeMinorGC();
                }
            }
        };
    }

    @Override
    public void start() {
        this.gcThread.start();
    }

    @Override
    public void shutdown() throws InterruptedException {
        LOG.info("Shutting down InterleavedLedgerStorage");
        LOG.info("Shutting down GC thread");
        this.gcThread.shutdown();
        LOG.info("Shutting down entry logger");
        this.entryLogger.shutdown();
        try {
            this.ledgerCache.close();
        }
        catch (IOException e) {
            LOG.error("Error while closing the ledger cache", (Throwable)e);
        }
        LOG.info("Complete shutting down Ledger Storage");
    }

    @Override
    public boolean setFenced(long ledgerId) throws IOException {
        return this.ledgerCache.setFenced(ledgerId);
    }

    @Override
    public boolean isFenced(long ledgerId) throws IOException {
        return this.ledgerCache.isFenced(ledgerId);
    }

    @Override
    public void setExplicitlac(long ledgerId, ByteBuf lac) throws IOException {
        this.ledgerCache.setExplicitLac(ledgerId, lac);
    }

    @Override
    public ByteBuf getExplicitLac(long ledgerId) {
        return this.ledgerCache.getExplicitLac(ledgerId);
    }

    @Override
    public void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        this.ledgerCache.setMasterKey(ledgerId, masterKey);
    }

    @Override
    public byte[] readMasterKey(long ledgerId) throws IOException, BookieException {
        return this.ledgerCache.readMasterKey(ledgerId);
    }

    @Override
    public boolean ledgerExists(long ledgerId) throws IOException {
        return this.ledgerCache.ledgerExists(ledgerId);
    }

    @Override
    public long getLastAddConfirmed(long ledgerId) throws IOException {
        Long lac = this.ledgerCache.getLastAddConfirmed(ledgerId);
        if (lac == null) {
            ByteBuf bb = this.getEntry(ledgerId, -1L);
            if (null == bb) {
                return -1L;
            }
            bb.readLong();
            bb.readLong();
            lac = bb.readLong();
            lac = this.ledgerCache.updateLastAddConfirmed(ledgerId, lac);
        }
        return lac;
    }

    @Override
    public Observable waitForLastAddConfirmedUpdate(long ledgerId, long previoisLAC, Observer observer) throws IOException {
        return this.ledgerCache.waitForLastAddConfirmedUpdate(ledgerId, previoisLAC, observer);
    }

    @Override
    public synchronized long addEntry(ByteBuf entry) throws IOException {
        long ledgerId = entry.getLong(entry.readerIndex() + 0);
        long entryId = entry.getLong(entry.readerIndex() + 8);
        long lac = entry.getLong(entry.readerIndex() + 16);
        this.processEntry(ledgerId, entryId, entry.nioBuffer());
        this.ledgerCache.updateLastAddConfirmed(ledgerId, lac);
        return entryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf getEntry(long ledgerId, long entryId) throws IOException {
        long offset;
        if (entryId == -1L) {
            entryId = this.ledgerCache.getLastEntry(ledgerId);
        }
        long startTimeNanos = MathUtils.nowInNano();
        boolean success = false;
        try {
            offset = this.ledgerCache.getEntryOffset(ledgerId, entryId);
            if (offset == 0L) {
                throw new Bookie.NoEntryException(ledgerId, entryId);
            }
            success = true;
        }
        finally {
            if (success) {
                this.getOffsetStats.registerSuccessfulEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
            } else {
                this.getOffsetStats.registerFailedEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
            }
        }
        startTimeNanos = MathUtils.nowInNano();
        success = false;
        try {
            byte[] retBytes = this.entryLogger.readEntry(ledgerId, entryId, offset);
            success = true;
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])retBytes);
            return byteBuf;
        }
        finally {
            if (success) {
                this.getEntryStats.registerSuccessfulEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
            } else {
                this.getEntryStats.registerFailedEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
            }
        }
    }

    private void flushOrCheckpoint(boolean isCheckpointFlush) throws IOException {
        boolean flushFailed = false;
        try {
            this.ledgerCache.flushLedger(true);
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException e) {
            throw e;
        }
        catch (IOException ioe) {
            LOG.error("Exception flushing Ledger cache", (Throwable)ioe);
            flushFailed = true;
        }
        try {
            if (isCheckpointFlush) {
                this.entryLogger.checkpoint();
            } else {
                this.entryLogger.flush();
            }
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException e) {
            throw e;
        }
        catch (IOException ioe) {
            LOG.error("Exception flushing Ledger", (Throwable)ioe);
            flushFailed = true;
        }
        if (flushFailed) {
            throw new IOException("Flushing to storage failed, check logs");
        }
    }

    @Override
    public CheckpointSource.Checkpoint checkpoint(CheckpointSource.Checkpoint checkpoint) throws IOException {
        CheckpointSource.Checkpoint lastCheckpoint = this.checkpointHolder.getLastCheckpoint();
        if (lastCheckpoint.compareTo(checkpoint) > 0) {
            return lastCheckpoint;
        }
        this.flushOrCheckpoint(true);
        this.checkpointHolder.clearLastCheckpoint(lastCheckpoint);
        return lastCheckpoint;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (!this.somethingWritten) {
            return;
        }
        this.somethingWritten = false;
        this.flushOrCheckpoint(false);
    }

    @Override
    public void deleteLedger(long ledgerId) throws IOException {
        this.activeLedgers.remove(ledgerId);
        this.ledgerCache.deleteLedger(ledgerId);
        for (LedgerStorage.LedgerDeletionListener listener : this.ledgerDeletionListeners) {
            listener.ledgerDeleted(ledgerId);
        }
    }

    @Override
    public Iterable<Long> getActiveLedgersInRange(long firstLedgerId, long lastLedgerId) {
        NavigableMap<Long, Boolean> bkActiveLedgersSnapshot = this.activeLedgers.snapshot();
        NavigableMap<Long, Boolean> subBkActiveLedgers = bkActiveLedgersSnapshot.subMap(firstLedgerId, true, lastLedgerId, false);
        return subBkActiveLedgers.keySet();
    }

    @Override
    public void updateEntriesLocations(Iterable<EntryLocation> locations) throws IOException {
        for (EntryLocation l : locations) {
            try {
                this.ledgerCache.putEntryOffset(l.ledger, l.entry, l.location);
            }
            catch (Bookie.NoLedgerException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Compaction failed for deleted ledger ledger: {} entry: {}", (Object)l.ledger, (Object)l.entry);
            }
        }
    }

    @Override
    public void flushEntriesLocationsIndex() throws IOException {
        this.ledgerCache.flushLedger(true);
    }

    @Override
    public EntryLogger getEntryLogger() {
        return this.entryLogger;
    }

    @Override
    public void registerLedgerDeletionListener(LedgerStorage.LedgerDeletionListener listener) {
        this.ledgerDeletionListeners.add(listener);
    }

    protected void processEntry(long ledgerId, long entryId, ByteBuffer entry) throws IOException {
        this.processEntry(ledgerId, entryId, entry, true);
    }

    protected synchronized void processEntry(long ledgerId, long entryId, ByteBuffer entry, boolean rollLog) throws IOException {
        this.somethingWritten = true;
        long pos = this.entryLogger.addEntry(ledgerId, entry, rollLog);
        this.ledgerCache.putEntryOffset(ledgerId, entryId, pos);
    }

    @Override
    public void onRotateEntryLog() {
        this.checkpointHolder.setNextCheckpoint(this.checkpointSource.newCheckpoint());
    }

    protected static class CheckpointHolder {
        CheckpointSource.Checkpoint lastCheckpoint = CheckpointSource.Checkpoint.MAX;

        protected CheckpointHolder() {
        }

        protected synchronized void setNextCheckpoint(CheckpointSource.Checkpoint cp) {
            if (CheckpointSource.Checkpoint.MAX.equals(this.lastCheckpoint) || this.lastCheckpoint.compareTo(cp) < 0) {
                this.lastCheckpoint = cp;
            }
        }

        protected synchronized void clearLastCheckpoint(CheckpointSource.Checkpoint done) {
            if (0 == this.lastCheckpoint.compareTo(done)) {
                this.lastCheckpoint = CheckpointSource.Checkpoint.MAX;
            }
        }

        protected synchronized CheckpointSource.Checkpoint getLastCheckpoint() {
            return this.lastCheckpoint;
        }
    }
}

