/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.benchmark.stream;

import java.io.File;
import java.net.URI;
import org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.configuration.Configuration;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamBenchmark {
    private static final Logger logger = LoggerFactory.getLogger(StreamBenchmark.class);
    private static final String USAGE = "StreamBenchmark <benchmark-class> [options]";
    protected final Options options = new Options();
    protected URI uri;
    protected DistributedLogConfiguration conf;
    protected StatsProvider statsProvider;
    protected String streamName;

    protected StreamBenchmark() {
        this.options.addOption("c", "conf", true, "Configuration File");
        this.options.addOption("u", "uri", true, "DistributedLog URI");
        this.options.addOption("p", "stats-provider", true, "Stats Provider");
        this.options.addOption("s", "stream", true, "Stream Name");
        this.options.addOption("h", "help", false, "Print usage.");
    }

    protected Options getOptions() {
        return this.options;
    }

    protected void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp(USAGE, this.options);
    }

    protected void parseCommandLine(String[] args) throws Exception {
        BasicParser parser = new BasicParser();
        CommandLine cmdline = parser.parse(this.options, args);
        if (cmdline.hasOption("h")) {
            this.printUsage();
            System.exit(0);
        }
        if (cmdline.hasOption("u")) {
            this.uri = URI.create(cmdline.getOptionValue("u"));
        } else {
            this.printUsage();
            System.exit(0);
        }
        this.conf = new DistributedLogConfiguration();
        if (cmdline.hasOption("c")) {
            String configFile = cmdline.getOptionValue("c");
            this.conf.loadConf(new File(configFile).toURI().toURL());
        }
        this.statsProvider = cmdline.hasOption("p") ? (StatsProvider)ReflectionUtils.newInstance((String)cmdline.getOptionValue("p"), StatsProvider.class) : new NullStatsProvider();
        if (cmdline.hasOption("s")) {
            this.streamName = cmdline.getOptionValue("s");
        } else {
            this.printUsage();
            System.exit(0);
        }
        this.parseCommandLine(cmdline);
    }

    protected abstract void parseCommandLine(CommandLine var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(String[] args) throws Exception {
        logger.info("Parsing arguments for benchmark : {}", (Object[])args);
        this.parseCommandLine(args);
        this.statsProvider.start((Configuration)this.conf);
        StatsLogger statsLogger = this.statsProvider.getStatsLogger("dl");
        Namespace namespace = NamespaceBuilder.newBuilder().conf(this.conf).uri(this.uri).statsLogger(statsLogger).build();
        try {
            this.benchmark(namespace, this.streamName, this.statsProvider.getStatsLogger("benchmark"));
        }
        finally {
            namespace.close();
            this.statsProvider.stop();
        }
    }

    protected abstract void benchmark(Namespace var1, String var2, StatsLogger var3);

    public static void main(String[] args) throws Exception {
        if (args.length <= 0) {
            System.err.println(USAGE);
            return;
        }
        String benchmarkClassName = args[0];
        StreamBenchmark benchmark = (StreamBenchmark)ReflectionUtils.newInstance((String)benchmarkClassName, StreamBenchmark.class);
        benchmark.run(args);
    }
}

