/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.benchmark;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.twitter.common.zookeeper.ServerSet;
import com.twitter.finagle.builder.ClientBuilder;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.thrift.ClientId$;
import com.twitter.util.Duration$;
import com.twitter.util.Function;
import com.twitter.util.Future;
import com.twitter.util.FutureEventListener;
import com.twitter.util.Promise;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecordSet;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.api.AsyncLogReader;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.benchmark.Utils;
import org.apache.distributedlog.benchmark.Worker;
import org.apache.distributedlog.benchmark.thrift.Message;
import org.apache.distributedlog.client.serverset.DLZkServerSet;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.apache.distributedlog.common.util.SchedulerUtils;
import org.apache.distributedlog.exceptions.DLInterruptedException;
import org.apache.distributedlog.service.DistributedLogClient;
import org.apache.distributedlog.service.DistributedLogClientBuilder;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;

public class ReaderWorker
implements Worker {
    private static final Logger LOG = LoggerFactory.getLogger(ReaderWorker.class);
    static final int BACKOFF_MS = 200;
    final String streamPrefix;
    final int startStreamId;
    final int endStreamId;
    final ScheduledExecutorService executorService;
    final ExecutorService callbackExecutor;
    final Namespace namespace;
    final DistributedLogManager[] dlms;
    final AsyncLogReader[] logReaders;
    final StreamReader[] streamReaders;
    final int numStreams;
    final boolean readFromHead;
    final int truncationIntervalInSeconds;
    final DLZkServerSet[] serverSets;
    final List<String> finagleNames;
    final DistributedLogClient dlc;
    volatile boolean running = true;
    final StatsReceiver statsReceiver;
    final StatsLogger statsLogger;
    final OpStatsLogger e2eStat;
    final OpStatsLogger deliveryStat;
    final OpStatsLogger negativeE2EStat;
    final OpStatsLogger negativeDeliveryStat;
    final OpStatsLogger truncationStat;
    final Counter invalidRecordsCounter;
    final Counter outOfOrderSequenceIdCounter;

    public ReaderWorker(DistributedLogConfiguration conf, URI uri, String streamPrefix, int startStreamId, int endStreamId, int readThreadPoolSize, List<String> serverSetPaths, List<String> finagleNames, int truncationIntervalInSeconds, boolean readFromHead, StatsReceiver statsReceiver, StatsLogger statsLogger) throws IOException {
        Preconditions.checkArgument((startStreamId <= endStreamId ? 1 : 0) != 0);
        this.streamPrefix = streamPrefix;
        this.startStreamId = startStreamId;
        this.endStreamId = endStreamId;
        this.truncationIntervalInSeconds = truncationIntervalInSeconds;
        this.readFromHead = readFromHead;
        this.statsReceiver = statsReceiver;
        this.statsLogger = statsLogger;
        this.e2eStat = this.statsLogger.getOpStatsLogger("e2e");
        this.negativeE2EStat = this.statsLogger.getOpStatsLogger("e2eNegative");
        this.deliveryStat = this.statsLogger.getOpStatsLogger("delivery");
        this.negativeDeliveryStat = this.statsLogger.getOpStatsLogger("deliveryNegative");
        this.truncationStat = this.statsLogger.getOpStatsLogger("truncation");
        this.invalidRecordsCounter = this.statsLogger.getCounter("invalid_records");
        this.outOfOrderSequenceIdCounter = this.statsLogger.getCounter("out_of_order_seq_id");
        this.executorService = Executors.newScheduledThreadPool(readThreadPoolSize, new ThreadFactoryBuilder().setNameFormat("benchmark.reader-%d").build());
        this.callbackExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setNameFormat("benchmark.reader-callback-%d").build());
        this.finagleNames = finagleNames;
        this.serverSets = this.createServerSets(serverSetPaths);
        conf.setDeserializeRecordSetOnReads(false);
        if (!(truncationIntervalInSeconds <= 0 || finagleNames.isEmpty() && serverSetPaths.isEmpty())) {
            String[] remotes;
            String local;
            DistributedLogClientBuilder builder = DistributedLogClientBuilder.newBuilder().clientId(ClientId$.MODULE$.apply("dlog_loadtest_reader")).clientBuilder(ClientBuilder.get().hostConnectionLimit(10).hostConnectionCoresize(10).tcpConnectTimeout(Duration$.MODULE$.fromSeconds(1)).requestTimeout(Duration$.MODULE$.fromSeconds(2))).redirectBackoffStartMs(100).redirectBackoffMaxMs(500).requestTimeoutMs(2000).statsReceiver(statsReceiver).thriftmux(true).name("reader");
            if (serverSetPaths.isEmpty()) {
                local = finagleNames.get(0);
                remotes = new String[finagleNames.size() - 1];
                finagleNames.subList(1, finagleNames.size()).toArray(remotes);
                builder = builder.finagleNameStrs(local, remotes);
                LOG.info("Initialized distributedlog client for truncation @ {}.", finagleNames);
            } else if (this.serverSets.length != 0) {
                local = this.serverSets[0].getServerSet();
                remotes = new ServerSet[this.serverSets.length - 1];
                for (int i = 1; i < this.serverSets.length; ++i) {
                    remotes[i - 1] = this.serverSets[i].getServerSet();
                }
                builder = builder.serverSets((ServerSet)local, (ServerSet[])remotes);
                LOG.info("Initialized distributedlog client for truncation @ {}.", serverSetPaths);
            } else {
                builder = builder.uri(uri);
                LOG.info("Initialized distributedlog client for namespace {}", (Object)uri);
            }
            this.dlc = builder.build();
        } else {
            this.dlc = null;
        }
        this.namespace = NamespaceBuilder.newBuilder().conf(conf).uri(uri).statsLogger(statsLogger.scope("dl")).build();
        this.numStreams = endStreamId - startStreamId;
        this.dlms = new DistributedLogManager[this.numStreams];
        this.logReaders = new AsyncLogReader[this.numStreams];
        final CountDownLatch latch = new CountDownLatch(this.numStreams);
        int i = 0;
        while (i < this.numStreams) {
            final int idx = i++;
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    ReaderWorker.this.reinitStream(idx).map((Function1)new Function<Void, Void>(){

                        public Void apply(Void value) {
                            LOG.info("Initialized stream reader {}.", (Object)idx);
                            latch.countDown();
                            return null;
                        }
                    });
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new DLInterruptedException("Failed to intialize benchmark readers : ", (Throwable)e);
        }
        this.streamReaders = new StreamReader[this.numStreams];
        for (i = 0; i < this.numStreams; ++i) {
            this.streamReaders[i] = new StreamReader(i, statsLogger.scope("perstream"));
            if (truncationIntervalInSeconds <= 0) continue;
            this.executorService.scheduleWithFixedDelay(this.streamReaders[i], truncationIntervalInSeconds, truncationIntervalInSeconds, TimeUnit.SECONDS);
        }
        LOG.info("Initialized benchmark reader on {} streams {} : [{} - {})", new Object[]{this.numStreams, streamPrefix, startStreamId, endStreamId});
    }

    protected DLZkServerSet[] createServerSets(List<String> serverSetPaths) {
        DLZkServerSet[] serverSets = new DLZkServerSet[serverSetPaths.size()];
        for (int i = 0; i < serverSets.length; ++i) {
            String serverSetPath = serverSetPaths.get(i);
            serverSets[i] = DLZkServerSet.of((URI)URI.create(serverSetPath), (int)60000);
        }
        return serverSets;
    }

    private Future<Void> reinitStream(int idx) {
        Promise promise = new Promise();
        this.reinitStream(idx, (Promise<Void>)promise);
        return promise;
    }

    private void reinitStream(int idx, Promise<Void> promise) {
        DLSN lastDLSN;
        int streamId = this.startStreamId + idx;
        String streamName = String.format("%s_%d", this.streamPrefix, streamId);
        if (this.logReaders[idx] != null) {
            try {
                FutureUtils.result((CompletableFuture)this.logReaders[idx].asyncClose());
            }
            catch (Exception e) {
                LOG.warn("Failed on closing stream reader {} : ", (Object)streamName, (Object)e);
            }
            this.logReaders[idx] = null;
        }
        if (this.dlms[idx] != null) {
            try {
                this.dlms[idx].close();
            }
            catch (IOException e) {
                LOG.warn("Failed on closing dlm {} : ", (Object)streamName, (Object)e);
            }
            this.dlms[idx] = null;
        }
        try {
            this.dlms[idx] = this.namespace.openLog(streamName);
        }
        catch (IOException ioe) {
            LOG.error("Failed on creating dlm {} : ", (Object)streamName, (Object)ioe);
            this.scheduleReinitStream(idx, promise);
            return;
        }
        if (this.readFromHead) {
            lastDLSN = DLSN.InitialDLSN;
        } else {
            try {
                lastDLSN = this.dlms[idx].getLastDLSN();
            }
            catch (IOException ioe) {
                LOG.error("Failed on getting last dlsn from stream {} : ", (Object)streamName, (Object)ioe);
                this.scheduleReinitStream(idx, promise);
                return;
            }
        }
        try {
            this.logReaders[idx] = this.dlms[idx].getAsyncLogReader(lastDLSN);
        }
        catch (IOException ioe) {
            LOG.error("Failed on opening reader for stream {} starting from {} : ", new Object[]{streamName, lastDLSN, ioe});
            this.scheduleReinitStream(idx, promise);
            return;
        }
        LOG.info("Opened reader for stream {}, starting from {}.", (Object)streamName, (Object)lastDLSN);
        promise.setValue(null);
    }

    Future<Void> scheduleReinitStream(int idx) {
        Promise promise = new Promise();
        this.scheduleReinitStream(idx, (Promise<Void>)promise);
        return promise;
    }

    void scheduleReinitStream(final int idx, final Promise<Void> promise) {
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                ReaderWorker.this.reinitStream(idx, (Promise<Void>)promise);
            }
        }, 200L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws IOException {
        this.running = false;
        for (AsyncLogReader asyncLogReader : this.logReaders) {
            if (null == asyncLogReader) continue;
            org.apache.distributedlog.util.Utils.ioResult((CompletableFuture)asyncLogReader.asyncClose());
        }
        for (DistributedLogManager distributedLogManager : this.dlms) {
            if (null == distributedLogManager) continue;
            distributedLogManager.close();
        }
        this.namespace.close();
        SchedulerUtils.shutdownScheduler((ExecutorService)this.executorService, (long)2L, (TimeUnit)TimeUnit.MINUTES);
        SchedulerUtils.shutdownScheduler((ExecutorService)this.callbackExecutor, (long)2L, (TimeUnit)TimeUnit.MINUTES);
        if (this.dlc != null) {
            this.dlc.close();
        }
        for (DLZkServerSet dLZkServerSet : this.serverSets) {
            dLZkServerSet.close();
        }
        for (StreamReader streamReader : this.streamReaders) {
            streamReader.unregisterGauge();
        }
    }

    @Override
    public void run() {
        LOG.info("Starting reader (prefix = {}, numStreams = {}).", (Object)this.streamPrefix, (Object)this.numStreams);
        for (StreamReader sr : this.streamReaders) {
            sr.readLoop();
        }
    }

    class StreamReader
    implements org.apache.distributedlog.common.concurrent.FutureEventListener<List<LogRecordWithDLSN>>,
    Runnable,
    Gauge<Number> {
        final int streamIdx;
        final String streamName;
        DLSN prevDLSN = null;
        long prevSequenceId = Long.MIN_VALUE;
        private static final String gaugeLabel = "sequence_id";

        StreamReader(int idx, StatsLogger statsLogger) {
            this.streamIdx = idx;
            int streamId = ReaderWorker.this.startStreamId + this.streamIdx;
            this.streamName = String.format("%s_%d", ReaderWorker.this.streamPrefix, streamId);
            statsLogger.scope(this.streamName).registerGauge(gaugeLabel, (Gauge)this);
        }

        public void onSuccess(List<LogRecordWithDLSN> records) {
            for (LogRecordWithDLSN record : records) {
                if (record.isRecordSet()) {
                    try {
                        this.processRecordSet(record);
                    }
                    catch (IOException e) {
                        this.onFailure(e);
                    }
                    continue;
                }
                this.processRecord(record);
            }
            this.readLoop();
        }

        public void processRecordSet(LogRecordWithDLSN record) throws IOException {
            LogRecordSet.Reader reader = LogRecordSet.of((LogRecordWithDLSN)record);
            LogRecordWithDLSN nextRecord = reader.nextRecord();
            while (null != nextRecord) {
                this.processRecord(nextRecord);
                nextRecord = reader.nextRecord();
            }
            reader.release();
        }

        public void processRecord(LogRecordWithDLSN record) {
            Message msg;
            try {
                msg = Utils.parseMessage(record.getPayload());
            }
            catch (TException e) {
                ReaderWorker.this.invalidRecordsCounter.inc();
                LOG.warn("Failed to parse record {} for stream {} : size = {} , ", new Object[]{record, this.streamIdx, record.getPayload().length, e});
                return;
            }
            long curTimeMillis = System.currentTimeMillis();
            long e2eLatency = curTimeMillis - msg.getPublishTime();
            long deliveryLatency = curTimeMillis - record.getTransactionId();
            if (e2eLatency >= 0L) {
                ReaderWorker.this.e2eStat.registerSuccessfulEvent(e2eLatency, TimeUnit.MILLISECONDS);
            } else {
                ReaderWorker.this.negativeE2EStat.registerSuccessfulEvent(-e2eLatency, TimeUnit.MILLISECONDS);
            }
            if (deliveryLatency >= 0L) {
                ReaderWorker.this.deliveryStat.registerSuccessfulEvent(deliveryLatency, TimeUnit.MILLISECONDS);
            } else {
                ReaderWorker.this.negativeDeliveryStat.registerSuccessfulEvent(-deliveryLatency, TimeUnit.MILLISECONDS);
            }
            this.prevDLSN = record.getDlsn();
        }

        public void onFailure(Throwable cause) {
            ReaderWorker.this.scheduleReinitStream(this.streamIdx).map((Function1)new Function<Void, Void>(){

                public Void apply(Void value) {
                    StreamReader.this.prevDLSN = null;
                    StreamReader.this.prevSequenceId = Long.MIN_VALUE;
                    StreamReader.this.readLoop();
                    return null;
                }
            });
        }

        void readLoop() {
            if (!ReaderWorker.this.running) {
                return;
            }
            ReaderWorker.this.logReaders[this.streamIdx].readBulk(10).whenComplete((BiConsumer)((Object)this));
        }

        @Override
        public void run() {
            final DLSN dlsnToTruncate = this.prevDLSN;
            if (null == dlsnToTruncate) {
                return;
            }
            final Stopwatch stopwatch = Stopwatch.createStarted();
            ReaderWorker.this.dlc.truncate(this.streamName, dlsnToTruncate).addEventListener((FutureEventListener)new FutureEventListener<Boolean>(){

                public void onSuccess(Boolean value) {
                    ReaderWorker.this.truncationStat.registerSuccessfulEvent(stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                }

                public void onFailure(Throwable cause) {
                    ReaderWorker.this.truncationStat.registerFailedEvent(stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                    LOG.error("Failed to truncate stream {} to {} : ", new Object[]{StreamReader.this.streamName, dlsnToTruncate, cause});
                }
            });
        }

        public Number getDefaultValue() {
            return Long.MIN_VALUE;
        }

        public synchronized Number getSample() {
            return this.prevSequenceId;
        }

        void unregisterGauge() {
            ReaderWorker.this.statsLogger.scope(this.streamName).unregisterGauge(gaugeLabel, (Gauge)this);
        }
    }
}

