/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.balancer;

import java.util.Map;

public class BalancerUtils {
    public static <K> int calculateNumStreamsToRebalance(K nodeToRebalance, Map<K, Integer> loadDistribution, int rebalanceWaterMark, double tolerancePercentage) {
        Integer myLoad = loadDistribution.get(nodeToRebalance);
        if (null == myLoad || myLoad <= rebalanceWaterMark) {
            return 0;
        }
        long totalLoad = 0L;
        int numNodes = loadDistribution.size();
        for (Map.Entry<K, Integer> entry : loadDistribution.entrySet()) {
            if (null == entry.getKey() || null == entry.getValue()) continue;
            totalLoad += (long)entry.getValue().intValue();
        }
        double averageLoad = (double)totalLoad / (double)numNodes;
        long permissibleLoad = Math.max(1L, (long)Math.ceil(averageLoad + averageLoad * tolerancePercentage / 100.0));
        if ((long)myLoad.intValue() <= permissibleLoad) {
            return 0;
        }
        return Math.max(0, myLoad - (int)Math.ceil(averageLoad));
    }
}

