/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.stats.Histogram;
import com.twitter.common.stats.Histograms;
import com.twitter.common.stats.Windowed;
import com.twitter.common.util.Clock;

public class WindowedHistogram<H extends Histogram>
extends Windowed<H>
implements Histogram {
    private long mergedHistIndex = -1L;
    private Function<H[], Histogram> merger;
    private Histogram mergedHistogram = null;

    public WindowedHistogram(Class<H> clazz, Amount<Long, Time> amount, int n, Supplier<H> supplier, Function<H[], Histogram> function, Clock clock) {
        super(clazz, amount, n, supplier, new Function<H, H>(){

            public H apply(H h) {
                h.clear();
                return h;
            }
        }, clock);
        Preconditions.checkNotNull(function);
        this.merger = function;
    }

    @Override
    public synchronized void add(long l) {
        ((Histogram)this.getCurrent()).add(l);
    }

    @Override
    public synchronized void clear() {
        for (Histogram histogram : (Histogram[])this.buffers) {
            histogram.clear();
        }
    }

    @Override
    public synchronized long getQuantile(double d) {
        long l = this.getCurrentIndex();
        if (this.mergedHistIndex < l) {
            Histogram[] histogramArray = (Histogram[])this.getTenured();
            this.mergedHistogram = (Histogram)this.merger.apply((Object)histogramArray);
            this.mergedHistIndex = l;
        }
        return this.mergedHistogram.getQuantile(d);
    }

    @Override
    public synchronized long[] getQuantiles(double[] dArray) {
        return Histograms.extractQuantiles(this, dArray);
    }
}

