/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.tool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.tools.DocumentationTool;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.openjdk.tools.javac.api.JavacTrees;
import org.openjdk.tools.javac.file.BaseFileManager;
import org.openjdk.tools.javac.main.CommandLine;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.platform.PlatformDescription;
import org.openjdk.tools.javac.platform.PlatformUtils;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Options;
import org.openjdk.tools.javadoc.doclet.Doclet;
import org.openjdk.tools.javadoc.doclet.DocletEnvironment;
import org.openjdk.tools.javadoc.internal.doclets.standard.Standard;
import org.openjdk.tools.javadoc.internal.tool.JavadocTool;
import org.openjdk.tools.javadoc.internal.tool.Messager;
import org.openjdk.tools.javadoc.internal.tool.ToolOption;

public class Start
extends ToolOption.Helper {
    private final Context context;
    private static final String ProgramName = "javadoc";
    private static final String defaultModifier = "protected";
    private Messager messager;
    private final String docletName;
    private final ClassLoader classLoader;
    private Class<?> docletClass;
    private Doclet doclet;
    private Locale locale;
    private boolean apiMode;
    private JavaFileManager fileManager;
    Set<Doclet.Option> docletOptions = null;

    Start() {
        this(null, null, null, null, null);
    }

    Start(PrintWriter writer) {
        this(null, null, writer, null, null);
    }

    Start(Context context, String programName, PrintWriter writer, String docletName, ClassLoader classLoader) {
        this.context = context == null ? new Context() : context;
        String pname = programName == null ? ProgramName : programName;
        this.messager = writer == null ? new Messager(this.context, pname) : new Messager(this.context, pname, writer, writer);
        this.docletName = docletName;
        this.classLoader = classLoader;
        this.docletClass = null;
        this.locale = Locale.getDefault();
    }

    public Start(Context context) {
        this.docletClass = null;
        this.context = Objects.requireNonNull(context);
        this.apiMode = true;
        this.docletName = null;
        this.classLoader = null;
        this.locale = Locale.getDefault();
    }

    void initMessager() {
        if (!this.apiMode) {
            return;
        }
        if (this.messager == null) {
            PrintWriter out;
            Log log = this.context.get(Log.logKey);
            this.messager = log instanceof Messager ? (Messager)log : ((out = this.context.get(Log.outKey)) == null ? new Messager(this.context, ProgramName) : new Messager(this.context, ProgramName, out, out));
        }
    }

    @Override
    void usage() {
        this.usage(true);
    }

    void usage(boolean exit) {
        this.usage("main.usage", "-help", null, exit);
    }

    @Override
    void Xusage() {
        this.Xusage(true);
    }

    void Xusage(boolean exit) {
        this.usage("main.Xusage", "-X", "main.Xusage.foot", exit);
    }

    private void usage(String main, String option, String foot, boolean exit) {
        this.messager.notice(main, new Object[0]);
        if (this.docletClass != null) {
            String name = this.doclet.getName();
            Set<Doclet.Option> supportedOptions = this.doclet.getSupportedOptions();
            this.messager.notice("main.doclet.usage.header", name);
            Doclet.Option.Kind myKind = option.equals("-X") ? Doclet.Option.Kind.EXTENDED : Doclet.Option.Kind.STANDARD;
            supportedOptions.stream().filter(opt -> opt.getKind() == myKind).forEach(opt -> this.messager.printNotice(opt.toString()));
        }
        if (foot != null) {
            this.messager.notice(foot, new Object[0]);
        }
        if (exit) {
            this.exit();
        }
    }

    private void exit() {
        this.messager.exit();
    }

    int begin(String ... argv) {
        try {
            argv = CommandLine.parse(argv);
        }
        catch (FileNotFoundException e) {
            this.messager.error("main.cant.read", e.getMessage());
            this.exit();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            this.exit();
        }
        List<String> argList = Arrays.asList(argv);
        boolean ok = this.begin(argList, Collections.emptySet());
        return ok ? 0 : 1;
    }

    public boolean begin(Class<?> docletClass, Iterable<String> options, Iterable<? extends JavaFileObject> fileObjects) {
        this.docletClass = docletClass;
        ArrayList<String> opts = new ArrayList<String>();
        for (String opt : options) {
            opts.add(opt);
        }
        return this.begin(opts, fileObjects);
    }

    /*
     * Exception decompiling
     */
    private boolean begin(List<String> options, Iterable<? extends JavaFileObject> fileObjects) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean parseAndExecute(List<String> argList, Iterable<? extends JavaFileObject> fileObjects) throws IOException {
        boolean ok;
        JavadocTool comp;
        String platformString;
        long tm = System.currentTimeMillis();
        ArrayList<String> javaNames = new ArrayList<String>();
        this.compOpts = Options.instance(this.context);
        this.compOpts.put("-Xlint:-options", "-Xlint:-options");
        this.doclet.init(this.locale, this.messager);
        this.parseArgs(argList, javaNames);
        if (this.fileManager instanceof BaseFileManager) {
            ((BaseFileManager)this.fileManager).handleOptions(this.fileManagerOpts);
        }
        if ((platformString = this.compOpts.get("-release")) != null) {
            PlatformDescription platformDescription;
            if (this.compOpts.isSet("-source")) {
                this.usageError("main.release.bootclasspath.conflict", "-source");
            }
            if (this.fileManagerOpts.containsKey((Object)Option.BOOTCLASSPATH)) {
                this.usageError("main.release.bootclasspath.conflict", Option.BOOTCLASSPATH.getText());
            }
            if ((platformDescription = PlatformUtils.lookupPlatformDescription(platformString)) == null) {
                this.usageError("main.unsupported.release.version", platformString);
            }
            this.compOpts.put(Option.SOURCE, platformDescription.getSourceVersion());
            this.context.put(PlatformDescription.class, platformDescription);
            Collection<Path> platformCP = platformDescription.getPlatformPath();
            if (platformCP != null) {
                if (this.fileManager instanceof StandardJavaFileManager) {
                    StandardJavaFileManager sfm = (StandardJavaFileManager)this.fileManager;
                    sfm.setLocationFromPaths(StandardLocation.PLATFORM_CLASS_PATH, platformCP);
                } else {
                    this.usageError("main.release.not.standard.file.manager", platformString);
                }
            }
        }
        this.compOpts.notifyListeners();
        if (javaNames.isEmpty() && this.subPackages.isEmpty() && this.isEmpty(fileObjects)) {
            this.usageError("main.No_packages_or_classes_specified", new Object[0]);
        }
        if ((comp = JavadocTool.make0(this.context)) == null) {
            return false;
        }
        if (this.showAccess == null) {
            this.setFilter(defaultModifier);
        }
        DocletEnvironment root = comp.getEnvironment(this.encoding, this.showAccess, this.overviewpath, javaNames, fileObjects, this.subPackages, this.excludedPackages, this.docClasses, this.quiet);
        comp = null;
        if (this.breakiterator || !this.locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            JavacTrees trees = JavacTrees.instance(this.context);
            trees.setBreakIterator(BreakIterator.getSentenceInstance(this.locale));
        }
        boolean bl = ok = root != null;
        if (ok) {
            ok = this.doclet.run(root);
        }
        if (this.compOpts.get("-verbose") != null) {
            tm = System.currentTimeMillis() - tm;
            this.messager.notice("main.done_in", Long.toString(tm));
        }
        return ok;
    }

    int handleDocletOptions(int idx, List<String> args, boolean isToolOption) {
        if (this.docletOptions == null) {
            this.docletOptions = this.doclet.getSupportedOptions();
        }
        String arg = args.get(idx);
        for (Doclet.Option opt : this.docletOptions) {
            if (!opt.matches(arg)) continue;
            if (args.size() - idx < opt.getArgumentCount()) {
                this.usageError("main.requires_argument", arg);
            }
            opt.process(arg, args.listIterator(idx + 1));
            return idx += opt.getArgumentCount();
        }
        if (!isToolOption) {
            this.usageError("main.invalid_flag", arg);
        }
        return idx;
    }

    private Class<?> preProcess(JavaFileManager jfm, List<String> argv) {
        ClassLoader cl;
        String userDocletPath = null;
        String userDocletName = null;
        for (int i = 0; i < argv.size(); ++i) {
            String arg = argv.get(i);
            if (arg.equals(ToolOption.LOCALE.opt)) {
                this.oneArg(argv, i++);
                String[] lname = argv.get(i);
                this.locale = this.getLocale((String)lname);
                continue;
            }
            if (arg.equals(ToolOption.DOCLET.opt)) {
                this.oneArg(argv, i++);
                if (userDocletName != null) {
                    this.usageError("main.more_than_one_doclet_specified_0_and_1", userDocletName, argv.get(i));
                }
                if (this.docletName != null) {
                    this.usageError("main.more_than_one_doclet_specified_0_and_1", this.docletName, argv.get(i));
                }
                userDocletName = argv.get(i);
                continue;
            }
            if (!arg.equals(ToolOption.DOCLETPATH.opt)) continue;
            this.oneArg(argv, i++);
            userDocletPath = userDocletPath == null ? argv.get(i) : userDocletPath + File.pathSeparator + argv.get(i);
        }
        if (this.docletClass != null) {
            return this.docletClass;
        }
        if (userDocletName != null && (cl = this.classLoader) == null) {
            if (!this.fileManager.hasLocation(DocumentationTool.Location.DOCLET_PATH)) {
                ArrayList<File> paths = new ArrayList<File>();
                if (userDocletPath != null) {
                    for (String pathname : userDocletPath.split(File.pathSeparator)) {
                        paths.add(new File(pathname));
                    }
                }
                try {
                    ((StandardJavaFileManager)this.fileManager).setLocation(DocumentationTool.Location.DOCLET_PATH, paths);
                }
                catch (IOException ioe) {
                    this.panic("main.doclet_no_classloader_found", ioe);
                    return null;
                }
            }
            if ((cl = this.fileManager.getClassLoader(DocumentationTool.Location.DOCLET_PATH)) == null) {
                this.panic("main.doclet_no_classloader_found", userDocletName);
                return null;
            }
            try {
                return cl.loadClass(userDocletName);
            }
            catch (ClassNotFoundException cnfe) {
                this.panic("main.doclet_class_not_found", userDocletName);
                return null;
            }
        }
        if (this.docletName != null) {
            try {
                return Class.forName(this.docletName, true, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                this.panic("main.doclet_class_not_found", userDocletName);
                return null;
            }
        }
        return Standard.class;
    }

    private void parseArgs(List<String> args, List<String> javaNames) {
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            ToolOption o = ToolOption.get(arg);
            if (o != null) {
                this.handleDocletOptions(i, args, true);
                if (o.hasArg) {
                    this.oneArg(args, i++);
                    o.process(this, args.get(i));
                    continue;
                }
                this.setOption(arg);
                o.process(this);
                continue;
            }
            if (arg.startsWith("-XD")) {
                String s = arg.substring("-XD".length());
                int eq = s.indexOf(61);
                String key = eq < 0 ? s : s.substring(0, eq);
                String value = eq < 0 ? s : s.substring(eq + 1);
                this.compOpts.put(key, value);
                continue;
            }
            if (arg.startsWith("-")) {
                i = this.handleDocletOptions(i, args, false);
                continue;
            }
            javaNames.add(arg);
        }
    }

    private <T> boolean isEmpty(Iterable<T> iter) {
        return !iter.iterator().hasNext();
    }

    private void oneArg(List<String> args, int index) {
        if (index + 1 < args.size()) {
            this.setOption(args.get(index), args.get(index + 1));
        } else {
            this.usageError("main.requires_argument", args.get(index));
        }
    }

    @Override
    void usageError(String key, Object ... args) {
        this.error(key, args);
        this.usage(true);
    }

    void panic(String key, Object ... args) {
        this.error(key, args);
        this.messager.exit();
    }

    void error(String key, Object ... args) {
        this.messager.error(key, args);
    }

    private void setOption(String opt) {
        String[] option = new String[]{opt};
        this.options.add(Arrays.asList(option));
    }

    private void setOption(String opt, String argument) {
        String[] option = new String[]{opt, argument};
        this.options.add(Arrays.asList(option));
    }

    private void setOption(String opt, List<String> arguments) {
        ArrayList<String> args = new ArrayList<String>(arguments.size() + 1);
        args.add(opt);
        args.addAll(arguments);
        this.options.add(args);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Locale getLocale(String localeName) {
        Locale userlocale = null;
        if (localeName == null) return Locale.getDefault();
        if (localeName.isEmpty()) {
            return Locale.getDefault();
        }
        int firstuscore = localeName.indexOf(95);
        int seconduscore = -1;
        String language = null;
        String country = null;
        String variant = null;
        if (firstuscore == 2) {
            language = localeName.substring(0, firstuscore);
            seconduscore = localeName.indexOf(95, firstuscore + 1);
            if (seconduscore > 0) {
                if (seconduscore != firstuscore + 3 || localeName.length() <= seconduscore + 1) {
                    this.usageError("main.malformed_locale_name", localeName);
                    return null;
                }
                country = localeName.substring(firstuscore + 1, seconduscore);
                variant = localeName.substring(seconduscore + 1);
            } else {
                if (localeName.length() != firstuscore + 3) {
                    this.usageError("main.malformed_locale_name", localeName);
                    return null;
                }
                country = localeName.substring(firstuscore + 1);
            }
        } else if (firstuscore == -1 && localeName.length() == 2) {
            language = localeName;
        } else {
            this.usageError("main.malformed_locale_name", localeName);
            return null;
        }
        userlocale = this.searchLocale(language, country, variant);
        if (userlocale == null) {
            this.usageError("main.illegal_locale_name", localeName);
            return null;
        }
        return userlocale;
    }

    private Locale searchLocale(String language, String country, String variant) {
        for (Locale loc : Locale.getAvailableLocales()) {
            if (!loc.getLanguage().equals(language) || country != null && !loc.getCountry().equals(country) || variant != null && !loc.getVariant().equals(variant)) continue;
            return loc;
        }
        return null;
    }
}

