// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package v2

import (
	"context"
	"time"

	v2 "github.com/apache/apisix-ingress-controller/pkg/kube/apisix/apis/config/v2"
	scheme "github.com/apache/apisix-ingress-controller/pkg/kube/apisix/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ApisixGlobalRulesGetter has a method to return a ApisixGlobalRuleInterface.
// A group's client should implement this interface.
type ApisixGlobalRulesGetter interface {
	ApisixGlobalRules(namespace string) ApisixGlobalRuleInterface
}

// ApisixGlobalRuleInterface has methods to work with ApisixGlobalRule resources.
type ApisixGlobalRuleInterface interface {
	Create(ctx context.Context, apisixGlobalRule *v2.ApisixGlobalRule, opts v1.CreateOptions) (*v2.ApisixGlobalRule, error)
	Update(ctx context.Context, apisixGlobalRule *v2.ApisixGlobalRule, opts v1.UpdateOptions) (*v2.ApisixGlobalRule, error)
	UpdateStatus(ctx context.Context, apisixGlobalRule *v2.ApisixGlobalRule, opts v1.UpdateOptions) (*v2.ApisixGlobalRule, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v2.ApisixGlobalRule, error)
	List(ctx context.Context, opts v1.ListOptions) (*v2.ApisixGlobalRuleList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2.ApisixGlobalRule, err error)
	ApisixGlobalRuleExpansion
}

// apisixGlobalRules implements ApisixGlobalRuleInterface
type apisixGlobalRules struct {
	client rest.Interface
	ns     string
}

// newApisixGlobalRules returns a ApisixGlobalRules
func newApisixGlobalRules(c *ApisixV2Client, namespace string) *apisixGlobalRules {
	return &apisixGlobalRules{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the apisixGlobalRule, and returns the corresponding apisixGlobalRule object, and an error if there is any.
func (c *apisixGlobalRules) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2.ApisixGlobalRule, err error) {
	result = &v2.ApisixGlobalRule{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("apisixglobalrules").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ApisixGlobalRules that match those selectors.
func (c *apisixGlobalRules) List(ctx context.Context, opts v1.ListOptions) (result *v2.ApisixGlobalRuleList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v2.ApisixGlobalRuleList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("apisixglobalrules").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested apisixGlobalRules.
func (c *apisixGlobalRules) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("apisixglobalrules").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a apisixGlobalRule and creates it.  Returns the server's representation of the apisixGlobalRule, and an error, if there is any.
func (c *apisixGlobalRules) Create(ctx context.Context, apisixGlobalRule *v2.ApisixGlobalRule, opts v1.CreateOptions) (result *v2.ApisixGlobalRule, err error) {
	result = &v2.ApisixGlobalRule{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("apisixglobalrules").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(apisixGlobalRule).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a apisixGlobalRule and updates it. Returns the server's representation of the apisixGlobalRule, and an error, if there is any.
func (c *apisixGlobalRules) Update(ctx context.Context, apisixGlobalRule *v2.ApisixGlobalRule, opts v1.UpdateOptions) (result *v2.ApisixGlobalRule, err error) {
	result = &v2.ApisixGlobalRule{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("apisixglobalrules").
		Name(apisixGlobalRule.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(apisixGlobalRule).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *apisixGlobalRules) UpdateStatus(ctx context.Context, apisixGlobalRule *v2.ApisixGlobalRule, opts v1.UpdateOptions) (result *v2.ApisixGlobalRule, err error) {
	result = &v2.ApisixGlobalRule{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("apisixglobalrules").
		Name(apisixGlobalRule.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(apisixGlobalRule).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the apisixGlobalRule and deletes it. Returns an error if one occurs.
func (c *apisixGlobalRules) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("apisixglobalrules").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *apisixGlobalRules) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("apisixglobalrules").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched apisixGlobalRule.
func (c *apisixGlobalRules) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2.ApisixGlobalRule, err error) {
	result = &v2.ApisixGlobalRule{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("apisixglobalrules").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
