/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.mapred.JSPUtil;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.TaskReport;

public class TaskGraphServlet
extends HttpServlet {
    private static final long serialVersionUID = -1365683739392460020L;
    public static final int width = 600;
    public static final int height = 200;
    public static final int ymargin = 20;
    public static final int xmargin = 80;
    private static final float oneThird = 0.33333334f;

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        TaskReport[] reports;
        response.setContentType("image/svg+xml");
        JobTracker tracker = (JobTracker)this.getServletContext().getAttribute("job.tracker");
        String jobIdStr = request.getParameter("jobid");
        if (jobIdStr == null) {
            return;
        }
        JobID jobId = JobID.forName(jobIdStr);
        JSPUtil.JobWithViewAccessCheck myJob = JSPUtil.checkAccessAndGetJob(tracker, jobId, request, response);
        if (!myJob.isViewJobAllowed()) {
            return;
        }
        boolean isMap = "map".equalsIgnoreCase(request.getParameter("type"));
        TaskReport[] taskReportArray = reports = isMap ? tracker.getMapTaskReports(jobId) : tracker.getReduceTaskReports(jobId);
        if (reports == null) {
            return;
        }
        int numTasks = reports.length;
        int tasksPerBar = (int)Math.ceil((double)numTasks / 600.0);
        int numBars = numTasks == 0 ? 600 : (int)Math.ceil((double)numTasks / (double)tasksPerBar);
        int w = Math.max(600, numBars);
        int barWidth = Math.min(10, w / numBars);
        int barsPerNotch = (int)Math.ceil(10.0 / (double)barWidth);
        int totalWidth = (w += numBars / barsPerNotch) + 160;
        PrintWriter out = response.getWriter();
        out.print("<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \n\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<?xml-stylesheet type=\"text/css\" href=\"/static/hadoop.css\"?>\n\n<svg width=\"");
        out.print(totalWidth);
        out.print("\" height=\"");
        out.print(240);
        out.print("\" version=\"1.1\"\nxmlns=\"http://www.w3.org/2000/svg\">\n\n");
        this.printLine(out, 79, 79, 221, 19, "black");
        this.printLine(out, 79, w + 80 + 1, 221, 221, "black");
        this.printLine(out, w + 80 + 1, w + 80 + 1, 221, 19, "#CCCCCC");
        this.printLine(out, 79, w + 80 + 1, 19, 19, "#CCCCCC");
        String[] colors = new String[]{"#00DD00", "#E50000", "#AAAAFF"};
        int xNotchInterval = (int)Math.ceil((double)numTasks / 10.0);
        int xOffset = -1;
        int xNotchCount = 0;
        int i = 0;
        int barCnt = 0;
        while (true) {
            if (barCnt % barsPerNotch == 0) {
                ++xOffset;
            }
            int x = barCnt * barWidth + 80 + xOffset;
            if (i >= xNotchInterval * xNotchCount) {
                this.printLine(out, x, x, 223, 218, "black");
                this.printText(out, x, 235, String.valueOf(xNotchInterval * xNotchCount++), "middle");
            }
            if (i >= reports.length) break;
            if (isMap) {
                float progress = this.getMapAvarageProgress(tasksPerBar, i, reports);
                int barHeight = (int)Math.ceil(200.0f * progress);
                int y = 200 - barHeight + 20;
                this.printRect(out, barWidth, barHeight, x, y, colors[2]);
            } else {
                float[] progresses = this.getReduceAvarageProgresses(tasksPerBar, i, reports);
                int prevHeight = 0;
                for (int j = 0; j < 3; ++j) {
                    int barHeight = (int)(66.0f * progresses[j]);
                    if (barHeight > 63) {
                        barHeight = 67;
                    }
                    int y = 200 - barHeight + 20 - prevHeight;
                    prevHeight += barHeight;
                    this.printRect(out, barWidth, barHeight, x, y, colors[j]);
                }
            }
            i += tasksPerBar;
            ++barCnt;
        }
        for (i = 0; i <= 10; ++i) {
            this.printLine(out, 77, 82, 20 + i * 200 / 10, 20 + i * 200 / 10, "black");
            this.printText(out, 70, 24 + i * 200 / 10, String.valueOf(100 - i * 10), "end");
        }
        if (!isMap) {
            this.printRect(out, 14, 14, 80 + w + 4, 40, colors[0]);
            this.printText(out, 80 + w + 24, 50, "copy", "start");
            this.printRect(out, 14, 14, 80 + w + 4, 70, colors[1]);
            this.printText(out, 80 + w + 24, 80, "sort", "start");
            this.printRect(out, 14, 14, 80 + w + 4, 100, colors[2]);
            this.printText(out, 80 + w + 24, 110, "reduce", "start");
        }
        out.print("</svg>");
    }

    private float getMapAvarageProgress(int tasksPerBar, int index, TaskReport[] reports) {
        int k;
        float progress = 0.0f;
        for (k = 0; k < tasksPerBar && index + k < reports.length; ++k) {
            progress += reports[index + k].getProgress();
        }
        return progress /= (float)k;
    }

    private float[] getReduceAvarageProgresses(int tasksPerBar, int index, TaskReport[] reports) {
        int k;
        float[] progresses = new float[]{0.0f, 0.0f, 0.0f};
        for (k = 0; k < tasksPerBar && index + k < reports.length; ++k) {
            int j = 0;
            for (float progress = reports[index + k].getProgress(); progress > 0.0f; progress -= 0.33333334f) {
                if (progress > 0.33333334f) {
                    int n = j;
                    progresses[n] = progresses[n] + 1.0f;
                } else {
                    int n = j;
                    progresses[n] = progresses[n] + progress * 3.0f;
                }
                ++j;
            }
        }
        int j = 0;
        while (j < 3) {
            int n = j++;
            progresses[n] = progresses[n] / (float)k;
        }
        return progresses;
    }

    private void printRect(PrintWriter out, int width, int height, int x, int y, String color) throws IOException {
        if (height > 0) {
            out.print("<rect width=\"");
            out.print(width);
            out.print("\" height=\"");
            out.print(height);
            out.print("\" x=\"");
            out.print(x);
            out.print("\" y=\"");
            out.print(y);
            out.print("\" style=\"fill:");
            out.print(color);
            out.print("\"/>\n");
        }
    }

    private void printLine(PrintWriter out, int x1, int x2, int y1, int y2, String color) throws IOException {
        out.print("<line x1=\"");
        out.print(x1);
        out.print("\" x2=\"");
        out.print(x2);
        out.print("\" y1=\"");
        out.print(y1);
        out.print("\" y2=\"");
        out.print(y2);
        out.print("\" class=\"taskgraphline\" style=\"stroke:");
        out.print(color);
        out.print("\"/>\n");
    }

    private void printText(PrintWriter out, int x, int y, String text, String anchor) throws IOException {
        out.print("<text x=\"");
        out.print(String.valueOf(x));
        out.print("\" y=\"");
        out.print(String.valueOf(y));
        out.print("\" style=\"fill:black;font-family:sans-serif;text-anchor:");
        out.print(anchor);
        out.print("\">");
        out.print(text);
        out.print("</text>\n");
    }
}

