/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskTracker;

class MapTaskRunner
extends TaskRunner {
    public MapTaskRunner(TaskTracker.TaskInProgress task, TaskTracker tracker, JobConf conf, TaskTracker.RunningJob rjob) throws IOException {
        super(task, tracker, conf, rjob);
    }

    @Override
    public boolean prepare() throws IOException {
        if (!super.prepare()) {
            return false;
        }
        this.mapOutputFile.removeAll();
        return true;
    }

    @Override
    public void close() throws IOException {
        LOG.info(this.getTask() + " done; removing files.");
        this.mapOutputFile.removeAll();
    }

    @Override
    public String getChildJavaOpts(JobConf jobConf, String defaultValue) {
        String user = jobConf.get("mapred.map.child.java.opts", super.getChildJavaOpts(jobConf, "-Xmx200m"));
        String admin = jobConf.get("mapreduce.admin.map.child.java.opts", "-Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN ");
        return user + " " + admin;
    }

    @Override
    public int getChildUlimit(JobConf jobConf) {
        return jobConf.getInt("mapred.map.child.ulimit", super.getChildUlimit(jobConf));
    }

    @Override
    public String getChildEnv(JobConf jobConf) {
        return jobConf.get("mapred.map.child.env", super.getChildEnv(jobConf));
    }
}

