/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.util.Iterator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.OptionDescriber;

public class MaxCombiner
extends LongCombiner {
    @Override
    public Long typedReduce(Key key, Iterator<Long> iter) {
        long max = Long.MIN_VALUE;
        while (iter.hasNext()) {
            Long l = iter.next();
            if (l <= max) continue;
            max = l;
        }
        return max;
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.setName("max");
        io.setDescription("MaxCombiner interprets Values as Longs and finds their maximum.  A variety of encodings (variable length, fixed length, or string) are available");
        return io;
    }
}

