/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.impl;

import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.file.blockfile.impl.CacheProvider;
import org.apache.accumulo.core.file.blockfile.impl.OpportunisticBlockCache;
import org.apache.accumulo.core.logging.LoggingBlockCache;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.cache.CacheType;
import org.apache.accumulo.core.spi.scan.ScanDispatch;

public class ScanCacheProvider
implements CacheProvider {
    private final BlockCache indexCache;
    private final BlockCache dataCache;

    public ScanCacheProvider(AccumuloConfiguration tableConfig, ScanDispatch dispatch, BlockCache indexCache, BlockCache dataCache) {
        BlockCache loggingIndexCache = LoggingBlockCache.wrap(CacheType.INDEX, indexCache);
        BlockCache loggingDataCache = LoggingBlockCache.wrap(CacheType.DATA, dataCache);
        switch (dispatch.getIndexCacheUsage()) {
            case ENABLED: {
                this.indexCache = loggingIndexCache;
                break;
            }
            case DISABLED: {
                this.indexCache = null;
                break;
            }
            case OPPORTUNISTIC: {
                this.indexCache = new OpportunisticBlockCache(loggingIndexCache);
                break;
            }
            case TABLE: {
                this.indexCache = tableConfig.getBoolean(Property.TABLE_INDEXCACHE_ENABLED) ? loggingIndexCache : null;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (dispatch.getDataCacheUsage()) {
            case ENABLED: {
                this.dataCache = loggingDataCache;
                break;
            }
            case DISABLED: {
                this.dataCache = null;
                break;
            }
            case OPPORTUNISTIC: {
                this.dataCache = new OpportunisticBlockCache(loggingDataCache);
                break;
            }
            case TABLE: {
                this.dataCache = tableConfig.getBoolean(Property.TABLE_BLOCKCACHE_ENABLED) ? loggingDataCache : null;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public BlockCache getDataCache() {
        return this.dataCache;
    }

    @Override
    public BlockCache getIndexCache() {
        return this.indexCache;
    }
}

