/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.compaction;

import java.util.Map;
import org.apache.accumulo.core.compaction.NullType;
import org.apache.accumulo.core.compaction.PatternType;
import org.apache.accumulo.core.compaction.SizeType;
import org.apache.accumulo.core.compaction.StringType;
import org.apache.accumulo.core.compaction.Type;
import org.apache.accumulo.core.compaction.UIntType;

public enum CompactionSettings {
    SF_NO_SUMMARY(new NullType(), true),
    SF_EXTRA_SUMMARY(new NullType(), true),
    SF_NO_SAMPLE(new NullType(), true),
    SF_GT_ESIZE_OPT(new SizeType(), true),
    SF_LT_ESIZE_OPT(new SizeType(), true),
    SF_NAME_RE_OPT(new PatternType(), true),
    SF_PATH_RE_OPT(new PatternType(), true),
    MIN_FILES_OPT(new UIntType(), true),
    OUTPUT_COMPRESSION_OPT(new StringType(), false),
    OUTPUT_BLOCK_SIZE_OPT(new SizeType(), false),
    OUTPUT_HDFS_BLOCK_SIZE_OPT(new SizeType(), false),
    OUTPUT_INDEX_BLOCK_SIZE_OPT(new SizeType(), false),
    OUTPUT_REPLICATION_OPT(new UIntType(), false);

    private final Type type;
    private final boolean selectorOpt;

    private CompactionSettings(Type type, boolean selectorOpt) {
        this.type = type;
        this.selectorOpt = selectorOpt;
    }

    public void put(Map<String, String> selectorOpts, Map<String, String> configurerOpts, String val) {
        if (this.selectorOpt) {
            selectorOpts.put(this.name(), this.type.convert(val));
        } else {
            configurerOpts.put(this.name(), this.type.convert(val));
        }
    }
}

