/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoopImpl.mapreduce.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Scanner;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.mapreduce.lib.DistributedCacheHelper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;

public class ConfiguratorBase {
    protected static String enumToConfKey(Class<?> implementingClass, Enum<?> e) {
        return implementingClass.getSimpleName() + "." + e.getDeclaringClass().getSimpleName() + "." + StringUtils.camelize((String)e.name().toLowerCase());
    }

    protected static String enumToConfKey(Enum<?> e) {
        return e.getDeclaringClass().getSimpleName() + "." + StringUtils.camelize((String)e.name().toLowerCase());
    }

    private static String cachedClientPropsFileName(Class<?> implementingClass) {
        return implementingClass.getSimpleName() + ".propsfile";
    }

    public static void setClientProperties(Class<?> implementingClass, Configuration conf, Properties props, String clientPropsPath) {
        if (clientPropsPath != null) {
            DistributedCacheHelper.addCacheFile((String)clientPropsPath, (String)ConfiguratorBase.cachedClientPropsFileName(implementingClass), (Configuration)conf);
            conf.set(ConfiguratorBase.enumToConfKey(implementingClass, ClientOpts.CLIENT_PROPS_FILE), clientPropsPath);
        } else {
            StringWriter writer = new StringWriter();
            try {
                props.store(writer, "client properties");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            conf.set(ConfiguratorBase.enumToConfKey(implementingClass, ClientOpts.CLIENT_PROPS), writer.toString());
        }
        conf.setBoolean(ConfiguratorBase.enumToConfKey(implementingClass, ClientOpts.IS_CONFIGURED), true);
    }

    public static Properties getClientProperties(Class<?> implementingClass, Configuration conf) {
        String propString;
        String clientPropsFile = conf.get(ConfiguratorBase.enumToConfKey(implementingClass, ClientOpts.CLIENT_PROPS_FILE), "");
        if (clientPropsFile.isEmpty()) {
            propString = conf.get(ConfiguratorBase.enumToConfKey(implementingClass, ClientOpts.CLIENT_PROPS), "");
        } else {
            try (InputStream inputStream = DistributedCacheHelper.openCachedFile((String)clientPropsFile, (String)ConfiguratorBase.cachedClientPropsFileName(implementingClass), (Configuration)conf);){
                StringBuilder sb = new StringBuilder();
                try (Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8);){
                    while (scanner.hasNextLine()) {
                        sb.append(scanner.nextLine() + "\n");
                    }
                }
                propString = sb.toString();
            }
            catch (IOException e) {
                throw new IllegalStateException("Error closing client properties file stream", e);
            }
        }
        Properties props = new Properties();
        if (!propString.isEmpty()) {
            try {
                props.load(new StringReader(propString));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return props;
    }

    public static Boolean isClientConfigured(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(ConfiguratorBase.enumToConfKey(implementingClass, ClientOpts.IS_CONFIGURED), false);
    }

    public static AccumuloClient createClient(Class<?> implementingClass, Configuration conf) {
        return (AccumuloClient)Accumulo.newClient().from(ConfiguratorBase.getClientProperties(implementingClass, conf)).build();
    }

    public static void setVisibilityCacheSize(Configuration conf, int visibilityCacheSize) {
        conf.setInt(ConfiguratorBase.enumToConfKey(GeneralOpts.VISIBILITY_CACHE_SIZE), visibilityCacheSize);
    }

    public static int getVisibilityCacheSize(Configuration conf) {
        return conf.getInt(ConfiguratorBase.enumToConfKey(GeneralOpts.VISIBILITY_CACHE_SIZE), 1000);
    }

    public static void setJobStored(Class<?> implementingClass, Configuration conf) {
        conf.setBoolean(ConfiguratorBase.enumToConfKey(implementingClass, ClientOpts.STORE_JOB_CALLED), true);
    }

    public static void checkJobStored(Class<?> implementingClass, Configuration conf) {
        if (!conf.getBoolean(ConfiguratorBase.enumToConfKey(implementingClass, ClientOpts.STORE_JOB_CALLED), false)) {
            throw new IllegalStateException("Bad configuration: the store method was not called.");
        }
    }

    public static enum ClientOpts {
        CLIENT_PROPS,
        CLIENT_PROPS_FILE,
        IS_CONFIGURED,
        STORE_JOB_CALLED;

    }

    public static enum GeneralOpts {
        LOG_LEVEL,
        VISIBILITY_CACHE_SIZE;

    }
}

