/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.tserver.RunnableStartedAt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveAssignmentRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ActiveAssignmentRunnable.class);
    private final ConcurrentHashMap<KeyExtent, RunnableStartedAt> activeAssignments;
    private final KeyExtent extent;
    private final Runnable delegate;
    private volatile Thread executingThread;

    public ActiveAssignmentRunnable(ConcurrentHashMap<KeyExtent, RunnableStartedAt> activeAssignments, KeyExtent extent, Runnable delegate) {
        Objects.requireNonNull(activeAssignments);
        Objects.requireNonNull(extent);
        Objects.requireNonNull(delegate);
        this.activeAssignments = activeAssignments;
        this.extent = extent;
        this.delegate = delegate;
    }

    @Override
    public void run() {
        if (this.activeAssignments.containsKey(this.extent)) {
            throw new IllegalStateException("Active assignment already exists for " + String.valueOf(this.extent));
        }
        this.executingThread = Thread.currentThread();
        try {
            RunnableStartedAt runnableWithStartTime = new RunnableStartedAt(this, System.currentTimeMillis());
            log.trace("Started assignment for {} at {}", (Object)this.extent, (Object)runnableWithStartTime.getStartTime());
            this.activeAssignments.put(this.extent, runnableWithStartTime);
            this.delegate.run();
        }
        finally {
            if (log.isTraceEnabled()) {
                log.trace("Finished assignment for {} at {}", (Object)this.extent, (Object)System.currentTimeMillis());
            }
            this.activeAssignments.remove(this.extent);
        }
    }

    public Exception getException() {
        Exception e = new Exception("Assignment of " + String.valueOf(this.extent));
        if (this.executingThread != null) {
            e.setStackTrace(this.executingThread.getStackTrace());
        }
        return e;
    }
}

