/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;

public final class PropUtil {
    private PropUtil() {
    }

    public static void setProperties(ServerContext context, PropStoreKey<?> propStoreKey, Map<String, String> properties) throws IllegalArgumentException {
        PropUtil.validateProperties(context, propStoreKey, properties);
        context.getPropStore().putAll(propStoreKey, properties);
    }

    public static void removeProperties(ServerContext context, PropStoreKey<?> propStoreKey, Collection<String> propertyNames) {
        context.getPropStore().removeProperties(propStoreKey, propertyNames);
    }

    public static void replaceProperties(ServerContext context, PropStoreKey<?> propStoreKey, long version, Map<String, String> properties) throws IllegalArgumentException {
        PropUtil.validateProperties(context, propStoreKey, properties);
        context.getPropStore().replaceAll(propStoreKey, version, properties);
    }

    protected static void validateProperties(ServerContext context, PropStoreKey<?> propStoreKey, Map<String, String> properties) throws IllegalArgumentException {
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            if (!Property.isValidProperty((String)prop.getKey(), (String)prop.getValue())) {
                String exceptionMessage = "Invalid property for : ";
                if (!Property.isValidTablePropertyKey((String)prop.getKey())) {
                    exceptionMessage = "Invalid Table property for : ";
                }
                throw new IllegalArgumentException(exceptionMessage + String.valueOf(propStoreKey) + " name: " + prop.getKey() + ", value: " + prop.getValue());
            }
            if (prop.getKey().equals(Property.TABLE_CLASSLOADER_CONTEXT.getKey()) && !Property.TABLE_CLASSLOADER_CONTEXT.getDefaultValue().equals(prop.getValue())) {
                ClassLoaderUtil.initContextFactory((AccumuloConfiguration)context.getConfiguration());
                if (!ClassLoaderUtil.isValidContext((String)prop.getValue())) {
                    throw new IllegalArgumentException("Unable to resolve classloader for context: " + prop.getValue());
                }
            }
            if (!prop.getKey().equals(Property.TABLE_ERASURE_CODE_POLICY.getKey())) continue;
            Collection<Volume> volumes = context.getVolumeManager().getVolumes();
            for (Volume volume : volumes) {
                if (!(volume.getFileSystem() instanceof DistributedFileSystem)) continue;
                Collection allPolicies = null;
                try {
                    allPolicies = ((DistributedFileSystem)volume.getFileSystem()).getAllErasureCodingPolicies();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to check EC policy", e);
                }
                if (!allPolicies.stream().filter(ErasureCodingPolicyInfo::isEnabled).map(pi -> pi.getPolicy().getName()).noneMatch(policy -> policy.equals(prop.getValue()))) continue;
                throw new IllegalArgumentException("EC policy " + prop.getKey() + " is not enabled in HDFS for volume " + String.valueOf(volume.getFileSystem().getUri()) + volume.getBasePath());
            }
        }
    }
}

