/*-
 * Copyright (c) 2017 Andrew Turner
 * All rights reserved.
 *
 * This software was developed by SRI International and the University of
 * Cambridge Computer Laboratory under DARPA/AFRL contract FA8750-10-C-0237
 * ("CTSRD"), as part of the DARPA CRASH research programme.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifdef __arm__
#include <arm/efi.h>
#else /* !__arm__ */

#ifndef __ARM64_INCLUDE_EFI_H_
#define __ARM64_INCLUDE_EFI_H_

#define	EFIABI_ATTR

#ifdef _KERNEL
#define ARCH_MAY_USE_EFI

#define	EFI_TIME_LOCK()
#define	EFI_TIME_UNLOCK()
#define	EFI_TIME_OWNED()

#define	EFI_RT_HANDLE_FAULTS_DEFAULT	0
#endif

struct efirt_callinfo {
	const char	*ec_name;
	register_t	ec_efi_status;
	register_t	ec_fptr;
	register_t	ec_argcnt;
	register_t	ec_arg1;
	register_t	ec_arg2;
	register_t	ec_arg3;
	register_t	ec_arg4;
	register_t	ec_arg5;
};

#endif /* __ARM64_INCLUDE_EFI_H_ */

#endif /* !__arm__ */
