/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or https://opensource.org/licenses/CDDL-1.0.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright (C) 2019 Romain Dolbeau. All rights reserved.
 *           <romain.dolbeau@european-processor-initiative.eu>
 */

#include <sys/isa_defs.h>
#include <sys/types.h>

#if defined(__powerpc__)
#pragma GCC target("altivec")

#include "vdev_raidz_math_powerpc_altivec_common.h"

#define	SYN_STRIDE		4

#define	ZERO_STRIDE		4
#define	ZERO_DEFINE()	\
	GEN_X_DEFINE_0_3() \
	GEN_X_DEFINE_33_36()
#define	ZERO_D			0, 1, 2, 3

#define	COPY_STRIDE		4
#define	COPY_DEFINE()	\
	GEN_X_DEFINE_0_3() \
	GEN_X_DEFINE_33_36()
#define	COPY_D			0, 1, 2, 3

#define	ADD_STRIDE		4
#define	ADD_DEFINE()	\
	GEN_X_DEFINE_0_3() \
	GEN_X_DEFINE_33_36()
#define	ADD_D			0, 1, 2, 3

#define	MUL_STRIDE		4
#define	MUL_DEFINE()	\
	GEN_X_DEFINE_0_3() \
	GEN_X_DEFINE_33_36()
#define	MUL_D			0, 1, 2, 3

#define	GEN_P_DEFINE() \
	GEN_X_DEFINE_0_3() \
	GEN_X_DEFINE_33_36()
#define	GEN_P_STRIDE		4
#define	GEN_P_P			0, 1, 2, 3

#define	GEN_PQ_DEFINE()	\
	GEN_X_DEFINE_0_3()	\
	GEN_X_DEFINE_4_5()	\
	GEN_X_DEFINE_6_7()	\
	GEN_X_DEFINE_16()	\
	GEN_X_DEFINE_17()	\
	GEN_X_DEFINE_33_36()
#define	GEN_PQ_STRIDE		4
#define	GEN_PQ_D		0, 1, 2, 3
#define	GEN_PQ_C		4, 5, 6, 7

#define	GEN_PQR_DEFINE() \
	GEN_X_DEFINE_0_3()	\
	GEN_X_DEFINE_4_5()	\
	GEN_X_DEFINE_6_7()	\
	GEN_X_DEFINE_16()	\
	GEN_X_DEFINE_17()	\
	GEN_X_DEFINE_33_36()
#define	GEN_PQR_STRIDE		4
#define	GEN_PQR_D		0, 1, 2, 3
#define	GEN_PQR_C		4, 5, 6, 7

#define	SYN_Q_DEFINE() \
	GEN_X_DEFINE_0_3()	\
	GEN_X_DEFINE_4_5()	\
	GEN_X_DEFINE_6_7()	\
	GEN_X_DEFINE_16()	\
	GEN_X_DEFINE_17()	\
	GEN_X_DEFINE_33_36()
#define	SYN_Q_STRIDE		4
#define	SYN_Q_D			0, 1, 2, 3
#define	SYN_Q_X			4, 5, 6, 7

#define	SYN_R_DEFINE() \
	GEN_X_DEFINE_0_3()	\
	GEN_X_DEFINE_4_5()	\
	GEN_X_DEFINE_6_7()	\
	GEN_X_DEFINE_16()	\
	GEN_X_DEFINE_17()	\
	GEN_X_DEFINE_33_36()
#define	SYN_R_STRIDE		4
#define	SYN_R_D			0, 1, 2, 3
#define	SYN_R_X			4, 5, 6, 7

#define	SYN_PQ_DEFINE() \
	GEN_X_DEFINE_0_3()	\
	GEN_X_DEFINE_4_5()	\
	GEN_X_DEFINE_6_7()	\
	GEN_X_DEFINE_16()	\
	GEN_X_DEFINE_17()	\
	GEN_X_DEFINE_33_36()
#define	SYN_PQ_STRIDE		4
#define	SYN_PQ_D		0, 1, 2, 3
#define	SYN_PQ_X		4, 5, 6, 7

#define	REC_PQ_DEFINE() \
	GEN_X_DEFINE_0_3()	\
	GEN_X_DEFINE_4_5()	\
	GEN_X_DEFINE_31()	\
	GEN_X_DEFINE_32()	\
	GEN_X_DEFINE_33_36()
#define	REC_PQ_STRIDE		2
#define	REC_PQ_X		0, 1
#define	REC_PQ_Y		2, 3
#define	REC_PQ_T		4, 5

#define	SYN_PR_DEFINE() \
	GEN_X_DEFINE_0_3()	\
	GEN_X_DEFINE_4_5()	\
	GEN_X_DEFINE_6_7()	\
	GEN_X_DEFINE_16()	\
	GEN_X_DEFINE_17()	\
	GEN_X_DEFINE_33_36()
#define	SYN_PR_STRIDE		4
#define	SYN_PR_D		0, 1, 2, 3
#define	SYN_PR_X		4, 5, 6, 7

#define	REC_PR_DEFINE()	\
	GEN_X_DEFINE_0_3()	\
	GEN_X_DEFINE_4_5()	\
	GEN_X_DEFINE_31()	\
	GEN_X_DEFINE_32()	\
	GEN_X_DEFINE_33_36()
#define	REC_PR_STRIDE		2
#define	REC_PR_X		0, 1
#define	REC_PR_Y		2, 3
#define	REC_PR_T		4, 5

#define	SYN_QR_DEFINE() \
	GEN_X_DEFINE_0_3()	\
	GEN_X_DEFINE_4_5()	\
	GEN_X_DEFINE_6_7()	\
	GEN_X_DEFINE_16()	\
	GEN_X_DEFINE_17()	\
	GEN_X_DEFINE_33_36()
#define	SYN_QR_STRIDE		4
#define	SYN_QR_D		0, 1, 2, 3
#define	SYN_QR_X		4, 5, 6, 7

#define	REC_QR_DEFINE()	\
	GEN_X_DEFINE_0_3()	\
	GEN_X_DEFINE_4_5()	\
	GEN_X_DEFINE_31()	\
	GEN_X_DEFINE_32()	\
	GEN_X_DEFINE_33_36()
#define	REC_QR_STRIDE		2
#define	REC_QR_X		0, 1
#define	REC_QR_Y		2, 3
#define	REC_QR_T		4, 5

#define	SYN_PQR_DEFINE() \
	GEN_X_DEFINE_0_3()	\
	GEN_X_DEFINE_4_5()	\
	GEN_X_DEFINE_6_7()	\
	GEN_X_DEFINE_16()	\
	GEN_X_DEFINE_17()	\
	GEN_X_DEFINE_33_36()
#define	SYN_PQR_STRIDE		 4
#define	SYN_PQR_D		 0, 1, 2, 3
#define	SYN_PQR_X		 4, 5, 6, 7

#define	REC_PQR_DEFINE() \
	GEN_X_DEFINE_0_3()	\
	GEN_X_DEFINE_4_5()	\
	GEN_X_DEFINE_6_7()	\
	GEN_X_DEFINE_8_9()	\
	GEN_X_DEFINE_31()	\
	GEN_X_DEFINE_32()	\
	GEN_X_DEFINE_33_36()
#define	REC_PQR_STRIDE		2
#define	REC_PQR_X		0, 1
#define	REC_PQR_Y		2, 3
#define	REC_PQR_Z		4, 5
#define	REC_PQR_XS		6, 7
#define	REC_PQR_YS		8, 9


#include <sys/vdev_raidz_impl.h>
#include "vdev_raidz_math_impl.h"

DEFINE_GEN_METHODS(powerpc_altivec);
DEFINE_REC_METHODS(powerpc_altivec);

static boolean_t
raidz_will_powerpc_altivec_work(void)
{
	return (kfpu_allowed()) && zfs_altivec_available();
}

const raidz_impl_ops_t vdev_raidz_powerpc_altivec_impl = {
	.init = NULL,
	.fini = NULL,
	.gen = RAIDZ_GEN_METHODS(powerpc_altivec),
	.rec = RAIDZ_REC_METHODS(powerpc_altivec),
	.is_supported = &raidz_will_powerpc_altivec_work,
	.name = "powerpc_altivec"
};

#endif /* defined(__powerpc__) */


#if defined(__powerpc__)
#if defined(_ZFS_LITTLE_ENDIAN) && _LITTLE_ENDIAN
/* BEGIN CSTYLED */
const uint8_t
__attribute__((aligned(256))) gf_clmul_mod_lt[4*256][16] = {
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x0f, 0x0e, 0x0d, 0x0c, 0x0b, 0x0a, 0x09, 0x08,
		0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x1e, 0x1c, 0x1a, 0x18, 0x16, 0x14, 0x12, 0x10,
		0x0e, 0x0c, 0x0a, 0x08, 0x06, 0x04, 0x02, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x11, 0x12, 0x17, 0x14, 0x1d, 0x1e, 0x1b, 0x18,
		0x09, 0x0a, 0x0f, 0x0c, 0x05, 0x06, 0x03, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x3c, 0x38, 0x34, 0x30, 0x2c, 0x28, 0x24, 0x20,
		0x1c, 0x18, 0x14, 0x10, 0x0c, 0x08, 0x04, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x33, 0x36, 0x39, 0x3c, 0x27, 0x22, 0x2d, 0x28,
		0x1b, 0x1e, 0x11, 0x14, 0x0f, 0x0a, 0x05, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x22, 0x24, 0x2e, 0x28, 0x3a, 0x3c, 0x36, 0x30,
		0x12, 0x14, 0x1e, 0x18, 0x0a, 0x0c, 0x06, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x2d, 0x2a, 0x23, 0x24, 0x31, 0x36, 0x3f, 0x38,
		0x15, 0x12, 0x1b, 0x1c, 0x09, 0x0e, 0x07, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x78, 0x70, 0x68, 0x60, 0x58, 0x50, 0x48, 0x40,
		0x38, 0x30, 0x28, 0x20, 0x18, 0x10, 0x08, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x77, 0x7e, 0x65, 0x6c, 0x53, 0x5a, 0x41, 0x48,
		0x3f, 0x36, 0x2d, 0x24, 0x1b, 0x12, 0x09, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x66, 0x6c, 0x72, 0x78, 0x4e, 0x44, 0x5a, 0x50,
		0x36, 0x3c, 0x22, 0x28, 0x1e, 0x14, 0x0a, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x69, 0x62, 0x7f, 0x74, 0x45, 0x4e, 0x53, 0x58,
		0x31, 0x3a, 0x27, 0x2c, 0x1d, 0x16, 0x0b, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x44, 0x48, 0x5c, 0x50, 0x74, 0x78, 0x6c, 0x60,
		0x24, 0x28, 0x3c, 0x30, 0x14, 0x18, 0x0c, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x4b, 0x46, 0x51, 0x5c, 0x7f, 0x72, 0x65, 0x68,
		0x23, 0x2e, 0x39, 0x34, 0x17, 0x1a, 0x0d, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x5a, 0x54, 0x46, 0x48, 0x62, 0x6c, 0x7e, 0x70,
		0x2a, 0x24, 0x36, 0x38, 0x12, 0x1c, 0x0e, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x55, 0x5a, 0x4b, 0x44, 0x69, 0x66, 0x77, 0x78,
		0x2d, 0x22, 0x33, 0x3c, 0x11, 0x1e, 0x0f, 0x00  },
	{	0xbb, 0xa6, 0x81, 0x9c, 0xcf, 0xd2, 0xf5, 0xe8,
		0x53, 0x4e, 0x69, 0x74, 0x27, 0x3a, 0x1d, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0xbb, 0xa6, 0x81, 0x9c, 0xcf, 0xd2, 0xf5, 0xe8,
		0x53, 0x4e, 0x69, 0x74, 0x27, 0x3a, 0x1d, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xff, 0xee, 0xdd, 0xcc, 0xbb, 0xaa, 0x99, 0x88,
		0x77, 0x66, 0x55, 0x44, 0x33, 0x22, 0x11, 0x00  },
	{	0xa6, 0xbb, 0x9c, 0x81, 0xd2, 0xcf, 0xe8, 0xf5,
		0x53, 0x4e, 0x69, 0x74, 0x27, 0x3a, 0x1d, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xee, 0xfc, 0xca, 0xd8, 0xa6, 0xb4, 0x82, 0x90,
		0x7e, 0x6c, 0x5a, 0x48, 0x36, 0x24, 0x12, 0x00  },
	{	0xa6, 0xbb, 0x9c, 0x81, 0xd2, 0xcf, 0xe8, 0xf5,
		0x53, 0x4e, 0x69, 0x74, 0x27, 0x3a, 0x1d, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xe1, 0xf2, 0xc7, 0xd4, 0xad, 0xbe, 0x8b, 0x98,
		0x79, 0x6a, 0x5f, 0x4c, 0x35, 0x26, 0x13, 0x00  },
	{	0x9c, 0x81, 0xa6, 0xbb, 0xf5, 0xe8, 0xcf, 0xd2,
		0x4e, 0x53, 0x74, 0x69, 0x27, 0x3a, 0x1d, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xcc, 0xd8, 0xe4, 0xf0, 0x9c, 0x88, 0xb4, 0xa0,
		0x6c, 0x78, 0x44, 0x50, 0x3c, 0x28, 0x14, 0x00  },
	{	0x9c, 0x81, 0xa6, 0xbb, 0xf5, 0xe8, 0xcf, 0xd2,
		0x4e, 0x53, 0x74, 0x69, 0x27, 0x3a, 0x1d, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xc3, 0xd6, 0xe9, 0xfc, 0x97, 0x82, 0xbd, 0xa8,
		0x6b, 0x7e, 0x41, 0x54, 0x3f, 0x2a, 0x15, 0x00  },
	{	0x81, 0x9c, 0xbb, 0xa6, 0xe8, 0xf5, 0xd2, 0xcf,
		0x4e, 0x53, 0x74, 0x69, 0x27, 0x3a, 0x1d, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xd2, 0xc4, 0xfe, 0xe8, 0x8a, 0x9c, 0xa6, 0xb0,
		0x62, 0x74, 0x4e, 0x58, 0x3a, 0x2c, 0x16, 0x00  },
	{	0x81, 0x9c, 0xbb, 0xa6, 0xe8, 0xf5, 0xd2, 0xcf,
		0x4e, 0x53, 0x74, 0x69, 0x27, 0x3a, 0x1d, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xdd, 0xca, 0xf3, 0xe4, 0x81, 0x96, 0xaf, 0xb8,
		0x65, 0x72, 0x4b, 0x5c, 0x39, 0x2e, 0x17, 0x00  },
	{	0xe8, 0xf5, 0xcf, 0xd2, 0xa6, 0xbb, 0x81, 0x9c,
		0x74, 0x69, 0x53, 0x4e, 0x3a, 0x27, 0x1d, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x88, 0x90, 0xb8, 0xa0, 0xe8, 0xf0, 0xd8, 0xc0,
		0x48, 0x50, 0x78, 0x60, 0x28, 0x30, 0x18, 0x00  },
	{	0xe8, 0xf5, 0xcf, 0xd2, 0xa6, 0xbb, 0x81, 0x9c,
		0x74, 0x69, 0x53, 0x4e, 0x3a, 0x27, 0x1d, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x87, 0x9e, 0xb5, 0xac, 0xe3, 0xfa, 0xd1, 0xc8,
		0x4f, 0x56, 0x7d, 0x64, 0x2b, 0x32, 0x19, 0x00  },
	{	0xf5, 0xe8, 0xd2, 0xcf, 0xbb, 0xa6, 0x9c, 0x81,
		0x74, 0x69, 0x53, 0x4e, 0x3a, 0x27, 0x1d, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x96, 0x8c, 0xa2, 0xb8, 0xfe, 0xe4, 0xca, 0xd0,
		0x46, 0x5c, 0x72, 0x68, 0x2e, 0x34, 0x1a, 0x00  },
	{	0xf5, 0xe8, 0xd2, 0xcf, 0xbb, 0xa6, 0x9c, 0x81,
		0x74, 0x69, 0x53, 0x4e, 0x3a, 0x27, 0x1d, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x99, 0x82, 0xaf, 0xb4, 0xf5, 0xee, 0xc3, 0xd8,
		0x41, 0x5a, 0x77, 0x6c, 0x2d, 0x36, 0x1b, 0x00  },
	{	0xcf, 0xd2, 0xe8, 0xf5, 0x9c, 0x81, 0xbb, 0xa6,
		0x69, 0x74, 0x4e, 0x53, 0x3a, 0x27, 0x1d, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xb4, 0xa8, 0x8c, 0x90, 0xc4, 0xd8, 0xfc, 0xe0,
		0x54, 0x48, 0x6c, 0x70, 0x24, 0x38, 0x1c, 0x00  },
	{	0xcf, 0xd2, 0xe8, 0xf5, 0x9c, 0x81, 0xbb, 0xa6,
		0x69, 0x74, 0x4e, 0x53, 0x3a, 0x27, 0x1d, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xbb, 0xa6, 0x81, 0x9c, 0xcf, 0xd2, 0xf5, 0xe8,
		0x53, 0x4e, 0x69, 0x74, 0x27, 0x3a, 0x1d, 0x00  },
	{	0xd2, 0xcf, 0xf5, 0xe8, 0x81, 0x9c, 0xa6, 0xbb,
		0x69, 0x74, 0x4e, 0x53, 0x3a, 0x27, 0x1d, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xaa, 0xb4, 0x96, 0x88, 0xd2, 0xcc, 0xee, 0xf0,
		0x5a, 0x44, 0x66, 0x78, 0x22, 0x3c, 0x1e, 0x00  },
	{	0xd2, 0xcf, 0xf5, 0xe8, 0x81, 0x9c, 0xa6, 0xbb,
		0x69, 0x74, 0x4e, 0x53, 0x3a, 0x27, 0x1d, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xa5, 0xba, 0x9b, 0x84, 0xd9, 0xc6, 0xe7, 0xf8,
		0x5d, 0x42, 0x63, 0x7c, 0x21, 0x3e, 0x1f, 0x00  },
	{	0x6b, 0x51, 0x1f, 0x25, 0x83, 0xb9, 0xf7, 0xcd,
		0xa6, 0x9c, 0xd2, 0xe8, 0x4e, 0x74, 0x3a, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x6b, 0x51, 0x1f, 0x25, 0x83, 0xb9, 0xf7, 0xcd,
		0xa6, 0x9c, 0xd2, 0xe8, 0x4e, 0x74, 0x3a, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xef, 0xce, 0xad, 0x8c, 0x6b, 0x4a, 0x29, 0x08,
		0xe7, 0xc6, 0xa5, 0x84, 0x63, 0x42, 0x21, 0x00  },
	{	0x76, 0x4c, 0x02, 0x38, 0x9e, 0xa4, 0xea, 0xd0,
		0xa6, 0x9c, 0xd2, 0xe8, 0x4e, 0x74, 0x3a, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xfe, 0xdc, 0xba, 0x98, 0x76, 0x54, 0x32, 0x10,
		0xee, 0xcc, 0xaa, 0x88, 0x66, 0x44, 0x22, 0x00  },
	{	0x76, 0x4c, 0x02, 0x38, 0x9e, 0xa4, 0xea, 0xd0,
		0xa6, 0x9c, 0xd2, 0xe8, 0x4e, 0x74, 0x3a, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xf1, 0xd2, 0xb7, 0x94, 0x7d, 0x5e, 0x3b, 0x18,
		0xe9, 0xca, 0xaf, 0x8c, 0x65, 0x46, 0x23, 0x00  },
	{	0x4c, 0x76, 0x38, 0x02, 0xb9, 0x83, 0xcd, 0xf7,
		0xbb, 0x81, 0xcf, 0xf5, 0x4e, 0x74, 0x3a, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xdc, 0xf8, 0x94, 0xb0, 0x4c, 0x68, 0x04, 0x20,
		0xfc, 0xd8, 0xb4, 0x90, 0x6c, 0x48, 0x24, 0x00  },
	{	0x4c, 0x76, 0x38, 0x02, 0xb9, 0x83, 0xcd, 0xf7,
		0xbb, 0x81, 0xcf, 0xf5, 0x4e, 0x74, 0x3a, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xd3, 0xf6, 0x99, 0xbc, 0x47, 0x62, 0x0d, 0x28,
		0xfb, 0xde, 0xb1, 0x94, 0x6f, 0x4a, 0x25, 0x00  },
	{	0x51, 0x6b, 0x25, 0x1f, 0xa4, 0x9e, 0xd0, 0xea,
		0xbb, 0x81, 0xcf, 0xf5, 0x4e, 0x74, 0x3a, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xc2, 0xe4, 0x8e, 0xa8, 0x5a, 0x7c, 0x16, 0x30,
		0xf2, 0xd4, 0xbe, 0x98, 0x6a, 0x4c, 0x26, 0x00  },
	{	0x51, 0x6b, 0x25, 0x1f, 0xa4, 0x9e, 0xd0, 0xea,
		0xbb, 0x81, 0xcf, 0xf5, 0x4e, 0x74, 0x3a, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xcd, 0xea, 0x83, 0xa4, 0x51, 0x76, 0x1f, 0x38,
		0xf5, 0xd2, 0xbb, 0x9c, 0x69, 0x4e, 0x27, 0x00  },
	{	0x38, 0x02, 0x51, 0x6b, 0xea, 0xd0, 0x83, 0xb9,
		0x81, 0xbb, 0xe8, 0xd2, 0x53, 0x69, 0x3a, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x98, 0xb0, 0xc8, 0xe0, 0x38, 0x10, 0x68, 0x40,
		0xd8, 0xf0, 0x88, 0xa0, 0x78, 0x50, 0x28, 0x00  },
	{	0x38, 0x02, 0x51, 0x6b, 0xea, 0xd0, 0x83, 0xb9,
		0x81, 0xbb, 0xe8, 0xd2, 0x53, 0x69, 0x3a, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x97, 0xbe, 0xc5, 0xec, 0x33, 0x1a, 0x61, 0x48,
		0xdf, 0xf6, 0x8d, 0xa4, 0x7b, 0x52, 0x29, 0x00  },
	{	0x25, 0x1f, 0x4c, 0x76, 0xf7, 0xcd, 0x9e, 0xa4,
		0x81, 0xbb, 0xe8, 0xd2, 0x53, 0x69, 0x3a, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x86, 0xac, 0xd2, 0xf8, 0x2e, 0x04, 0x7a, 0x50,
		0xd6, 0xfc, 0x82, 0xa8, 0x7e, 0x54, 0x2a, 0x00  },
	{	0x25, 0x1f, 0x4c, 0x76, 0xf7, 0xcd, 0x9e, 0xa4,
		0x81, 0xbb, 0xe8, 0xd2, 0x53, 0x69, 0x3a, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x89, 0xa2, 0xdf, 0xf4, 0x25, 0x0e, 0x73, 0x58,
		0xd1, 0xfa, 0x87, 0xac, 0x7d, 0x56, 0x2b, 0x00  },
	{	0x1f, 0x25, 0x76, 0x4c, 0xd0, 0xea, 0xb9, 0x83,
		0x9c, 0xa6, 0xf5, 0xcf, 0x53, 0x69, 0x3a, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xa4, 0x88, 0xfc, 0xd0, 0x14, 0x38, 0x4c, 0x60,
		0xc4, 0xe8, 0x9c, 0xb0, 0x74, 0x58, 0x2c, 0x00  },
	{	0x1f, 0x25, 0x76, 0x4c, 0xd0, 0xea, 0xb9, 0x83,
		0x9c, 0xa6, 0xf5, 0xcf, 0x53, 0x69, 0x3a, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xab, 0x86, 0xf1, 0xdc, 0x1f, 0x32, 0x45, 0x68,
		0xc3, 0xee, 0x99, 0xb4, 0x77, 0x5a, 0x2d, 0x00  },
	{	0x02, 0x38, 0x6b, 0x51, 0xcd, 0xf7, 0xa4, 0x9e,
		0x9c, 0xa6, 0xf5, 0xcf, 0x53, 0x69, 0x3a, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xba, 0x94, 0xe6, 0xc8, 0x02, 0x2c, 0x5e, 0x70,
		0xca, 0xe4, 0x96, 0xb8, 0x72, 0x5c, 0x2e, 0x00  },
	{	0x02, 0x38, 0x6b, 0x51, 0xcd, 0xf7, 0xa4, 0x9e,
		0x9c, 0xa6, 0xf5, 0xcf, 0x53, 0x69, 0x3a, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0xb5, 0x9a, 0xeb, 0xc4, 0x09, 0x26, 0x57, 0x78,
		0xcd, 0xe2, 0x93, 0xbc, 0x71, 0x5e, 0x2f, 0x00  },
	{	0xd0, 0xf7, 0x9e, 0xb9, 0x4c, 0x6b, 0x02, 0x25,
		0xf5, 0xd2, 0xbb, 0x9c, 0x69, 0x4e, 0x27, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0xd0, 0xf7, 0x9e, 0xb9, 0x4c, 0x6b, 0x02, 0x25,
		0xf5, 0xd2, 0xbb, 0x9c, 0x69, 0x4e, 0x27, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x1f, 0x2e, 0x7d, 0x4c, 0xdb, 0xea, 0xb9, 0x88,
		0x97, 0xa6, 0xf5, 0xc4, 0x53, 0x62, 0x31, 0x00  },
	{	0xcd, 0xea, 0x83, 0xa4, 0x51, 0x76, 0x1f, 0x38,
		0xf5, 0xd2, 0xbb, 0x9c, 0x69, 0x4e, 0x27, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x0e, 0x3c, 0x6a, 0x58, 0xc6, 0xf4, 0xa2, 0x90,
		0x9e, 0xac, 0xfa, 0xc8, 0x56, 0x64, 0x32, 0x00  },
	{	0xcd, 0xea, 0x83, 0xa4, 0x51, 0x76, 0x1f, 0x38,
		0xf5, 0xd2, 0xbb, 0x9c, 0x69, 0x4e, 0x27, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x01, 0x32, 0x67, 0x54, 0xcd, 0xfe, 0xab, 0x98,
		0x99, 0xaa, 0xff, 0xcc, 0x55, 0x66, 0x33, 0x00  },
	{	0xf7, 0xd0, 0xb9, 0x9e, 0x76, 0x51, 0x38, 0x1f,
		0xe8, 0xcf, 0xa6, 0x81, 0x69, 0x4e, 0x27, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x2c, 0x18, 0x44, 0x70, 0xfc, 0xc8, 0x94, 0xa0,
		0x8c, 0xb8, 0xe4, 0xd0, 0x5c, 0x68, 0x34, 0x00  },
	{	0xf7, 0xd0, 0xb9, 0x9e, 0x76, 0x51, 0x38, 0x1f,
		0xe8, 0xcf, 0xa6, 0x81, 0x69, 0x4e, 0x27, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x23, 0x16, 0x49, 0x7c, 0xf7, 0xc2, 0x9d, 0xa8,
		0x8b, 0xbe, 0xe1, 0xd4, 0x5f, 0x6a, 0x35, 0x00  },
	{	0xea, 0xcd, 0xa4, 0x83, 0x6b, 0x4c, 0x25, 0x02,
		0xe8, 0xcf, 0xa6, 0x81, 0x69, 0x4e, 0x27, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x32, 0x04, 0x5e, 0x68, 0xea, 0xdc, 0x86, 0xb0,
		0x82, 0xb4, 0xee, 0xd8, 0x5a, 0x6c, 0x36, 0x00  },
	{	0xea, 0xcd, 0xa4, 0x83, 0x6b, 0x4c, 0x25, 0x02,
		0xe8, 0xcf, 0xa6, 0x81, 0x69, 0x4e, 0x27, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x3d, 0x0a, 0x53, 0x64, 0xe1, 0xd6, 0x8f, 0xb8,
		0x85, 0xb2, 0xeb, 0xdc, 0x59, 0x6e, 0x37, 0x00  },
	{	0x83, 0xa4, 0xd0, 0xf7, 0x25, 0x02, 0x76, 0x51,
		0xd2, 0xf5, 0x81, 0xa6, 0x74, 0x53, 0x27, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x68, 0x50, 0x18, 0x20, 0x88, 0xb0, 0xf8, 0xc0,
		0xa8, 0x90, 0xd8, 0xe0, 0x48, 0x70, 0x38, 0x00  },
	{	0x83, 0xa4, 0xd0, 0xf7, 0x25, 0x02, 0x76, 0x51,
		0xd2, 0xf5, 0x81, 0xa6, 0x74, 0x53, 0x27, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x67, 0x5e, 0x15, 0x2c, 0x83, 0xba, 0xf1, 0xc8,
		0xaf, 0x96, 0xdd, 0xe4, 0x4b, 0x72, 0x39, 0x00  },
	{	0x9e, 0xb9, 0xcd, 0xea, 0x38, 0x1f, 0x6b, 0x4c,
		0xd2, 0xf5, 0x81, 0xa6, 0x74, 0x53, 0x27, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x76, 0x4c, 0x02, 0x38, 0x9e, 0xa4, 0xea, 0xd0,
		0xa6, 0x9c, 0xd2, 0xe8, 0x4e, 0x74, 0x3a, 0x00  },
	{	0x9e, 0xb9, 0xcd, 0xea, 0x38, 0x1f, 0x6b, 0x4c,
		0xd2, 0xf5, 0x81, 0xa6, 0x74, 0x53, 0x27, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x79, 0x42, 0x0f, 0x34, 0x95, 0xae, 0xe3, 0xd8,
		0xa1, 0x9a, 0xd7, 0xec, 0x4d, 0x76, 0x3b, 0x00  },
	{	0xa4, 0x83, 0xf7, 0xd0, 0x1f, 0x38, 0x4c, 0x6b,
		0xcf, 0xe8, 0x9c, 0xbb, 0x74, 0x53, 0x27, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x54, 0x68, 0x2c, 0x10, 0xa4, 0x98, 0xdc, 0xe0,
		0xb4, 0x88, 0xcc, 0xf0, 0x44, 0x78, 0x3c, 0x00  },
	{	0xa4, 0x83, 0xf7, 0xd0, 0x1f, 0x38, 0x4c, 0x6b,
		0xcf, 0xe8, 0x9c, 0xbb, 0x74, 0x53, 0x27, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x5b, 0x66, 0x21, 0x1c, 0xaf, 0x92, 0xd5, 0xe8,
		0xb3, 0x8e, 0xc9, 0xf4, 0x47, 0x7a, 0x3d, 0x00  },
	{	0xb9, 0x9e, 0xea, 0xcd, 0x02, 0x25, 0x51, 0x76,
		0xcf, 0xe8, 0x9c, 0xbb, 0x74, 0x53, 0x27, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x4a, 0x74, 0x36, 0x08, 0xb2, 0x8c, 0xce, 0xf0,
		0xba, 0x84, 0xc6, 0xf8, 0x42, 0x7c, 0x3e, 0x00  },
	{	0xb9, 0x9e, 0xea, 0xcd, 0x02, 0x25, 0x51, 0x76,
		0xcf, 0xe8, 0x9c, 0xbb, 0x74, 0x53, 0x27, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x45, 0x7a, 0x3b, 0x04, 0xb9, 0x86, 0xc7, 0xf8,
		0xbd, 0x82, 0xc3, 0xfc, 0x41, 0x7e, 0x3f, 0x00  },
	{	0xd6, 0xa2, 0x3e, 0x4a, 0x1b, 0x6f, 0xf3, 0x87,
		0x51, 0x25, 0xb9, 0xcd, 0x9c, 0xe8, 0x74, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0xd6, 0xa2, 0x3e, 0x4a, 0x1b, 0x6f, 0xf3, 0x87,
		0x51, 0x25, 0xb9, 0xcd, 0x9c, 0xe8, 0x74, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xcf, 0x8e, 0x4d, 0x0c, 0xcb, 0x8a, 0x49, 0x08,
		0xc7, 0x86, 0x45, 0x04, 0xc3, 0x82, 0x41, 0x00  },
	{	0xcb, 0xbf, 0x23, 0x57, 0x06, 0x72, 0xee, 0x9a,
		0x51, 0x25, 0xb9, 0xcd, 0x9c, 0xe8, 0x74, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xde, 0x9c, 0x5a, 0x18, 0xd6, 0x94, 0x52, 0x10,
		0xce, 0x8c, 0x4a, 0x08, 0xc6, 0x84, 0x42, 0x00  },
	{	0xcb, 0xbf, 0x23, 0x57, 0x06, 0x72, 0xee, 0x9a,
		0x51, 0x25, 0xb9, 0xcd, 0x9c, 0xe8, 0x74, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xd1, 0x92, 0x57, 0x14, 0xdd, 0x9e, 0x5b, 0x18,
		0xc9, 0x8a, 0x4f, 0x0c, 0xc5, 0x86, 0x43, 0x00  },
	{	0xf1, 0x85, 0x19, 0x6d, 0x21, 0x55, 0xc9, 0xbd,
		0x4c, 0x38, 0xa4, 0xd0, 0x9c, 0xe8, 0x74, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xfc, 0xb8, 0x74, 0x30, 0xec, 0xa8, 0x64, 0x20,
		0xdc, 0x98, 0x54, 0x10, 0xcc, 0x88, 0x44, 0x00  },
	{	0xf1, 0x85, 0x19, 0x6d, 0x21, 0x55, 0xc9, 0xbd,
		0x4c, 0x38, 0xa4, 0xd0, 0x9c, 0xe8, 0x74, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xf3, 0xb6, 0x79, 0x3c, 0xe7, 0xa2, 0x6d, 0x28,
		0xdb, 0x9e, 0x51, 0x14, 0xcf, 0x8a, 0x45, 0x00  },
	{	0xec, 0x98, 0x04, 0x70, 0x3c, 0x48, 0xd4, 0xa0,
		0x4c, 0x38, 0xa4, 0xd0, 0x9c, 0xe8, 0x74, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xe2, 0xa4, 0x6e, 0x28, 0xfa, 0xbc, 0x76, 0x30,
		0xd2, 0x94, 0x5e, 0x18, 0xca, 0x8c, 0x46, 0x00  },
	{	0xec, 0x98, 0x04, 0x70, 0x3c, 0x48, 0xd4, 0xa0,
		0x4c, 0x38, 0xa4, 0xd0, 0x9c, 0xe8, 0x74, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xed, 0xaa, 0x63, 0x24, 0xf1, 0xb6, 0x7f, 0x38,
		0xd5, 0x92, 0x5b, 0x1c, 0xc9, 0x8e, 0x47, 0x00  },
	{	0x85, 0xf1, 0x70, 0x04, 0x72, 0x06, 0x87, 0xf3,
		0x76, 0x02, 0x83, 0xf7, 0x81, 0xf5, 0x74, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xb8, 0xf0, 0x28, 0x60, 0x98, 0xd0, 0x08, 0x40,
		0xf8, 0xb0, 0x68, 0x20, 0xd8, 0x90, 0x48, 0x00  },
	{	0x85, 0xf1, 0x70, 0x04, 0x72, 0x06, 0x87, 0xf3,
		0x76, 0x02, 0x83, 0xf7, 0x81, 0xf5, 0x74, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xb7, 0xfe, 0x25, 0x6c, 0x93, 0xda, 0x01, 0x48,
		0xff, 0xb6, 0x6d, 0x24, 0xdb, 0x92, 0x49, 0x00  },
	{	0x98, 0xec, 0x6d, 0x19, 0x6f, 0x1b, 0x9a, 0xee,
		0x76, 0x02, 0x83, 0xf7, 0x81, 0xf5, 0x74, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xa6, 0xec, 0x32, 0x78, 0x8e, 0xc4, 0x1a, 0x50,
		0xf6, 0xbc, 0x62, 0x28, 0xde, 0x94, 0x4a, 0x00  },
	{	0x98, 0xec, 0x6d, 0x19, 0x6f, 0x1b, 0x9a, 0xee,
		0x76, 0x02, 0x83, 0xf7, 0x81, 0xf5, 0x74, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xa9, 0xe2, 0x3f, 0x74, 0x85, 0xce, 0x13, 0x58,
		0xf1, 0xba, 0x67, 0x2c, 0xdd, 0x96, 0x4b, 0x00  },
	{	0xa2, 0xd6, 0x57, 0x23, 0x48, 0x3c, 0xbd, 0xc9,
		0x6b, 0x1f, 0x9e, 0xea, 0x81, 0xf5, 0x74, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x84, 0xc8, 0x1c, 0x50, 0xb4, 0xf8, 0x2c, 0x60,
		0xe4, 0xa8, 0x7c, 0x30, 0xd4, 0x98, 0x4c, 0x00  },
	{	0xa2, 0xd6, 0x57, 0x23, 0x48, 0x3c, 0xbd, 0xc9,
		0x6b, 0x1f, 0x9e, 0xea, 0x81, 0xf5, 0x74, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x8b, 0xc6, 0x11, 0x5c, 0xbf, 0xf2, 0x25, 0x68,
		0xe3, 0xae, 0x79, 0x34, 0xd7, 0x9a, 0x4d, 0x00  },
	{	0xbf, 0xcb, 0x4a, 0x3e, 0x55, 0x21, 0xa0, 0xd4,
		0x6b, 0x1f, 0x9e, 0xea, 0x81, 0xf5, 0x74, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x9a, 0xd4, 0x06, 0x48, 0xa2, 0xec, 0x3e, 0x70,
		0xea, 0xa4, 0x76, 0x38, 0xd2, 0x9c, 0x4e, 0x00  },
	{	0xbf, 0xcb, 0x4a, 0x3e, 0x55, 0x21, 0xa0, 0xd4,
		0x6b, 0x1f, 0x9e, 0xea, 0x81, 0xf5, 0x74, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x95, 0xda, 0x0b, 0x44, 0xa9, 0xe6, 0x37, 0x78,
		0xed, 0xa2, 0x73, 0x3c, 0xd1, 0x9e, 0x4f, 0x00  },
	{	0x6d, 0x04, 0xbf, 0xd6, 0xd4, 0xbd, 0x06, 0x6f,
		0x02, 0x6b, 0xd0, 0xb9, 0xbb, 0xd2, 0x69, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x6d, 0x04, 0xbf, 0xd6, 0xd4, 0xbd, 0x06, 0x6f,
		0x02, 0x6b, 0xd0, 0xb9, 0xbb, 0xd2, 0x69, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x3f, 0x6e, 0x9d, 0xcc, 0x7b, 0x2a, 0xd9, 0x88,
		0xb7, 0xe6, 0x15, 0x44, 0xf3, 0xa2, 0x51, 0x00  },
	{	0x70, 0x19, 0xa2, 0xcb, 0xc9, 0xa0, 0x1b, 0x72,
		0x02, 0x6b, 0xd0, 0xb9, 0xbb, 0xd2, 0x69, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x2e, 0x7c, 0x8a, 0xd8, 0x66, 0x34, 0xc2, 0x90,
		0xbe, 0xec, 0x1a, 0x48, 0xf6, 0xa4, 0x52, 0x00  },
	{	0x70, 0x19, 0xa2, 0xcb, 0xc9, 0xa0, 0x1b, 0x72,
		0x02, 0x6b, 0xd0, 0xb9, 0xbb, 0xd2, 0x69, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x21, 0x72, 0x87, 0xd4, 0x6d, 0x3e, 0xcb, 0x98,
		0xb9, 0xea, 0x1f, 0x4c, 0xf5, 0xa6, 0x53, 0x00  },
	{	0x4a, 0x23, 0x98, 0xf1, 0xee, 0x87, 0x3c, 0x55,
		0x1f, 0x76, 0xcd, 0xa4, 0xbb, 0xd2, 0x69, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x0c, 0x58, 0xa4, 0xf0, 0x5c, 0x08, 0xf4, 0xa0,
		0xac, 0xf8, 0x04, 0x50, 0xfc, 0xa8, 0x54, 0x00  },
	{	0x4a, 0x23, 0x98, 0xf1, 0xee, 0x87, 0x3c, 0x55,
		0x1f, 0x76, 0xcd, 0xa4, 0xbb, 0xd2, 0x69, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x03, 0x56, 0xa9, 0xfc, 0x57, 0x02, 0xfd, 0xa8,
		0xab, 0xfe, 0x01, 0x54, 0xff, 0xaa, 0x55, 0x00  },
	{	0x57, 0x3e, 0x85, 0xec, 0xf3, 0x9a, 0x21, 0x48,
		0x1f, 0x76, 0xcd, 0xa4, 0xbb, 0xd2, 0x69, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x12, 0x44, 0xbe, 0xe8, 0x4a, 0x1c, 0xe6, 0xb0,
		0xa2, 0xf4, 0x0e, 0x58, 0xfa, 0xac, 0x56, 0x00  },
	{	0x57, 0x3e, 0x85, 0xec, 0xf3, 0x9a, 0x21, 0x48,
		0x1f, 0x76, 0xcd, 0xa4, 0xbb, 0xd2, 0x69, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x1d, 0x4a, 0xb3, 0xe4, 0x41, 0x16, 0xef, 0xb8,
		0xa5, 0xf2, 0x0b, 0x5c, 0xf9, 0xae, 0x57, 0x00  },
	{	0x3e, 0x57, 0xf1, 0x98, 0xbd, 0xd4, 0x72, 0x1b,
		0x25, 0x4c, 0xea, 0x83, 0xa6, 0xcf, 0x69, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x48, 0x10, 0xf8, 0xa0, 0x28, 0x70, 0x98, 0xc0,
		0x88, 0xd0, 0x38, 0x60, 0xe8, 0xb0, 0x58, 0x00  },
	{	0x3e, 0x57, 0xf1, 0x98, 0xbd, 0xd4, 0x72, 0x1b,
		0x25, 0x4c, 0xea, 0x83, 0xa6, 0xcf, 0x69, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x47, 0x1e, 0xf5, 0xac, 0x23, 0x7a, 0x91, 0xc8,
		0x8f, 0xd6, 0x3d, 0x64, 0xeb, 0xb2, 0x59, 0x00  },
	{	0x23, 0x4a, 0xec, 0x85, 0xa0, 0xc9, 0x6f, 0x06,
		0x25, 0x4c, 0xea, 0x83, 0xa6, 0xcf, 0x69, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x56, 0x0c, 0xe2, 0xb8, 0x3e, 0x64, 0x8a, 0xd0,
		0x86, 0xdc, 0x32, 0x68, 0xee, 0xb4, 0x5a, 0x00  },
	{	0x23, 0x4a, 0xec, 0x85, 0xa0, 0xc9, 0x6f, 0x06,
		0x25, 0x4c, 0xea, 0x83, 0xa6, 0xcf, 0x69, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x59, 0x02, 0xef, 0xb4, 0x35, 0x6e, 0x83, 0xd8,
		0x81, 0xda, 0x37, 0x6c, 0xed, 0xb6, 0x5b, 0x00  },
	{	0x19, 0x70, 0xd6, 0xbf, 0x87, 0xee, 0x48, 0x21,
		0x38, 0x51, 0xf7, 0x9e, 0xa6, 0xcf, 0x69, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x74, 0x28, 0xcc, 0x90, 0x04, 0x58, 0xbc, 0xe0,
		0x94, 0xc8, 0x2c, 0x70, 0xe4, 0xb8, 0x5c, 0x00  },
	{	0x19, 0x70, 0xd6, 0xbf, 0x87, 0xee, 0x48, 0x21,
		0x38, 0x51, 0xf7, 0x9e, 0xa6, 0xcf, 0x69, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x7b, 0x26, 0xc1, 0x9c, 0x0f, 0x52, 0xb5, 0xe8,
		0x93, 0xce, 0x29, 0x74, 0xe7, 0xba, 0x5d, 0x00  },
	{	0x04, 0x6d, 0xcb, 0xa2, 0x9a, 0xf3, 0x55, 0x3c,
		0x38, 0x51, 0xf7, 0x9e, 0xa6, 0xcf, 0x69, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x6a, 0x34, 0xd6, 0x88, 0x12, 0x4c, 0xae, 0xf0,
		0x9a, 0xc4, 0x26, 0x78, 0xe2, 0xbc, 0x5e, 0x00  },
	{	0x04, 0x6d, 0xcb, 0xa2, 0x9a, 0xf3, 0x55, 0x3c,
		0x38, 0x51, 0xf7, 0x9e, 0xa6, 0xcf, 0x69, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x65, 0x3a, 0xdb, 0x84, 0x19, 0x46, 0xa7, 0xf8,
		0x9d, 0xc2, 0x23, 0x7c, 0xe1, 0xbe, 0x5f, 0x00  },
	{	0xbd, 0xf3, 0x21, 0x6f, 0x98, 0xd6, 0x04, 0x4a,
		0xf7, 0xb9, 0x6b, 0x25, 0xd2, 0x9c, 0x4e, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0xbd, 0xf3, 0x21, 0x6f, 0x98, 0xd6, 0x04, 0x4a,
		0xf7, 0xb9, 0x6b, 0x25, 0xd2, 0x9c, 0x4e, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x2f, 0x4e, 0xed, 0x8c, 0xab, 0xca, 0x69, 0x08,
		0x27, 0x46, 0xe5, 0x84, 0xa3, 0xc2, 0x61, 0x00  },
	{	0xa0, 0xee, 0x3c, 0x72, 0x85, 0xcb, 0x19, 0x57,
		0xf7, 0xb9, 0x6b, 0x25, 0xd2, 0x9c, 0x4e, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x3e, 0x5c, 0xfa, 0x98, 0xb6, 0xd4, 0x72, 0x10,
		0x2e, 0x4c, 0xea, 0x88, 0xa6, 0xc4, 0x62, 0x00  },
	{	0xa0, 0xee, 0x3c, 0x72, 0x85, 0xcb, 0x19, 0x57,
		0xf7, 0xb9, 0x6b, 0x25, 0xd2, 0x9c, 0x4e, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x31, 0x52, 0xf7, 0x94, 0xbd, 0xde, 0x7b, 0x18,
		0x29, 0x4a, 0xef, 0x8c, 0xa5, 0xc6, 0x63, 0x00  },
	{	0x9a, 0xd4, 0x06, 0x48, 0xa2, 0xec, 0x3e, 0x70,
		0xea, 0xa4, 0x76, 0x38, 0xd2, 0x9c, 0x4e, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x1c, 0x78, 0xd4, 0xb0, 0x8c, 0xe8, 0x44, 0x20,
		0x3c, 0x58, 0xf4, 0x90, 0xac, 0xc8, 0x64, 0x00  },
	{	0x9a, 0xd4, 0x06, 0x48, 0xa2, 0xec, 0x3e, 0x70,
		0xea, 0xa4, 0x76, 0x38, 0xd2, 0x9c, 0x4e, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x13, 0x76, 0xd9, 0xbc, 0x87, 0xe2, 0x4d, 0x28,
		0x3b, 0x5e, 0xf1, 0x94, 0xaf, 0xca, 0x65, 0x00  },
	{	0x87, 0xc9, 0x1b, 0x55, 0xbf, 0xf1, 0x23, 0x6d,
		0xea, 0xa4, 0x76, 0x38, 0xd2, 0x9c, 0x4e, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x02, 0x64, 0xce, 0xa8, 0x9a, 0xfc, 0x56, 0x30,
		0x32, 0x54, 0xfe, 0x98, 0xaa, 0xcc, 0x66, 0x00  },
	{	0x87, 0xc9, 0x1b, 0x55, 0xbf, 0xf1, 0x23, 0x6d,
		0xea, 0xa4, 0x76, 0x38, 0xd2, 0x9c, 0x4e, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x0d, 0x6a, 0xc3, 0xa4, 0x91, 0xf6, 0x5f, 0x38,
		0x35, 0x52, 0xfb, 0x9c, 0xa9, 0xce, 0x67, 0x00  },
	{	0xee, 0xa0, 0x6f, 0x21, 0xf1, 0xbf, 0x70, 0x3e,
		0xd0, 0x9e, 0x51, 0x1f, 0xcf, 0x81, 0x4e, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x58, 0x30, 0x88, 0xe0, 0xf8, 0x90, 0x28, 0x40,
		0x18, 0x70, 0xc8, 0xa0, 0xb8, 0xd0, 0x68, 0x00  },
	{	0xee, 0xa0, 0x6f, 0x21, 0xf1, 0xbf, 0x70, 0x3e,
		0xd0, 0x9e, 0x51, 0x1f, 0xcf, 0x81, 0x4e, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x57, 0x3e, 0x85, 0xec, 0xf3, 0x9a, 0x21, 0x48,
		0x1f, 0x76, 0xcd, 0xa4, 0xbb, 0xd2, 0x69, 0x00  },
	{	0xf3, 0xbd, 0x72, 0x3c, 0xec, 0xa2, 0x6d, 0x23,
		0xd0, 0x9e, 0x51, 0x1f, 0xcf, 0x81, 0x4e, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x46, 0x2c, 0x92, 0xf8, 0xee, 0x84, 0x3a, 0x50,
		0x16, 0x7c, 0xc2, 0xa8, 0xbe, 0xd4, 0x6a, 0x00  },
	{	0xf3, 0xbd, 0x72, 0x3c, 0xec, 0xa2, 0x6d, 0x23,
		0xd0, 0x9e, 0x51, 0x1f, 0xcf, 0x81, 0x4e, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x49, 0x22, 0x9f, 0xf4, 0xe5, 0x8e, 0x33, 0x58,
		0x11, 0x7a, 0xc7, 0xac, 0xbd, 0xd6, 0x6b, 0x00  },
	{	0xc9, 0x87, 0x48, 0x06, 0xcb, 0x85, 0x4a, 0x04,
		0xcd, 0x83, 0x4c, 0x02, 0xcf, 0x81, 0x4e, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x64, 0x08, 0xbc, 0xd0, 0xd4, 0xb8, 0x0c, 0x60,
		0x04, 0x68, 0xdc, 0xb0, 0xb4, 0xd8, 0x6c, 0x00  },
	{	0xc9, 0x87, 0x48, 0x06, 0xcb, 0x85, 0x4a, 0x04,
		0xcd, 0x83, 0x4c, 0x02, 0xcf, 0x81, 0x4e, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x6b, 0x06, 0xb1, 0xdc, 0xdf, 0xb2, 0x05, 0x68,
		0x03, 0x6e, 0xd9, 0xb4, 0xb7, 0xda, 0x6d, 0x00  },
	{	0xd4, 0x9a, 0x55, 0x1b, 0xd6, 0x98, 0x57, 0x19,
		0xcd, 0x83, 0x4c, 0x02, 0xcf, 0x81, 0x4e, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x7a, 0x14, 0xa6, 0xc8, 0xc2, 0xac, 0x1e, 0x70,
		0x0a, 0x64, 0xd6, 0xb8, 0xb2, 0xdc, 0x6e, 0x00  },
	{	0xd4, 0x9a, 0x55, 0x1b, 0xd6, 0x98, 0x57, 0x19,
		0xcd, 0x83, 0x4c, 0x02, 0xcf, 0x81, 0x4e, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x75, 0x1a, 0xab, 0xc4, 0xc9, 0xa6, 0x17, 0x78,
		0x0d, 0x62, 0xd3, 0xbc, 0xb1, 0xde, 0x6f, 0x00  },
	{	0x06, 0x55, 0xa0, 0xf3, 0x57, 0x04, 0xf1, 0xa2,
		0xa4, 0xf7, 0x02, 0x51, 0xf5, 0xa6, 0x53, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x06, 0x55, 0xa0, 0xf3, 0x57, 0x04, 0xf1, 0xa2,
		0xa4, 0xf7, 0x02, 0x51, 0xf5, 0xa6, 0x53, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xdf, 0xae, 0x3d, 0x4c, 0x1b, 0x6a, 0xf9, 0x88,
		0x57, 0x26, 0xb5, 0xc4, 0x93, 0xe2, 0x71, 0x00  },
	{	0x1b, 0x48, 0xbd, 0xee, 0x4a, 0x19, 0xec, 0xbf,
		0xa4, 0xf7, 0x02, 0x51, 0xf5, 0xa6, 0x53, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xce, 0xbc, 0x2a, 0x58, 0x06, 0x74, 0xe2, 0x90,
		0x5e, 0x2c, 0xba, 0xc8, 0x96, 0xe4, 0x72, 0x00  },
	{	0x1b, 0x48, 0xbd, 0xee, 0x4a, 0x19, 0xec, 0xbf,
		0xa4, 0xf7, 0x02, 0x51, 0xf5, 0xa6, 0x53, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xc1, 0xb2, 0x27, 0x54, 0x0d, 0x7e, 0xeb, 0x98,
		0x59, 0x2a, 0xbf, 0xcc, 0x95, 0xe6, 0x73, 0x00  },
	{	0x21, 0x72, 0x87, 0xd4, 0x6d, 0x3e, 0xcb, 0x98,
		0xb9, 0xea, 0x1f, 0x4c, 0xf5, 0xa6, 0x53, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xec, 0x98, 0x04, 0x70, 0x3c, 0x48, 0xd4, 0xa0,
		0x4c, 0x38, 0xa4, 0xd0, 0x9c, 0xe8, 0x74, 0x00  },
	{	0x21, 0x72, 0x87, 0xd4, 0x6d, 0x3e, 0xcb, 0x98,
		0xb9, 0xea, 0x1f, 0x4c, 0xf5, 0xa6, 0x53, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xe3, 0x96, 0x09, 0x7c, 0x37, 0x42, 0xdd, 0xa8,
		0x4b, 0x3e, 0xa1, 0xd4, 0x9f, 0xea, 0x75, 0x00  },
	{	0x3c, 0x6f, 0x9a, 0xc9, 0x70, 0x23, 0xd6, 0x85,
		0xb9, 0xea, 0x1f, 0x4c, 0xf5, 0xa6, 0x53, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xf2, 0x84, 0x1e, 0x68, 0x2a, 0x5c, 0xc6, 0xb0,
		0x42, 0x34, 0xae, 0xd8, 0x9a, 0xec, 0x76, 0x00  },
	{	0x3c, 0x6f, 0x9a, 0xc9, 0x70, 0x23, 0xd6, 0x85,
		0xb9, 0xea, 0x1f, 0x4c, 0xf5, 0xa6, 0x53, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xfd, 0x8a, 0x13, 0x64, 0x21, 0x56, 0xcf, 0xb8,
		0x45, 0x32, 0xab, 0xdc, 0x99, 0xee, 0x77, 0x00  },
	{	0x55, 0x06, 0xee, 0xbd, 0x3e, 0x6d, 0x85, 0xd6,
		0x83, 0xd0, 0x38, 0x6b, 0xe8, 0xbb, 0x53, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xa8, 0xd0, 0x58, 0x20, 0x48, 0x30, 0xb8, 0xc0,
		0x68, 0x10, 0x98, 0xe0, 0x88, 0xf0, 0x78, 0x00  },
	{	0x55, 0x06, 0xee, 0xbd, 0x3e, 0x6d, 0x85, 0xd6,
		0x83, 0xd0, 0x38, 0x6b, 0xe8, 0xbb, 0x53, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xa7, 0xde, 0x55, 0x2c, 0x43, 0x3a, 0xb1, 0xc8,
		0x6f, 0x16, 0x9d, 0xe4, 0x8b, 0xf2, 0x79, 0x00  },
	{	0x48, 0x1b, 0xf3, 0xa0, 0x23, 0x70, 0x98, 0xcb,
		0x83, 0xd0, 0x38, 0x6b, 0xe8, 0xbb, 0x53, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xb6, 0xcc, 0x42, 0x38, 0x5e, 0x24, 0xaa, 0xd0,
		0x66, 0x1c, 0x92, 0xe8, 0x8e, 0xf4, 0x7a, 0x00  },
	{	0x48, 0x1b, 0xf3, 0xa0, 0x23, 0x70, 0x98, 0xcb,
		0x83, 0xd0, 0x38, 0x6b, 0xe8, 0xbb, 0x53, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0xb9, 0xc2, 0x4f, 0x34, 0x55, 0x2e, 0xa3, 0xd8,
		0x61, 0x1a, 0x97, 0xec, 0x8d, 0xf6, 0x7b, 0x00  },
	{	0x72, 0x21, 0xc9, 0x9a, 0x04, 0x57, 0xbf, 0xec,
		0x9e, 0xcd, 0x25, 0x76, 0xe8, 0xbb, 0x53, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x94, 0xe8, 0x6c, 0x10, 0x64, 0x18, 0x9c, 0xe0,
		0x74, 0x08, 0x8c, 0xf0, 0x84, 0xf8, 0x7c, 0x00  },
	{	0x72, 0x21, 0xc9, 0x9a, 0x04, 0x57, 0xbf, 0xec,
		0x9e, 0xcd, 0x25, 0x76, 0xe8, 0xbb, 0x53, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x9b, 0xe6, 0x61, 0x1c, 0x6f, 0x12, 0x95, 0xe8,
		0x73, 0x0e, 0x89, 0xf4, 0x87, 0xfa, 0x7d, 0x00  },
	{	0x6f, 0x3c, 0xd4, 0x87, 0x19, 0x4a, 0xa2, 0xf1,
		0x9e, 0xcd, 0x25, 0x76, 0xe8, 0xbb, 0x53, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x8a, 0xf4, 0x76, 0x08, 0x72, 0x0c, 0x8e, 0xf0,
		0x7a, 0x04, 0x86, 0xf8, 0x82, 0xfc, 0x7e, 0x00  },
	{	0x6f, 0x3c, 0xd4, 0x87, 0x19, 0x4a, 0xa2, 0xf1,
		0x9e, 0xcd, 0x25, 0x76, 0xe8, 0xbb, 0x53, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27,
		0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00  },
	{	0x85, 0xfa, 0x7b, 0x04, 0x79, 0x06, 0x87, 0xf8,
		0x7d, 0x02, 0x83, 0xfc, 0x81, 0xfe, 0x7f, 0x00  },
	{	0xb1, 0x59, 0x7c, 0x94, 0x36, 0xde, 0xfb, 0x13,
		0xa2, 0x4a, 0x6f, 0x87, 0x25, 0xcd, 0xe8, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0xb1, 0x59, 0x7c, 0x94, 0x36, 0xde, 0xfb, 0x13,
		0xa2, 0x4a, 0x6f, 0x87, 0x25, 0xcd, 0xe8, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x8f, 0x0e, 0x8d, 0x0c, 0x8b, 0x0a, 0x89, 0x08,
		0x87, 0x06, 0x85, 0x04, 0x83, 0x02, 0x81, 0x00  },
	{	0xac, 0x44, 0x61, 0x89, 0x2b, 0xc3, 0xe6, 0x0e,
		0xa2, 0x4a, 0x6f, 0x87, 0x25, 0xcd, 0xe8, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x9e, 0x1c, 0x9a, 0x18, 0x96, 0x14, 0x92, 0x10,
		0x8e, 0x0c, 0x8a, 0x08, 0x86, 0x04, 0x82, 0x00  },
	{	0xac, 0x44, 0x61, 0x89, 0x2b, 0xc3, 0xe6, 0x0e,
		0xa2, 0x4a, 0x6f, 0x87, 0x25, 0xcd, 0xe8, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x91, 0x12, 0x97, 0x14, 0x9d, 0x1e, 0x9b, 0x18,
		0x89, 0x0a, 0x8f, 0x0c, 0x85, 0x06, 0x83, 0x00  },
	{	0x96, 0x7e, 0x5b, 0xb3, 0x0c, 0xe4, 0xc1, 0x29,
		0xbf, 0x57, 0x72, 0x9a, 0x25, 0xcd, 0xe8, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xbc, 0x38, 0xb4, 0x30, 0xac, 0x28, 0xa4, 0x20,
		0x9c, 0x18, 0x94, 0x10, 0x8c, 0x08, 0x84, 0x00  },
	{	0x96, 0x7e, 0x5b, 0xb3, 0x0c, 0xe4, 0xc1, 0x29,
		0xbf, 0x57, 0x72, 0x9a, 0x25, 0xcd, 0xe8, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xb3, 0x36, 0xb9, 0x3c, 0xa7, 0x22, 0xad, 0x28,
		0x9b, 0x1e, 0x91, 0x14, 0x8f, 0x0a, 0x85, 0x00  },
	{	0x8b, 0x63, 0x46, 0xae, 0x11, 0xf9, 0xdc, 0x34,
		0xbf, 0x57, 0x72, 0x9a, 0x25, 0xcd, 0xe8, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xa2, 0x24, 0xae, 0x28, 0xba, 0x3c, 0xb6, 0x30,
		0x92, 0x14, 0x9e, 0x18, 0x8a, 0x0c, 0x86, 0x00  },
	{	0x8b, 0x63, 0x46, 0xae, 0x11, 0xf9, 0xdc, 0x34,
		0xbf, 0x57, 0x72, 0x9a, 0x25, 0xcd, 0xe8, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xad, 0x2a, 0xa3, 0x24, 0xb1, 0x36, 0xbf, 0x38,
		0x95, 0x12, 0x9b, 0x1c, 0x89, 0x0e, 0x87, 0x00  },
	{	0xe2, 0x0a, 0x32, 0xda, 0x5f, 0xb7, 0x8f, 0x67,
		0x85, 0x6d, 0x55, 0xbd, 0x38, 0xd0, 0xe8, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xf8, 0x70, 0xe8, 0x60, 0xd8, 0x50, 0xc8, 0x40,
		0xb8, 0x30, 0xa8, 0x20, 0x98, 0x10, 0x88, 0x00  },
	{	0xe2, 0x0a, 0x32, 0xda, 0x5f, 0xb7, 0x8f, 0x67,
		0x85, 0x6d, 0x55, 0xbd, 0x38, 0xd0, 0xe8, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xf7, 0x7e, 0xe5, 0x6c, 0xd3, 0x5a, 0xc1, 0x48,
		0xbf, 0x36, 0xad, 0x24, 0x9b, 0x12, 0x89, 0x00  },
	{	0xff, 0x17, 0x2f, 0xc7, 0x42, 0xaa, 0x92, 0x7a,
		0x85, 0x6d, 0x55, 0xbd, 0x38, 0xd0, 0xe8, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xe6, 0x6c, 0xf2, 0x78, 0xce, 0x44, 0xda, 0x50,
		0xb6, 0x3c, 0xa2, 0x28, 0x9e, 0x14, 0x8a, 0x00  },
	{	0xff, 0x17, 0x2f, 0xc7, 0x42, 0xaa, 0x92, 0x7a,
		0x85, 0x6d, 0x55, 0xbd, 0x38, 0xd0, 0xe8, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xe9, 0x62, 0xff, 0x74, 0xc5, 0x4e, 0xd3, 0x58,
		0xb1, 0x3a, 0xa7, 0x2c, 0x9d, 0x16, 0x8b, 0x00  },
	{	0xc5, 0x2d, 0x15, 0xfd, 0x65, 0x8d, 0xb5, 0x5d,
		0x98, 0x70, 0x48, 0xa0, 0x38, 0xd0, 0xe8, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xc4, 0x48, 0xdc, 0x50, 0xf4, 0x78, 0xec, 0x60,
		0xa4, 0x28, 0xbc, 0x30, 0x94, 0x18, 0x8c, 0x00  },
	{	0xc5, 0x2d, 0x15, 0xfd, 0x65, 0x8d, 0xb5, 0x5d,
		0x98, 0x70, 0x48, 0xa0, 0x38, 0xd0, 0xe8, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xcb, 0x46, 0xd1, 0x5c, 0xff, 0x72, 0xe5, 0x68,
		0xa3, 0x2e, 0xb9, 0x34, 0x97, 0x1a, 0x8d, 0x00  },
	{	0xd8, 0x30, 0x08, 0xe0, 0x78, 0x90, 0xa8, 0x40,
		0x98, 0x70, 0x48, 0xa0, 0x38, 0xd0, 0xe8, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xda, 0x54, 0xc6, 0x48, 0xe2, 0x6c, 0xfe, 0x70,
		0xaa, 0x24, 0xb6, 0x38, 0x92, 0x1c, 0x8e, 0x00  },
	{	0xd8, 0x30, 0x08, 0xe0, 0x78, 0x90, 0xa8, 0x40,
		0x98, 0x70, 0x48, 0xa0, 0x38, 0xd0, 0xe8, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xd5, 0x5a, 0xcb, 0x44, 0xe9, 0x66, 0xf7, 0x78,
		0xad, 0x22, 0xb3, 0x3c, 0x91, 0x1e, 0x8f, 0x00  },
	{	0x0a, 0xff, 0xfd, 0x08, 0xf9, 0x0c, 0x0e, 0xfb,
		0xf1, 0x04, 0x06, 0xf3, 0x02, 0xf7, 0xf5, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x0a, 0xff, 0xfd, 0x08, 0xf9, 0x0c, 0x0e, 0xfb,
		0xf1, 0x04, 0x06, 0xf3, 0x02, 0xf7, 0xf5, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x7f, 0xee, 0x5d, 0xcc, 0x3b, 0xaa, 0x19, 0x88,
		0xf7, 0x66, 0xd5, 0x44, 0xb3, 0x22, 0x91, 0x00  },
	{	0x17, 0xe2, 0xe0, 0x15, 0xe4, 0x11, 0x13, 0xe6,
		0xf1, 0x04, 0x06, 0xf3, 0x02, 0xf7, 0xf5, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x6e, 0xfc, 0x4a, 0xd8, 0x26, 0xb4, 0x02, 0x90,
		0xfe, 0x6c, 0xda, 0x48, 0xb6, 0x24, 0x92, 0x00  },
	{	0x17, 0xe2, 0xe0, 0x15, 0xe4, 0x11, 0x13, 0xe6,
		0xf1, 0x04, 0x06, 0xf3, 0x02, 0xf7, 0xf5, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x61, 0xf2, 0x47, 0xd4, 0x2d, 0xbe, 0x0b, 0x98,
		0xf9, 0x6a, 0xdf, 0x4c, 0xb5, 0x26, 0x93, 0x00  },
	{	0x2d, 0xd8, 0xda, 0x2f, 0xc3, 0x36, 0x34, 0xc1,
		0xec, 0x19, 0x1b, 0xee, 0x02, 0xf7, 0xf5, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x4c, 0xd8, 0x64, 0xf0, 0x1c, 0x88, 0x34, 0xa0,
		0xec, 0x78, 0xc4, 0x50, 0xbc, 0x28, 0x94, 0x00  },
	{	0x2d, 0xd8, 0xda, 0x2f, 0xc3, 0x36, 0x34, 0xc1,
		0xec, 0x19, 0x1b, 0xee, 0x02, 0xf7, 0xf5, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x43, 0xd6, 0x69, 0xfc, 0x17, 0x82, 0x3d, 0xa8,
		0xeb, 0x7e, 0xc1, 0x54, 0xbf, 0x2a, 0x95, 0x00  },
	{	0x30, 0xc5, 0xc7, 0x32, 0xde, 0x2b, 0x29, 0xdc,
		0xec, 0x19, 0x1b, 0xee, 0x02, 0xf7, 0xf5, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x52, 0xc4, 0x7e, 0xe8, 0x0a, 0x9c, 0x26, 0xb0,
		0xe2, 0x74, 0xce, 0x58, 0xba, 0x2c, 0x96, 0x00  },
	{	0x30, 0xc5, 0xc7, 0x32, 0xde, 0x2b, 0x29, 0xdc,
		0xec, 0x19, 0x1b, 0xee, 0x02, 0xf7, 0xf5, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x5d, 0xca, 0x73, 0xe4, 0x01, 0x96, 0x2f, 0xb8,
		0xe5, 0x72, 0xcb, 0x5c, 0xb9, 0x2e, 0x97, 0x00  },
	{	0x59, 0xac, 0xb3, 0x46, 0x90, 0x65, 0x7a, 0x8f,
		0xd6, 0x23, 0x3c, 0xc9, 0x1f, 0xea, 0xf5, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x08, 0x90, 0x38, 0xa0, 0x68, 0xf0, 0x58, 0xc0,
		0xc8, 0x50, 0xf8, 0x60, 0xa8, 0x30, 0x98, 0x00  },
	{	0x59, 0xac, 0xb3, 0x46, 0x90, 0x65, 0x7a, 0x8f,
		0xd6, 0x23, 0x3c, 0xc9, 0x1f, 0xea, 0xf5, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x07, 0x9e, 0x35, 0xac, 0x63, 0xfa, 0x51, 0xc8,
		0xcf, 0x56, 0xfd, 0x64, 0xab, 0x32, 0x99, 0x00  },
	{	0x44, 0xb1, 0xae, 0x5b, 0x8d, 0x78, 0x67, 0x92,
		0xd6, 0x23, 0x3c, 0xc9, 0x1f, 0xea, 0xf5, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x16, 0x8c, 0x22, 0xb8, 0x7e, 0xe4, 0x4a, 0xd0,
		0xc6, 0x5c, 0xf2, 0x68, 0xae, 0x34, 0x9a, 0x00  },
	{	0x44, 0xb1, 0xae, 0x5b, 0x8d, 0x78, 0x67, 0x92,
		0xd6, 0x23, 0x3c, 0xc9, 0x1f, 0xea, 0xf5, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x19, 0x82, 0x2f, 0xb4, 0x75, 0xee, 0x43, 0xd8,
		0xc1, 0x5a, 0xf7, 0x6c, 0xad, 0x36, 0x9b, 0x00  },
	{	0x7e, 0x8b, 0x94, 0x61, 0xaa, 0x5f, 0x40, 0xb5,
		0xcb, 0x3e, 0x21, 0xd4, 0x1f, 0xea, 0xf5, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x34, 0xa8, 0x0c, 0x90, 0x44, 0xd8, 0x7c, 0xe0,
		0xd4, 0x48, 0xec, 0x70, 0xa4, 0x38, 0x9c, 0x00  },
	{	0x7e, 0x8b, 0x94, 0x61, 0xaa, 0x5f, 0x40, 0xb5,
		0xcb, 0x3e, 0x21, 0xd4, 0x1f, 0xea, 0xf5, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x3b, 0xa6, 0x01, 0x9c, 0x4f, 0xd2, 0x75, 0xe8,
		0xd3, 0x4e, 0xe9, 0x74, 0xa7, 0x3a, 0x9d, 0x00  },
	{	0x63, 0x96, 0x89, 0x7c, 0xb7, 0x42, 0x5d, 0xa8,
		0xcb, 0x3e, 0x21, 0xd4, 0x1f, 0xea, 0xf5, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x2a, 0xb4, 0x16, 0x88, 0x52, 0xcc, 0x6e, 0xf0,
		0xda, 0x44, 0xe6, 0x78, 0xa2, 0x3c, 0x9e, 0x00  },
	{	0x63, 0x96, 0x89, 0x7c, 0xb7, 0x42, 0x5d, 0xa8,
		0xcb, 0x3e, 0x21, 0xd4, 0x1f, 0xea, 0xf5, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x53, 0x53, 0x4e, 0x4e, 0x69, 0x69, 0x74, 0x74,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x25, 0xba, 0x1b, 0x84, 0x59, 0xc6, 0x67, 0xf8,
		0xdd, 0x42, 0xe3, 0x7c, 0xa1, 0x3e, 0x9f, 0x00  },
	{	0xda, 0x08, 0x63, 0xb1, 0xb5, 0x67, 0x0c, 0xde,
		0x04, 0xd6, 0xbd, 0x6f, 0x6b, 0xb9, 0xd2, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0xda, 0x08, 0x63, 0xb1, 0xb5, 0x67, 0x0c, 0xde,
		0x04, 0xd6, 0xbd, 0x6f, 0x6b, 0xb9, 0xd2, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x6f, 0xce, 0x2d, 0x8c, 0xeb, 0x4a, 0xa9, 0x08,
		0x67, 0xc6, 0x25, 0x84, 0xe3, 0x42, 0xa1, 0x00  },
	{	0xc7, 0x15, 0x7e, 0xac, 0xa8, 0x7a, 0x11, 0xc3,
		0x04, 0xd6, 0xbd, 0x6f, 0x6b, 0xb9, 0xd2, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x7e, 0xdc, 0x3a, 0x98, 0xf6, 0x54, 0xb2, 0x10,
		0x6e, 0xcc, 0x2a, 0x88, 0xe6, 0x44, 0xa2, 0x00  },
	{	0xc7, 0x15, 0x7e, 0xac, 0xa8, 0x7a, 0x11, 0xc3,
		0x04, 0xd6, 0xbd, 0x6f, 0x6b, 0xb9, 0xd2, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x71, 0xd2, 0x37, 0x94, 0xfd, 0x5e, 0xbb, 0x18,
		0x69, 0xca, 0x2f, 0x8c, 0xe5, 0x46, 0xa3, 0x00  },
	{	0xfd, 0x2f, 0x44, 0x96, 0x8f, 0x5d, 0x36, 0xe4,
		0x19, 0xcb, 0xa0, 0x72, 0x6b, 0xb9, 0xd2, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x5c, 0xf8, 0x14, 0xb0, 0xcc, 0x68, 0x84, 0x20,
		0x7c, 0xd8, 0x34, 0x90, 0xec, 0x48, 0xa4, 0x00  },
	{	0xfd, 0x2f, 0x44, 0x96, 0x8f, 0x5d, 0x36, 0xe4,
		0x19, 0xcb, 0xa0, 0x72, 0x6b, 0xb9, 0xd2, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x53, 0xf6, 0x19, 0xbc, 0xc7, 0x62, 0x8d, 0x28,
		0x7b, 0xde, 0x31, 0x94, 0xef, 0x4a, 0xa5, 0x00  },
	{	0xe0, 0x32, 0x59, 0x8b, 0x92, 0x40, 0x2b, 0xf9,
		0x19, 0xcb, 0xa0, 0x72, 0x6b, 0xb9, 0xd2, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x42, 0xe4, 0x0e, 0xa8, 0xda, 0x7c, 0x96, 0x30,
		0x72, 0xd4, 0x3e, 0x98, 0xea, 0x4c, 0xa6, 0x00  },
	{	0xe0, 0x32, 0x59, 0x8b, 0x92, 0x40, 0x2b, 0xf9,
		0x19, 0xcb, 0xa0, 0x72, 0x6b, 0xb9, 0xd2, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x4d, 0xea, 0x03, 0xa4, 0xd1, 0x76, 0x9f, 0x38,
		0x75, 0xd2, 0x3b, 0x9c, 0xe9, 0x4e, 0xa7, 0x00  },
	{	0x89, 0x5b, 0x2d, 0xff, 0xdc, 0x0e, 0x78, 0xaa,
		0x23, 0xf1, 0x87, 0x55, 0x76, 0xa4, 0xd2, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x18, 0xb0, 0x48, 0xe0, 0xb8, 0x10, 0xe8, 0x40,
		0x58, 0xf0, 0x08, 0xa0, 0xf8, 0x50, 0xa8, 0x00  },
	{	0x89, 0x5b, 0x2d, 0xff, 0xdc, 0x0e, 0x78, 0xaa,
		0x23, 0xf1, 0x87, 0x55, 0x76, 0xa4, 0xd2, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x17, 0xbe, 0x45, 0xec, 0xb3, 0x1a, 0xe1, 0x48,
		0x5f, 0xf6, 0x0d, 0xa4, 0xfb, 0x52, 0xa9, 0x00  },
	{	0x94, 0x46, 0x30, 0xe2, 0xc1, 0x13, 0x65, 0xb7,
		0x23, 0xf1, 0x87, 0x55, 0x76, 0xa4, 0xd2, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x06, 0xac, 0x52, 0xf8, 0xae, 0x04, 0xfa, 0x50,
		0x56, 0xfc, 0x02, 0xa8, 0xfe, 0x54, 0xaa, 0x00  },
	{	0x94, 0x46, 0x30, 0xe2, 0xc1, 0x13, 0x65, 0xb7,
		0x23, 0xf1, 0x87, 0x55, 0x76, 0xa4, 0xd2, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x09, 0xa2, 0x5f, 0xf4, 0xa5, 0x0e, 0xf3, 0x58,
		0x51, 0xfa, 0x07, 0xac, 0xfd, 0x56, 0xab, 0x00  },
	{	0xae, 0x7c, 0x0a, 0xd8, 0xe6, 0x34, 0x42, 0x90,
		0x3e, 0xec, 0x9a, 0x48, 0x76, 0xa4, 0xd2, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x24, 0x88, 0x7c, 0xd0, 0x94, 0x38, 0xcc, 0x60,
		0x44, 0xe8, 0x1c, 0xb0, 0xf4, 0x58, 0xac, 0x00  },
	{	0xae, 0x7c, 0x0a, 0xd8, 0xe6, 0x34, 0x42, 0x90,
		0x3e, 0xec, 0x9a, 0x48, 0x76, 0xa4, 0xd2, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x2b, 0x86, 0x71, 0xdc, 0x9f, 0x32, 0xc5, 0x68,
		0x43, 0xee, 0x19, 0xb4, 0xf7, 0x5a, 0xad, 0x00  },
	{	0xb3, 0x61, 0x17, 0xc5, 0xfb, 0x29, 0x5f, 0x8d,
		0x3e, 0xec, 0x9a, 0x48, 0x76, 0xa4, 0xd2, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x3a, 0x94, 0x66, 0xc8, 0x82, 0x2c, 0xde, 0x70,
		0x4a, 0xe4, 0x16, 0xb8, 0xf2, 0x5c, 0xae, 0x00  },
	{	0xb3, 0x61, 0x17, 0xc5, 0xfb, 0x29, 0x5f, 0x8d,
		0x3e, 0xec, 0x9a, 0x48, 0x76, 0xa4, 0xd2, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x35, 0x9a, 0x6b, 0xc4, 0x89, 0x26, 0xd7, 0x78,
		0x4d, 0xe2, 0x13, 0xbc, 0xf1, 0x5e, 0xaf, 0x00  },
	{	0x61, 0xae, 0xe2, 0x2d, 0x7a, 0xb5, 0xf9, 0x36,
		0x57, 0x98, 0xd4, 0x1b, 0x4c, 0x83, 0xcf, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x61, 0xae, 0xe2, 0x2d, 0x7a, 0xb5, 0xf9, 0x36,
		0x57, 0x98, 0xd4, 0x1b, 0x4c, 0x83, 0xcf, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x9f, 0x2e, 0xfd, 0x4c, 0x5b, 0xea, 0x39, 0x88,
		0x17, 0xa6, 0x75, 0xc4, 0xd3, 0x62, 0xb1, 0x00  },
	{	0x7c, 0xb3, 0xff, 0x30, 0x67, 0xa8, 0xe4, 0x2b,
		0x57, 0x98, 0xd4, 0x1b, 0x4c, 0x83, 0xcf, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x8e, 0x3c, 0xea, 0x58, 0x46, 0xf4, 0x22, 0x90,
		0x1e, 0xac, 0x7a, 0xc8, 0xd6, 0x64, 0xb2, 0x00  },
	{	0x7c, 0xb3, 0xff, 0x30, 0x67, 0xa8, 0xe4, 0x2b,
		0x57, 0x98, 0xd4, 0x1b, 0x4c, 0x83, 0xcf, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x81, 0x32, 0xe7, 0x54, 0x4d, 0xfe, 0x2b, 0x98,
		0x19, 0xaa, 0x7f, 0xcc, 0xd5, 0x66, 0xb3, 0x00  },
	{	0x46, 0x89, 0xc5, 0x0a, 0x40, 0x8f, 0xc3, 0x0c,
		0x4a, 0x85, 0xc9, 0x06, 0x4c, 0x83, 0xcf, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xac, 0x18, 0xc4, 0x70, 0x7c, 0xc8, 0x14, 0xa0,
		0x0c, 0xb8, 0x64, 0xd0, 0xdc, 0x68, 0xb4, 0x00  },
	{	0x46, 0x89, 0xc5, 0x0a, 0x40, 0x8f, 0xc3, 0x0c,
		0x4a, 0x85, 0xc9, 0x06, 0x4c, 0x83, 0xcf, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xa3, 0x16, 0xc9, 0x7c, 0x77, 0xc2, 0x1d, 0xa8,
		0x0b, 0xbe, 0x61, 0xd4, 0xdf, 0x6a, 0xb5, 0x00  },
	{	0x5b, 0x94, 0xd8, 0x17, 0x5d, 0x92, 0xde, 0x11,
		0x4a, 0x85, 0xc9, 0x06, 0x4c, 0x83, 0xcf, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xb2, 0x04, 0xde, 0x68, 0x6a, 0xdc, 0x06, 0xb0,
		0x02, 0xb4, 0x6e, 0xd8, 0xda, 0x6c, 0xb6, 0x00  },
	{	0x5b, 0x94, 0xd8, 0x17, 0x5d, 0x92, 0xde, 0x11,
		0x4a, 0x85, 0xc9, 0x06, 0x4c, 0x83, 0xcf, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xbd, 0x0a, 0xd3, 0x64, 0x61, 0xd6, 0x0f, 0xb8,
		0x05, 0xb2, 0x6b, 0xdc, 0xd9, 0x6e, 0xb7, 0x00  },
	{	0x32, 0xfd, 0xac, 0x63, 0x13, 0xdc, 0x8d, 0x42,
		0x70, 0xbf, 0xee, 0x21, 0x51, 0x9e, 0xcf, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xe8, 0x50, 0x98, 0x20, 0x08, 0xb0, 0x78, 0xc0,
		0x28, 0x90, 0x58, 0xe0, 0xc8, 0x70, 0xb8, 0x00  },
	{	0x32, 0xfd, 0xac, 0x63, 0x13, 0xdc, 0x8d, 0x42,
		0x70, 0xbf, 0xee, 0x21, 0x51, 0x9e, 0xcf, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xe7, 0x5e, 0x95, 0x2c, 0x03, 0xba, 0x71, 0xc8,
		0x2f, 0x96, 0x5d, 0xe4, 0xcb, 0x72, 0xb9, 0x00  },
	{	0x2f, 0xe0, 0xb1, 0x7e, 0x0e, 0xc1, 0x90, 0x5f,
		0x70, 0xbf, 0xee, 0x21, 0x51, 0x9e, 0xcf, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xf6, 0x4c, 0x82, 0x38, 0x1e, 0xa4, 0x6a, 0xd0,
		0x26, 0x9c, 0x52, 0xe8, 0xce, 0x74, 0xba, 0x00  },
	{	0x2f, 0xe0, 0xb1, 0x7e, 0x0e, 0xc1, 0x90, 0x5f,
		0x70, 0xbf, 0xee, 0x21, 0x51, 0x9e, 0xcf, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xf9, 0x42, 0x8f, 0x34, 0x15, 0xae, 0x63, 0xd8,
		0x21, 0x9a, 0x57, 0xec, 0xcd, 0x76, 0xbb, 0x00  },
	{	0x15, 0xda, 0x8b, 0x44, 0x29, 0xe6, 0xb7, 0x78,
		0x6d, 0xa2, 0xf3, 0x3c, 0x51, 0x9e, 0xcf, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xd4, 0x68, 0xac, 0x10, 0x24, 0x98, 0x5c, 0xe0,
		0x34, 0x88, 0x4c, 0xf0, 0xc4, 0x78, 0xbc, 0x00  },
	{	0x15, 0xda, 0x8b, 0x44, 0x29, 0xe6, 0xb7, 0x78,
		0x6d, 0xa2, 0xf3, 0x3c, 0x51, 0x9e, 0xcf, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xdb, 0x66, 0xa1, 0x1c, 0x2f, 0x92, 0x55, 0xe8,
		0x33, 0x8e, 0x49, 0xf4, 0xc7, 0x7a, 0xbd, 0x00  },
	{	0x08, 0xc7, 0x96, 0x59, 0x34, 0xfb, 0xaa, 0x65,
		0x6d, 0xa2, 0xf3, 0x3c, 0x51, 0x9e, 0xcf, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xca, 0x74, 0xb6, 0x08, 0x32, 0x8c, 0x4e, 0xf0,
		0x3a, 0x84, 0x46, 0xf8, 0xc2, 0x7c, 0xbe, 0x00  },
	{	0x08, 0xc7, 0x96, 0x59, 0x34, 0xfb, 0xaa, 0x65,
		0x6d, 0xa2, 0xf3, 0x3c, 0x51, 0x9e, 0xcf, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x4e, 0x4e, 0x53, 0x53, 0x74, 0x74, 0x69, 0x69,
		0x27, 0x27, 0x3a, 0x3a, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xc5, 0x7a, 0xbb, 0x04, 0x39, 0x86, 0x47, 0xf8,
		0x3d, 0x82, 0x43, 0xfc, 0xc1, 0x7e, 0xbf, 0x00  },
	{	0x67, 0xfb, 0x42, 0xde, 0x2d, 0xb1, 0x08, 0x94,
		0xf3, 0x6f, 0xd6, 0x4a, 0xb9, 0x25, 0x9c, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x67, 0xfb, 0x42, 0xde, 0x2d, 0xb1, 0x08, 0x94,
		0xf3, 0x6f, 0xd6, 0x4a, 0xb9, 0x25, 0x9c, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x4f, 0x8e, 0xcd, 0x0c, 0x4b, 0x8a, 0xc9, 0x08,
		0x47, 0x86, 0xc5, 0x04, 0x43, 0x82, 0xc1, 0x00  },
	{	0x7a, 0xe6, 0x5f, 0xc3, 0x30, 0xac, 0x15, 0x89,
		0xf3, 0x6f, 0xd6, 0x4a, 0xb9, 0x25, 0x9c, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x5e, 0x9c, 0xda, 0x18, 0x56, 0x94, 0xd2, 0x10,
		0x4e, 0x8c, 0xca, 0x08, 0x46, 0x84, 0xc2, 0x00  },
	{	0x7a, 0xe6, 0x5f, 0xc3, 0x30, 0xac, 0x15, 0x89,
		0xf3, 0x6f, 0xd6, 0x4a, 0xb9, 0x25, 0x9c, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x51, 0x92, 0xd7, 0x14, 0x5d, 0x9e, 0xdb, 0x18,
		0x49, 0x8a, 0xcf, 0x0c, 0x45, 0x86, 0xc3, 0x00  },
	{	0x40, 0xdc, 0x65, 0xf9, 0x17, 0x8b, 0x32, 0xae,
		0xee, 0x72, 0xcb, 0x57, 0xb9, 0x25, 0x9c, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x7c, 0xb8, 0xf4, 0x30, 0x6c, 0xa8, 0xe4, 0x20,
		0x5c, 0x98, 0xd4, 0x10, 0x4c, 0x88, 0xc4, 0x00  },
	{	0x40, 0xdc, 0x65, 0xf9, 0x17, 0x8b, 0x32, 0xae,
		0xee, 0x72, 0xcb, 0x57, 0xb9, 0x25, 0x9c, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x73, 0xb6, 0xf9, 0x3c, 0x67, 0xa2, 0xed, 0x28,
		0x5b, 0x9e, 0xd1, 0x14, 0x4f, 0x8a, 0xc5, 0x00  },
	{	0x5d, 0xc1, 0x78, 0xe4, 0x0a, 0x96, 0x2f, 0xb3,
		0xee, 0x72, 0xcb, 0x57, 0xb9, 0x25, 0x9c, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x62, 0xa4, 0xee, 0x28, 0x7a, 0xbc, 0xf6, 0x30,
		0x52, 0x94, 0xde, 0x18, 0x4a, 0x8c, 0xc6, 0x00  },
	{	0x5d, 0xc1, 0x78, 0xe4, 0x0a, 0x96, 0x2f, 0xb3,
		0xee, 0x72, 0xcb, 0x57, 0xb9, 0x25, 0x9c, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x6d, 0xaa, 0xe3, 0x24, 0x71, 0xb6, 0xff, 0x38,
		0x55, 0x92, 0xdb, 0x1c, 0x49, 0x8e, 0xc7, 0x00  },
	{	0x34, 0xa8, 0x0c, 0x90, 0x44, 0xd8, 0x7c, 0xe0,
		0xd4, 0x48, 0xec, 0x70, 0xa4, 0x38, 0x9c, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x38, 0xf0, 0xa8, 0x60, 0x18, 0xd0, 0x88, 0x40,
		0x78, 0xb0, 0xe8, 0x20, 0x58, 0x90, 0xc8, 0x00  },
	{	0x34, 0xa8, 0x0c, 0x90, 0x44, 0xd8, 0x7c, 0xe0,
		0xd4, 0x48, 0xec, 0x70, 0xa4, 0x38, 0x9c, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x37, 0xfe, 0xa5, 0x6c, 0x13, 0xda, 0x81, 0x48,
		0x7f, 0xb6, 0xed, 0x24, 0x5b, 0x92, 0xc9, 0x00  },
	{	0x29, 0xb5, 0x11, 0x8d, 0x59, 0xc5, 0x61, 0xfd,
		0xd4, 0x48, 0xec, 0x70, 0xa4, 0x38, 0x9c, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x26, 0xec, 0xb2, 0x78, 0x0e, 0xc4, 0x9a, 0x50,
		0x76, 0xbc, 0xe2, 0x28, 0x5e, 0x94, 0xca, 0x00  },
	{	0x29, 0xb5, 0x11, 0x8d, 0x59, 0xc5, 0x61, 0xfd,
		0xd4, 0x48, 0xec, 0x70, 0xa4, 0x38, 0x9c, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x29, 0xe2, 0xbf, 0x74, 0x05, 0xce, 0x93, 0x58,
		0x71, 0xba, 0xe7, 0x2c, 0x5d, 0x96, 0xcb, 0x00  },
	{	0x13, 0x8f, 0x2b, 0xb7, 0x7e, 0xe2, 0x46, 0xda,
		0xc9, 0x55, 0xf1, 0x6d, 0xa4, 0x38, 0x9c, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x04, 0xc8, 0x9c, 0x50, 0x34, 0xf8, 0xac, 0x60,
		0x64, 0xa8, 0xfc, 0x30, 0x54, 0x98, 0xcc, 0x00  },
	{	0x13, 0x8f, 0x2b, 0xb7, 0x7e, 0xe2, 0x46, 0xda,
		0xc9, 0x55, 0xf1, 0x6d, 0xa4, 0x38, 0x9c, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x0b, 0xc6, 0x91, 0x5c, 0x3f, 0xf2, 0xa5, 0x68,
		0x63, 0xae, 0xf9, 0x34, 0x57, 0x9a, 0xcd, 0x00  },
	{	0x0e, 0x92, 0x36, 0xaa, 0x63, 0xff, 0x5b, 0xc7,
		0xc9, 0x55, 0xf1, 0x6d, 0xa4, 0x38, 0x9c, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x1a, 0xd4, 0x86, 0x48, 0x22, 0xec, 0xbe, 0x70,
		0x6a, 0xa4, 0xf6, 0x38, 0x52, 0x9c, 0xce, 0x00  },
	{	0x0e, 0x92, 0x36, 0xaa, 0x63, 0xff, 0x5b, 0xc7,
		0xc9, 0x55, 0xf1, 0x6d, 0xa4, 0x38, 0x9c, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x15, 0xda, 0x8b, 0x44, 0x29, 0xe6, 0xb7, 0x78,
		0x6d, 0xa2, 0xf3, 0x3c, 0x51, 0x9e, 0xcf, 0x00  },
	{	0xdc, 0x5d, 0xc3, 0x42, 0xe2, 0x63, 0xfd, 0x7c,
		0xa0, 0x21, 0xbf, 0x3e, 0x9e, 0x1f, 0x81, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0xdc, 0x5d, 0xc3, 0x42, 0xe2, 0x63, 0xfd, 0x7c,
		0xa0, 0x21, 0xbf, 0x3e, 0x9e, 0x1f, 0x81, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xbf, 0x6e, 0x1d, 0xcc, 0xfb, 0x2a, 0x59, 0x88,
		0x37, 0xe6, 0x95, 0x44, 0x73, 0xa2, 0xd1, 0x00  },
	{	0xc1, 0x40, 0xde, 0x5f, 0xff, 0x7e, 0xe0, 0x61,
		0xa0, 0x21, 0xbf, 0x3e, 0x9e, 0x1f, 0x81, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xae, 0x7c, 0x0a, 0xd8, 0xe6, 0x34, 0x42, 0x90,
		0x3e, 0xec, 0x9a, 0x48, 0x76, 0xa4, 0xd2, 0x00  },
	{	0xc1, 0x40, 0xde, 0x5f, 0xff, 0x7e, 0xe0, 0x61,
		0xa0, 0x21, 0xbf, 0x3e, 0x9e, 0x1f, 0x81, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xa1, 0x72, 0x07, 0xd4, 0xed, 0x3e, 0x4b, 0x98,
		0x39, 0xea, 0x9f, 0x4c, 0x75, 0xa6, 0xd3, 0x00  },
	{	0xfb, 0x7a, 0xe4, 0x65, 0xd8, 0x59, 0xc7, 0x46,
		0xbd, 0x3c, 0xa2, 0x23, 0x9e, 0x1f, 0x81, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x8c, 0x58, 0x24, 0xf0, 0xdc, 0x08, 0x74, 0xa0,
		0x2c, 0xf8, 0x84, 0x50, 0x7c, 0xa8, 0xd4, 0x00  },
	{	0xfb, 0x7a, 0xe4, 0x65, 0xd8, 0x59, 0xc7, 0x46,
		0xbd, 0x3c, 0xa2, 0x23, 0x9e, 0x1f, 0x81, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x83, 0x56, 0x29, 0xfc, 0xd7, 0x02, 0x7d, 0xa8,
		0x2b, 0xfe, 0x81, 0x54, 0x7f, 0xaa, 0xd5, 0x00  },
	{	0xe6, 0x67, 0xf9, 0x78, 0xc5, 0x44, 0xda, 0x5b,
		0xbd, 0x3c, 0xa2, 0x23, 0x9e, 0x1f, 0x81, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x92, 0x44, 0x3e, 0xe8, 0xca, 0x1c, 0x66, 0xb0,
		0x22, 0xf4, 0x8e, 0x58, 0x7a, 0xac, 0xd6, 0x00  },
	{	0xe6, 0x67, 0xf9, 0x78, 0xc5, 0x44, 0xda, 0x5b,
		0xbd, 0x3c, 0xa2, 0x23, 0x9e, 0x1f, 0x81, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x9d, 0x4a, 0x33, 0xe4, 0xc1, 0x16, 0x6f, 0xb8,
		0x25, 0xf2, 0x8b, 0x5c, 0x79, 0xae, 0xd7, 0x00  },
	{	0x8f, 0x0e, 0x8d, 0x0c, 0x8b, 0x0a, 0x89, 0x08,
		0x87, 0x06, 0x85, 0x04, 0x83, 0x02, 0x81, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xc8, 0x10, 0x78, 0xa0, 0xa8, 0x70, 0x18, 0xc0,
		0x08, 0xd0, 0xb8, 0x60, 0x68, 0xb0, 0xd8, 0x00  },
	{	0x8f, 0x0e, 0x8d, 0x0c, 0x8b, 0x0a, 0x89, 0x08,
		0x87, 0x06, 0x85, 0x04, 0x83, 0x02, 0x81, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xc7, 0x1e, 0x75, 0xac, 0xa3, 0x7a, 0x11, 0xc8,
		0x0f, 0xd6, 0xbd, 0x64, 0x6b, 0xb2, 0xd9, 0x00  },
	{	0x92, 0x13, 0x90, 0x11, 0x96, 0x17, 0x94, 0x15,
		0x87, 0x06, 0x85, 0x04, 0x83, 0x02, 0x81, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xd6, 0x0c, 0x62, 0xb8, 0xbe, 0x64, 0x0a, 0xd0,
		0x06, 0xdc, 0xb2, 0x68, 0x6e, 0xb4, 0xda, 0x00  },
	{	0x92, 0x13, 0x90, 0x11, 0x96, 0x17, 0x94, 0x15,
		0x87, 0x06, 0x85, 0x04, 0x83, 0x02, 0x81, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xd9, 0x02, 0x6f, 0xb4, 0xb5, 0x6e, 0x03, 0xd8,
		0x01, 0xda, 0xb7, 0x6c, 0x6d, 0xb6, 0xdb, 0x00  },
	{	0xa8, 0x29, 0xaa, 0x2b, 0xb1, 0x30, 0xb3, 0x32,
		0x9a, 0x1b, 0x98, 0x19, 0x83, 0x02, 0x81, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xf4, 0x28, 0x4c, 0x90, 0x84, 0x58, 0x3c, 0xe0,
		0x14, 0xc8, 0xac, 0x70, 0x64, 0xb8, 0xdc, 0x00  },
	{	0xa8, 0x29, 0xaa, 0x2b, 0xb1, 0x30, 0xb3, 0x32,
		0x9a, 0x1b, 0x98, 0x19, 0x83, 0x02, 0x81, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xfb, 0x26, 0x41, 0x9c, 0x8f, 0x52, 0x35, 0xe8,
		0x13, 0xce, 0xa9, 0x74, 0x67, 0xba, 0xdd, 0x00  },
	{	0xb5, 0x34, 0xb7, 0x36, 0xac, 0x2d, 0xae, 0x2f,
		0x9a, 0x1b, 0x98, 0x19, 0x83, 0x02, 0x81, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xea, 0x34, 0x56, 0x88, 0x92, 0x4c, 0x2e, 0xf0,
		0x1a, 0xc4, 0xa6, 0x78, 0x62, 0xbc, 0xde, 0x00  },
	{	0xb5, 0x34, 0xb7, 0x36, 0xac, 0x2d, 0xae, 0x2f,
		0x9a, 0x1b, 0x98, 0x19, 0x83, 0x02, 0x81, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x74, 0x74, 0x69, 0x69, 0x53, 0x53, 0x4e, 0x4e,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xe5, 0x3a, 0x5b, 0x84, 0x99, 0x46, 0x27, 0xf8,
		0x1d, 0xc2, 0xa3, 0x7c, 0x61, 0xbe, 0xdf, 0x00  },
	{	0x0c, 0xaa, 0x5d, 0xfb, 0xae, 0x08, 0xff, 0x59,
		0x55, 0xf3, 0x04, 0xa2, 0xf7, 0x51, 0xa6, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x0c, 0xaa, 0x5d, 0xfb, 0xae, 0x08, 0xff, 0x59,
		0x55, 0xf3, 0x04, 0xa2, 0xf7, 0x51, 0xa6, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xaf, 0x4e, 0x6d, 0x8c, 0x2b, 0xca, 0xe9, 0x08,
		0xa7, 0x46, 0x65, 0x84, 0x23, 0xc2, 0xe1, 0x00  },
	{	0x11, 0xb7, 0x40, 0xe6, 0xb3, 0x15, 0xe2, 0x44,
		0x55, 0xf3, 0x04, 0xa2, 0xf7, 0x51, 0xa6, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xbe, 0x5c, 0x7a, 0x98, 0x36, 0xd4, 0xf2, 0x10,
		0xae, 0x4c, 0x6a, 0x88, 0x26, 0xc4, 0xe2, 0x00  },
	{	0x11, 0xb7, 0x40, 0xe6, 0xb3, 0x15, 0xe2, 0x44,
		0x55, 0xf3, 0x04, 0xa2, 0xf7, 0x51, 0xa6, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xb1, 0x52, 0x77, 0x94, 0x3d, 0xde, 0xfb, 0x18,
		0xa9, 0x4a, 0x6f, 0x8c, 0x25, 0xc6, 0xe3, 0x00  },
	{	0x2b, 0x8d, 0x7a, 0xdc, 0x94, 0x32, 0xc5, 0x63,
		0x48, 0xee, 0x19, 0xbf, 0xf7, 0x51, 0xa6, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x9c, 0x78, 0x54, 0xb0, 0x0c, 0xe8, 0xc4, 0x20,
		0xbc, 0x58, 0x74, 0x90, 0x2c, 0xc8, 0xe4, 0x00  },
	{	0x2b, 0x8d, 0x7a, 0xdc, 0x94, 0x32, 0xc5, 0x63,
		0x48, 0xee, 0x19, 0xbf, 0xf7, 0x51, 0xa6, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x93, 0x76, 0x59, 0xbc, 0x07, 0xe2, 0xcd, 0x28,
		0xbb, 0x5e, 0x71, 0x94, 0x2f, 0xca, 0xe5, 0x00  },
	{	0x36, 0x90, 0x67, 0xc1, 0x89, 0x2f, 0xd8, 0x7e,
		0x48, 0xee, 0x19, 0xbf, 0xf7, 0x51, 0xa6, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x82, 0x64, 0x4e, 0xa8, 0x1a, 0xfc, 0xd6, 0x30,
		0xb2, 0x54, 0x7e, 0x98, 0x2a, 0xcc, 0xe6, 0x00  },
	{	0x36, 0x90, 0x67, 0xc1, 0x89, 0x2f, 0xd8, 0x7e,
		0x48, 0xee, 0x19, 0xbf, 0xf7, 0x51, 0xa6, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x8d, 0x6a, 0x43, 0xa4, 0x11, 0xf6, 0xdf, 0x38,
		0xb5, 0x52, 0x7b, 0x9c, 0x29, 0xce, 0xe7, 0x00  },
	{	0x5f, 0xf9, 0x13, 0xb5, 0xc7, 0x61, 0x8b, 0x2d,
		0x72, 0xd4, 0x3e, 0x98, 0xea, 0x4c, 0xa6, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xd8, 0x30, 0x08, 0xe0, 0x78, 0x90, 0xa8, 0x40,
		0x98, 0x70, 0x48, 0xa0, 0x38, 0xd0, 0xe8, 0x00  },
	{	0x5f, 0xf9, 0x13, 0xb5, 0xc7, 0x61, 0x8b, 0x2d,
		0x72, 0xd4, 0x3e, 0x98, 0xea, 0x4c, 0xa6, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xd7, 0x3e, 0x05, 0xec, 0x73, 0x9a, 0xa1, 0x48,
		0x9f, 0x76, 0x4d, 0xa4, 0x3b, 0xd2, 0xe9, 0x00  },
	{	0x42, 0xe4, 0x0e, 0xa8, 0xda, 0x7c, 0x96, 0x30,
		0x72, 0xd4, 0x3e, 0x98, 0xea, 0x4c, 0xa6, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xc6, 0x2c, 0x12, 0xf8, 0x6e, 0x84, 0xba, 0x50,
		0x96, 0x7c, 0x42, 0xa8, 0x3e, 0xd4, 0xea, 0x00  },
	{	0x42, 0xe4, 0x0e, 0xa8, 0xda, 0x7c, 0x96, 0x30,
		0x72, 0xd4, 0x3e, 0x98, 0xea, 0x4c, 0xa6, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xc9, 0x22, 0x1f, 0xf4, 0x65, 0x8e, 0xb3, 0x58,
		0x91, 0x7a, 0x47, 0xac, 0x3d, 0xd6, 0xeb, 0x00  },
	{	0x78, 0xde, 0x34, 0x92, 0xfd, 0x5b, 0xb1, 0x17,
		0x6f, 0xc9, 0x23, 0x85, 0xea, 0x4c, 0xa6, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xe4, 0x08, 0x3c, 0xd0, 0x54, 0xb8, 0x8c, 0x60,
		0x84, 0x68, 0x5c, 0xb0, 0x34, 0xd8, 0xec, 0x00  },
	{	0x78, 0xde, 0x34, 0x92, 0xfd, 0x5b, 0xb1, 0x17,
		0x6f, 0xc9, 0x23, 0x85, 0xea, 0x4c, 0xa6, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xeb, 0x06, 0x31, 0xdc, 0x5f, 0xb2, 0x85, 0x68,
		0x83, 0x6e, 0x59, 0xb4, 0x37, 0xda, 0xed, 0x00  },
	{	0x65, 0xc3, 0x29, 0x8f, 0xe0, 0x46, 0xac, 0x0a,
		0x6f, 0xc9, 0x23, 0x85, 0xea, 0x4c, 0xa6, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xfa, 0x14, 0x26, 0xc8, 0x42, 0xac, 0x9e, 0x70,
		0x8a, 0x64, 0x56, 0xb8, 0x32, 0xdc, 0xee, 0x00  },
	{	0x65, 0xc3, 0x29, 0x8f, 0xe0, 0x46, 0xac, 0x0a,
		0x6f, 0xc9, 0x23, 0x85, 0xea, 0x4c, 0xa6, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0xf5, 0x1a, 0x2b, 0xc4, 0x49, 0xa6, 0x97, 0x78,
		0x8d, 0x62, 0x53, 0xbc, 0x31, 0xde, 0xef, 0x00  },
	{	0xb7, 0x0c, 0xdc, 0x67, 0x61, 0xda, 0x0a, 0xb1,
		0x06, 0xbd, 0x6d, 0xd6, 0xd0, 0x6b, 0xbb, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0xb7, 0x0c, 0xdc, 0x67, 0x61, 0xda, 0x0a, 0xb1,
		0x06, 0xbd, 0x6d, 0xd6, 0xd0, 0x6b, 0xbb, 0x00  },
	{	0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
		0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x5f, 0xae, 0xbd, 0x4c, 0x9b, 0x6a, 0x79, 0x88,
		0xd7, 0x26, 0x35, 0xc4, 0x13, 0xe2, 0xf1, 0x00  },
	{	0xaa, 0x11, 0xc1, 0x7a, 0x7c, 0xc7, 0x17, 0xac,
		0x06, 0xbd, 0x6d, 0xd6, 0xd0, 0x6b, 0xbb, 0x00  },
	{	0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00,
		0xe0, 0xc0, 0xa0, 0x80, 0x60, 0x40, 0x20, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x4e, 0xbc, 0xaa, 0x58, 0x86, 0x74, 0x62, 0x90,
		0xde, 0x2c, 0x3a, 0xc8, 0x16, 0xe4, 0xf2, 0x00  },
	{	0xaa, 0x11, 0xc1, 0x7a, 0x7c, 0xc7, 0x17, 0xac,
		0x06, 0xbd, 0x6d, 0xd6, 0xd0, 0x6b, 0xbb, 0x00  },
	{	0x10, 0x20, 0x70, 0x40, 0xd0, 0xe0, 0xb0, 0x80,
		0x90, 0xa0, 0xf0, 0xc0, 0x50, 0x60, 0x30, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x41, 0xb2, 0xa7, 0x54, 0x8d, 0x7e, 0x6b, 0x98,
		0xd9, 0x2a, 0x3f, 0xcc, 0x15, 0xe6, 0xf3, 0x00  },
	{	0x90, 0x2b, 0xfb, 0x40, 0x5b, 0xe0, 0x30, 0x8b,
		0x1b, 0xa0, 0x70, 0xcb, 0xd0, 0x6b, 0xbb, 0x00  },
	{	0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00,
		0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x6c, 0x98, 0x84, 0x70, 0xbc, 0x48, 0x54, 0xa0,
		0xcc, 0x38, 0x24, 0xd0, 0x1c, 0xe8, 0xf4, 0x00  },
	{	0x90, 0x2b, 0xfb, 0x40, 0x5b, 0xe0, 0x30, 0x8b,
		0x1b, 0xa0, 0x70, 0xcb, 0xd0, 0x6b, 0xbb, 0x00  },
	{	0x30, 0x60, 0x90, 0xc0, 0x70, 0x20, 0xd0, 0x80,
		0xb0, 0xe0, 0x10, 0x40, 0xf0, 0xa0, 0x50, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x63, 0x96, 0x89, 0x7c, 0xb7, 0x42, 0x5d, 0xa8,
		0xcb, 0x3e, 0x21, 0xd4, 0x1f, 0xea, 0xf5, 0x00  },
	{	0x8d, 0x36, 0xe6, 0x5d, 0x46, 0xfd, 0x2d, 0x96,
		0x1b, 0xa0, 0x70, 0xcb, 0xd0, 0x6b, 0xbb, 0x00  },
	{	0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00,
		0x20, 0x40, 0xe0, 0x80, 0xa0, 0xc0, 0x60, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x72, 0x84, 0x9e, 0x68, 0xaa, 0x5c, 0x46, 0xb0,
		0xc2, 0x34, 0x2e, 0xd8, 0x1a, 0xec, 0xf6, 0x00  },
	{	0x8d, 0x36, 0xe6, 0x5d, 0x46, 0xfd, 0x2d, 0x96,
		0x1b, 0xa0, 0x70, 0xcb, 0xd0, 0x6b, 0xbb, 0x00  },
	{	0xd0, 0xa0, 0x30, 0x40, 0x10, 0x60, 0xf0, 0x80,
		0x50, 0x20, 0xb0, 0xc0, 0x90, 0xe0, 0x70, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x7d, 0x8a, 0x93, 0x64, 0xa1, 0x56, 0x4f, 0xb8,
		0xc5, 0x32, 0x2b, 0xdc, 0x19, 0xee, 0xf7, 0x00  },
	{	0xe4, 0x5f, 0x92, 0x29, 0x08, 0xb3, 0x7e, 0xc5,
		0x21, 0x9a, 0x57, 0xec, 0xcd, 0x76, 0xbb, 0x00  },
	{	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00,
		0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x28, 0xd0, 0xd8, 0x20, 0xc8, 0x30, 0x38, 0xc0,
		0xe8, 0x10, 0x18, 0xe0, 0x08, 0xf0, 0xf8, 0x00  },
	{	0xe4, 0x5f, 0x92, 0x29, 0x08, 0xb3, 0x7e, 0xc5,
		0x21, 0x9a, 0x57, 0xec, 0xcd, 0x76, 0xbb, 0x00  },
	{	0x70, 0xe0, 0x50, 0xc0, 0x30, 0xa0, 0x10, 0x80,
		0xf0, 0x60, 0xd0, 0x40, 0xb0, 0x20, 0x90, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x27, 0xde, 0xd5, 0x2c, 0xc3, 0x3a, 0x31, 0xc8,
		0xef, 0x16, 0x1d, 0xe4, 0x0b, 0xf2, 0xf9, 0x00  },
	{	0xf9, 0x42, 0x8f, 0x34, 0x15, 0xae, 0x63, 0xd8,
		0x21, 0x9a, 0x57, 0xec, 0xcd, 0x76, 0xbb, 0x00  },
	{	0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00,
		0x60, 0xc0, 0x20, 0x80, 0xe0, 0x40, 0xa0, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x36, 0xcc, 0xc2, 0x38, 0xde, 0x24, 0x2a, 0xd0,
		0xe6, 0x1c, 0x12, 0xe8, 0x0e, 0xf4, 0xfa, 0x00  },
	{	0xf9, 0x42, 0x8f, 0x34, 0x15, 0xae, 0x63, 0xd8,
		0x21, 0x9a, 0x57, 0xec, 0xcd, 0x76, 0xbb, 0x00  },
	{	0x90, 0x20, 0xf0, 0x40, 0x50, 0xe0, 0x30, 0x80,
		0x10, 0xa0, 0x70, 0xc0, 0xd0, 0x60, 0xb0, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x39, 0xc2, 0xcf, 0x34, 0xd5, 0x2e, 0x23, 0xd8,
		0xe1, 0x1a, 0x17, 0xec, 0x0d, 0xf6, 0xfb, 0x00  },
	{	0xc3, 0x78, 0xb5, 0x0e, 0x32, 0x89, 0x44, 0xff,
		0x3c, 0x87, 0x4a, 0xf1, 0xcd, 0x76, 0xbb, 0x00  },
	{	0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00,
		0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x14, 0xe8, 0xec, 0x10, 0xe4, 0x18, 0x1c, 0xe0,
		0xf4, 0x08, 0x0c, 0xf0, 0x04, 0xf8, 0xfc, 0x00  },
	{	0xc3, 0x78, 0xb5, 0x0e, 0x32, 0x89, 0x44, 0xff,
		0x3c, 0x87, 0x4a, 0xf1, 0xcd, 0x76, 0xbb, 0x00  },
	{	0xb0, 0x60, 0x10, 0xc0, 0xf0, 0x20, 0x50, 0x80,
		0x30, 0xe0, 0x90, 0x40, 0x70, 0xa0, 0xd0, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x1b, 0xe6, 0xe1, 0x1c, 0xef, 0x12, 0x15, 0xe8,
		0xf3, 0x0e, 0x09, 0xf4, 0x07, 0xfa, 0xfd, 0x00  },
	{	0xde, 0x65, 0xa8, 0x13, 0x2f, 0x94, 0x59, 0xe2,
		0x3c, 0x87, 0x4a, 0xf1, 0xcd, 0x76, 0xbb, 0x00  },
	{	0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00,
		0xa0, 0x40, 0x60, 0x80, 0x20, 0xc0, 0xe0, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x0a, 0xf4, 0xf6, 0x08, 0xf2, 0x0c, 0x0e, 0xf0,
		0xfa, 0x04, 0x06, 0xf8, 0x02, 0xfc, 0xfe, 0x00  },
	{	0xde, 0x65, 0xa8, 0x13, 0x2f, 0x94, 0x59, 0xe2,
		0x3c, 0x87, 0x4a, 0xf1, 0xcd, 0x76, 0xbb, 0x00  },
	{	0x50, 0xa0, 0xb0, 0x40, 0x90, 0x60, 0x70, 0x80,
		0xd0, 0x20, 0x30, 0xc0, 0x10, 0xe0, 0xf0, 0x00  },
	{	0x69, 0x69, 0x74, 0x74, 0x4e, 0x4e, 0x53, 0x53,
		0x3a, 0x3a, 0x27, 0x27, 0x1d, 0x1d, 0x00, 0x00  },
	{	0x05, 0xfa, 0xfb, 0x04, 0xf9, 0x06, 0x07, 0xf8,
		0xfd, 0x02, 0x03, 0xfc, 0x01, 0xfe, 0xff, 0x00  }
};
/* END CSTYLED */
#else
/* BEGIN CSTYLED */
const uint8_t
__attribute__((aligned(256))) gf_clmul_mod_lt[4*256][16] = {
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
		0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x02, 0x04, 0x06, 0x08, 0x0a, 0x0c, 0x0e,
		0x10, 0x12, 0x14, 0x16, 0x18, 0x1a, 0x1c, 0x1e  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x03, 0x06, 0x05, 0x0c, 0x0f, 0x0a, 0x09,
		0x18, 0x1b, 0x1e, 0x1d, 0x14, 0x17, 0x12, 0x11  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c,
		0x20, 0x24, 0x28, 0x2c, 0x30, 0x34, 0x38, 0x3c  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x05, 0x0a, 0x0f, 0x14, 0x11, 0x1e, 0x1b,
		0x28, 0x2d, 0x22, 0x27, 0x3c, 0x39, 0x36, 0x33  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x06, 0x0c, 0x0a, 0x18, 0x1e, 0x14, 0x12,
		0x30, 0x36, 0x3c, 0x3a, 0x28, 0x2e, 0x24, 0x22  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x07, 0x0e, 0x09, 0x1c, 0x1b, 0x12, 0x15,
		0x38, 0x3f, 0x36, 0x31, 0x24, 0x23, 0x2a, 0x2d  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38,
		0x40, 0x48, 0x50, 0x58, 0x60, 0x68, 0x70, 0x78  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x09, 0x12, 0x1b, 0x24, 0x2d, 0x36, 0x3f,
		0x48, 0x41, 0x5a, 0x53, 0x6c, 0x65, 0x7e, 0x77  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x0a, 0x14, 0x1e, 0x28, 0x22, 0x3c, 0x36,
		0x50, 0x5a, 0x44, 0x4e, 0x78, 0x72, 0x6c, 0x66  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x0b, 0x16, 0x1d, 0x2c, 0x27, 0x3a, 0x31,
		0x58, 0x53, 0x4e, 0x45, 0x74, 0x7f, 0x62, 0x69  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x0c, 0x18, 0x14, 0x30, 0x3c, 0x28, 0x24,
		0x60, 0x6c, 0x78, 0x74, 0x50, 0x5c, 0x48, 0x44  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x0d, 0x1a, 0x17, 0x34, 0x39, 0x2e, 0x23,
		0x68, 0x65, 0x72, 0x7f, 0x5c, 0x51, 0x46, 0x4b  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x0e, 0x1c, 0x12, 0x38, 0x36, 0x24, 0x2a,
		0x70, 0x7e, 0x6c, 0x62, 0x48, 0x46, 0x54, 0x5a  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x0f, 0x1e, 0x11, 0x3c, 0x33, 0x22, 0x2d,
		0x78, 0x77, 0x66, 0x69, 0x44, 0x4b, 0x5a, 0x55  },
	{	0x00, 0x1d, 0x3a, 0x27, 0x74, 0x69, 0x4e, 0x53,
		0xe8, 0xf5, 0xd2, 0xcf, 0x9c, 0x81, 0xa6, 0xbb  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x1d, 0x3a, 0x27, 0x74, 0x69, 0x4e, 0x53,
		0xe8, 0xf5, 0xd2, 0xcf, 0x9c, 0x81, 0xa6, 0xbb  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,
		0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff  },
	{	0x00, 0x1d, 0x3a, 0x27, 0x74, 0x69, 0x4e, 0x53,
		0xf5, 0xe8, 0xcf, 0xd2, 0x81, 0x9c, 0xbb, 0xa6  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x12, 0x24, 0x36, 0x48, 0x5a, 0x6c, 0x7e,
		0x90, 0x82, 0xb4, 0xa6, 0xd8, 0xca, 0xfc, 0xee  },
	{	0x00, 0x1d, 0x3a, 0x27, 0x74, 0x69, 0x4e, 0x53,
		0xf5, 0xe8, 0xcf, 0xd2, 0x81, 0x9c, 0xbb, 0xa6  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x13, 0x26, 0x35, 0x4c, 0x5f, 0x6a, 0x79,
		0x98, 0x8b, 0xbe, 0xad, 0xd4, 0xc7, 0xf2, 0xe1  },
	{	0x00, 0x1d, 0x3a, 0x27, 0x69, 0x74, 0x53, 0x4e,
		0xd2, 0xcf, 0xe8, 0xf5, 0xbb, 0xa6, 0x81, 0x9c  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x14, 0x28, 0x3c, 0x50, 0x44, 0x78, 0x6c,
		0xa0, 0xb4, 0x88, 0x9c, 0xf0, 0xe4, 0xd8, 0xcc  },
	{	0x00, 0x1d, 0x3a, 0x27, 0x69, 0x74, 0x53, 0x4e,
		0xd2, 0xcf, 0xe8, 0xf5, 0xbb, 0xa6, 0x81, 0x9c  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x15, 0x2a, 0x3f, 0x54, 0x41, 0x7e, 0x6b,
		0xa8, 0xbd, 0x82, 0x97, 0xfc, 0xe9, 0xd6, 0xc3  },
	{	0x00, 0x1d, 0x3a, 0x27, 0x69, 0x74, 0x53, 0x4e,
		0xcf, 0xd2, 0xf5, 0xe8, 0xa6, 0xbb, 0x9c, 0x81  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x16, 0x2c, 0x3a, 0x58, 0x4e, 0x74, 0x62,
		0xb0, 0xa6, 0x9c, 0x8a, 0xe8, 0xfe, 0xc4, 0xd2  },
	{	0x00, 0x1d, 0x3a, 0x27, 0x69, 0x74, 0x53, 0x4e,
		0xcf, 0xd2, 0xf5, 0xe8, 0xa6, 0xbb, 0x9c, 0x81  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x17, 0x2e, 0x39, 0x5c, 0x4b, 0x72, 0x65,
		0xb8, 0xaf, 0x96, 0x81, 0xe4, 0xf3, 0xca, 0xdd  },
	{	0x00, 0x1d, 0x27, 0x3a, 0x4e, 0x53, 0x69, 0x74,
		0x9c, 0x81, 0xbb, 0xa6, 0xd2, 0xcf, 0xf5, 0xe8  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x18, 0x30, 0x28, 0x60, 0x78, 0x50, 0x48,
		0xc0, 0xd8, 0xf0, 0xe8, 0xa0, 0xb8, 0x90, 0x88  },
	{	0x00, 0x1d, 0x27, 0x3a, 0x4e, 0x53, 0x69, 0x74,
		0x9c, 0x81, 0xbb, 0xa6, 0xd2, 0xcf, 0xf5, 0xe8  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x19, 0x32, 0x2b, 0x64, 0x7d, 0x56, 0x4f,
		0xc8, 0xd1, 0xfa, 0xe3, 0xac, 0xb5, 0x9e, 0x87  },
	{	0x00, 0x1d, 0x27, 0x3a, 0x4e, 0x53, 0x69, 0x74,
		0x81, 0x9c, 0xa6, 0xbb, 0xcf, 0xd2, 0xe8, 0xf5  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x1a, 0x34, 0x2e, 0x68, 0x72, 0x5c, 0x46,
		0xd0, 0xca, 0xe4, 0xfe, 0xb8, 0xa2, 0x8c, 0x96  },
	{	0x00, 0x1d, 0x27, 0x3a, 0x4e, 0x53, 0x69, 0x74,
		0x81, 0x9c, 0xa6, 0xbb, 0xcf, 0xd2, 0xe8, 0xf5  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x1b, 0x36, 0x2d, 0x6c, 0x77, 0x5a, 0x41,
		0xd8, 0xc3, 0xee, 0xf5, 0xb4, 0xaf, 0x82, 0x99  },
	{	0x00, 0x1d, 0x27, 0x3a, 0x53, 0x4e, 0x74, 0x69,
		0xa6, 0xbb, 0x81, 0x9c, 0xf5, 0xe8, 0xd2, 0xcf  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x1c, 0x38, 0x24, 0x70, 0x6c, 0x48, 0x54,
		0xe0, 0xfc, 0xd8, 0xc4, 0x90, 0x8c, 0xa8, 0xb4  },
	{	0x00, 0x1d, 0x27, 0x3a, 0x53, 0x4e, 0x74, 0x69,
		0xa6, 0xbb, 0x81, 0x9c, 0xf5, 0xe8, 0xd2, 0xcf  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x1d, 0x3a, 0x27, 0x74, 0x69, 0x4e, 0x53,
		0xe8, 0xf5, 0xd2, 0xcf, 0x9c, 0x81, 0xa6, 0xbb  },
	{	0x00, 0x1d, 0x27, 0x3a, 0x53, 0x4e, 0x74, 0x69,
		0xbb, 0xa6, 0x9c, 0x81, 0xe8, 0xf5, 0xcf, 0xd2  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x1e, 0x3c, 0x22, 0x78, 0x66, 0x44, 0x5a,
		0xf0, 0xee, 0xcc, 0xd2, 0x88, 0x96, 0xb4, 0xaa  },
	{	0x00, 0x1d, 0x27, 0x3a, 0x53, 0x4e, 0x74, 0x69,
		0xbb, 0xa6, 0x9c, 0x81, 0xe8, 0xf5, 0xcf, 0xd2  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x1f, 0x3e, 0x21, 0x7c, 0x63, 0x42, 0x5d,
		0xf8, 0xe7, 0xc6, 0xd9, 0x84, 0x9b, 0xba, 0xa5  },
	{	0x00, 0x3a, 0x74, 0x4e, 0xe8, 0xd2, 0x9c, 0xa6,
		0xcd, 0xf7, 0xb9, 0x83, 0x25, 0x1f, 0x51, 0x6b  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x3a, 0x74, 0x4e, 0xe8, 0xd2, 0x9c, 0xa6,
		0xcd, 0xf7, 0xb9, 0x83, 0x25, 0x1f, 0x51, 0x6b  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x21, 0x42, 0x63, 0x84, 0xa5, 0xc6, 0xe7,
		0x08, 0x29, 0x4a, 0x6b, 0x8c, 0xad, 0xce, 0xef  },
	{	0x00, 0x3a, 0x74, 0x4e, 0xe8, 0xd2, 0x9c, 0xa6,
		0xd0, 0xea, 0xa4, 0x9e, 0x38, 0x02, 0x4c, 0x76  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x22, 0x44, 0x66, 0x88, 0xaa, 0xcc, 0xee,
		0x10, 0x32, 0x54, 0x76, 0x98, 0xba, 0xdc, 0xfe  },
	{	0x00, 0x3a, 0x74, 0x4e, 0xe8, 0xd2, 0x9c, 0xa6,
		0xd0, 0xea, 0xa4, 0x9e, 0x38, 0x02, 0x4c, 0x76  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x23, 0x46, 0x65, 0x8c, 0xaf, 0xca, 0xe9,
		0x18, 0x3b, 0x5e, 0x7d, 0x94, 0xb7, 0xd2, 0xf1  },
	{	0x00, 0x3a, 0x74, 0x4e, 0xf5, 0xcf, 0x81, 0xbb,
		0xf7, 0xcd, 0x83, 0xb9, 0x02, 0x38, 0x76, 0x4c  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x24, 0x48, 0x6c, 0x90, 0xb4, 0xd8, 0xfc,
		0x20, 0x04, 0x68, 0x4c, 0xb0, 0x94, 0xf8, 0xdc  },
	{	0x00, 0x3a, 0x74, 0x4e, 0xf5, 0xcf, 0x81, 0xbb,
		0xf7, 0xcd, 0x83, 0xb9, 0x02, 0x38, 0x76, 0x4c  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x25, 0x4a, 0x6f, 0x94, 0xb1, 0xde, 0xfb,
		0x28, 0x0d, 0x62, 0x47, 0xbc, 0x99, 0xf6, 0xd3  },
	{	0x00, 0x3a, 0x74, 0x4e, 0xf5, 0xcf, 0x81, 0xbb,
		0xea, 0xd0, 0x9e, 0xa4, 0x1f, 0x25, 0x6b, 0x51  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x26, 0x4c, 0x6a, 0x98, 0xbe, 0xd4, 0xf2,
		0x30, 0x16, 0x7c, 0x5a, 0xa8, 0x8e, 0xe4, 0xc2  },
	{	0x00, 0x3a, 0x74, 0x4e, 0xf5, 0xcf, 0x81, 0xbb,
		0xea, 0xd0, 0x9e, 0xa4, 0x1f, 0x25, 0x6b, 0x51  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x27, 0x4e, 0x69, 0x9c, 0xbb, 0xd2, 0xf5,
		0x38, 0x1f, 0x76, 0x51, 0xa4, 0x83, 0xea, 0xcd  },
	{	0x00, 0x3a, 0x69, 0x53, 0xd2, 0xe8, 0xbb, 0x81,
		0xb9, 0x83, 0xd0, 0xea, 0x6b, 0x51, 0x02, 0x38  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x28, 0x50, 0x78, 0xa0, 0x88, 0xf0, 0xd8,
		0x40, 0x68, 0x10, 0x38, 0xe0, 0xc8, 0xb0, 0x98  },
	{	0x00, 0x3a, 0x69, 0x53, 0xd2, 0xe8, 0xbb, 0x81,
		0xb9, 0x83, 0xd0, 0xea, 0x6b, 0x51, 0x02, 0x38  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x29, 0x52, 0x7b, 0xa4, 0x8d, 0xf6, 0xdf,
		0x48, 0x61, 0x1a, 0x33, 0xec, 0xc5, 0xbe, 0x97  },
	{	0x00, 0x3a, 0x69, 0x53, 0xd2, 0xe8, 0xbb, 0x81,
		0xa4, 0x9e, 0xcd, 0xf7, 0x76, 0x4c, 0x1f, 0x25  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x2a, 0x54, 0x7e, 0xa8, 0x82, 0xfc, 0xd6,
		0x50, 0x7a, 0x04, 0x2e, 0xf8, 0xd2, 0xac, 0x86  },
	{	0x00, 0x3a, 0x69, 0x53, 0xd2, 0xe8, 0xbb, 0x81,
		0xa4, 0x9e, 0xcd, 0xf7, 0x76, 0x4c, 0x1f, 0x25  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x2b, 0x56, 0x7d, 0xac, 0x87, 0xfa, 0xd1,
		0x58, 0x73, 0x0e, 0x25, 0xf4, 0xdf, 0xa2, 0x89  },
	{	0x00, 0x3a, 0x69, 0x53, 0xcf, 0xf5, 0xa6, 0x9c,
		0x83, 0xb9, 0xea, 0xd0, 0x4c, 0x76, 0x25, 0x1f  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x2c, 0x58, 0x74, 0xb0, 0x9c, 0xe8, 0xc4,
		0x60, 0x4c, 0x38, 0x14, 0xd0, 0xfc, 0x88, 0xa4  },
	{	0x00, 0x3a, 0x69, 0x53, 0xcf, 0xf5, 0xa6, 0x9c,
		0x83, 0xb9, 0xea, 0xd0, 0x4c, 0x76, 0x25, 0x1f  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x2d, 0x5a, 0x77, 0xb4, 0x99, 0xee, 0xc3,
		0x68, 0x45, 0x32, 0x1f, 0xdc, 0xf1, 0x86, 0xab  },
	{	0x00, 0x3a, 0x69, 0x53, 0xcf, 0xf5, 0xa6, 0x9c,
		0x9e, 0xa4, 0xf7, 0xcd, 0x51, 0x6b, 0x38, 0x02  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x2e, 0x5c, 0x72, 0xb8, 0x96, 0xe4, 0xca,
		0x70, 0x5e, 0x2c, 0x02, 0xc8, 0xe6, 0x94, 0xba  },
	{	0x00, 0x3a, 0x69, 0x53, 0xcf, 0xf5, 0xa6, 0x9c,
		0x9e, 0xa4, 0xf7, 0xcd, 0x51, 0x6b, 0x38, 0x02  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x2f, 0x5e, 0x71, 0xbc, 0x93, 0xe2, 0xcd,
		0x78, 0x57, 0x26, 0x09, 0xc4, 0xeb, 0x9a, 0xb5  },
	{	0x00, 0x27, 0x4e, 0x69, 0x9c, 0xbb, 0xd2, 0xf5,
		0x25, 0x02, 0x6b, 0x4c, 0xb9, 0x9e, 0xf7, 0xd0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x27, 0x4e, 0x69, 0x9c, 0xbb, 0xd2, 0xf5,
		0x25, 0x02, 0x6b, 0x4c, 0xb9, 0x9e, 0xf7, 0xd0  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x31, 0x62, 0x53, 0xc4, 0xf5, 0xa6, 0x97,
		0x88, 0xb9, 0xea, 0xdb, 0x4c, 0x7d, 0x2e, 0x1f  },
	{	0x00, 0x27, 0x4e, 0x69, 0x9c, 0xbb, 0xd2, 0xf5,
		0x38, 0x1f, 0x76, 0x51, 0xa4, 0x83, 0xea, 0xcd  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x32, 0x64, 0x56, 0xc8, 0xfa, 0xac, 0x9e,
		0x90, 0xa2, 0xf4, 0xc6, 0x58, 0x6a, 0x3c, 0x0e  },
	{	0x00, 0x27, 0x4e, 0x69, 0x9c, 0xbb, 0xd2, 0xf5,
		0x38, 0x1f, 0x76, 0x51, 0xa4, 0x83, 0xea, 0xcd  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x33, 0x66, 0x55, 0xcc, 0xff, 0xaa, 0x99,
		0x98, 0xab, 0xfe, 0xcd, 0x54, 0x67, 0x32, 0x01  },
	{	0x00, 0x27, 0x4e, 0x69, 0x81, 0xa6, 0xcf, 0xe8,
		0x1f, 0x38, 0x51, 0x76, 0x9e, 0xb9, 0xd0, 0xf7  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x34, 0x68, 0x5c, 0xd0, 0xe4, 0xb8, 0x8c,
		0xa0, 0x94, 0xc8, 0xfc, 0x70, 0x44, 0x18, 0x2c  },
	{	0x00, 0x27, 0x4e, 0x69, 0x81, 0xa6, 0xcf, 0xe8,
		0x1f, 0x38, 0x51, 0x76, 0x9e, 0xb9, 0xd0, 0xf7  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x35, 0x6a, 0x5f, 0xd4, 0xe1, 0xbe, 0x8b,
		0xa8, 0x9d, 0xc2, 0xf7, 0x7c, 0x49, 0x16, 0x23  },
	{	0x00, 0x27, 0x4e, 0x69, 0x81, 0xa6, 0xcf, 0xe8,
		0x02, 0x25, 0x4c, 0x6b, 0x83, 0xa4, 0xcd, 0xea  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x36, 0x6c, 0x5a, 0xd8, 0xee, 0xb4, 0x82,
		0xb0, 0x86, 0xdc, 0xea, 0x68, 0x5e, 0x04, 0x32  },
	{	0x00, 0x27, 0x4e, 0x69, 0x81, 0xa6, 0xcf, 0xe8,
		0x02, 0x25, 0x4c, 0x6b, 0x83, 0xa4, 0xcd, 0xea  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x37, 0x6e, 0x59, 0xdc, 0xeb, 0xb2, 0x85,
		0xb8, 0x8f, 0xd6, 0xe1, 0x64, 0x53, 0x0a, 0x3d  },
	{	0x00, 0x27, 0x53, 0x74, 0xa6, 0x81, 0xf5, 0xd2,
		0x51, 0x76, 0x02, 0x25, 0xf7, 0xd0, 0xa4, 0x83  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x38, 0x70, 0x48, 0xe0, 0xd8, 0x90, 0xa8,
		0xc0, 0xf8, 0xb0, 0x88, 0x20, 0x18, 0x50, 0x68  },
	{	0x00, 0x27, 0x53, 0x74, 0xa6, 0x81, 0xf5, 0xd2,
		0x51, 0x76, 0x02, 0x25, 0xf7, 0xd0, 0xa4, 0x83  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x39, 0x72, 0x4b, 0xe4, 0xdd, 0x96, 0xaf,
		0xc8, 0xf1, 0xba, 0x83, 0x2c, 0x15, 0x5e, 0x67  },
	{	0x00, 0x27, 0x53, 0x74, 0xa6, 0x81, 0xf5, 0xd2,
		0x4c, 0x6b, 0x1f, 0x38, 0xea, 0xcd, 0xb9, 0x9e  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x3a, 0x74, 0x4e, 0xe8, 0xd2, 0x9c, 0xa6,
		0xd0, 0xea, 0xa4, 0x9e, 0x38, 0x02, 0x4c, 0x76  },
	{	0x00, 0x27, 0x53, 0x74, 0xa6, 0x81, 0xf5, 0xd2,
		0x4c, 0x6b, 0x1f, 0x38, 0xea, 0xcd, 0xb9, 0x9e  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x3b, 0x76, 0x4d, 0xec, 0xd7, 0x9a, 0xa1,
		0xd8, 0xe3, 0xae, 0x95, 0x34, 0x0f, 0x42, 0x79  },
	{	0x00, 0x27, 0x53, 0x74, 0xbb, 0x9c, 0xe8, 0xcf,
		0x6b, 0x4c, 0x38, 0x1f, 0xd0, 0xf7, 0x83, 0xa4  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x3c, 0x78, 0x44, 0xf0, 0xcc, 0x88, 0xb4,
		0xe0, 0xdc, 0x98, 0xa4, 0x10, 0x2c, 0x68, 0x54  },
	{	0x00, 0x27, 0x53, 0x74, 0xbb, 0x9c, 0xe8, 0xcf,
		0x6b, 0x4c, 0x38, 0x1f, 0xd0, 0xf7, 0x83, 0xa4  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x3d, 0x7a, 0x47, 0xf4, 0xc9, 0x8e, 0xb3,
		0xe8, 0xd5, 0x92, 0xaf, 0x1c, 0x21, 0x66, 0x5b  },
	{	0x00, 0x27, 0x53, 0x74, 0xbb, 0x9c, 0xe8, 0xcf,
		0x76, 0x51, 0x25, 0x02, 0xcd, 0xea, 0x9e, 0xb9  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x3e, 0x7c, 0x42, 0xf8, 0xc6, 0x84, 0xba,
		0xf0, 0xce, 0x8c, 0xb2, 0x08, 0x36, 0x74, 0x4a  },
	{	0x00, 0x27, 0x53, 0x74, 0xbb, 0x9c, 0xe8, 0xcf,
		0x76, 0x51, 0x25, 0x02, 0xcd, 0xea, 0x9e, 0xb9  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d  },
	{	0x00, 0x3f, 0x7e, 0x41, 0xfc, 0xc3, 0x82, 0xbd,
		0xf8, 0xc7, 0x86, 0xb9, 0x04, 0x3b, 0x7a, 0x45  },
	{	0x00, 0x74, 0xe8, 0x9c, 0xcd, 0xb9, 0x25, 0x51,
		0x87, 0xf3, 0x6f, 0x1b, 0x4a, 0x3e, 0xa2, 0xd6  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x74, 0xe8, 0x9c, 0xcd, 0xb9, 0x25, 0x51,
		0x87, 0xf3, 0x6f, 0x1b, 0x4a, 0x3e, 0xa2, 0xd6  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x41, 0x82, 0xc3, 0x04, 0x45, 0x86, 0xc7,
		0x08, 0x49, 0x8a, 0xcb, 0x0c, 0x4d, 0x8e, 0xcf  },
	{	0x00, 0x74, 0xe8, 0x9c, 0xcd, 0xb9, 0x25, 0x51,
		0x9a, 0xee, 0x72, 0x06, 0x57, 0x23, 0xbf, 0xcb  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x42, 0x84, 0xc6, 0x08, 0x4a, 0x8c, 0xce,
		0x10, 0x52, 0x94, 0xd6, 0x18, 0x5a, 0x9c, 0xde  },
	{	0x00, 0x74, 0xe8, 0x9c, 0xcd, 0xb9, 0x25, 0x51,
		0x9a, 0xee, 0x72, 0x06, 0x57, 0x23, 0xbf, 0xcb  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x43, 0x86, 0xc5, 0x0c, 0x4f, 0x8a, 0xc9,
		0x18, 0x5b, 0x9e, 0xdd, 0x14, 0x57, 0x92, 0xd1  },
	{	0x00, 0x74, 0xe8, 0x9c, 0xd0, 0xa4, 0x38, 0x4c,
		0xbd, 0xc9, 0x55, 0x21, 0x6d, 0x19, 0x85, 0xf1  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x44, 0x88, 0xcc, 0x10, 0x54, 0x98, 0xdc,
		0x20, 0x64, 0xa8, 0xec, 0x30, 0x74, 0xb8, 0xfc  },
	{	0x00, 0x74, 0xe8, 0x9c, 0xd0, 0xa4, 0x38, 0x4c,
		0xbd, 0xc9, 0x55, 0x21, 0x6d, 0x19, 0x85, 0xf1  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x45, 0x8a, 0xcf, 0x14, 0x51, 0x9e, 0xdb,
		0x28, 0x6d, 0xa2, 0xe7, 0x3c, 0x79, 0xb6, 0xf3  },
	{	0x00, 0x74, 0xe8, 0x9c, 0xd0, 0xa4, 0x38, 0x4c,
		0xa0, 0xd4, 0x48, 0x3c, 0x70, 0x04, 0x98, 0xec  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x46, 0x8c, 0xca, 0x18, 0x5e, 0x94, 0xd2,
		0x30, 0x76, 0xbc, 0xfa, 0x28, 0x6e, 0xa4, 0xe2  },
	{	0x00, 0x74, 0xe8, 0x9c, 0xd0, 0xa4, 0x38, 0x4c,
		0xa0, 0xd4, 0x48, 0x3c, 0x70, 0x04, 0x98, 0xec  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x47, 0x8e, 0xc9, 0x1c, 0x5b, 0x92, 0xd5,
		0x38, 0x7f, 0xb6, 0xf1, 0x24, 0x63, 0xaa, 0xed  },
	{	0x00, 0x74, 0xf5, 0x81, 0xf7, 0x83, 0x02, 0x76,
		0xf3, 0x87, 0x06, 0x72, 0x04, 0x70, 0xf1, 0x85  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x48, 0x90, 0xd8, 0x20, 0x68, 0xb0, 0xf8,
		0x40, 0x08, 0xd0, 0x98, 0x60, 0x28, 0xf0, 0xb8  },
	{	0x00, 0x74, 0xf5, 0x81, 0xf7, 0x83, 0x02, 0x76,
		0xf3, 0x87, 0x06, 0x72, 0x04, 0x70, 0xf1, 0x85  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x49, 0x92, 0xdb, 0x24, 0x6d, 0xb6, 0xff,
		0x48, 0x01, 0xda, 0x93, 0x6c, 0x25, 0xfe, 0xb7  },
	{	0x00, 0x74, 0xf5, 0x81, 0xf7, 0x83, 0x02, 0x76,
		0xee, 0x9a, 0x1b, 0x6f, 0x19, 0x6d, 0xec, 0x98  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x4a, 0x94, 0xde, 0x28, 0x62, 0xbc, 0xf6,
		0x50, 0x1a, 0xc4, 0x8e, 0x78, 0x32, 0xec, 0xa6  },
	{	0x00, 0x74, 0xf5, 0x81, 0xf7, 0x83, 0x02, 0x76,
		0xee, 0x9a, 0x1b, 0x6f, 0x19, 0x6d, 0xec, 0x98  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x4b, 0x96, 0xdd, 0x2c, 0x67, 0xba, 0xf1,
		0x58, 0x13, 0xce, 0x85, 0x74, 0x3f, 0xe2, 0xa9  },
	{	0x00, 0x74, 0xf5, 0x81, 0xea, 0x9e, 0x1f, 0x6b,
		0xc9, 0xbd, 0x3c, 0x48, 0x23, 0x57, 0xd6, 0xa2  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x4c, 0x98, 0xd4, 0x30, 0x7c, 0xa8, 0xe4,
		0x60, 0x2c, 0xf8, 0xb4, 0x50, 0x1c, 0xc8, 0x84  },
	{	0x00, 0x74, 0xf5, 0x81, 0xea, 0x9e, 0x1f, 0x6b,
		0xc9, 0xbd, 0x3c, 0x48, 0x23, 0x57, 0xd6, 0xa2  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x4d, 0x9a, 0xd7, 0x34, 0x79, 0xae, 0xe3,
		0x68, 0x25, 0xf2, 0xbf, 0x5c, 0x11, 0xc6, 0x8b  },
	{	0x00, 0x74, 0xf5, 0x81, 0xea, 0x9e, 0x1f, 0x6b,
		0xd4, 0xa0, 0x21, 0x55, 0x3e, 0x4a, 0xcb, 0xbf  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x4e, 0x9c, 0xd2, 0x38, 0x76, 0xa4, 0xea,
		0x70, 0x3e, 0xec, 0xa2, 0x48, 0x06, 0xd4, 0x9a  },
	{	0x00, 0x74, 0xf5, 0x81, 0xea, 0x9e, 0x1f, 0x6b,
		0xd4, 0xa0, 0x21, 0x55, 0x3e, 0x4a, 0xcb, 0xbf  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x4f, 0x9e, 0xd1, 0x3c, 0x73, 0xa2, 0xed,
		0x78, 0x37, 0xe6, 0xa9, 0x44, 0x0b, 0xda, 0x95  },
	{	0x00, 0x69, 0xd2, 0xbb, 0xb9, 0xd0, 0x6b, 0x02,
		0x6f, 0x06, 0xbd, 0xd4, 0xd6, 0xbf, 0x04, 0x6d  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x69, 0xd2, 0xbb, 0xb9, 0xd0, 0x6b, 0x02,
		0x6f, 0x06, 0xbd, 0xd4, 0xd6, 0xbf, 0x04, 0x6d  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x51, 0xa2, 0xf3, 0x44, 0x15, 0xe6, 0xb7,
		0x88, 0xd9, 0x2a, 0x7b, 0xcc, 0x9d, 0x6e, 0x3f  },
	{	0x00, 0x69, 0xd2, 0xbb, 0xb9, 0xd0, 0x6b, 0x02,
		0x72, 0x1b, 0xa0, 0xc9, 0xcb, 0xa2, 0x19, 0x70  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x52, 0xa4, 0xf6, 0x48, 0x1a, 0xec, 0xbe,
		0x90, 0xc2, 0x34, 0x66, 0xd8, 0x8a, 0x7c, 0x2e  },
	{	0x00, 0x69, 0xd2, 0xbb, 0xb9, 0xd0, 0x6b, 0x02,
		0x72, 0x1b, 0xa0, 0xc9, 0xcb, 0xa2, 0x19, 0x70  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x53, 0xa6, 0xf5, 0x4c, 0x1f, 0xea, 0xb9,
		0x98, 0xcb, 0x3e, 0x6d, 0xd4, 0x87, 0x72, 0x21  },
	{	0x00, 0x69, 0xd2, 0xbb, 0xa4, 0xcd, 0x76, 0x1f,
		0x55, 0x3c, 0x87, 0xee, 0xf1, 0x98, 0x23, 0x4a  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x54, 0xa8, 0xfc, 0x50, 0x04, 0xf8, 0xac,
		0xa0, 0xf4, 0x08, 0x5c, 0xf0, 0xa4, 0x58, 0x0c  },
	{	0x00, 0x69, 0xd2, 0xbb, 0xa4, 0xcd, 0x76, 0x1f,
		0x55, 0x3c, 0x87, 0xee, 0xf1, 0x98, 0x23, 0x4a  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x55, 0xaa, 0xff, 0x54, 0x01, 0xfe, 0xab,
		0xa8, 0xfd, 0x02, 0x57, 0xfc, 0xa9, 0x56, 0x03  },
	{	0x00, 0x69, 0xd2, 0xbb, 0xa4, 0xcd, 0x76, 0x1f,
		0x48, 0x21, 0x9a, 0xf3, 0xec, 0x85, 0x3e, 0x57  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x56, 0xac, 0xfa, 0x58, 0x0e, 0xf4, 0xa2,
		0xb0, 0xe6, 0x1c, 0x4a, 0xe8, 0xbe, 0x44, 0x12  },
	{	0x00, 0x69, 0xd2, 0xbb, 0xa4, 0xcd, 0x76, 0x1f,
		0x48, 0x21, 0x9a, 0xf3, 0xec, 0x85, 0x3e, 0x57  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x57, 0xae, 0xf9, 0x5c, 0x0b, 0xf2, 0xa5,
		0xb8, 0xef, 0x16, 0x41, 0xe4, 0xb3, 0x4a, 0x1d  },
	{	0x00, 0x69, 0xcf, 0xa6, 0x83, 0xea, 0x4c, 0x25,
		0x1b, 0x72, 0xd4, 0xbd, 0x98, 0xf1, 0x57, 0x3e  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x58, 0xb0, 0xe8, 0x60, 0x38, 0xd0, 0x88,
		0xc0, 0x98, 0x70, 0x28, 0xa0, 0xf8, 0x10, 0x48  },
	{	0x00, 0x69, 0xcf, 0xa6, 0x83, 0xea, 0x4c, 0x25,
		0x1b, 0x72, 0xd4, 0xbd, 0x98, 0xf1, 0x57, 0x3e  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x59, 0xb2, 0xeb, 0x64, 0x3d, 0xd6, 0x8f,
		0xc8, 0x91, 0x7a, 0x23, 0xac, 0xf5, 0x1e, 0x47  },
	{	0x00, 0x69, 0xcf, 0xa6, 0x83, 0xea, 0x4c, 0x25,
		0x06, 0x6f, 0xc9, 0xa0, 0x85, 0xec, 0x4a, 0x23  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x5a, 0xb4, 0xee, 0x68, 0x32, 0xdc, 0x86,
		0xd0, 0x8a, 0x64, 0x3e, 0xb8, 0xe2, 0x0c, 0x56  },
	{	0x00, 0x69, 0xcf, 0xa6, 0x83, 0xea, 0x4c, 0x25,
		0x06, 0x6f, 0xc9, 0xa0, 0x85, 0xec, 0x4a, 0x23  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x5b, 0xb6, 0xed, 0x6c, 0x37, 0xda, 0x81,
		0xd8, 0x83, 0x6e, 0x35, 0xb4, 0xef, 0x02, 0x59  },
	{	0x00, 0x69, 0xcf, 0xa6, 0x9e, 0xf7, 0x51, 0x38,
		0x21, 0x48, 0xee, 0x87, 0xbf, 0xd6, 0x70, 0x19  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x5c, 0xb8, 0xe4, 0x70, 0x2c, 0xc8, 0x94,
		0xe0, 0xbc, 0x58, 0x04, 0x90, 0xcc, 0x28, 0x74  },
	{	0x00, 0x69, 0xcf, 0xa6, 0x9e, 0xf7, 0x51, 0x38,
		0x21, 0x48, 0xee, 0x87, 0xbf, 0xd6, 0x70, 0x19  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x5d, 0xba, 0xe7, 0x74, 0x29, 0xce, 0x93,
		0xe8, 0xb5, 0x52, 0x0f, 0x9c, 0xc1, 0x26, 0x7b  },
	{	0x00, 0x69, 0xcf, 0xa6, 0x9e, 0xf7, 0x51, 0x38,
		0x3c, 0x55, 0xf3, 0x9a, 0xa2, 0xcb, 0x6d, 0x04  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x5e, 0xbc, 0xe2, 0x78, 0x26, 0xc4, 0x9a,
		0xf0, 0xae, 0x4c, 0x12, 0x88, 0xd6, 0x34, 0x6a  },
	{	0x00, 0x69, 0xcf, 0xa6, 0x9e, 0xf7, 0x51, 0x38,
		0x3c, 0x55, 0xf3, 0x9a, 0xa2, 0xcb, 0x6d, 0x04  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x3a, 0x3a, 0x3a, 0x3a, 0x27, 0x27, 0x27, 0x27  },
	{	0x00, 0x5f, 0xbe, 0xe1, 0x7c, 0x23, 0xc2, 0x9d,
		0xf8, 0xa7, 0x46, 0x19, 0x84, 0xdb, 0x3a, 0x65  },
	{	0x00, 0x4e, 0x9c, 0xd2, 0x25, 0x6b, 0xb9, 0xf7,
		0x4a, 0x04, 0xd6, 0x98, 0x6f, 0x21, 0xf3, 0xbd  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x4e, 0x9c, 0xd2, 0x25, 0x6b, 0xb9, 0xf7,
		0x4a, 0x04, 0xd6, 0x98, 0x6f, 0x21, 0xf3, 0xbd  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x61, 0xc2, 0xa3, 0x84, 0xe5, 0x46, 0x27,
		0x08, 0x69, 0xca, 0xab, 0x8c, 0xed, 0x4e, 0x2f  },
	{	0x00, 0x4e, 0x9c, 0xd2, 0x25, 0x6b, 0xb9, 0xf7,
		0x57, 0x19, 0xcb, 0x85, 0x72, 0x3c, 0xee, 0xa0  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x62, 0xc4, 0xa6, 0x88, 0xea, 0x4c, 0x2e,
		0x10, 0x72, 0xd4, 0xb6, 0x98, 0xfa, 0x5c, 0x3e  },
	{	0x00, 0x4e, 0x9c, 0xd2, 0x25, 0x6b, 0xb9, 0xf7,
		0x57, 0x19, 0xcb, 0x85, 0x72, 0x3c, 0xee, 0xa0  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x63, 0xc6, 0xa5, 0x8c, 0xef, 0x4a, 0x29,
		0x18, 0x7b, 0xde, 0xbd, 0x94, 0xf7, 0x52, 0x31  },
	{	0x00, 0x4e, 0x9c, 0xd2, 0x38, 0x76, 0xa4, 0xea,
		0x70, 0x3e, 0xec, 0xa2, 0x48, 0x06, 0xd4, 0x9a  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x64, 0xc8, 0xac, 0x90, 0xf4, 0x58, 0x3c,
		0x20, 0x44, 0xe8, 0x8c, 0xb0, 0xd4, 0x78, 0x1c  },
	{	0x00, 0x4e, 0x9c, 0xd2, 0x38, 0x76, 0xa4, 0xea,
		0x70, 0x3e, 0xec, 0xa2, 0x48, 0x06, 0xd4, 0x9a  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x65, 0xca, 0xaf, 0x94, 0xf1, 0x5e, 0x3b,
		0x28, 0x4d, 0xe2, 0x87, 0xbc, 0xd9, 0x76, 0x13  },
	{	0x00, 0x4e, 0x9c, 0xd2, 0x38, 0x76, 0xa4, 0xea,
		0x6d, 0x23, 0xf1, 0xbf, 0x55, 0x1b, 0xc9, 0x87  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x66, 0xcc, 0xaa, 0x98, 0xfe, 0x54, 0x32,
		0x30, 0x56, 0xfc, 0x9a, 0xa8, 0xce, 0x64, 0x02  },
	{	0x00, 0x4e, 0x9c, 0xd2, 0x38, 0x76, 0xa4, 0xea,
		0x6d, 0x23, 0xf1, 0xbf, 0x55, 0x1b, 0xc9, 0x87  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x67, 0xce, 0xa9, 0x9c, 0xfb, 0x52, 0x35,
		0x38, 0x5f, 0xf6, 0x91, 0xa4, 0xc3, 0x6a, 0x0d  },
	{	0x00, 0x4e, 0x81, 0xcf, 0x1f, 0x51, 0x9e, 0xd0,
		0x3e, 0x70, 0xbf, 0xf1, 0x21, 0x6f, 0xa0, 0xee  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x68, 0xd0, 0xb8, 0xa0, 0xc8, 0x70, 0x18,
		0x40, 0x28, 0x90, 0xf8, 0xe0, 0x88, 0x30, 0x58  },
	{	0x00, 0x4e, 0x81, 0xcf, 0x1f, 0x51, 0x9e, 0xd0,
		0x3e, 0x70, 0xbf, 0xf1, 0x21, 0x6f, 0xa0, 0xee  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x69, 0xd2, 0xbb, 0xa4, 0xcd, 0x76, 0x1f,
		0x48, 0x21, 0x9a, 0xf3, 0xec, 0x85, 0x3e, 0x57  },
	{	0x00, 0x4e, 0x81, 0xcf, 0x1f, 0x51, 0x9e, 0xd0,
		0x23, 0x6d, 0xa2, 0xec, 0x3c, 0x72, 0xbd, 0xf3  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x6a, 0xd4, 0xbe, 0xa8, 0xc2, 0x7c, 0x16,
		0x50, 0x3a, 0x84, 0xee, 0xf8, 0x92, 0x2c, 0x46  },
	{	0x00, 0x4e, 0x81, 0xcf, 0x1f, 0x51, 0x9e, 0xd0,
		0x23, 0x6d, 0xa2, 0xec, 0x3c, 0x72, 0xbd, 0xf3  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x6b, 0xd6, 0xbd, 0xac, 0xc7, 0x7a, 0x11,
		0x58, 0x33, 0x8e, 0xe5, 0xf4, 0x9f, 0x22, 0x49  },
	{	0x00, 0x4e, 0x81, 0xcf, 0x02, 0x4c, 0x83, 0xcd,
		0x04, 0x4a, 0x85, 0xcb, 0x06, 0x48, 0x87, 0xc9  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x6c, 0xd8, 0xb4, 0xb0, 0xdc, 0x68, 0x04,
		0x60, 0x0c, 0xb8, 0xd4, 0xd0, 0xbc, 0x08, 0x64  },
	{	0x00, 0x4e, 0x81, 0xcf, 0x02, 0x4c, 0x83, 0xcd,
		0x04, 0x4a, 0x85, 0xcb, 0x06, 0x48, 0x87, 0xc9  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x6d, 0xda, 0xb7, 0xb4, 0xd9, 0x6e, 0x03,
		0x68, 0x05, 0xb2, 0xdf, 0xdc, 0xb1, 0x06, 0x6b  },
	{	0x00, 0x4e, 0x81, 0xcf, 0x02, 0x4c, 0x83, 0xcd,
		0x19, 0x57, 0x98, 0xd6, 0x1b, 0x55, 0x9a, 0xd4  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x6e, 0xdc, 0xb2, 0xb8, 0xd6, 0x64, 0x0a,
		0x70, 0x1e, 0xac, 0xc2, 0xc8, 0xa6, 0x14, 0x7a  },
	{	0x00, 0x4e, 0x81, 0xcf, 0x02, 0x4c, 0x83, 0xcd,
		0x19, 0x57, 0x98, 0xd6, 0x1b, 0x55, 0x9a, 0xd4  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x6f, 0xde, 0xb1, 0xbc, 0xd3, 0x62, 0x0d,
		0x78, 0x17, 0xa6, 0xc9, 0xc4, 0xab, 0x1a, 0x75  },
	{	0x00, 0x53, 0xa6, 0xf5, 0x51, 0x02, 0xf7, 0xa4,
		0xa2, 0xf1, 0x04, 0x57, 0xf3, 0xa0, 0x55, 0x06  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x53, 0xa6, 0xf5, 0x51, 0x02, 0xf7, 0xa4,
		0xa2, 0xf1, 0x04, 0x57, 0xf3, 0xa0, 0x55, 0x06  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x71, 0xe2, 0x93, 0xc4, 0xb5, 0x26, 0x57,
		0x88, 0xf9, 0x6a, 0x1b, 0x4c, 0x3d, 0xae, 0xdf  },
	{	0x00, 0x53, 0xa6, 0xf5, 0x51, 0x02, 0xf7, 0xa4,
		0xbf, 0xec, 0x19, 0x4a, 0xee, 0xbd, 0x48, 0x1b  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x72, 0xe4, 0x96, 0xc8, 0xba, 0x2c, 0x5e,
		0x90, 0xe2, 0x74, 0x06, 0x58, 0x2a, 0xbc, 0xce  },
	{	0x00, 0x53, 0xa6, 0xf5, 0x51, 0x02, 0xf7, 0xa4,
		0xbf, 0xec, 0x19, 0x4a, 0xee, 0xbd, 0x48, 0x1b  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x73, 0xe6, 0x95, 0xcc, 0xbf, 0x2a, 0x59,
		0x98, 0xeb, 0x7e, 0x0d, 0x54, 0x27, 0xb2, 0xc1  },
	{	0x00, 0x53, 0xa6, 0xf5, 0x4c, 0x1f, 0xea, 0xb9,
		0x98, 0xcb, 0x3e, 0x6d, 0xd4, 0x87, 0x72, 0x21  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x74, 0xe8, 0x9c, 0xd0, 0xa4, 0x38, 0x4c,
		0xa0, 0xd4, 0x48, 0x3c, 0x70, 0x04, 0x98, 0xec  },
	{	0x00, 0x53, 0xa6, 0xf5, 0x4c, 0x1f, 0xea, 0xb9,
		0x98, 0xcb, 0x3e, 0x6d, 0xd4, 0x87, 0x72, 0x21  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x75, 0xea, 0x9f, 0xd4, 0xa1, 0x3e, 0x4b,
		0xa8, 0xdd, 0x42, 0x37, 0x7c, 0x09, 0x96, 0xe3  },
	{	0x00, 0x53, 0xa6, 0xf5, 0x4c, 0x1f, 0xea, 0xb9,
		0x85, 0xd6, 0x23, 0x70, 0xc9, 0x9a, 0x6f, 0x3c  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x76, 0xec, 0x9a, 0xd8, 0xae, 0x34, 0x42,
		0xb0, 0xc6, 0x5c, 0x2a, 0x68, 0x1e, 0x84, 0xf2  },
	{	0x00, 0x53, 0xa6, 0xf5, 0x4c, 0x1f, 0xea, 0xb9,
		0x85, 0xd6, 0x23, 0x70, 0xc9, 0x9a, 0x6f, 0x3c  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x77, 0xee, 0x99, 0xdc, 0xab, 0x32, 0x45,
		0xb8, 0xcf, 0x56, 0x21, 0x64, 0x13, 0x8a, 0xfd  },
	{	0x00, 0x53, 0xbb, 0xe8, 0x6b, 0x38, 0xd0, 0x83,
		0xd6, 0x85, 0x6d, 0x3e, 0xbd, 0xee, 0x06, 0x55  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x78, 0xf0, 0x88, 0xe0, 0x98, 0x10, 0x68,
		0xc0, 0xb8, 0x30, 0x48, 0x20, 0x58, 0xd0, 0xa8  },
	{	0x00, 0x53, 0xbb, 0xe8, 0x6b, 0x38, 0xd0, 0x83,
		0xd6, 0x85, 0x6d, 0x3e, 0xbd, 0xee, 0x06, 0x55  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x79, 0xf2, 0x8b, 0xe4, 0x9d, 0x16, 0x6f,
		0xc8, 0xb1, 0x3a, 0x43, 0x2c, 0x55, 0xde, 0xa7  },
	{	0x00, 0x53, 0xbb, 0xe8, 0x6b, 0x38, 0xd0, 0x83,
		0xcb, 0x98, 0x70, 0x23, 0xa0, 0xf3, 0x1b, 0x48  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x7a, 0xf4, 0x8e, 0xe8, 0x92, 0x1c, 0x66,
		0xd0, 0xaa, 0x24, 0x5e, 0x38, 0x42, 0xcc, 0xb6  },
	{	0x00, 0x53, 0xbb, 0xe8, 0x6b, 0x38, 0xd0, 0x83,
		0xcb, 0x98, 0x70, 0x23, 0xa0, 0xf3, 0x1b, 0x48  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x7b, 0xf6, 0x8d, 0xec, 0x97, 0x1a, 0x61,
		0xd8, 0xa3, 0x2e, 0x55, 0x34, 0x4f, 0xc2, 0xb9  },
	{	0x00, 0x53, 0xbb, 0xe8, 0x76, 0x25, 0xcd, 0x9e,
		0xec, 0xbf, 0x57, 0x04, 0x9a, 0xc9, 0x21, 0x72  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x7c, 0xf8, 0x84, 0xf0, 0x8c, 0x08, 0x74,
		0xe0, 0x9c, 0x18, 0x64, 0x10, 0x6c, 0xe8, 0x94  },
	{	0x00, 0x53, 0xbb, 0xe8, 0x76, 0x25, 0xcd, 0x9e,
		0xec, 0xbf, 0x57, 0x04, 0x9a, 0xc9, 0x21, 0x72  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x7d, 0xfa, 0x87, 0xf4, 0x89, 0x0e, 0x73,
		0xe8, 0x95, 0x12, 0x6f, 0x1c, 0x61, 0xe6, 0x9b  },
	{	0x00, 0x53, 0xbb, 0xe8, 0x76, 0x25, 0xcd, 0x9e,
		0xf1, 0xa2, 0x4a, 0x19, 0x87, 0xd4, 0x3c, 0x6f  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x7e, 0xfc, 0x82, 0xf8, 0x86, 0x04, 0x7a,
		0xf0, 0x8e, 0x0c, 0x72, 0x08, 0x76, 0xf4, 0x8a  },
	{	0x00, 0x53, 0xbb, 0xe8, 0x76, 0x25, 0xcd, 0x9e,
		0xf1, 0xa2, 0x4a, 0x19, 0x87, 0xd4, 0x3c, 0x6f  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d,
		0x27, 0x27, 0x27, 0x27, 0x3a, 0x3a, 0x3a, 0x3a  },
	{	0x00, 0x7f, 0xfe, 0x81, 0xfc, 0x83, 0x02, 0x7d,
		0xf8, 0x87, 0x06, 0x79, 0x04, 0x7b, 0xfa, 0x85  },
	{	0x00, 0xe8, 0xcd, 0x25, 0x87, 0x6f, 0x4a, 0xa2,
		0x13, 0xfb, 0xde, 0x36, 0x94, 0x7c, 0x59, 0xb1  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0xe8, 0xcd, 0x25, 0x87, 0x6f, 0x4a, 0xa2,
		0x13, 0xfb, 0xde, 0x36, 0x94, 0x7c, 0x59, 0xb1  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x81, 0x02, 0x83, 0x04, 0x85, 0x06, 0x87,
		0x08, 0x89, 0x0a, 0x8b, 0x0c, 0x8d, 0x0e, 0x8f  },
	{	0x00, 0xe8, 0xcd, 0x25, 0x87, 0x6f, 0x4a, 0xa2,
		0x0e, 0xe6, 0xc3, 0x2b, 0x89, 0x61, 0x44, 0xac  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x82, 0x04, 0x86, 0x08, 0x8a, 0x0c, 0x8e,
		0x10, 0x92, 0x14, 0x96, 0x18, 0x9a, 0x1c, 0x9e  },
	{	0x00, 0xe8, 0xcd, 0x25, 0x87, 0x6f, 0x4a, 0xa2,
		0x0e, 0xe6, 0xc3, 0x2b, 0x89, 0x61, 0x44, 0xac  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x83, 0x06, 0x85, 0x0c, 0x8f, 0x0a, 0x89,
		0x18, 0x9b, 0x1e, 0x9d, 0x14, 0x97, 0x12, 0x91  },
	{	0x00, 0xe8, 0xcd, 0x25, 0x9a, 0x72, 0x57, 0xbf,
		0x29, 0xc1, 0xe4, 0x0c, 0xb3, 0x5b, 0x7e, 0x96  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x84, 0x08, 0x8c, 0x10, 0x94, 0x18, 0x9c,
		0x20, 0xa4, 0x28, 0xac, 0x30, 0xb4, 0x38, 0xbc  },
	{	0x00, 0xe8, 0xcd, 0x25, 0x9a, 0x72, 0x57, 0xbf,
		0x29, 0xc1, 0xe4, 0x0c, 0xb3, 0x5b, 0x7e, 0x96  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x85, 0x0a, 0x8f, 0x14, 0x91, 0x1e, 0x9b,
		0x28, 0xad, 0x22, 0xa7, 0x3c, 0xb9, 0x36, 0xb3  },
	{	0x00, 0xe8, 0xcd, 0x25, 0x9a, 0x72, 0x57, 0xbf,
		0x34, 0xdc, 0xf9, 0x11, 0xae, 0x46, 0x63, 0x8b  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x86, 0x0c, 0x8a, 0x18, 0x9e, 0x14, 0x92,
		0x30, 0xb6, 0x3c, 0xba, 0x28, 0xae, 0x24, 0xa2  },
	{	0x00, 0xe8, 0xcd, 0x25, 0x9a, 0x72, 0x57, 0xbf,
		0x34, 0xdc, 0xf9, 0x11, 0xae, 0x46, 0x63, 0x8b  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x87, 0x0e, 0x89, 0x1c, 0x9b, 0x12, 0x95,
		0x38, 0xbf, 0x36, 0xb1, 0x24, 0xa3, 0x2a, 0xad  },
	{	0x00, 0xe8, 0xd0, 0x38, 0xbd, 0x55, 0x6d, 0x85,
		0x67, 0x8f, 0xb7, 0x5f, 0xda, 0x32, 0x0a, 0xe2  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x88, 0x10, 0x98, 0x20, 0xa8, 0x30, 0xb8,
		0x40, 0xc8, 0x50, 0xd8, 0x60, 0xe8, 0x70, 0xf8  },
	{	0x00, 0xe8, 0xd0, 0x38, 0xbd, 0x55, 0x6d, 0x85,
		0x67, 0x8f, 0xb7, 0x5f, 0xda, 0x32, 0x0a, 0xe2  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x89, 0x12, 0x9b, 0x24, 0xad, 0x36, 0xbf,
		0x48, 0xc1, 0x5a, 0xd3, 0x6c, 0xe5, 0x7e, 0xf7  },
	{	0x00, 0xe8, 0xd0, 0x38, 0xbd, 0x55, 0x6d, 0x85,
		0x7a, 0x92, 0xaa, 0x42, 0xc7, 0x2f, 0x17, 0xff  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x8a, 0x14, 0x9e, 0x28, 0xa2, 0x3c, 0xb6,
		0x50, 0xda, 0x44, 0xce, 0x78, 0xf2, 0x6c, 0xe6  },
	{	0x00, 0xe8, 0xd0, 0x38, 0xbd, 0x55, 0x6d, 0x85,
		0x7a, 0x92, 0xaa, 0x42, 0xc7, 0x2f, 0x17, 0xff  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x8b, 0x16, 0x9d, 0x2c, 0xa7, 0x3a, 0xb1,
		0x58, 0xd3, 0x4e, 0xc5, 0x74, 0xff, 0x62, 0xe9  },
	{	0x00, 0xe8, 0xd0, 0x38, 0xa0, 0x48, 0x70, 0x98,
		0x5d, 0xb5, 0x8d, 0x65, 0xfd, 0x15, 0x2d, 0xc5  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x8c, 0x18, 0x94, 0x30, 0xbc, 0x28, 0xa4,
		0x60, 0xec, 0x78, 0xf4, 0x50, 0xdc, 0x48, 0xc4  },
	{	0x00, 0xe8, 0xd0, 0x38, 0xa0, 0x48, 0x70, 0x98,
		0x5d, 0xb5, 0x8d, 0x65, 0xfd, 0x15, 0x2d, 0xc5  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x8d, 0x1a, 0x97, 0x34, 0xb9, 0x2e, 0xa3,
		0x68, 0xe5, 0x72, 0xff, 0x5c, 0xd1, 0x46, 0xcb  },
	{	0x00, 0xe8, 0xd0, 0x38, 0xa0, 0x48, 0x70, 0x98,
		0x40, 0xa8, 0x90, 0x78, 0xe0, 0x08, 0x30, 0xd8  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x8e, 0x1c, 0x92, 0x38, 0xb6, 0x24, 0xaa,
		0x70, 0xfe, 0x6c, 0xe2, 0x48, 0xc6, 0x54, 0xda  },
	{	0x00, 0xe8, 0xd0, 0x38, 0xa0, 0x48, 0x70, 0x98,
		0x40, 0xa8, 0x90, 0x78, 0xe0, 0x08, 0x30, 0xd8  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x8f, 0x1e, 0x91, 0x3c, 0xb3, 0x22, 0xad,
		0x78, 0xf7, 0x66, 0xe9, 0x44, 0xcb, 0x5a, 0xd5  },
	{	0x00, 0xf5, 0xf7, 0x02, 0xf3, 0x06, 0x04, 0xf1,
		0xfb, 0x0e, 0x0c, 0xf9, 0x08, 0xfd, 0xff, 0x0a  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0xf5, 0xf7, 0x02, 0xf3, 0x06, 0x04, 0xf1,
		0xfb, 0x0e, 0x0c, 0xf9, 0x08, 0xfd, 0xff, 0x0a  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x91, 0x22, 0xb3, 0x44, 0xd5, 0x66, 0xf7,
		0x88, 0x19, 0xaa, 0x3b, 0xcc, 0x5d, 0xee, 0x7f  },
	{	0x00, 0xf5, 0xf7, 0x02, 0xf3, 0x06, 0x04, 0xf1,
		0xe6, 0x13, 0x11, 0xe4, 0x15, 0xe0, 0xe2, 0x17  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x92, 0x24, 0xb6, 0x48, 0xda, 0x6c, 0xfe,
		0x90, 0x02, 0xb4, 0x26, 0xd8, 0x4a, 0xfc, 0x6e  },
	{	0x00, 0xf5, 0xf7, 0x02, 0xf3, 0x06, 0x04, 0xf1,
		0xe6, 0x13, 0x11, 0xe4, 0x15, 0xe0, 0xe2, 0x17  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x93, 0x26, 0xb5, 0x4c, 0xdf, 0x6a, 0xf9,
		0x98, 0x0b, 0xbe, 0x2d, 0xd4, 0x47, 0xf2, 0x61  },
	{	0x00, 0xf5, 0xf7, 0x02, 0xee, 0x1b, 0x19, 0xec,
		0xc1, 0x34, 0x36, 0xc3, 0x2f, 0xda, 0xd8, 0x2d  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x94, 0x28, 0xbc, 0x50, 0xc4, 0x78, 0xec,
		0xa0, 0x34, 0x88, 0x1c, 0xf0, 0x64, 0xd8, 0x4c  },
	{	0x00, 0xf5, 0xf7, 0x02, 0xee, 0x1b, 0x19, 0xec,
		0xc1, 0x34, 0x36, 0xc3, 0x2f, 0xda, 0xd8, 0x2d  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x95, 0x2a, 0xbf, 0x54, 0xc1, 0x7e, 0xeb,
		0xa8, 0x3d, 0x82, 0x17, 0xfc, 0x69, 0xd6, 0x43  },
	{	0x00, 0xf5, 0xf7, 0x02, 0xee, 0x1b, 0x19, 0xec,
		0xdc, 0x29, 0x2b, 0xde, 0x32, 0xc7, 0xc5, 0x30  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x96, 0x2c, 0xba, 0x58, 0xce, 0x74, 0xe2,
		0xb0, 0x26, 0x9c, 0x0a, 0xe8, 0x7e, 0xc4, 0x52  },
	{	0x00, 0xf5, 0xf7, 0x02, 0xee, 0x1b, 0x19, 0xec,
		0xdc, 0x29, 0x2b, 0xde, 0x32, 0xc7, 0xc5, 0x30  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x97, 0x2e, 0xb9, 0x5c, 0xcb, 0x72, 0xe5,
		0xb8, 0x2f, 0x96, 0x01, 0xe4, 0x73, 0xca, 0x5d  },
	{	0x00, 0xf5, 0xea, 0x1f, 0xc9, 0x3c, 0x23, 0xd6,
		0x8f, 0x7a, 0x65, 0x90, 0x46, 0xb3, 0xac, 0x59  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x98, 0x30, 0xa8, 0x60, 0xf8, 0x50, 0xc8,
		0xc0, 0x58, 0xf0, 0x68, 0xa0, 0x38, 0x90, 0x08  },
	{	0x00, 0xf5, 0xea, 0x1f, 0xc9, 0x3c, 0x23, 0xd6,
		0x8f, 0x7a, 0x65, 0x90, 0x46, 0xb3, 0xac, 0x59  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x99, 0x32, 0xab, 0x64, 0xfd, 0x56, 0xcf,
		0xc8, 0x51, 0xfa, 0x63, 0xac, 0x35, 0x9e, 0x07  },
	{	0x00, 0xf5, 0xea, 0x1f, 0xc9, 0x3c, 0x23, 0xd6,
		0x92, 0x67, 0x78, 0x8d, 0x5b, 0xae, 0xb1, 0x44  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x9a, 0x34, 0xae, 0x68, 0xf2, 0x5c, 0xc6,
		0xd0, 0x4a, 0xe4, 0x7e, 0xb8, 0x22, 0x8c, 0x16  },
	{	0x00, 0xf5, 0xea, 0x1f, 0xc9, 0x3c, 0x23, 0xd6,
		0x92, 0x67, 0x78, 0x8d, 0x5b, 0xae, 0xb1, 0x44  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x9b, 0x36, 0xad, 0x6c, 0xf7, 0x5a, 0xc1,
		0xd8, 0x43, 0xee, 0x75, 0xb4, 0x2f, 0x82, 0x19  },
	{	0x00, 0xf5, 0xea, 0x1f, 0xd4, 0x21, 0x3e, 0xcb,
		0xb5, 0x40, 0x5f, 0xaa, 0x61, 0x94, 0x8b, 0x7e  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x9c, 0x38, 0xa4, 0x70, 0xec, 0x48, 0xd4,
		0xe0, 0x7c, 0xd8, 0x44, 0x90, 0x0c, 0xa8, 0x34  },
	{	0x00, 0xf5, 0xea, 0x1f, 0xd4, 0x21, 0x3e, 0xcb,
		0xb5, 0x40, 0x5f, 0xaa, 0x61, 0x94, 0x8b, 0x7e  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x9d, 0x3a, 0xa7, 0x74, 0xe9, 0x4e, 0xd3,
		0xe8, 0x75, 0xd2, 0x4f, 0x9c, 0x01, 0xa6, 0x3b  },
	{	0x00, 0xf5, 0xea, 0x1f, 0xd4, 0x21, 0x3e, 0xcb,
		0xa8, 0x5d, 0x42, 0xb7, 0x7c, 0x89, 0x96, 0x63  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x9e, 0x3c, 0xa2, 0x78, 0xe6, 0x44, 0xda,
		0xf0, 0x6e, 0xcc, 0x52, 0x88, 0x16, 0xb4, 0x2a  },
	{	0x00, 0xf5, 0xea, 0x1f, 0xd4, 0x21, 0x3e, 0xcb,
		0xa8, 0x5d, 0x42, 0xb7, 0x7c, 0x89, 0x96, 0x63  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x74, 0x74, 0x69, 0x69, 0x4e, 0x4e, 0x53, 0x53  },
	{	0x00, 0x9f, 0x3e, 0xa1, 0x7c, 0xe3, 0x42, 0xdd,
		0xf8, 0x67, 0xc6, 0x59, 0x84, 0x1b, 0xba, 0x25  },
	{	0x00, 0xd2, 0xb9, 0x6b, 0x6f, 0xbd, 0xd6, 0x04,
		0xde, 0x0c, 0x67, 0xb5, 0xb1, 0x63, 0x08, 0xda  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0xd2, 0xb9, 0x6b, 0x6f, 0xbd, 0xd6, 0x04,
		0xde, 0x0c, 0x67, 0xb5, 0xb1, 0x63, 0x08, 0xda  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xa1, 0x42, 0xe3, 0x84, 0x25, 0xc6, 0x67,
		0x08, 0xa9, 0x4a, 0xeb, 0x8c, 0x2d, 0xce, 0x6f  },
	{	0x00, 0xd2, 0xb9, 0x6b, 0x6f, 0xbd, 0xd6, 0x04,
		0xc3, 0x11, 0x7a, 0xa8, 0xac, 0x7e, 0x15, 0xc7  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xa2, 0x44, 0xe6, 0x88, 0x2a, 0xcc, 0x6e,
		0x10, 0xb2, 0x54, 0xf6, 0x98, 0x3a, 0xdc, 0x7e  },
	{	0x00, 0xd2, 0xb9, 0x6b, 0x6f, 0xbd, 0xd6, 0x04,
		0xc3, 0x11, 0x7a, 0xa8, 0xac, 0x7e, 0x15, 0xc7  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xa3, 0x46, 0xe5, 0x8c, 0x2f, 0xca, 0x69,
		0x18, 0xbb, 0x5e, 0xfd, 0x94, 0x37, 0xd2, 0x71  },
	{	0x00, 0xd2, 0xb9, 0x6b, 0x72, 0xa0, 0xcb, 0x19,
		0xe4, 0x36, 0x5d, 0x8f, 0x96, 0x44, 0x2f, 0xfd  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xa4, 0x48, 0xec, 0x90, 0x34, 0xd8, 0x7c,
		0x20, 0x84, 0x68, 0xcc, 0xb0, 0x14, 0xf8, 0x5c  },
	{	0x00, 0xd2, 0xb9, 0x6b, 0x72, 0xa0, 0xcb, 0x19,
		0xe4, 0x36, 0x5d, 0x8f, 0x96, 0x44, 0x2f, 0xfd  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xa5, 0x4a, 0xef, 0x94, 0x31, 0xde, 0x7b,
		0x28, 0x8d, 0x62, 0xc7, 0xbc, 0x19, 0xf6, 0x53  },
	{	0x00, 0xd2, 0xb9, 0x6b, 0x72, 0xa0, 0xcb, 0x19,
		0xf9, 0x2b, 0x40, 0x92, 0x8b, 0x59, 0x32, 0xe0  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xa6, 0x4c, 0xea, 0x98, 0x3e, 0xd4, 0x72,
		0x30, 0x96, 0x7c, 0xda, 0xa8, 0x0e, 0xe4, 0x42  },
	{	0x00, 0xd2, 0xb9, 0x6b, 0x72, 0xa0, 0xcb, 0x19,
		0xf9, 0x2b, 0x40, 0x92, 0x8b, 0x59, 0x32, 0xe0  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xa7, 0x4e, 0xe9, 0x9c, 0x3b, 0xd2, 0x75,
		0x38, 0x9f, 0x76, 0xd1, 0xa4, 0x03, 0xea, 0x4d  },
	{	0x00, 0xd2, 0xa4, 0x76, 0x55, 0x87, 0xf1, 0x23,
		0xaa, 0x78, 0x0e, 0xdc, 0xff, 0x2d, 0x5b, 0x89  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xa8, 0x50, 0xf8, 0xa0, 0x08, 0xf0, 0x58,
		0x40, 0xe8, 0x10, 0xb8, 0xe0, 0x48, 0xb0, 0x18  },
	{	0x00, 0xd2, 0xa4, 0x76, 0x55, 0x87, 0xf1, 0x23,
		0xaa, 0x78, 0x0e, 0xdc, 0xff, 0x2d, 0x5b, 0x89  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xa9, 0x52, 0xfb, 0xa4, 0x0d, 0xf6, 0x5f,
		0x48, 0xe1, 0x1a, 0xb3, 0xec, 0x45, 0xbe, 0x17  },
	{	0x00, 0xd2, 0xa4, 0x76, 0x55, 0x87, 0xf1, 0x23,
		0xb7, 0x65, 0x13, 0xc1, 0xe2, 0x30, 0x46, 0x94  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xaa, 0x54, 0xfe, 0xa8, 0x02, 0xfc, 0x56,
		0x50, 0xfa, 0x04, 0xae, 0xf8, 0x52, 0xac, 0x06  },
	{	0x00, 0xd2, 0xa4, 0x76, 0x55, 0x87, 0xf1, 0x23,
		0xb7, 0x65, 0x13, 0xc1, 0xe2, 0x30, 0x46, 0x94  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xab, 0x56, 0xfd, 0xac, 0x07, 0xfa, 0x51,
		0x58, 0xf3, 0x0e, 0xa5, 0xf4, 0x5f, 0xa2, 0x09  },
	{	0x00, 0xd2, 0xa4, 0x76, 0x48, 0x9a, 0xec, 0x3e,
		0x90, 0x42, 0x34, 0xe6, 0xd8, 0x0a, 0x7c, 0xae  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xac, 0x58, 0xf4, 0xb0, 0x1c, 0xe8, 0x44,
		0x60, 0xcc, 0x38, 0x94, 0xd0, 0x7c, 0x88, 0x24  },
	{	0x00, 0xd2, 0xa4, 0x76, 0x48, 0x9a, 0xec, 0x3e,
		0x90, 0x42, 0x34, 0xe6, 0xd8, 0x0a, 0x7c, 0xae  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xad, 0x5a, 0xf7, 0xb4, 0x19, 0xee, 0x43,
		0x68, 0xc5, 0x32, 0x9f, 0xdc, 0x71, 0x86, 0x2b  },
	{	0x00, 0xd2, 0xa4, 0x76, 0x48, 0x9a, 0xec, 0x3e,
		0x8d, 0x5f, 0x29, 0xfb, 0xc5, 0x17, 0x61, 0xb3  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xae, 0x5c, 0xf2, 0xb8, 0x16, 0xe4, 0x4a,
		0x70, 0xde, 0x2c, 0x82, 0xc8, 0x66, 0x94, 0x3a  },
	{	0x00, 0xd2, 0xa4, 0x76, 0x48, 0x9a, 0xec, 0x3e,
		0x8d, 0x5f, 0x29, 0xfb, 0xc5, 0x17, 0x61, 0xb3  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xaf, 0x5e, 0xf1, 0xbc, 0x13, 0xe2, 0x4d,
		0x78, 0xd7, 0x26, 0x89, 0xc4, 0x6b, 0x9a, 0x35  },
	{	0x00, 0xcf, 0x83, 0x4c, 0x1b, 0xd4, 0x98, 0x57,
		0x36, 0xf9, 0xb5, 0x7a, 0x2d, 0xe2, 0xae, 0x61  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0xcf, 0x83, 0x4c, 0x1b, 0xd4, 0x98, 0x57,
		0x36, 0xf9, 0xb5, 0x7a, 0x2d, 0xe2, 0xae, 0x61  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xb1, 0x62, 0xd3, 0xc4, 0x75, 0xa6, 0x17,
		0x88, 0x39, 0xea, 0x5b, 0x4c, 0xfd, 0x2e, 0x9f  },
	{	0x00, 0xcf, 0x83, 0x4c, 0x1b, 0xd4, 0x98, 0x57,
		0x2b, 0xe4, 0xa8, 0x67, 0x30, 0xff, 0xb3, 0x7c  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xb2, 0x64, 0xd6, 0xc8, 0x7a, 0xac, 0x1e,
		0x90, 0x22, 0xf4, 0x46, 0x58, 0xea, 0x3c, 0x8e  },
	{	0x00, 0xcf, 0x83, 0x4c, 0x1b, 0xd4, 0x98, 0x57,
		0x2b, 0xe4, 0xa8, 0x67, 0x30, 0xff, 0xb3, 0x7c  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xb3, 0x66, 0xd5, 0xcc, 0x7f, 0xaa, 0x19,
		0x98, 0x2b, 0xfe, 0x4d, 0x54, 0xe7, 0x32, 0x81  },
	{	0x00, 0xcf, 0x83, 0x4c, 0x06, 0xc9, 0x85, 0x4a,
		0x0c, 0xc3, 0x8f, 0x40, 0x0a, 0xc5, 0x89, 0x46  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xb4, 0x68, 0xdc, 0xd0, 0x64, 0xb8, 0x0c,
		0xa0, 0x14, 0xc8, 0x7c, 0x70, 0xc4, 0x18, 0xac  },
	{	0x00, 0xcf, 0x83, 0x4c, 0x06, 0xc9, 0x85, 0x4a,
		0x0c, 0xc3, 0x8f, 0x40, 0x0a, 0xc5, 0x89, 0x46  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xb5, 0x6a, 0xdf, 0xd4, 0x61, 0xbe, 0x0b,
		0xa8, 0x1d, 0xc2, 0x77, 0x7c, 0xc9, 0x16, 0xa3  },
	{	0x00, 0xcf, 0x83, 0x4c, 0x06, 0xc9, 0x85, 0x4a,
		0x11, 0xde, 0x92, 0x5d, 0x17, 0xd8, 0x94, 0x5b  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xb6, 0x6c, 0xda, 0xd8, 0x6e, 0xb4, 0x02,
		0xb0, 0x06, 0xdc, 0x6a, 0x68, 0xde, 0x04, 0xb2  },
	{	0x00, 0xcf, 0x83, 0x4c, 0x06, 0xc9, 0x85, 0x4a,
		0x11, 0xde, 0x92, 0x5d, 0x17, 0xd8, 0x94, 0x5b  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xb7, 0x6e, 0xd9, 0xdc, 0x6b, 0xb2, 0x05,
		0xb8, 0x0f, 0xd6, 0x61, 0x64, 0xd3, 0x0a, 0xbd  },
	{	0x00, 0xcf, 0x9e, 0x51, 0x21, 0xee, 0xbf, 0x70,
		0x42, 0x8d, 0xdc, 0x13, 0x63, 0xac, 0xfd, 0x32  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xb8, 0x70, 0xc8, 0xe0, 0x58, 0x90, 0x28,
		0xc0, 0x78, 0xb0, 0x08, 0x20, 0x98, 0x50, 0xe8  },
	{	0x00, 0xcf, 0x9e, 0x51, 0x21, 0xee, 0xbf, 0x70,
		0x42, 0x8d, 0xdc, 0x13, 0x63, 0xac, 0xfd, 0x32  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xb9, 0x72, 0xcb, 0xe4, 0x5d, 0x96, 0x2f,
		0xc8, 0x71, 0xba, 0x03, 0x2c, 0x95, 0x5e, 0xe7  },
	{	0x00, 0xcf, 0x9e, 0x51, 0x21, 0xee, 0xbf, 0x70,
		0x5f, 0x90, 0xc1, 0x0e, 0x7e, 0xb1, 0xe0, 0x2f  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xba, 0x74, 0xce, 0xe8, 0x52, 0x9c, 0x26,
		0xd0, 0x6a, 0xa4, 0x1e, 0x38, 0x82, 0x4c, 0xf6  },
	{	0x00, 0xcf, 0x9e, 0x51, 0x21, 0xee, 0xbf, 0x70,
		0x5f, 0x90, 0xc1, 0x0e, 0x7e, 0xb1, 0xe0, 0x2f  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xbb, 0x76, 0xcd, 0xec, 0x57, 0x9a, 0x21,
		0xd8, 0x63, 0xae, 0x15, 0x34, 0x8f, 0x42, 0xf9  },
	{	0x00, 0xcf, 0x9e, 0x51, 0x3c, 0xf3, 0xa2, 0x6d,
		0x78, 0xb7, 0xe6, 0x29, 0x44, 0x8b, 0xda, 0x15  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xbc, 0x78, 0xc4, 0xf0, 0x4c, 0x88, 0x34,
		0xe0, 0x5c, 0x98, 0x24, 0x10, 0xac, 0x68, 0xd4  },
	{	0x00, 0xcf, 0x9e, 0x51, 0x3c, 0xf3, 0xa2, 0x6d,
		0x78, 0xb7, 0xe6, 0x29, 0x44, 0x8b, 0xda, 0x15  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xbd, 0x7a, 0xc7, 0xf4, 0x49, 0x8e, 0x33,
		0xe8, 0x55, 0x92, 0x2f, 0x1c, 0xa1, 0x66, 0xdb  },
	{	0x00, 0xcf, 0x9e, 0x51, 0x3c, 0xf3, 0xa2, 0x6d,
		0x65, 0xaa, 0xfb, 0x34, 0x59, 0x96, 0xc7, 0x08  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xbe, 0x7c, 0xc2, 0xf8, 0x46, 0x84, 0x3a,
		0xf0, 0x4e, 0x8c, 0x32, 0x08, 0xb6, 0x74, 0xca  },
	{	0x00, 0xcf, 0x9e, 0x51, 0x3c, 0xf3, 0xa2, 0x6d,
		0x65, 0xaa, 0xfb, 0x34, 0x59, 0x96, 0xc7, 0x08  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x3a, 0x3a, 0x27, 0x27,
		0x69, 0x69, 0x74, 0x74, 0x53, 0x53, 0x4e, 0x4e  },
	{	0x00, 0xbf, 0x7e, 0xc1, 0xfc, 0x43, 0x82, 0x3d,
		0xf8, 0x47, 0x86, 0x39, 0x04, 0xbb, 0x7a, 0xc5  },
	{	0x00, 0x9c, 0x25, 0xb9, 0x4a, 0xd6, 0x6f, 0xf3,
		0x94, 0x08, 0xb1, 0x2d, 0xde, 0x42, 0xfb, 0x67  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x9c, 0x25, 0xb9, 0x4a, 0xd6, 0x6f, 0xf3,
		0x94, 0x08, 0xb1, 0x2d, 0xde, 0x42, 0xfb, 0x67  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xc1, 0x82, 0x43, 0x04, 0xc5, 0x86, 0x47,
		0x08, 0xc9, 0x8a, 0x4b, 0x0c, 0xcd, 0x8e, 0x4f  },
	{	0x00, 0x9c, 0x25, 0xb9, 0x4a, 0xd6, 0x6f, 0xf3,
		0x89, 0x15, 0xac, 0x30, 0xc3, 0x5f, 0xe6, 0x7a  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xc2, 0x84, 0x46, 0x08, 0xca, 0x8c, 0x4e,
		0x10, 0xd2, 0x94, 0x56, 0x18, 0xda, 0x9c, 0x5e  },
	{	0x00, 0x9c, 0x25, 0xb9, 0x4a, 0xd6, 0x6f, 0xf3,
		0x89, 0x15, 0xac, 0x30, 0xc3, 0x5f, 0xe6, 0x7a  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xc3, 0x86, 0x45, 0x0c, 0xcf, 0x8a, 0x49,
		0x18, 0xdb, 0x9e, 0x5d, 0x14, 0xd7, 0x92, 0x51  },
	{	0x00, 0x9c, 0x25, 0xb9, 0x57, 0xcb, 0x72, 0xee,
		0xae, 0x32, 0x8b, 0x17, 0xf9, 0x65, 0xdc, 0x40  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xc4, 0x88, 0x4c, 0x10, 0xd4, 0x98, 0x5c,
		0x20, 0xe4, 0xa8, 0x6c, 0x30, 0xf4, 0xb8, 0x7c  },
	{	0x00, 0x9c, 0x25, 0xb9, 0x57, 0xcb, 0x72, 0xee,
		0xae, 0x32, 0x8b, 0x17, 0xf9, 0x65, 0xdc, 0x40  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xc5, 0x8a, 0x4f, 0x14, 0xd1, 0x9e, 0x5b,
		0x28, 0xed, 0xa2, 0x67, 0x3c, 0xf9, 0xb6, 0x73  },
	{	0x00, 0x9c, 0x25, 0xb9, 0x57, 0xcb, 0x72, 0xee,
		0xb3, 0x2f, 0x96, 0x0a, 0xe4, 0x78, 0xc1, 0x5d  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xc6, 0x8c, 0x4a, 0x18, 0xde, 0x94, 0x52,
		0x30, 0xf6, 0xbc, 0x7a, 0x28, 0xee, 0xa4, 0x62  },
	{	0x00, 0x9c, 0x25, 0xb9, 0x57, 0xcb, 0x72, 0xee,
		0xb3, 0x2f, 0x96, 0x0a, 0xe4, 0x78, 0xc1, 0x5d  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xc7, 0x8e, 0x49, 0x1c, 0xdb, 0x92, 0x55,
		0x38, 0xff, 0xb6, 0x71, 0x24, 0xe3, 0xaa, 0x6d  },
	{	0x00, 0x9c, 0x38, 0xa4, 0x70, 0xec, 0x48, 0xd4,
		0xe0, 0x7c, 0xd8, 0x44, 0x90, 0x0c, 0xa8, 0x34  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xc8, 0x90, 0x58, 0x20, 0xe8, 0xb0, 0x78,
		0x40, 0x88, 0xd0, 0x18, 0x60, 0xa8, 0xf0, 0x38  },
	{	0x00, 0x9c, 0x38, 0xa4, 0x70, 0xec, 0x48, 0xd4,
		0xe0, 0x7c, 0xd8, 0x44, 0x90, 0x0c, 0xa8, 0x34  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xc9, 0x92, 0x5b, 0x24, 0xed, 0xb6, 0x7f,
		0x48, 0x81, 0xda, 0x13, 0x6c, 0xa5, 0xfe, 0x37  },
	{	0x00, 0x9c, 0x38, 0xa4, 0x70, 0xec, 0x48, 0xd4,
		0xfd, 0x61, 0xc5, 0x59, 0x8d, 0x11, 0xb5, 0x29  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xca, 0x94, 0x5e, 0x28, 0xe2, 0xbc, 0x76,
		0x50, 0x9a, 0xc4, 0x0e, 0x78, 0xb2, 0xec, 0x26  },
	{	0x00, 0x9c, 0x38, 0xa4, 0x70, 0xec, 0x48, 0xd4,
		0xfd, 0x61, 0xc5, 0x59, 0x8d, 0x11, 0xb5, 0x29  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xcb, 0x96, 0x5d, 0x2c, 0xe7, 0xba, 0x71,
		0x58, 0x93, 0xce, 0x05, 0x74, 0xbf, 0xe2, 0x29  },
	{	0x00, 0x9c, 0x38, 0xa4, 0x6d, 0xf1, 0x55, 0xc9,
		0xda, 0x46, 0xe2, 0x7e, 0xb7, 0x2b, 0x8f, 0x13  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xcc, 0x98, 0x54, 0x30, 0xfc, 0xa8, 0x64,
		0x60, 0xac, 0xf8, 0x34, 0x50, 0x9c, 0xc8, 0x04  },
	{	0x00, 0x9c, 0x38, 0xa4, 0x6d, 0xf1, 0x55, 0xc9,
		0xda, 0x46, 0xe2, 0x7e, 0xb7, 0x2b, 0x8f, 0x13  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xcd, 0x9a, 0x57, 0x34, 0xf9, 0xae, 0x63,
		0x68, 0xa5, 0xf2, 0x3f, 0x5c, 0x91, 0xc6, 0x0b  },
	{	0x00, 0x9c, 0x38, 0xa4, 0x6d, 0xf1, 0x55, 0xc9,
		0xc7, 0x5b, 0xff, 0x63, 0xaa, 0x36, 0x92, 0x0e  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xce, 0x9c, 0x52, 0x38, 0xf6, 0xa4, 0x6a,
		0x70, 0xbe, 0xec, 0x22, 0x48, 0x86, 0xd4, 0x1a  },
	{	0x00, 0x9c, 0x38, 0xa4, 0x6d, 0xf1, 0x55, 0xc9,
		0xc7, 0x5b, 0xff, 0x63, 0xaa, 0x36, 0x92, 0x0e  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xcf, 0x9e, 0x51, 0x3c, 0xf3, 0xa2, 0x6d,
		0x78, 0xb7, 0xe6, 0x29, 0x44, 0x8b, 0xda, 0x15  },
	{	0x00, 0x81, 0x1f, 0x9e, 0x3e, 0xbf, 0x21, 0xa0,
		0x7c, 0xfd, 0x63, 0xe2, 0x42, 0xc3, 0x5d, 0xdc  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x81, 0x1f, 0x9e, 0x3e, 0xbf, 0x21, 0xa0,
		0x7c, 0xfd, 0x63, 0xe2, 0x42, 0xc3, 0x5d, 0xdc  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xd1, 0xa2, 0x73, 0x44, 0x95, 0xe6, 0x37,
		0x88, 0x59, 0x2a, 0xfb, 0xcc, 0x1d, 0x6e, 0xbf  },
	{	0x00, 0x81, 0x1f, 0x9e, 0x3e, 0xbf, 0x21, 0xa0,
		0x61, 0xe0, 0x7e, 0xff, 0x5f, 0xde, 0x40, 0xc1  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xd2, 0xa4, 0x76, 0x48, 0x9a, 0xec, 0x3e,
		0x90, 0x42, 0x34, 0xe6, 0xd8, 0x0a, 0x7c, 0xae  },
	{	0x00, 0x81, 0x1f, 0x9e, 0x3e, 0xbf, 0x21, 0xa0,
		0x61, 0xe0, 0x7e, 0xff, 0x5f, 0xde, 0x40, 0xc1  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xd3, 0xa6, 0x75, 0x4c, 0x9f, 0xea, 0x39,
		0x98, 0x4b, 0x3e, 0xed, 0xd4, 0x07, 0x72, 0xa1  },
	{	0x00, 0x81, 0x1f, 0x9e, 0x23, 0xa2, 0x3c, 0xbd,
		0x46, 0xc7, 0x59, 0xd8, 0x65, 0xe4, 0x7a, 0xfb  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xd4, 0xa8, 0x7c, 0x50, 0x84, 0xf8, 0x2c,
		0xa0, 0x74, 0x08, 0xdc, 0xf0, 0x24, 0x58, 0x8c  },
	{	0x00, 0x81, 0x1f, 0x9e, 0x23, 0xa2, 0x3c, 0xbd,
		0x46, 0xc7, 0x59, 0xd8, 0x65, 0xe4, 0x7a, 0xfb  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xd5, 0xaa, 0x7f, 0x54, 0x81, 0xfe, 0x2b,
		0xa8, 0x7d, 0x02, 0xd7, 0xfc, 0x29, 0x56, 0x83  },
	{	0x00, 0x81, 0x1f, 0x9e, 0x23, 0xa2, 0x3c, 0xbd,
		0x5b, 0xda, 0x44, 0xc5, 0x78, 0xf9, 0x67, 0xe6  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xd6, 0xac, 0x7a, 0x58, 0x8e, 0xf4, 0x22,
		0xb0, 0x66, 0x1c, 0xca, 0xe8, 0x3e, 0x44, 0x92  },
	{	0x00, 0x81, 0x1f, 0x9e, 0x23, 0xa2, 0x3c, 0xbd,
		0x5b, 0xda, 0x44, 0xc5, 0x78, 0xf9, 0x67, 0xe6  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xd7, 0xae, 0x79, 0x5c, 0x8b, 0xf2, 0x25,
		0xb8, 0x6f, 0x16, 0xc1, 0xe4, 0x33, 0x4a, 0x9d  },
	{	0x00, 0x81, 0x02, 0x83, 0x04, 0x85, 0x06, 0x87,
		0x08, 0x89, 0x0a, 0x8b, 0x0c, 0x8d, 0x0e, 0x8f  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xd8, 0xb0, 0x68, 0x60, 0xb8, 0xd0, 0x08,
		0xc0, 0x18, 0x70, 0xa8, 0xa0, 0x78, 0x10, 0xc8  },
	{	0x00, 0x81, 0x02, 0x83, 0x04, 0x85, 0x06, 0x87,
		0x08, 0x89, 0x0a, 0x8b, 0x0c, 0x8d, 0x0e, 0x8f  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xd9, 0xb2, 0x6b, 0x64, 0xbd, 0xd6, 0x0f,
		0xc8, 0x11, 0x7a, 0xa3, 0xac, 0x75, 0x1e, 0xc7  },
	{	0x00, 0x81, 0x02, 0x83, 0x04, 0x85, 0x06, 0x87,
		0x15, 0x94, 0x17, 0x96, 0x11, 0x90, 0x13, 0x92  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xda, 0xb4, 0x6e, 0x68, 0xb2, 0xdc, 0x06,
		0xd0, 0x0a, 0x64, 0xbe, 0xb8, 0x62, 0x0c, 0xd6  },
	{	0x00, 0x81, 0x02, 0x83, 0x04, 0x85, 0x06, 0x87,
		0x15, 0x94, 0x17, 0x96, 0x11, 0x90, 0x13, 0x92  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xdb, 0xb6, 0x6d, 0x6c, 0xb7, 0xda, 0x01,
		0xd8, 0x03, 0x6e, 0xb5, 0xb4, 0x6f, 0x02, 0xd9  },
	{	0x00, 0x81, 0x02, 0x83, 0x19, 0x98, 0x1b, 0x9a,
		0x32, 0xb3, 0x30, 0xb1, 0x2b, 0xaa, 0x29, 0xa8  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xdc, 0xb8, 0x64, 0x70, 0xac, 0xc8, 0x14,
		0xe0, 0x3c, 0x58, 0x84, 0x90, 0x4c, 0x28, 0xf4  },
	{	0x00, 0x81, 0x02, 0x83, 0x19, 0x98, 0x1b, 0x9a,
		0x32, 0xb3, 0x30, 0xb1, 0x2b, 0xaa, 0x29, 0xa8  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xdd, 0xba, 0x67, 0x74, 0xa9, 0xce, 0x13,
		0xe8, 0x35, 0x52, 0x8f, 0x9c, 0x41, 0x26, 0xfb  },
	{	0x00, 0x81, 0x02, 0x83, 0x19, 0x98, 0x1b, 0x9a,
		0x2f, 0xae, 0x2d, 0xac, 0x36, 0xb7, 0x34, 0xb5  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xde, 0xbc, 0x62, 0x78, 0xa6, 0xc4, 0x1a,
		0xf0, 0x2e, 0x4c, 0x92, 0x88, 0x56, 0x34, 0xea  },
	{	0x00, 0x81, 0x02, 0x83, 0x19, 0x98, 0x1b, 0x9a,
		0x2f, 0xae, 0x2d, 0xac, 0x36, 0xb7, 0x34, 0xb5  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x4e, 0x4e, 0x53, 0x53, 0x69, 0x69, 0x74, 0x74  },
	{	0x00, 0xdf, 0xbe, 0x61, 0x7c, 0xa3, 0xc2, 0x1d,
		0xf8, 0x27, 0x46, 0x99, 0x84, 0x5b, 0x3a, 0xe5  },
	{	0x00, 0xa6, 0x51, 0xf7, 0xa2, 0x04, 0xf3, 0x55,
		0x59, 0xff, 0x08, 0xae, 0xfb, 0x5d, 0xaa, 0x0c  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0xa6, 0x51, 0xf7, 0xa2, 0x04, 0xf3, 0x55,
		0x59, 0xff, 0x08, 0xae, 0xfb, 0x5d, 0xaa, 0x0c  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xe1, 0xc2, 0x23, 0x84, 0x65, 0x46, 0xa7,
		0x08, 0xe9, 0xca, 0x2b, 0x8c, 0x6d, 0x4e, 0xaf  },
	{	0x00, 0xa6, 0x51, 0xf7, 0xa2, 0x04, 0xf3, 0x55,
		0x44, 0xe2, 0x15, 0xb3, 0xe6, 0x40, 0xb7, 0x11  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xe2, 0xc4, 0x26, 0x88, 0x6a, 0x4c, 0xae,
		0x10, 0xf2, 0xd4, 0x36, 0x98, 0x7a, 0x5c, 0xbe  },
	{	0x00, 0xa6, 0x51, 0xf7, 0xa2, 0x04, 0xf3, 0x55,
		0x44, 0xe2, 0x15, 0xb3, 0xe6, 0x40, 0xb7, 0x11  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xe3, 0xc6, 0x25, 0x8c, 0x6f, 0x4a, 0xa9,
		0x18, 0xfb, 0xde, 0x3d, 0x94, 0x77, 0x52, 0xb1  },
	{	0x00, 0xa6, 0x51, 0xf7, 0xbf, 0x19, 0xee, 0x48,
		0x63, 0xc5, 0x32, 0x94, 0xdc, 0x7a, 0x8d, 0x2b  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xe4, 0xc8, 0x2c, 0x90, 0x74, 0x58, 0xbc,
		0x20, 0xc4, 0xe8, 0x0c, 0xb0, 0x54, 0x78, 0x9c  },
	{	0x00, 0xa6, 0x51, 0xf7, 0xbf, 0x19, 0xee, 0x48,
		0x63, 0xc5, 0x32, 0x94, 0xdc, 0x7a, 0x8d, 0x2b  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xe5, 0xca, 0x2f, 0x94, 0x71, 0x5e, 0xbb,
		0x28, 0xcd, 0xe2, 0x07, 0xbc, 0x59, 0x76, 0x93  },
	{	0x00, 0xa6, 0x51, 0xf7, 0xbf, 0x19, 0xee, 0x48,
		0x7e, 0xd8, 0x2f, 0x89, 0xc1, 0x67, 0x90, 0x36  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xe6, 0xcc, 0x2a, 0x98, 0x7e, 0x54, 0xb2,
		0x30, 0xd6, 0xfc, 0x1a, 0xa8, 0x4e, 0x64, 0x82  },
	{	0x00, 0xa6, 0x51, 0xf7, 0xbf, 0x19, 0xee, 0x48,
		0x7e, 0xd8, 0x2f, 0x89, 0xc1, 0x67, 0x90, 0x36  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xe7, 0xce, 0x29, 0x9c, 0x7b, 0x52, 0xb5,
		0x38, 0xdf, 0xf6, 0x11, 0xa4, 0x43, 0x6a, 0x8d  },
	{	0x00, 0xa6, 0x4c, 0xea, 0x98, 0x3e, 0xd4, 0x72,
		0x2d, 0x8b, 0x61, 0xc7, 0xb5, 0x13, 0xf9, 0x5f  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xe8, 0xd0, 0x38, 0xa0, 0x48, 0x70, 0x98,
		0x40, 0xa8, 0x90, 0x78, 0xe0, 0x08, 0x30, 0xd8  },
	{	0x00, 0xa6, 0x4c, 0xea, 0x98, 0x3e, 0xd4, 0x72,
		0x2d, 0x8b, 0x61, 0xc7, 0xb5, 0x13, 0xf9, 0x5f  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xe9, 0xd2, 0x3b, 0xa4, 0x4d, 0x76, 0x9f,
		0x48, 0xa1, 0x9a, 0x73, 0xec, 0x05, 0x3e, 0xd7  },
	{	0x00, 0xa6, 0x4c, 0xea, 0x98, 0x3e, 0xd4, 0x72,
		0x30, 0x96, 0x7c, 0xda, 0xa8, 0x0e, 0xe4, 0x42  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xea, 0xd4, 0x3e, 0xa8, 0x42, 0x7c, 0x96,
		0x50, 0xba, 0x84, 0x6e, 0xf8, 0x12, 0x2c, 0xc6  },
	{	0x00, 0xa6, 0x4c, 0xea, 0x98, 0x3e, 0xd4, 0x72,
		0x30, 0x96, 0x7c, 0xda, 0xa8, 0x0e, 0xe4, 0x42  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xeb, 0xd6, 0x3d, 0xac, 0x47, 0x7a, 0x91,
		0x58, 0xb3, 0x8e, 0x65, 0xf4, 0x1f, 0x22, 0xc9  },
	{	0x00, 0xa6, 0x4c, 0xea, 0x85, 0x23, 0xc9, 0x6f,
		0x17, 0xb1, 0x5b, 0xfd, 0x92, 0x34, 0xde, 0x78  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xec, 0xd8, 0x34, 0xb0, 0x5c, 0x68, 0x84,
		0x60, 0x8c, 0xb8, 0x54, 0xd0, 0x3c, 0x08, 0xe4  },
	{	0x00, 0xa6, 0x4c, 0xea, 0x85, 0x23, 0xc9, 0x6f,
		0x17, 0xb1, 0x5b, 0xfd, 0x92, 0x34, 0xde, 0x78  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xed, 0xda, 0x37, 0xb4, 0x59, 0x6e, 0x83,
		0x68, 0x85, 0xb2, 0x5f, 0xdc, 0x31, 0x06, 0xeb  },
	{	0x00, 0xa6, 0x4c, 0xea, 0x85, 0x23, 0xc9, 0x6f,
		0x0a, 0xac, 0x46, 0xe0, 0x8f, 0x29, 0xc3, 0x65  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xee, 0xdc, 0x32, 0xb8, 0x56, 0x64, 0x8a,
		0x70, 0x9e, 0xac, 0x42, 0xc8, 0x26, 0x14, 0xfa  },
	{	0x00, 0xa6, 0x4c, 0xea, 0x85, 0x23, 0xc9, 0x6f,
		0x0a, 0xac, 0x46, 0xe0, 0x8f, 0x29, 0xc3, 0x65  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xef, 0xde, 0x31, 0xbc, 0x53, 0x62, 0x8d,
		0x78, 0x97, 0xa6, 0x49, 0xc4, 0x2b, 0x1a, 0xf5  },
	{	0x00, 0xbb, 0x6b, 0xd0, 0xd6, 0x6d, 0xbd, 0x06,
		0xb1, 0x0a, 0xda, 0x61, 0x67, 0xdc, 0x0c, 0xb7  },
	{	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0xbb, 0x6b, 0xd0, 0xd6, 0x6d, 0xbd, 0x06,
		0xb1, 0x0a, 0xda, 0x61, 0x67, 0xdc, 0x0c, 0xb7  },
	{	0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
		0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xf1, 0xe2, 0x13, 0xc4, 0x35, 0x26, 0xd7,
		0x88, 0x79, 0x6a, 0x9b, 0x4c, 0xbd, 0xae, 0x5f  },
	{	0x00, 0xbb, 0x6b, 0xd0, 0xd6, 0x6d, 0xbd, 0x06,
		0xac, 0x17, 0xc7, 0x7c, 0x7a, 0xc1, 0x11, 0xaa  },
	{	0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0,
		0x00, 0x20, 0x40, 0x60, 0x80, 0xa0, 0xc0, 0xe0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xf2, 0xe4, 0x16, 0xc8, 0x3a, 0x2c, 0xde,
		0x90, 0x62, 0x74, 0x86, 0x58, 0xaa, 0xbc, 0x4e  },
	{	0x00, 0xbb, 0x6b, 0xd0, 0xd6, 0x6d, 0xbd, 0x06,
		0xac, 0x17, 0xc7, 0x7c, 0x7a, 0xc1, 0x11, 0xaa  },
	{	0x00, 0x30, 0x60, 0x50, 0xc0, 0xf0, 0xa0, 0x90,
		0x80, 0xb0, 0xe0, 0xd0, 0x40, 0x70, 0x20, 0x10  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xf3, 0xe6, 0x15, 0xcc, 0x3f, 0x2a, 0xd9,
		0x98, 0x6b, 0x7e, 0x8d, 0x54, 0xa7, 0xb2, 0x41  },
	{	0x00, 0xbb, 0x6b, 0xd0, 0xcb, 0x70, 0xa0, 0x1b,
		0x8b, 0x30, 0xe0, 0x5b, 0x40, 0xfb, 0x2b, 0x90  },
	{	0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0,
		0x00, 0x40, 0x80, 0xc0, 0x00, 0x40, 0x80, 0xc0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xf4, 0xe8, 0x1c, 0xd0, 0x24, 0x38, 0xcc,
		0xa0, 0x54, 0x48, 0xbc, 0x70, 0x84, 0x98, 0x6c  },
	{	0x00, 0xbb, 0x6b, 0xd0, 0xcb, 0x70, 0xa0, 0x1b,
		0x8b, 0x30, 0xe0, 0x5b, 0x40, 0xfb, 0x2b, 0x90  },
	{	0x00, 0x50, 0xa0, 0xf0, 0x40, 0x10, 0xe0, 0xb0,
		0x80, 0xd0, 0x20, 0x70, 0xc0, 0x90, 0x60, 0x30  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xf5, 0xea, 0x1f, 0xd4, 0x21, 0x3e, 0xcb,
		0xa8, 0x5d, 0x42, 0xb7, 0x7c, 0x89, 0x96, 0x63  },
	{	0x00, 0xbb, 0x6b, 0xd0, 0xcb, 0x70, 0xa0, 0x1b,
		0x96, 0x2d, 0xfd, 0x46, 0x5d, 0xe6, 0x36, 0x8d  },
	{	0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20,
		0x00, 0x60, 0xc0, 0xa0, 0x80, 0xe0, 0x40, 0x20  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xf6, 0xec, 0x1a, 0xd8, 0x2e, 0x34, 0xc2,
		0xb0, 0x46, 0x5c, 0xaa, 0x68, 0x9e, 0x84, 0x72  },
	{	0x00, 0xbb, 0x6b, 0xd0, 0xcb, 0x70, 0xa0, 0x1b,
		0x96, 0x2d, 0xfd, 0x46, 0x5d, 0xe6, 0x36, 0x8d  },
	{	0x00, 0x70, 0xe0, 0x90, 0xc0, 0xb0, 0x20, 0x50,
		0x80, 0xf0, 0x60, 0x10, 0x40, 0x30, 0xa0, 0xd0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xf7, 0xee, 0x19, 0xdc, 0x2b, 0x32, 0xc5,
		0xb8, 0x4f, 0x56, 0xa1, 0x64, 0x93, 0x8a, 0x7d  },
	{	0x00, 0xbb, 0x76, 0xcd, 0xec, 0x57, 0x9a, 0x21,
		0xc5, 0x7e, 0xb3, 0x08, 0x29, 0x92, 0x5f, 0xe4  },
	{	0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
		0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xf8, 0xf0, 0x08, 0xe0, 0x18, 0x10, 0xe8,
		0xc0, 0x38, 0x30, 0xc8, 0x20, 0xd8, 0xd0, 0x28  },
	{	0x00, 0xbb, 0x76, 0xcd, 0xec, 0x57, 0x9a, 0x21,
		0xc5, 0x7e, 0xb3, 0x08, 0x29, 0x92, 0x5f, 0xe4  },
	{	0x00, 0x90, 0x20, 0xb0, 0x40, 0xd0, 0x60, 0xf0,
		0x80, 0x10, 0xa0, 0x30, 0xc0, 0x50, 0xe0, 0x70  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xf9, 0xf2, 0x0b, 0xe4, 0x1d, 0x16, 0xef,
		0xc8, 0x31, 0x3a, 0xc3, 0x2c, 0xd5, 0xde, 0x27  },
	{	0x00, 0xbb, 0x76, 0xcd, 0xec, 0x57, 0x9a, 0x21,
		0xd8, 0x63, 0xae, 0x15, 0x34, 0x8f, 0x42, 0xf9  },
	{	0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60,
		0x00, 0xa0, 0x40, 0xe0, 0x80, 0x20, 0xc0, 0x60  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xfa, 0xf4, 0x0e, 0xe8, 0x12, 0x1c, 0xe6,
		0xd0, 0x2a, 0x24, 0xde, 0x38, 0xc2, 0xcc, 0x36  },
	{	0x00, 0xbb, 0x76, 0xcd, 0xec, 0x57, 0x9a, 0x21,
		0xd8, 0x63, 0xae, 0x15, 0x34, 0x8f, 0x42, 0xf9  },
	{	0x00, 0xb0, 0x60, 0xd0, 0xc0, 0x70, 0xa0, 0x10,
		0x80, 0x30, 0xe0, 0x50, 0x40, 0xf0, 0x20, 0x90  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xfb, 0xf6, 0x0d, 0xec, 0x17, 0x1a, 0xe1,
		0xd8, 0x23, 0x2e, 0xd5, 0x34, 0xcf, 0xc2, 0x39  },
	{	0x00, 0xbb, 0x76, 0xcd, 0xf1, 0x4a, 0x87, 0x3c,
		0xff, 0x44, 0x89, 0x32, 0x0e, 0xb5, 0x78, 0xc3  },
	{	0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40,
		0x00, 0xc0, 0x80, 0x40, 0x00, 0xc0, 0x80, 0x40  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xfc, 0xf8, 0x04, 0xf0, 0x0c, 0x08, 0xf4,
		0xe0, 0x1c, 0x18, 0xe4, 0x10, 0xec, 0xe8, 0x14  },
	{	0x00, 0xbb, 0x76, 0xcd, 0xf1, 0x4a, 0x87, 0x3c,
		0xff, 0x44, 0x89, 0x32, 0x0e, 0xb5, 0x78, 0xc3  },
	{	0x00, 0xd0, 0xa0, 0x70, 0x40, 0x90, 0xe0, 0x30,
		0x80, 0x50, 0x20, 0xf0, 0xc0, 0x10, 0x60, 0xb0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xfd, 0xfa, 0x07, 0xf4, 0x09, 0x0e, 0xf3,
		0xe8, 0x15, 0x12, 0xef, 0x1c, 0xe1, 0xe6, 0x1b  },
	{	0x00, 0xbb, 0x76, 0xcd, 0xf1, 0x4a, 0x87, 0x3c,
		0xe2, 0x59, 0x94, 0x2f, 0x13, 0xa8, 0x65, 0xde  },
	{	0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0,
		0x00, 0xe0, 0xc0, 0x20, 0x80, 0x60, 0x40, 0xa0  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xfe, 0xfc, 0x02, 0xf8, 0x06, 0x04, 0xfa,
		0xf0, 0x0e, 0x0c, 0xf2, 0x08, 0xf6, 0xf4, 0x0a  },
	{	0x00, 0xbb, 0x76, 0xcd, 0xf1, 0x4a, 0x87, 0x3c,
		0xe2, 0x59, 0x94, 0x2f, 0x13, 0xa8, 0x65, 0xde  },
	{	0x00, 0xf0, 0xe0, 0x10, 0xc0, 0x30, 0x20, 0xd0,
		0x80, 0x70, 0x60, 0x90, 0x40, 0xb0, 0xa0, 0x50  },
	{	0x00, 0x00, 0x1d, 0x1d, 0x27, 0x27, 0x3a, 0x3a,
		0x53, 0x53, 0x4e, 0x4e, 0x74, 0x74, 0x69, 0x69  },
	{	0x00, 0xff, 0xfe, 0x01, 0xfc, 0x03, 0x02, 0xfd,
		0xf8, 0x07, 0x06, 0xf9, 0x04, 0xfb, 0xfa, 0x05  }
};
/* END CSTYLED */
#endif // ENDIANNESS
#endif /* defined(__powerpc__) */
