/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq.jms2;

import jakarta.jms.BytesMessage;
import jakarta.jms.IllegalStateException;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.InvalidClientIDRuntimeException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidDestinationRuntimeException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.InvalidSelectorRuntimeException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.JMSSecurityRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.MessageNotWriteableRuntimeException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.ResourceAllocationException;
import jakarta.jms.ResourceAllocationRuntimeException;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.TransactionInProgressException;
import jakarta.jms.TransactionInProgressRuntimeException;
import jakarta.jms.TransactionRolledBackException;
import jakarta.jms.TransactionRolledBackRuntimeException;
import jakarta.transaction.SystemException;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.resource.activemq.jms2.DelegateMessage;
import org.apache.openejb.resource.activemq.jms2.WrappingByteMessage;
import org.apache.openejb.resource.activemq.jms2.WrappingMapMessage;
import org.apache.openejb.resource.activemq.jms2.WrappingObjectMessage;
import org.apache.openejb.resource.activemq.jms2.WrappingStreamMessage;
import org.apache.openejb.resource.activemq.jms2.WrappingTextMessage;

public final class JMS2 {
    private JMS2() {
    }

    public static JMSRuntimeException toRuntimeException(JMSException e) {
        if (e instanceof IllegalStateException) {
            return new IllegalStateRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof InvalidClientIDException) {
            return new InvalidClientIDRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof InvalidDestinationException) {
            return new InvalidDestinationRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof InvalidSelectorException) {
            return new InvalidSelectorRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof JMSSecurityException) {
            return new JMSSecurityRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof MessageFormatException) {
            return new MessageFormatRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof MessageNotWriteableException) {
            return new MessageNotWriteableRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof ResourceAllocationException) {
            return new ResourceAllocationRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof TransactionInProgressException) {
            return new TransactionInProgressRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof TransactionRolledBackException) {
            return new TransactionRolledBackRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        return new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
    }

    public static <T extends Message> T wrap(T message10) {
        if (message10 == null) {
            return null;
        }
        if (message10.getClass().getName().startsWith(JMS2.class.getPackage().getName())) {
            return message10;
        }
        if (TextMessage.class.isInstance(message10)) {
            return (T)new WrappingTextMessage((TextMessage)TextMessage.class.cast(message10));
        }
        if (ObjectMessage.class.isInstance(message10)) {
            return (T)new WrappingObjectMessage((ObjectMessage)ObjectMessage.class.cast(message10));
        }
        if (MapMessage.class.isInstance(message10)) {
            return (T)new WrappingMapMessage((MapMessage)MapMessage.class.cast(message10));
        }
        if (BytesMessage.class.isInstance(message10)) {
            return (T)new WrappingByteMessage((BytesMessage)BytesMessage.class.cast(message10));
        }
        if (StreamMessage.class.isInstance(message10)) {
            return (T)new WrappingStreamMessage((StreamMessage)StreamMessage.class.cast(message10));
        }
        return (T)new DelegateMessage(message10);
    }

    public static boolean inTx() {
        try {
            return OpenEJB.getTransactionManager().getTransaction() != null;
        }
        catch (SystemException | NullPointerException e) {
            return false;
        }
    }
}

