/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.meter;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.agent.core.meter.MeterTag;
import org.apache.skywalking.apm.agent.core.meter.MeterType;
import org.apache.skywalking.apm.network.language.agent.v3.Label;

public class MeterId {
    private final String name;
    private final MeterType type;
    private final List<MeterTag> tags;
    private List<Label> labels;

    public MeterId(String name, MeterType type, List<MeterTag> tags) {
        this.name = name;
        this.type = type;
        this.tags = tags;
    }

    public String getName() {
        return this.name;
    }

    public List<MeterTag> getTags() {
        return this.tags;
    }

    public MeterType getType() {
        return this.type;
    }

    public List<Label> transformTags() {
        if (this.labels != null) {
            return this.labels;
        }
        this.labels = this.tags.stream().map(t -> Label.newBuilder().setName(t.getKey()).setValue(t.getValue()).build()).collect(Collectors.toList());
        return this.labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeterId meterId = (MeterId)o;
        return Objects.equals(this.name, meterId.name) && this.type == meterId.type && Objects.equals(this.tags, meterId.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.tags});
    }
}

