/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class ThreadPerTaskExecutorRunInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Object skyWalkingDynamicField = objInst.getSkyWalkingDynamicField();
        if (skyWalkingDynamicField == null) {
            return;
        }
        if (!(skyWalkingDynamicField instanceof ContextSnapshot)) {
            return;
        }
        AbstractSpan span = ContextManager.createLocalSpan((String)this.getOperationName(objInst, method));
        span.setComponent((Component)ComponentsDefine.THREAD_PER_TASK_EXECUTOR);
        this.setCarrierThread(span);
        ContextSnapshot contextSnapshot = (ContextSnapshot)skyWalkingDynamicField;
        ContextManager.continued((ContextSnapshot)contextSnapshot);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (ContextManager.isActive()) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(t);
        }
    }

    private String getOperationName(EnhancedInstance objInst, Method method) {
        return objInst.getClass().getName() + "." + method.getName();
    }

    private void setCarrierThread(AbstractSpan span) {
        String[] parts;
        String threadInfo = Thread.currentThread().toString();
        if (threadInfo.startsWith("VirtualThread") && (parts = threadInfo.split("@")).length >= 1) {
            Tags.THREAD_CARRIER.set(span, parts[1]);
        }
    }
}

