/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.mongodb.v3.support;

import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.mongodb.v3.MongoPluginConfig;
import org.apache.skywalking.apm.plugin.mongodb.v3.support.MongoNamespaceInfo;
import org.apache.skywalking.apm.plugin.mongodb.v3.support.MongoOperationHelper;
import org.apache.skywalking.apm.util.StringUtil;

public class MongoSpanHelper {
    private static final AbstractTag<String> DB_COLLECTION_TAG = Tags.ofKey((String)"db.collection");

    private MongoSpanHelper() {
    }

    public static void createExitSpan(String executeMethod, String remotePeer, Object operation) {
        MongoNamespaceInfo mongoNamespaceInfo;
        AbstractSpan span = ContextManager.createExitSpan((String)("MongoDB/" + executeMethod), (ContextCarrier)new ContextCarrier(), (String)remotePeer);
        span.setComponent((Component)ComponentsDefine.MONGO_DRIVER);
        Tags.DB_TYPE.set(span, "MongoDB");
        SpanLayer.asDB((AbstractSpan)span);
        if (operation instanceof EnhancedInstance && (mongoNamespaceInfo = (MongoNamespaceInfo)((EnhancedInstance)operation).getSkyWalkingDynamicField()) != null) {
            if (StringUtil.isNotEmpty((String)mongoNamespaceInfo.getDatabaseName())) {
                Tags.DB_INSTANCE.set(span, mongoNamespaceInfo.getDatabaseName());
            }
            if (StringUtil.isNotEmpty((String)mongoNamespaceInfo.getCollectionName())) {
                span.tag(DB_COLLECTION_TAG, mongoNamespaceInfo.getCollectionName());
            }
        }
        if (MongoPluginConfig.Plugin.MongoDB.TRACE_PARAM) {
            Tags.DB_BIND_VARIABLES.set(span, MongoOperationHelper.getTraceParam(operation));
        }
    }
}

